/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.bosch.rcpXml;

import de.seetec.v5.re.cm.device.video.bosch.BoschDevice;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.Command;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.Direction;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.PacketXML;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.Type;

public class ConfMpeg4AvcBitrateOptimizationOptionsXml
extends PacketXML {
    public static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.bosch.rcpXml.ConfMpeg4AvcBitrateOptimizationOptionsXml";
    private boolean isBitrateOptimizationSupported = false;

    public ConfMpeg4AvcBitrateOptimizationOptionsXml() {
        this.type = Type.TYPE_P_OCTET;
        this.command = Command.CMD_MPEG4_AVC_BITRATE_OPTIMIZATION_OPTIONS;
    }

    public boolean getBitrateOptimizationOptions() {
        return this.isBitrateOptimizationSupported;
    }

    @Override
    public void send(BoschDevice device, Direction direction) throws Exception {
        if (direction == Direction.WRITE) {
            throw new Exception("Writing Options is not allowed");
        }
        super.send(device, direction);
        try {
            byte[] bitrateOptimizationOptions = this.getResultAsByteArray();
            this.isBitrateOptimizationSupported = bitrateOptimizationOptions != null && bitrateOptimizationOptions.length > 0 && bitrateOptimizationOptions[0] == 1;
        }
        catch (Exception ex) {
            this.logger.info("Exception while reading bitrate optimization. Feature probably not supported for " + this);
        }
    }

    @Override
    public String toString() {
        return "BitrateOptimization supported: " + this.isBitrateOptimizationSupported;
    }
}

