/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.bosch.rcpXml;

import de.seetec.v5.re.cm.device.video.bosch.BoschDevice;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.Command;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.Direction;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.PacketXML;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.Type;

public class CamNameLinesXML
extends PacketXML {
    private String name = "";
    private int maxTitleLength;

    public void setNameStamp(String value) {
        this.name = value.length() > 32 ? value.substring(0, 31) : value;
    }

    public String getNameStamp() {
        return this.name;
    }

    public CamNameLinesXML() {
        this.command = Command.CONF_CAMNAME_LINES;
        this.type = Type.TYPE_P_UNICODE;
    }

    @Override
    public void send(BoschDevice device, Direction direction) throws Exception {
        if (direction == Direction.WRITE) {
            this.payload = PacketXML.convertStringToUnicodeString(this.name);
            while (this.payload.length() / 4 < this.maxTitleLength) {
                this.payload = this.payload + "0000";
            }
        }
        super.send(device, direction);
        this.name = this.getResultAsUnicodeString();
    }

    public void setMaxTitleLength(int maxTitleLength) {
        this.maxTitleLength = maxTitleLength;
    }
}

