/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.bosch.rcpXml;

import de.seetec.v5.re.cm.device.video.bosch.BoschDevice;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.AlarmEntry;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.Command;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.Direction;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.PacketXML;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.Type;
import de.seetec.v5.shared.Basic;
import java.util.ArrayList;
import java.util.List;

public class AlarmOverviewXML
extends PacketXML {
    public static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.bosch.rcpXml.AlarmOverviewXML";
    private List<AlarmEntry> alarmEntries;

    public List<AlarmEntry> getAlarmEntries() {
        return this.alarmEntries;
    }

    public AlarmOverviewXML() {
        this.type = Type.TYPE_P_OCTET;
        this.command = Command.CMD_ALARM_OVERVIEW;
    }

    private List<AlarmEntry> getAlarmEntries(byte[] alarmEntryData) {
        AlarmEntry alarmEntry;
        ArrayList<AlarmEntry> res = new ArrayList<AlarmEntry>();
        for (int offset = 0; offset < alarmEntryData.length; offset += alarmEntry.getEntryLength()) {
            alarmEntry = new AlarmEntry(alarmEntryData, offset);
            res.add(alarmEntry);
        }
        return res;
    }

    @Override
    public void send(BoschDevice device, Direction direction) throws Exception {
        if (direction == Direction.WRITE) {
            throw new Exception("Writing Alarms is not allowed");
        }
        super.send(device, direction);
        String result = this.getResultAsString();
        byte[] resultData = Basic.hexStringToByteArray((String)result.replace("\r", "").replace("\n", "").replace(" ", ""));
        byte[] alarmEntryData = new byte[resultData.length - 4];
        System.arraycopy(resultData, 4, alarmEntryData, 0, alarmEntryData.length);
        this.alarmEntries = this.getAlarmEntries(alarmEntryData);
    }

    @Override
    public String toString() {
        StringBuilder res = new StringBuilder();
        if (this.alarmEntries != null && this.alarmEntries.size() > 0) {
            res.append("\r\nAlarm Entries: ");
            for (AlarmEntry alarmEntry : this.alarmEntries) {
                res.append("\r\n Name: ");
                res.append(alarmEntry.getAlarmName());
                res.append(" Type: ");
                res.append((Object)alarmEntry.getAlarmType());
                res.append(" Source: ");
                res.append((Object)alarmEntry.getAlarmSource());
            }
        }
        return super.toString() + "\r\n" + res.toString();
    }
}

