/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.bosch.rcp;

import de.seetec.v5.re.cm.device.video.bosch.rcp.Packet;

public class StreamingVal
extends Packet {
    private static final String CLASS_DEBUG_NAME = "RCP StreamingVal";
    private int value = -1;
    private static final int OFF = 0;
    private static final int MPEG4 = 1;
    private static final int MPEG2 = 2;
    private static final int MPEG2_AND_MPEG4 = 3;

    public StreamingVal() {
        this.setCommand(CMD_STREAMING_VAL);
        this.setDataType((byte)1);
    }

    public void setStreamingOff() {
        this.setValue(0);
    }

    public boolean isStreamingOff() {
        return this.value == 0;
    }

    public void setStreamingMpeg2() {
        this.setValue(2);
    }

    public boolean isStreamingMpeg2() {
        return this.value == 2;
    }

    public void setStreamingMpeg4() {
        this.setValue(1);
    }

    public boolean isStreamingMpeg4() {
        return this.value == 1;
    }

    public void setStreamingMpeg24() {
        this.setValue(3);
    }

    public boolean isStreamingMpeg24() {
        return this.value == 3;
    }

    public void setValue(int i) {
        this.value = i;
    }

    public int getValue() {
        return this.value;
    }

    @Override
    protected void deserializeBody(byte[] data) {
        if (data != null && data.length > 0) {
            this.value = data[0];
        }
    }

    @Override
    public byte[] serializeBody() {
        if (this.isActionRequest()) {
            return new byte[]{(byte)this.value};
        }
        return new byte[0];
    }

    protected String toStringValue() {
        String str;
        switch (this.value) {
            case 0: {
                str = "Off";
                break;
            }
            case 2: {
                str = "Mpeg2";
                break;
            }
            case 1: {
                str = "Mpeg4";
                break;
            }
            case 3: {
                str = "Mpeg2+4";
                break;
            }
            default: {
                str = "Unknown [ " + this.value + " ]";
            }
        }
        return str;
    }

    @Override
    protected String getClassDebugName() {
        return CLASS_DEBUG_NAME + (this.getRead() ? "Read" : "Write");
    }

    @Override
    protected String getClassDebugInfo() {
        if (this.isActionRequest() ^ this.getWrite()) {
            return "Encoder [ " + this.toStringNumdesc() + " ]";
        }
        return "Encoder [ " + this.toStringNumdesc() + " ], Value [ " + this.toStringValue() + " ]";
    }
}

