/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.bosch.rcp;

import de.seetec.v5.re.cm.device.video.bosch.rcp.AlarmOverview;
import de.seetec.v5.re.cm.device.video.bosch.rcp.BaseFramerate;
import de.seetec.v5.re.cm.device.video.bosch.rcp.CapabilityList;
import de.seetec.v5.re.cm.device.video.bosch.rcp.CapabilityListRsp;
import de.seetec.v5.re.cm.device.video.bosch.rcp.ClientRegistrationReq;
import de.seetec.v5.re.cm.device.video.bosch.rcp.ClientRegistrationRsp;
import de.seetec.v5.re.cm.device.video.bosch.rcp.ClientUnregister;
import de.seetec.v5.re.cm.device.video.bosch.rcp.CoderList;
import de.seetec.v5.re.cm.device.video.bosch.rcp.CoderListRsp;
import de.seetec.v5.re.cm.device.video.bosch.rcp.ConfAudio;
import de.seetec.v5.re.cm.device.video.bosch.rcp.ConfVideoInputFormatEx;
import de.seetec.v5.re.cm.device.video.bosch.rcp.Connect;
import de.seetec.v5.re.cm.device.video.bosch.rcp.Disconnect;
import de.seetec.v5.re.cm.device.video.bosch.rcp.H264EncBaseOperationMode;
import de.seetec.v5.re.cm.device.video.bosch.rcp.H264EncBaseOperationModeCaps;
import de.seetec.v5.re.cm.device.video.bosch.rcp.HardwareVersion;
import de.seetec.v5.re.cm.device.video.bosch.rcp.InputPinState;
import de.seetec.v5.re.cm.device.video.bosch.rcp.JpegStreamSetup;
import de.seetec.v5.re.cm.device.video.bosch.rcp.MotionAlarmState;
import de.seetec.v5.re.cm.device.video.bosch.rcp.Mpeg4Bandwidth;
import de.seetec.v5.re.cm.device.video.bosch.rcp.Mpeg4CurrentParams;
import de.seetec.v5.re.cm.device.video.bosch.rcp.Mpeg4FrameSkipRatio;
import de.seetec.v5.re.cm.device.video.bosch.rcp.Mpeg4GopStructure;
import de.seetec.v5.re.cm.device.video.bosch.rcp.Mpeg4IFrameDistance;
import de.seetec.v5.re.cm.device.video.bosch.rcp.Mpeg4Resolution;
import de.seetec.v5.re.cm.device.video.bosch.rcp.MulticastGroupIP;
import de.seetec.v5.re.cm.device.video.bosch.rcp.MulticastGroupPort;
import de.seetec.v5.re.cm.device.video.bosch.rcp.MulticastGroupPortAudio;
import de.seetec.v5.re.cm.device.video.bosch.rcp.RelayOutputState;
import de.seetec.v5.re.cm.device.video.bosch.rcp.Retrigger;
import de.seetec.v5.re.cm.device.video.bosch.rcp.StreamingVal;
import de.seetec.v5.re.cm.device.video.bosch.rcp.TimeStampVal;
import de.seetec.v5.re.cm.device.video.bosch.rcp.TimeoutWarning;
import de.seetec.v5.re.cm.device.video.bosch.rcp.TransparentData;
import de.seetec.v5.re.cm.device.video.bosch.rcp.TransparentDataMsg;
import de.seetec.v5.re.cm.device.video.bosch.rcp.ViProcAlarm;
import de.seetec.v5.re.cm.device.video.bosch.rcp.VideoAlarmState;
import de.seetec.v5.re.cm.device.video.bosch.rcp.VideoOperationMode;
import de.seetec.v5.re.cm.device.video.bosch.rcp.VideoQuality;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Packet {
    public static final byte ERROR_UNKNOWN = -1;
    public static final byte ERROR_INVALID_VERSION = 16;
    public static final byte ERROR_NOT_REGISTERED = 32;
    public static final byte ERROR_INVALID_CLIENTID = 33;
    public static final byte ERROR_INVALID_METHOD = 48;
    public static final byte ERROR_INVALID_CMD = 64;
    public static final byte ERROR_INVALID_ACCESS_TYPE = 80;
    public static final byte ERROR_INVALID_DATA_TYPE = 96;
    public static final byte ERROR_WRITE_ERROR = 112;
    public static final byte ERROR_PACKET_SIZE = -128;
    public static final byte ERROR_READ_NOT_SUPPORTED = -112;
    public static final byte ERROR_INVALID_AUTH_LEVEL = -96;
    public static final byte ERROR_INVALID_SESSION_ID = -80;
    public static final byte ERROR_TRY_LATER = -64;
    protected static final byte TYPE_FLAG = 0;
    protected static final byte TYPE_T_OCTET = 1;
    protected static final byte TYPE_T_WORD = 2;
    protected static final byte TYPE_T_INT = 4;
    protected static final byte TYPE_T_DWORD = 8;
    protected static final byte TYPE_P_OCTET = 12;
    protected static final byte TYPE_P_STRING = 16;
    protected static final byte TYPE_P_UNICODE = 20;
    protected static final byte ACTION_REQUEST = 0;
    protected static final byte ACTION_REPLY = 1;
    protected static final byte ACTION_MESSAGE = 2;
    protected static final byte ACTION_ERROR = 3;
    protected static final int HEADER_LENGTH = 16;
    protected static final int HEADER_INDEX_CMD = 0;
    protected static final int HEADER_INDEX_TYPE = 2;
    protected static final int HEADER_INDEX_VERSIONRW = 3;
    protected static final int HEADER_INDEX_ACTION = 4;
    protected static final int HEADER_INDEX_RESERVED = 5;
    protected static final int HEADER_INDEX_CLIENTID = 6;
    protected static final int HEADER_INDEX_SESSIONID = 8;
    protected static final int HEADER_INDEX_NUMDESC = 12;
    protected static final int HEADER_INDEX_PL = 14;
    static final byte[] CMD_CLIENT_REGISTRATION = Packet.toBytes(255, 0);
    static final byte[] CMD_CLIENT_UNREGISTER = Packet.toBytes(255, 1);
    static final byte[] CMD_CONNECT = Packet.toBytes(255, 12);
    static final byte[] CMD_CAPABILITY_LIST = Packet.toBytes(255, 16);
    static final byte[] CMD_CODER_LIST = Packet.toBytes(255, 17);
    static final byte[] CMD_DISCONNECT = Packet.toBytes(255, 13);
    static final byte[] CMD_CONNECT_TO = Packet.toBytes(255, 204);
    static final byte[] CMD_TRANSPARENT_DATA = Packet.toBytes(255, 221);
    static final byte[] CMD_RETRIGGER = Packet.toBytes(255, 194);
    static final byte[] CMD_HARDWARE_VERSION = Packet.toBytes(0, 46);
    static final byte[] CMD_INPUT_PIN_STATE = Packet.toBytes(1, 192);
    static final byte[] CMD_RELAY_OUTPUT_STATE = Packet.toBytes(1, 193);
    static final byte[] CMD_MPEG4_BANDWIDTH = Packet.toBytes(6, 7);
    static final byte[] CMD_MPEG4_BANDWIDTH_SOFT = Packet.toBytes(6, 18);
    static final byte[] CMD_MPEG4_BANDWIDTH_HARD = Packet.toBytes(6, 19);
    static final byte[] CMD_MPEG4_IFRAME_DISTANCE = Packet.toBytes(6, 4);
    static final byte[] CMD_MPEG4_FRAME_SKIP_RATIO = Packet.toBytes(6, 6);
    static final byte[] CMD_MPEG4_GOP_STRUCTURE = Packet.toBytes(10, 148);
    static final byte[] CMD_MPEG4_RESOLUTION = Packet.toBytes(6, 8);
    static final byte[] CMD_STREAMING_VAL = Packet.toBytes(1, 185);
    static final byte[] CMD_MULTICAST_GROUP_IP = Packet.toBytes(1, 180);
    static final byte[] CMD_MULTICAST_GROUP_PORT = Packet.toBytes(2, 134);
    static final byte[] CMD_MULTICAST_GROUP_PORT_AUDIO = Packet.toBytes(1, 178);
    static final byte[] CMD_MPEG4_CURRENT_PARAMS = Packet.toBytes(6, 0);
    static final byte[] CMD_VIPROC_ALARM = Packet.toBytes(8, 7);
    static final byte[] CMD_TIME_STAMP_VAL = Packet.toBytes(0, 133);
    static final byte[] CMD_CLIENT_TIMEOUT_WARNING = Packet.toBytes(255, 3);
    static final byte[] CMD_VIDEO_ALARM_STATE = Packet.toBytes(1, 194);
    static final byte[] CMD_MOTION_ALARM_STATE = Packet.toBytes(1, 195);
    static final byte[] CMD_VIDEO_QUALITY = Packet.toBytes(10, 130);
    static final byte[] CMD_BASE_FRAMERATE = Packet.toBytes(10, 214);
    static final byte[] CMD_VIDEO_OPERATION_MODE = Packet.toBytes(10, 156);
    static final byte[] CMD_CONF_AUDIO_G711 = Packet.toBytes(0, 12);
    static final byte[] CMD_H264_ENC_BASE_OPERATION_MODE = Packet.toBytes(10, 211);
    static final byte[] CMD_H264_ENC_BASE_OPERATION_MODE_CAPS = Packet.toBytes(10, 249);
    static final byte[] CMD_CONF_JPEG_STREAM_SETUP = Packet.toBytes(10, 213);
    static final byte[] CMD_CONF_VIDEO_INPUT_FORMAT_EX = Packet.toBytes(11, 16);
    static final byte[] CMD_VARIANT_ID_OPTIONS = Packet.toBytes(11, 182);
    static final byte[] CMD_VARIANT_ID = Packet.toBytes(11, 178);
    static final byte[] CMD_AUPROC_ALARM = Packet.toBytes(10, 121);
    static final byte[] CMD_VIRTUAL_ALARM_STATE = Packet.toBytes(10, 139);
    static final byte[] CMD_ALARM_OVERVIEW = Packet.toBytes(12, 56);
    private static final String CLASS_DEBUG_NAME = "RCP Packet";
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.bosch.rcp.Packet";
    protected static final Logger LOGGER = LogManager.getLogger((String)"de.seetec.v5.re.cm.bosch.rcp.Packet");
    protected Logger logger = null;
    protected byte[] header = new byte[16];
    protected byte errCode;
    private static final char[] NIBBLE = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    static byte[] toBytes(int i1, int i2) {
        return new byte[]{(byte)i1, (byte)i2};
    }

    public Packet() {
        this.logger = LogManager.getLogger((String)this.getClass().getName());
        this.setVersion((byte)3);
    }

    protected static boolean isCommand(byte[] data, byte[] cmd) {
        return data[0] == cmd[0] && data[1] == cmd[1];
    }

    public byte[] serialize() {
        byte[] hdr = this.getHeader();
        byte[] body = null;
        body = this.isActionError() ? new byte[]{this.getErrorCode()} : this.serializeBody();
        byte[] pl = Packet.intTo2Bytes(body.length);
        hdr[14] = pl[0];
        hdr[15] = pl[1];
        byte[] data = new byte[hdr.length + body.length];
        System.arraycopy(hdr, 0, data, 0, hdr.length);
        System.arraycopy(body, 0, data, hdr.length, body.length);
        return data;
    }

    public static Packet deserialize(byte[] data) {
        Packet packet = null;
        if (Packet.isCommand(data, CMD_CLIENT_REGISTRATION)) {
            packet = data[4] == 0 ? new ClientRegistrationReq() : new ClientRegistrationRsp();
        } else if (Packet.isCommand(data, CMD_CLIENT_UNREGISTER)) {
            packet = new ClientUnregister();
        } else if (Packet.isCommand(data, CMD_CONNECT)) {
            packet = new Connect();
        } else if (Packet.isCommand(data, CMD_CAPABILITY_LIST)) {
            packet = data[4] == 0 ? new CapabilityList() : new CapabilityListRsp();
        } else if (Packet.isCommand(data, CMD_CODER_LIST)) {
            packet = data[4] == 0 ? new CoderList() : new CoderListRsp();
        } else if (Packet.isCommand(data, CMD_RETRIGGER)) {
            packet = new Retrigger();
        } else if (Packet.isCommand(data, CMD_TRANSPARENT_DATA)) {
            packet = data[4] == 2 ? new TransparentDataMsg() : new TransparentData();
        } else if (Packet.isCommand(data, CMD_DISCONNECT)) {
            packet = new Disconnect();
        } else if (Packet.isCommand(data, CMD_HARDWARE_VERSION)) {
            packet = new HardwareVersion();
        } else if (Packet.isCommand(data, CMD_MPEG4_BANDWIDTH)) {
            packet = new Mpeg4Bandwidth();
        } else if (Packet.isCommand(data, CMD_MPEG4_BANDWIDTH_SOFT)) {
            packet = new Mpeg4Bandwidth();
        } else if (Packet.isCommand(data, CMD_MPEG4_BANDWIDTH_HARD)) {
            packet = new Mpeg4Bandwidth();
        } else if (Packet.isCommand(data, CMD_MPEG4_IFRAME_DISTANCE)) {
            packet = new Mpeg4IFrameDistance();
        } else if (Packet.isCommand(data, CMD_MPEG4_FRAME_SKIP_RATIO)) {
            packet = new Mpeg4FrameSkipRatio();
        } else if (Packet.isCommand(data, CMD_MPEG4_GOP_STRUCTURE)) {
            packet = new Mpeg4GopStructure();
        } else if (Packet.isCommand(data, CMD_MPEG4_RESOLUTION)) {
            packet = new Mpeg4Resolution();
        } else if (Packet.isCommand(data, CMD_INPUT_PIN_STATE)) {
            packet = new InputPinState();
        } else if (Packet.isCommand(data, CMD_RELAY_OUTPUT_STATE)) {
            packet = new RelayOutputState();
        } else if (Packet.isCommand(data, CMD_STREAMING_VAL)) {
            packet = new StreamingVal();
        } else if (Packet.isCommand(data, CMD_MULTICAST_GROUP_IP)) {
            packet = new MulticastGroupIP();
        } else if (Packet.isCommand(data, CMD_MULTICAST_GROUP_PORT)) {
            packet = new MulticastGroupPort();
        } else if (Packet.isCommand(data, CMD_MULTICAST_GROUP_PORT_AUDIO)) {
            packet = new MulticastGroupPortAudio();
        } else if (Packet.isCommand(data, CMD_MPEG4_CURRENT_PARAMS)) {
            packet = new Mpeg4CurrentParams();
        } else if (Packet.isCommand(data, CMD_VIPROC_ALARM)) {
            packet = new ViProcAlarm();
        } else if (Packet.isCommand(data, CMD_TIME_STAMP_VAL)) {
            packet = new TimeStampVal();
        } else if (Packet.isCommand(data, CMD_CLIENT_TIMEOUT_WARNING)) {
            packet = new TimeoutWarning();
        } else if (Packet.isCommand(data, CMD_VIDEO_ALARM_STATE)) {
            packet = new VideoAlarmState();
        } else if (Packet.isCommand(data, CMD_MOTION_ALARM_STATE)) {
            packet = new MotionAlarmState();
        } else if (Packet.isCommand(data, CMD_VIDEO_QUALITY)) {
            packet = new VideoQuality();
        } else if (Packet.isCommand(data, CMD_VIDEO_OPERATION_MODE)) {
            packet = new VideoOperationMode();
        } else if (Packet.isCommand(data, CMD_CONF_AUDIO_G711)) {
            packet = new ConfAudio();
        } else if (Packet.isCommand(data, CMD_H264_ENC_BASE_OPERATION_MODE)) {
            packet = new H264EncBaseOperationMode();
        } else if (Packet.isCommand(data, CMD_H264_ENC_BASE_OPERATION_MODE_CAPS)) {
            packet = new H264EncBaseOperationModeCaps();
        } else if (Packet.isCommand(data, CMD_CONF_JPEG_STREAM_SETUP)) {
            packet = new JpegStreamSetup();
        } else if (Packet.isCommand(data, CMD_CONF_VIDEO_INPUT_FORMAT_EX)) {
            packet = new ConfVideoInputFormatEx();
        } else if (Packet.isCommand(data, CMD_BASE_FRAMERATE)) {
            packet = new BaseFramerate();
        } else if (Packet.isCommand(data, CMD_ALARM_OVERVIEW)) {
            packet = new AlarmOverview();
        }
        if (packet == null) {
            return null;
        }
        byte[] hdr = new byte[16];
        System.arraycopy(data, 0, hdr, 0, hdr.length);
        packet.deserializeHeader(hdr);
        if (packet.isActionError()) {
            packet.setErrorCode(data[16]);
        } else {
            byte[] body = new byte[data.length - 16];
            System.arraycopy(data, 16, body, 0, body.length);
            packet.deserializeBody(body);
        }
        return packet;
    }

    public void initResponseFromRequest(Packet p) {
        if (p.getRead()) {
            this.setRead();
        } else {
            this.setWrite();
        }
        this.setActionResponse();
        this.setReserved(p.getReserved());
        this.setClientID(p.getClientID());
        this.setSessionID(p.getSessionID());
    }

    protected void deserializeHeader(byte[] data) {
        this.header = data;
    }

    protected void deserializeBody(byte[] data) {
    }

    public byte[] getHeader() {
        return this.header;
    }

    public byte[] serializeBody() {
        return new byte[0];
    }

    public byte[] getCommand() {
        return new byte[]{this.header[0], this.header[1]};
    }

    public void setCommand(byte[] cmd) {
        this.header[0] = cmd[0];
        this.header[1] = cmd[1];
    }

    public byte getDataType() {
        return this.header[2];
    }

    public void setDataType(byte type) {
        this.header[2] = type;
    }

    public byte getVersion() {
        return (byte)(this.header[3] >> 4 & 0xF);
    }

    public void setVersion(byte i) {
        this.header[3] = (byte)(this.header[3] & 0xF);
        this.header[3] = (byte)(this.header[3] | i << 4);
    }

    public boolean getRead() {
        return (this.header[3] & 0xF) == 0;
    }

    public void setRead() {
        this.header[3] = (byte)(this.header[3] & 0xF0);
    }

    public boolean getWrite() {
        return !this.getRead();
    }

    public void setWrite() {
        this.header[3] = (byte)(this.header[3] | 1);
    }

    public void setActionRequest() {
        this.setAction((byte)0);
    }

    public boolean isActionRequest() {
        return this.header[4] == 0;
    }

    public void setActionResponse() {
        this.setAction((byte)1);
    }

    public boolean isActionRespone() {
        return this.header[4] == 1;
    }

    public void setActionError() {
        this.setAction((byte)3);
    }

    public boolean isActionError() {
        return this.header[4] == 3;
    }

    public void setActionMessage() {
        this.setAction((byte)2);
    }

    public boolean isActionMessage() {
        return this.header[4] == 2;
    }

    protected byte getAction() {
        return this.header[4];
    }

    protected void setAction(byte action) {
        this.header[4] = action;
    }

    public byte getReserved() {
        return this.header[5];
    }

    public void setReserved(byte reserved) {
        this.header[5] = reserved;
    }

    public byte[] getClientID() {
        return new byte[]{this.header[6], this.header[7]};
    }

    public void setClientID(byte[] clientID) {
        this.header[6] = clientID[0];
        this.header[7] = clientID[1];
    }

    public byte[] getSessionID() {
        return new byte[]{this.header[8], this.header[9], this.header[10], this.header[11]};
    }

    public void setSessionID(byte[] sessionID) {
        if (sessionID != null) {
            this.header[8] = sessionID[0];
            this.header[9] = sessionID[1];
            this.header[10] = sessionID[2];
            this.header[11] = sessionID[3];
        }
    }

    public int getNumericDescriptorAsInt() {
        return Packet.bytesToInt(this.getNumericDescriptor());
    }

    public byte[] getNumericDescriptor() {
        return new byte[]{this.header[12], this.header[13]};
    }

    public void setNumericDescriptor(byte[] numDesc) {
        this.header[12] = numDesc[0];
        this.header[13] = numDesc[1];
    }

    public void setNumericDescriptorAsInt(int i) {
        this.setNumericDescriptorAsInt(i, 0L);
    }

    public void setNumericDescriptorAsInt(int numDesc, long hardware) {
        this.setNumericDescriptor(new byte[]{0, (byte)numDesc});
    }

    public String toStringNumdesc() {
        return Packet.hexString(this.getNumericDescriptor());
    }

    public void setNumericDescriptor_Method1(int line) {
        this.setNumericDescriptor(new byte[]{(byte)line, 1});
    }

    protected int getNumericDescriptor_Method1() {
        return this.getNumericDescriptor()[0];
    }

    public void setNumericDescriptor_Method2(int line) {
        this.setNumericDescriptor(new byte[]{0, (byte)line});
    }

    protected int getNumericDescriptor_Method2() {
        return this.getNumericDescriptor()[1];
    }

    public int getPayloadLength() {
        return Packet.bytesToInt(new byte[]{this.header[14], this.header[15]});
    }

    public void setPayloadLength(int length) {
        byte[] bytes = Packet.intTo2Bytes(length);
        this.header[14] = bytes[0];
        this.header[15] = bytes[1];
    }

    public byte getErrorCode() {
        return this.errCode;
    }

    public void setErrorCode(byte b) {
        this.setActionError();
        this.errCode = b;
    }

    public static String hexString(byte a) {
        StringBuilder sb = new StringBuilder(2);
        sb.append(NIBBLE[a >>> 4 & 0xF]);
        sb.append(NIBBLE[a & 0xF]);
        return sb.toString();
    }

    public static String hexString(byte[] buf, int i, int length) {
        StringBuilder sb = new StringBuilder(length * 2);
        for (int j = i; j < i + length; ++j) {
            sb.append(NIBBLE[buf[j] >>> 4 & 0xF]);
            sb.append(NIBBLE[buf[j] & 0xF]);
            sb.append(" ");
        }
        return sb.toString();
    }

    public static String hexString(byte[] buf) {
        return Packet.hexString(buf, 0, buf.length);
    }

    public static byte[] intTo2Bytes(int n) {
        byte[] array = new byte[]{(byte)(n >>> 8), (byte)(n >>> 0)};
        return array;
    }

    public static byte[] intTo4Bytes(int n) {
        byte[] array = new byte[]{(byte)(n >>> 24), (byte)(n >>> 16), (byte)(n >>> 8), (byte)(n >>> 0)};
        return array;
    }

    public static int bytesToInt(byte[] array, int offset, int length) {
        int nResult = 0;
        for (int i = 0; i < length; ++i) {
            nResult = (nResult << 8) + (array[offset + i] & 0xFF);
        }
        return nResult;
    }

    public static int bytesToInt(byte[] array) {
        return Packet.bytesToInt(array, 0, array.length);
    }

    public String toString() {
        if (this.header == null || this.header[0] == 0 && this.header[1] == 0) {
            return this.getClassDebugName() + ", not initialized";
        }
        if (this.isActionError()) {
            return this.getClassDebugName() + ", SessionID [ " + Packet.hexString(this.header, 8, 4) + " ], Error [ " + Packet.hexString(this.getErrorCode()) + " ] : " + this.toString_Error();
        }
        if (this.isActionRequest()) {
            return this.getClassDebugName() + "Req, " + this.getClassDebugInfo();
        }
        if (this.isActionRespone()) {
            return this.getClassDebugName() + "Rsp, " + this.getClassDebugInfo();
        }
        return this.getClassDebugName() + "Msg, " + this.getClassDebugInfo();
    }

    protected String getClassDebugName() {
        return CLASS_DEBUG_NAME;
    }

    protected String getClassDebugInfo() {
        return "Cmd [" + Packet.hexString(this.header[0]) + " " + Packet.hexString(this.header[1]) + "]";
    }

    protected String toString_Error() {
        switch (this.getErrorCode()) {
            case 16: {
                return "Invalid Version";
            }
            case 33: {
                return "Invalid ClientID";
            }
            case 48: {
                return "Invalid Method";
            }
            case 64: {
                return "Invalid Cmd";
            }
            case 80: {
                return "Invalid Access Type";
            }
            case 96: {
                return "Invalid Data Type";
            }
            case 112: {
                return "Write Error";
            }
            case -128: {
                return "Packet Size";
            }
            case -112: {
                return "IRead Not Supported";
            }
            case -96: {
                return "Invalid Auth Level";
            }
            case -80: {
                return "Invalid SessionID";
            }
            case -64: {
                return "Try Later";
            }
        }
        return "Unknown Error";
    }
}

