/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.bosch.rcp;

import de.seetec.v5.re.cm.device.video.bosch.rcp.Packet;
import java.io.UnsupportedEncodingException;

public class MulticastGroupIP
extends Packet {
    private static final String CLASS_DEBUG_NAME = "RCP MulticastGroupIP";
    String value;

    public MulticastGroupIP() {
        this.setCommand(CMD_MULTICAST_GROUP_IP);
        this.setDataType((byte)16);
    }

    public void setIp(String str) {
        this.value = str;
    }

    public String getIp() {
        return this.value;
    }

    @Override
    protected void deserializeBody(byte[] data) {
        if (data != null && data.length > 0) {
            if (data[data.length - 1] == 0) {
                byte[] temp = new byte[data.length - 1];
                System.arraycopy(data, 0, temp, 0, temp.length);
                data = temp;
            }
            try {
                this.value = new String(data, "ASCII");
            }
            catch (UnsupportedEncodingException ex) {
                this.logger.warn("Bad Encoding", (Throwable)ex);
            }
        }
    }

    @Override
    public byte[] serializeBody() {
        if (this.isActionRequest() && this.value != null) {
            try {
                byte[] bytes = this.value.getBytes("ASCII");
                if (bytes[bytes.length] != 0) {
                    byte[] temp = new byte[bytes.length + 1];
                    System.arraycopy(bytes, 0, temp, 0, bytes.length);
                    temp[bytes.length] = 0;
                    bytes = temp;
                }
                return bytes;
            }
            catch (UnsupportedEncodingException ex) {
                this.logger.warn("Bad Encoding", (Throwable)ex);
                return new byte[0];
            }
        }
        return new byte[0];
    }

    @Override
    protected String getClassDebugName() {
        return CLASS_DEBUG_NAME + (this.getRead() ? "Read" : "Write");
    }

    @Override
    protected String getClassDebugInfo() {
        if (this.isActionRequest() ^ this.getWrite()) {
            return "Encoder [ " + this.toStringNumdesc() + " ]";
        }
        return "Encoder [ " + this.toStringNumdesc() + " ], Value [ " + this.value + " ]";
    }
}

