/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.bosch.rcp;

import de.seetec.v5.re.cm.device.video.bosch.rcp.Packet;

public class Mpeg4GopStructure
extends Packet {
    private static final String CLASS_DEBUG_NAME = "RCP Mpg4GopStructure";
    private int value = -1;

    public Mpeg4GopStructure() {
        this.setCommand(CMD_MPEG4_GOP_STRUCTURE);
        this.setDataType((byte)1);
    }

    public void setValue(int i) {
        this.value = i;
    }

    public int getValue() {
        return this.value;
    }

    @Override
    protected void deserializeBody(byte[] data) {
        if (data != null && data.length > 0) {
            this.value = data[0];
        }
    }

    @Override
    public byte[] serializeBody() {
        if (this.isActionRequest()) {
            return new byte[]{(byte)this.value};
        }
        return new byte[0];
    }

    protected String toStringValue() {
        return "Unknown [ " + GOP_VALUES.valueOf(this.value).name() + " ]";
    }

    @Override
    protected String getClassDebugName() {
        return CLASS_DEBUG_NAME + (this.getRead() ? "Read" : "Write");
    }

    @Override
    protected String getClassDebugInfo() {
        if (this.isActionRequest() ^ this.getWrite()) {
            return "Encoder [ " + this.toStringNumdesc() + " ]";
        }
        return "Encoder [ " + this.toStringNumdesc() + " ], Value [ " + this.toStringValue() + " ]";
    }

    public static enum GOP_VALUES {
        IP(0),
        IBP(1),
        IBBP(2),
        IBBRBP(3);

        private int i;

        private GOP_VALUES(int i) {
            this.i = i;
        }

        public int getValue() {
            return this.i;
        }

        public static GOP_VALUES valueOf(int givenValue) {
            GOP_VALUES type = null;
            for (GOP_VALUES t : GOP_VALUES.values()) {
                if (givenValue != t.i) continue;
                type = t;
                break;
            }
            return type;
        }
    }
}

