/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.bosch.rcp;

import de.seetec.v5.re.cm.device.video.bosch.rcp.Packet;

public class Mpeg4Bandwidth
extends Packet {
    private static final String CLASS_DEBUG_NAME = "RCP Mpeg4Bandwidth";
    private int value = -1;

    public Mpeg4Bandwidth() {
        this.setCommand(CMD_MPEG4_BANDWIDTH);
        this.setDataType((byte)8);
    }

    public void setBandwidth(int bandwidth) {
        this.value = bandwidth;
    }

    public int getBandwidth() {
        return this.value;
    }

    @Override
    protected void deserializeBody(byte[] data) {
        if (data != null && data.length > 0) {
            this.value = Mpeg4Bandwidth.bytesToInt(data);
        }
    }

    @Override
    public byte[] serializeBody() {
        if (this.isActionRequest()) {
            return Mpeg4Bandwidth.intTo4Bytes(this.value);
        }
        return new byte[0];
    }

    @Override
    protected String getClassDebugName() {
        return CLASS_DEBUG_NAME + (this.getRead() ? "Read" : "Write");
    }

    @Override
    protected String getClassDebugInfo() {
        if (this.isActionRequest() ^ this.getWrite()) {
            return "Encoder [ " + this.toStringNumdesc() + " ]";
        }
        return "Encoder [ " + this.toStringNumdesc() + " ], Value [ " + this.getBandwidth() + " ]";
    }
}

