/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.bosch.rcp;

import de.seetec.v5.re.cm.device.video.bosch.rcp.OperationModeCombination;
import de.seetec.v5.re.cm.device.video.bosch.rcp.Packet;
import de.seetec.v5.shared.Basic;
import java.util.ArrayList;
import java.util.Arrays;

public class H264EncBaseOperationModeCaps
extends Packet {
    private static final String CLASS_DEBUG_NAME = "RCP H264EncBaseOperationModeCaps";
    private ArrayList<OperationModeCombination> caps = new ArrayList();
    private int numberOfStreams = 0;

    public H264EncBaseOperationModeCaps() {
        this.setCommand(CMD_H264_ENC_BASE_OPERATION_MODE_CAPS);
        this.setDataType((byte)12);
    }

    @Override
    public void deserializeBody(byte[] data) {
        if (data != null && data.length > 0) {
            this.numberOfStreams = Basic.byteArrayToInt4((byte[])Arrays.copyOfRange(data, 0, 4));
            for (int i = 4; i < data.length; i += 8) {
                this.caps.add(new OperationModeCombination(this.numberOfStreams, Arrays.copyOfRange(data, i, i + 8)));
            }
        }
    }

    public final ArrayList<OperationModeCombination> getCapabilities() {
        return this.caps;
    }

    public final void printCapabilities() {
        StringBuilder output = new StringBuilder("=====================");
        output.append("\r\n");
        if (this.caps != null) {
            output.append("Number of Streams : ");
            output.append(this.numberOfStreams);
            output.append("\r\n");
            for (OperationModeCombination operationModeCombination : this.caps) {
                output.append(operationModeCombination);
            }
        } else {
            output.append("Capabilities null.");
            output.append("\r\n");
        }
        output.append("=====================");
        this.logger.info(output.toString());
    }

    @Override
    protected String getClassDebugName() {
        return CLASS_DEBUG_NAME + (this.getRead() ? "Read" : "Write");
    }

    @Override
    protected String getClassDebugInfo() {
        return "n/a";
    }
}

