/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.bosch.rcp;

import de.seetec.v5.re.cm.device.video.bosch.rcp.MediaDescriptor;
import de.seetec.v5.re.cm.device.video.bosch.rcp.Packet;
import java.util.List;
import java.util.Vector;

public class Connect
extends Packet {
    private static final String CLASS_DEBUG_NAME = "RCP Connect";
    private List<MediaDescriptor> descriptors = new Vector<MediaDescriptor>();

    public Connect() {
        this.setCommand(CMD_CONNECT);
        this.setDataType((byte)12);
        this.setAction((byte)0);
        this.setWrite();
    }

    public void addDescriptor(MediaDescriptor desc) {
        this.descriptors.add(desc);
    }

    protected void dumpDescriptors() {
        for (MediaDescriptor mediaDescriptor : this.descriptors) {
            this.logger.info(mediaDescriptor.toStringReq());
        }
    }

    public void removeDescripotr(MediaDescriptor desc) {
        this.descriptors.remove(desc);
    }

    public List<MediaDescriptor> getDescriptors() {
        return this.descriptors;
    }

    @Override
    public byte[] serializeBody() {
        byte[] data = new byte[32 * this.descriptors.size()];
        int i = 0;
        for (MediaDescriptor mediaDescriptor : this.descriptors) {
            System.arraycopy(mediaDescriptor.getData(), 0, data, i * 32, 32);
        }
        return data;
    }

    @Override
    public void deserializeBody(byte[] data) {
        byte[] mdData = new byte[32];
        for (int i = 0; i < data.length / 32; ++i) {
            System.arraycopy(data, i * 32, mdData, 0, 32);
            MediaDescriptor md = new MediaDescriptor();
            md.setData(mdData);
            this.addDescriptor(md);
        }
    }

    @Override
    public String toString() {
        StringBuilder str = new StringBuilder(CLASS_DEBUG_NAME);
        for (MediaDescriptor mediaDescriptor : this.descriptors) {
            if (this.isActionRequest()) {
                str.append(", ").append(mediaDescriptor.toStringReq());
                continue;
            }
            str.append(", ").append(mediaDescriptor.toStringRsp());
        }
        return str.toString();
    }

    @Override
    protected String getClassDebugName() {
        return CLASS_DEBUG_NAME;
    }

    @Override
    protected String getClassDebugInfo() {
        return this.toString();
    }
}

