/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.bosch.mpeg;

public enum ResolutionMapping {
    BOSCH_QCIF(176, 144, 0),
    BOSCH_CIF(352, 288, 1),
    BOSCH_CIF_SPECIAL(352, 240, 1),
    BOSCH_2CIF(704, 288, 2),
    BOSCH_4CIF(704, 576, 3),
    BOSCH_1_2D1(352, 480, 4),
    BOSCH_2_3D1(480, 480, 5),
    BOSCH_QVGA(320, 240, 6),
    BOSCH_VGA(640, 480, 7),
    BOSCH_WD144(256, 144, 8),
    BOSCH_WD288(512, 288, 9),
    BOSCH_WD432(768, 432, 10),
    BOSCH_1280_1024(1280, 1024, 11),
    BOSCH_720P(1280, 720, 12),
    BOSCH_1080P(1920, 1080, 14),
    BOSCH_5MP(2592, 1944, 15),
    BOSCH_1280_960(1280, 960, 16),
    BOSCH_1440x_1080(1440, 1080, 17);

    private int width;
    private int height;
    private int resolutionTag;

    private ResolutionMapping(int width, int height, int resolutionTag) {
        this.width = width;
        this.height = height;
        this.resolutionTag = resolutionTag;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getResolutionTag() {
        return this.resolutionTag;
    }

    public static ResolutionMapping valueOf(int width, int height) {
        ResolutionMapping mapping = null;
        for (ResolutionMapping t : ResolutionMapping.values()) {
            if (width != t.getWidth() || height != t.getHeight()) continue;
            mapping = t;
            break;
        }
        return mapping;
    }

    public static ResolutionMapping valueOf(int resolutionTag) {
        ResolutionMapping mapping = null;
        for (ResolutionMapping t : ResolutionMapping.values()) {
            if (resolutionTag != t.getResolutionTag()) continue;
            mapping = t;
            break;
        }
        return mapping;
    }
}

