/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.bosch.mpeg;

import de.seetec.v5.re.cm.device.shared.BitInputStream;
import de.seetec.v5.re.cm.device.shared.LiveCameraSrv;
import de.seetec.v5.re.cm.device.shared.net.NetworkCallback;
import de.seetec.v5.re.cm.device.shared.net.RCPNetworkCallback;
import de.seetec.v5.re.cm.device.shared.net.udp.UdpReaderMulticast;
import de.seetec.v5.re.cm.device.shared.net.udp.UdpReaderUnicast;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingHelper;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingVideoSourceClientRTSP;
import de.seetec.v5.re.cm.device.video.bosch.BoschCameraSrv;
import de.seetec.v5.re.cm.device.video.bosch.BoschDevice;
import de.seetec.v5.re.cm.device.video.bosch.BoschHardwareMotionDetection;
import de.seetec.v5.re.cm.device.video.bosch.BoschMotionDetectionHandler;
import de.seetec.v5.re.cm.device.video.bosch.TpktStreamReader;
import de.seetec.v5.re.cm.device.video.bosch.TpktStreamWriter;
import de.seetec.v5.re.cm.device.video.bosch.mpeg.AudioAdapter;
import de.seetec.v5.re.cm.device.video.bosch.mpeg.ResolutionMapping;
import de.seetec.v5.re.cm.device.video.bosch.rcp.BaseFramerate;
import de.seetec.v5.re.cm.device.video.bosch.rcp.CapabilityList;
import de.seetec.v5.re.cm.device.video.bosch.rcp.CapabilityListRsp;
import de.seetec.v5.re.cm.device.video.bosch.rcp.ClientRegistrationReq;
import de.seetec.v5.re.cm.device.video.bosch.rcp.ClientRegistrationRsp;
import de.seetec.v5.re.cm.device.video.bosch.rcp.ClientUnregister;
import de.seetec.v5.re.cm.device.video.bosch.rcp.CoderList;
import de.seetec.v5.re.cm.device.video.bosch.rcp.CoderListRsp;
import de.seetec.v5.re.cm.device.video.bosch.rcp.ConfAudio;
import de.seetec.v5.re.cm.device.video.bosch.rcp.ConfVideoInputFormatEx;
import de.seetec.v5.re.cm.device.video.bosch.rcp.Connect;
import de.seetec.v5.re.cm.device.video.bosch.rcp.Disconnect;
import de.seetec.v5.re.cm.device.video.bosch.rcp.H264EncBaseOperationMode;
import de.seetec.v5.re.cm.device.video.bosch.rcp.HardwareVersion;
import de.seetec.v5.re.cm.device.video.bosch.rcp.JpegStreamSetup;
import de.seetec.v5.re.cm.device.video.bosch.rcp.MediaDescriptor;
import de.seetec.v5.re.cm.device.video.bosch.rcp.MotionAlarmState;
import de.seetec.v5.re.cm.device.video.bosch.rcp.Mpeg4Bandwidth;
import de.seetec.v5.re.cm.device.video.bosch.rcp.Mpeg4BandwidthHard;
import de.seetec.v5.re.cm.device.video.bosch.rcp.Mpeg4BandwidthSoft;
import de.seetec.v5.re.cm.device.video.bosch.rcp.Mpeg4CurrentParams;
import de.seetec.v5.re.cm.device.video.bosch.rcp.Mpeg4FrameSkipRatio;
import de.seetec.v5.re.cm.device.video.bosch.rcp.Mpeg4GopStructure;
import de.seetec.v5.re.cm.device.video.bosch.rcp.Mpeg4IFrameDistance;
import de.seetec.v5.re.cm.device.video.bosch.rcp.Mpeg4Resolution;
import de.seetec.v5.re.cm.device.video.bosch.rcp.MulticastGroupIP;
import de.seetec.v5.re.cm.device.video.bosch.rcp.MulticastGroupPort;
import de.seetec.v5.re.cm.device.video.bosch.rcp.MulticastGroupPortAudio;
import de.seetec.v5.re.cm.device.video.bosch.rcp.Packet;
import de.seetec.v5.re.cm.device.video.bosch.rcp.Retrigger;
import de.seetec.v5.re.cm.device.video.bosch.rcp.StreamingVal;
import de.seetec.v5.re.cm.device.video.bosch.rcp.TimeStampVal;
import de.seetec.v5.re.cm.device.video.bosch.rcp.TimeoutWarning;
import de.seetec.v5.re.cm.device.video.bosch.rcp.VideoAlarmState;
import de.seetec.v5.re.cm.device.video.bosch.rcp.VideoOperationMode;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.re.shared.MediaFrame;
import de.seetec.v5.shared.OPCLowerNodeIDType;
import de.seetec.v5.shared.util.ConfigurationException;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;

public class BoschMPEGVideoSourceClient
extends StreamingVideoSourceClientRTSP
implements NetworkCallback,
RCPNetworkCallback,
Runnable {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.devide.video.bosch.mpeg.BoschMPEGVideoSourceClient";
    private Thread myThread = null;
    private final AudioAdapter adapter = new AudioAdapter(this);
    private UdpReaderUnicast udpReaderAudio = null;
    private UdpReaderUnicast udpReader = null;
    private Socket socket = null;
    private TpktStreamReader rcpReader = null;
    private TpktStreamWriter rcpWriter = null;
    private int rcpPort = 1756;
    private UdpReaderMulticast udpReaderMulticast = null;
    private UdpReaderMulticast udpReaderMulticastAudio = null;
    private String multicastIP = null;
    private int multicastPort = Integer.MIN_VALUE;
    private int multicastPortAudio = Integer.MIN_VALUE;
    private String passphrase = null;
    private int res = 0;
    private boolean registered;
    private byte[] clientID;
    private byte[] sessionID;
    private byte[] sessionIDAudio;
    private byte lastFuckingByteFrompreviousFrame = 0;
    private byte numberOfEbit = (byte)-1;
    private byte[] previousPacket = null;
    private byte[] coderToUse = new byte[2];
    private Codec mediaTypeFlag = Codec.H263;
    private boolean useLegacyStyle = false;
    private long lastPacketsStat = System.currentTimeMillis();
    private long packetsReceived = 0L;
    private long packetsDropped = 0L;
    private long streamID = 1L;
    private int profile = -1;
    private int qualityForJpeg = -1;
    private boolean setOfNewCaptureModeRequested = false;
    private boolean setOfNewCaptureModeSuccessfull = false;
    private int baseFramerate = 30;

    @Override
    public int init() {
        OutputStream outStream;
        InputStream inStream;
        this.logger.info("init started for" + this.getVideoSrv());
        this.coderToUse[0] = 0;
        this.registered = false;
        this.clientID = new byte[]{0, 0};
        this.sessionID = new byte[]{0, 0, 0, 0};
        this.sessionIDAudio = new byte[]{0, 0, 0, 0};
        this.completeFrame = new ByteArrayOutputStream();
        if (this.getVideoSrv().getDevice().getDeviceType() == 201704L || this.getVideoSrv().getDevice().getDeviceType() == 201705L || this.getVideoSrv().getDevice().getDeviceType() == 201714L) {
            this.logger.info("Using vcs-legacy implementation for " + this.getVideoSrv());
            this.useLegacyStyle = true;
            this.mediaTypeFlag = Codec.H263_VCS;
        }
        if ((this.errorCode = super.init()) != 0) {
            this.logger.error("Error while initializing. Code: " + this.errorCode + " for " + this);
            return this.errorCode;
        }
        this.iFrameDist = (int)(this.fps * (long)this.iFrameDistMS) / 1000000;
        this.iFrameDist = this.iFrameDist < 3L ? 3L : this.iFrameDist;
        this.iFrameDist = this.iFrameDist > 60L ? 60L : this.iFrameDist;
        this.bandwidth /= 1000;
        ResolutionMapping resolutionMapping = ResolutionMapping.valueOf(this.width, this.height);
        if (resolutionMapping == null) {
            this.logger.info("Resolution unknown. Message NOT important for HD streams. Using 4CIF for " + this.getVideoSrv().getDevice());
            resolutionMapping = ResolutionMapping.BOSCH_4CIF;
        }
        this.res = resolutionMapping.getResolutionTag();
        if (this.isAudioEnabled) {
            this.logger.info("Audio enabled for " + this.getVideoSrv());
            try {
                this.logger.info("Audio Parameter: " + this.audioCodec + " with " + this.audioBitrate + "bit for " + this.getVideoSrv().getDevice());
            }
            catch (Exception e) {
                this.logger.error("Reading audio configuration from " + this.getVideoSrv().getDevice() + " failed :-(", (Throwable)e);
                return -21601;
            }
        }
        if (!this.isMulticastEnabled) {
            this.udpReader = new UdpReaderUnicast(this);
            this.udpReader.init(524288, 5000, true, true);
            this.logger.info("UDP port '" + this.udpReader.getPort() + "' opened for " + this.getVideoSrv());
        }
        if (this.isAudioEnabled) {
            this.audioSourceClient = new StreamingVideoSourceClientRTSP.AudioSourceClient(this.adapter);
            if (!this.isMulticastEnabled) {
                this.udpReaderAudio = new UdpReaderUnicast(this.adapter);
                this.udpReaderAudio.init(524288, 5000, true, true);
                this.logger.info("UDP audio port '" + this.udpReaderAudio.getPort() + "' opened for " + this.getVideoSrv());
            }
        }
        try {
            this.socket = new Socket(this.host, this.rcpPort);
            this.socket.setSoTimeout(10000);
            inStream = this.socket.getInputStream();
            outStream = this.socket.getOutputStream();
        }
        catch (Exception e) {
            this.logger.error("Cannot connect to " + this.host + ":" + this.rcpPort + " for " + this.getVideoSrv());
            return -21603;
        }
        this.rcpReader = new TpktStreamReader();
        this.rcpReader.init(inStream, this);
        this.rcpWriter = new TpktStreamWriter(outStream, this);
        this.profile = (int)((long)(this.videoSourceNr * 2) - (2L - this.streamID));
        while (this.profile > 8) {
            this.profile -= 8;
        }
        if (this.useLegacyStyle) {
            this.coderToUse[1] = this.streamID == 1L ? 1 : 2;
            this.logger.info("Coder to use for VCS: " + this.coderToUse[1]);
        } else {
            CoderList reqCoder = new CoderList();
            reqCoder.setRead();
            reqCoder.setNumericDescriptorAsInt(this.videoSourceNr);
            reqCoder.setActionRequest();
            this.sendRCPDataPacket(reqCoder);
            CapabilityList reqCap = new CapabilityList();
            reqCap.setClientID(this.clientID);
            this.sendRCPDataPacket(reqCap);
        }
        ClientRegistrationReq req = new ClientRegistrationReq();
        this.passphrase = BoschCameraSrv.createPassphrase(this.networkParameter);
        req.setPass(this.passphrase);
        this.sendRCPDataPacket(req);
        this.logger.info("init done for" + this.getVideoSrv());
        return 0;
    }

    @Override
    public void run() {
        long keepAliveInterval = 10000L;
        long time = System.currentTimeMillis();
        while (!this.isShutdown()) {
            try {
                Thread.sleep(500L);
            }
            catch (Exception e) {
                this.logger.fatal("Error while sleep. " + e.getMessage());
            }
            if (this.isShutdown()) break;
            if (System.currentTimeMillis() <= time + keepAliveInterval) continue;
            Retrigger rtReq = new Retrigger();
            rtReq.setActionRequest();
            rtReq.setClientID(this.clientID);
            rtReq.setSessionID(this.sessionID);
            this.sendRCPDataPacket(rtReq);
            if (this.isAudioEnabled) {
                rtReq.setSessionID(this.sessionIDAudio);
                this.sendRCPDataPacket(rtReq);
            }
            time = System.currentTimeMillis();
        }
    }

    @Override
    public synchronized int shutdown() {
        block11: {
            if (this.startShutdown(CLASS_NAME)) {
                return 0;
            }
            Disconnect rtReq = new Disconnect();
            rtReq.setActionRequest();
            rtReq.setClientID(this.clientID);
            if (this.isAudioEnabled) {
                rtReq.setSessionID(this.sessionIDAudio);
                this.sendRCPDataPacket(rtReq);
            }
            rtReq.setSessionID(this.sessionID);
            this.sendRCPDataPacket(rtReq);
            ClientUnregister unReq = new ClientUnregister();
            unReq.setActionRequest();
            unReq.setClientID(this.clientID);
            this.sendRCPDataPacket(unReq);
            if (this.udpReaderAudio != null) {
                this.udpReaderAudio.shutdown();
            }
            this.udpReaderAudio = null;
            if (this.udpReaderMulticastAudio != null) {
                this.udpReaderMulticastAudio.shutdown();
            }
            this.udpReaderMulticastAudio = null;
            if (this.udpReader != null) {
                this.udpReader.shutdown();
            }
            this.udpReader = null;
            if (this.udpReaderMulticast != null) {
                this.udpReaderMulticast.shutdown();
            }
            this.udpReaderMulticast = null;
            if (this.rcpReader != null) {
                this.rcpReader.shutdown();
            }
            this.rcpReader = null;
            if (this.rcpWriter != null) {
                this.rcpWriter.shutdown();
            }
            this.rcpWriter = null;
            if (this.socket != null) {
                try {
                    this.socket.close();
                }
                catch (Exception e) {
                    if (!this.logger.isDebugEnabled()) break block11;
                    this.logger.debug("Error while closing socket: " + e.getMessage());
                }
            }
        }
        super.shutdown();
        this.socket = null;
        this.passphrase = null;
        this.logger.info("shutdown done for " + this.getVideoSrv());
        return 0;
    }

    @Override
    public void onNetworkError(int error) {
        if (this.isShutdown()) {
            return;
        }
        this.logger.warn("Shutting down : " + error);
        this.listener.sendStatusService(error);
        this.shutdown();
    }

    protected final int checkForH263MediaType(byte[] data) {
        if (data != null && data.length >= 5) {
            int OFFSET = -1;
            if (data[0] == 0 && data[1] == 0 && (data[2] & 0x80) == 128) {
                OFFSET = 3;
            }
            if (OFFSET > 0) {
                byte[] bytesToEvaluate = new byte[data.length - OFFSET];
                System.arraycopy(data, OFFSET, bytesToEvaluate, 0, data.length - OFFSET);
                BitInputStream bin = new BitInputStream(bytesToEvaluate);
                try {
                    bin.skipBits(6);
                    bin.skipBits(2);
                    bin.skipBits(3);
                    int resolutionFormat = (int)(Math.pow(2 * bin.readBit(), 2.0) + (double)(2 * bin.readBit()) + (double)bin.readBit());
                    if (resolutionFormat != 7) {
                        if (resolutionFormat == 1) {
                            this.width = 128;
                            this.height = 96;
                        } else if (resolutionFormat == 2) {
                            this.width = 176;
                            this.height = 144;
                        } else if (resolutionFormat == 3) {
                            this.width = 352;
                            this.height = 288;
                        } else if (resolutionFormat == 4) {
                            this.width = 704;
                            this.height = 576;
                        } else if (resolutionFormat == 5) {
                            this.width = 1408;
                            this.height = 1152;
                        } else if (resolutionFormat == 6) {
                            this.width = 704;
                            this.height = 288;
                        }
                        return bin.readBit() == 0 ? 33 : 35;
                    }
                    bin.skipBits(2);
                    if (bin.readBit() == 1) {
                        resolutionFormat = (int)(Math.pow(2 * bin.readBit(), 2.0) + (double)(2 * bin.readBit()) + (double)bin.readBit());
                        bin.skipBits(15);
                    }
                    int pictureType = (int)(Math.pow(2 * bin.readBit(), 2.0) + (double)(2 * bin.readBit()) + (double)bin.readBit());
                    bin.skipBits(6);
                    if (bin.readBit() == 1) {
                        bin.skipBits(2);
                    }
                    bin.skipBits(4);
                    int widthInfo = 0;
                    for (int i = 8; i >= 0; --i) {
                        widthInfo += (int)Math.pow(2 * bin.readBit(), i);
                    }
                    widthInfo = (widthInfo + 1) * 4;
                    bin.skipBits(1);
                    int heightInfo = 0;
                    for (int i = 8; i >= 0; --i) {
                        heightInfo += (int)Math.pow(2 * bin.readBit(), i);
                    }
                    this.width = widthInfo;
                    this.height = heightInfo *= 4;
                    return pictureType == 0 ? 33 : 35;
                }
                catch (Exception ee) {
                    this.logger.error("Error extracting resolution from MPEG-4 data.", (Throwable)ee);
                    return Integer.MIN_VALUE;
                }
            }
            return Integer.MIN_VALUE;
        }
        this.logger.error("Given data is null or invalid");
        return Integer.MIN_VALUE;
    }

    @Override
    public synchronized void onUdpData(byte[] data) {
        block20: {
            if (this.videoCodec == Codec.MPEG4) {
                try {
                    int offset;
                    if ((data[1] & 0x7F) != 34) {
                        return;
                    }
                    this.checkForPacketLoss(data);
                    ++this.packetsReceived;
                    if ((data[12] & 0x80) == 0) {
                        offset = 16;
                        this.previousPacket = new byte[data.length - offset];
                        System.arraycopy(data, offset, this.previousPacket, 0, data.length - offset);
                    } else if ((data[12] & 0x40) == 0) {
                        offset = 20;
                        byte sbit = (byte)(data[12] >> 3 & 7);
                        if ((this.numberOfEbit + sbit) % 8 != 0) {
                            ++this.packetsDropped;
                            return;
                        }
                        if (sbit != 0) {
                            this.completeFrame.write(this.previousPacket, 0, this.previousPacket.length - 1);
                            byte sbitMask = 0;
                            for (int i = 0; i < 8 - sbit; ++i) {
                                sbitMask = (byte)((double)sbitMask + Math.pow(2.0, i));
                            }
                            data[20] = (byte)(data[20] & sbitMask);
                            data[20] = (byte)(data[20] | this.lastFuckingByteFrompreviousFrame);
                        } else {
                            this.completeFrame.write(this.previousPacket, 0, this.previousPacket.length);
                        }
                        this.previousPacket = new byte[data.length - offset];
                        System.arraycopy(data, offset, this.previousPacket, 0, data.length - offset);
                    }
                    this.numberOfEbit = (byte)(data[12] & 7);
                    int mask = -1;
                    for (int i = 0; i < this.numberOfEbit; ++i) {
                        mask = (byte)((double)mask - Math.pow(2.0, i));
                    }
                    this.lastFuckingByteFrompreviousFrame = (byte)(data[data.length - 1] & mask);
                    if (this.lastPacketsStat + 120000L < System.currentTimeMillis()) {
                        this.logger.info("Packets Rec/Drop: " + this.packetsReceived + "/" + this.packetsDropped + ". Ratio: " + this.packetsDropped * 100L / this.packetsReceived + "% loss for " + this.getVideoSrv());
                        this.lastPacketsStat = System.currentTimeMillis();
                    }
                    if (StreamingHelper.isFollowUp(data)) break block20;
                    try {
                        this.completeFrame.write(this.previousPacket);
                    }
                    catch (Exception e) {
                        this.logger.error("Error writing last piece to packet for " + this.getVideoSrv());
                        this.logger.error((Object)e, (Throwable)e);
                    }
                    byte[] completeFrameAsByteArray = this.completeFrame.toByteArray();
                    this.completeFrame.reset();
                    int mediaType = this.checkForH263MediaType(completeFrameAsByteArray);
                    if (mediaType < 0) {
                        this.logger.warn("Unknown Mediatype. Discarding frame. Length: " + completeFrameAsByteArray.length + " Origin: " + this.getVideoSrv());
                        break block20;
                    }
                    try {
                        MediaFrame mediaFrame = StreamingHelper.createSeeTecVideoFrameHeader(this.mediaTypeFlag, this.width, this.height, completeFrameAsByteArray, this.parameterSet);
                        long timestamp = this.calculateTimestampFromRTP(data, mediaType);
                        this.deliverFrame(mediaType, mediaFrame, timestamp);
                    }
                    catch (Exception e) {
                        this.logger.error("Ignoring packet due to unexpected error: " + e.getMessage() + ". For: " + this.getVideoSrv());
                    }
                }
                catch (Exception exception) {
                    this.logger.debug("Ignoring packet due to unexpected error: " + exception.getMessage(), (Throwable)exception);
                }
            } else {
                if (this.isProprietaryBoschWatermarkingData(data)) {
                    return;
                }
                this.respectEveryParameterSet = true;
                this.enableDeliverPPSBeforePFrameIfAvailable = true;
                super.processRtpData(data);
            }
        }
    }

    private boolean isProprietaryBoschWatermarkingData(byte[] data) {
        return (data[1] & 0x7F) == 97;
    }

    @Override
    public final boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    private void sendRCPDataPacket(Packet p) {
        if (this.rcpWriter != null) {
            this.rcpWriter.send(p.serialize());
        } else {
            this.logger.warn("rcpWriter is null for " + this.getVideoSrv());
            this.listener.sendStatusService(-21603);
            this.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRCPDataPacket(byte[] data) {
        block100: {
            Packet p = Packet.deserialize(data);
            if (this.isShutdown()) {
                return;
            }
            if (p == null) {
                return;
            }
            if (!this.registered) {
                CapabilityListRsp rsp;
                if (p instanceof ClientRegistrationRsp) {
                    ClientRegistrationRsp rsp2 = (ClientRegistrationRsp)p;
                    if (rsp2.registerFailed()) {
                        this.logger.warn("Register failed for " + this.getVideoSrv());
                        this.listener.sendStatusService(-21657);
                        this.shutdown();
                    } else {
                        this.clientID = rsp2.getClientID();
                        this.logger.info("Register success, clientID is [ " + Packet.hexString(this.clientID) + "] for " + this.getVideoSrv());
                        this.registered = true;
                        BoschCameraSrv boschCameraSrv = (BoschCameraSrv)this.getVideoSrv();
                        ConfVideoInputFormatEx confVideoInputFormatEx = new ConfVideoInputFormatEx();
                        confVideoInputFormatEx.setClientID(this.clientID);
                        confVideoInputFormatEx.setNumericDescriptorAsInt(this.videoSourceNr);
                        confVideoInputFormatEx.setRead();
                        this.sendRCPDataPacket(confVideoInputFormatEx);
                        boschCameraSrv.setCaptureModeSet(true);
                    }
                } else if (p instanceof CoderListRsp) {
                    BoschDevice boschDevice;
                    CoderListRsp rsp3 = (CoderListRsp)p;
                    if (rsp3.isActionError()) {
                        this.logger.warn("Error when retrieving coders: " + rsp3.toString() + " for " + this.getVideoSrv());
                        this.shutdown();
                        return;
                    }
                    this.coderToUse[1] = this.streamID == 1L ? (!(boschDevice = (BoschDevice)this.getVideoSrv().getDevice()).useSingleJpegImages() && this.videoCodec == Codec.MJPEG ? rsp3.getCoders()[2] : rsp3.getCoders()[0]) : rsp3.getCoders()[1];
                } else if (p instanceof CapabilityListRsp && !(rsp = (CapabilityListRsp)p).isH264Supported() && this.videoCodec == Codec.H264) {
                    this.logger.error("H.264 selected but firmware too old to deliver H.264 for " + this.getVideoSrv());
                    this.listener.sendStatusService(-21668);
                    this.shutdown();
                }
            } else if (p instanceof Connect) {
                this.onConnect((Connect)p);
            } else if (p instanceof ConfVideoInputFormatEx) {
                ConfVideoInputFormatEx rsp = (ConfVideoInputFormatEx)p;
                if (rsp.isActionRespone()) {
                    if (!this.setOfNewCaptureModeRequested) {
                        ConfVideoInputFormatEx.VIDEO_FORMAT configuredVideoFormat = null;
                        try {
                            String displayResolution = this.getVideoSrv().getDevice().getDeviceCnf().getCaptureMode().getDisplayResolution();
                            int captureModeMaxFramerate = this.getVideoSrv().getDevice().getDeviceCnf().getCaptureMode().getMaxFramerate() / 1000;
                            configuredVideoFormat = ConfVideoInputFormatEx.VIDEO_FORMAT.valueOf(displayResolution, captureModeMaxFramerate);
                        }
                        catch (ConfigurationException ex) {
                            this.logger.error((Object)ex, (Throwable)ex);
                        }
                        finally {
                            if (configuredVideoFormat == null) {
                                configuredVideoFormat = rsp.getVideoFormat();
                            }
                        }
                        if (rsp.getVideoFormat() != configuredVideoFormat) {
                            this.logger.info("New capture mode has to be set. New one should be: " + (Object)((Object)configuredVideoFormat) + " for " + this);
                            ConfVideoInputFormatEx confVideoInputFormatEx = new ConfVideoInputFormatEx();
                            confVideoInputFormatEx.setClientID(this.clientID);
                            confVideoInputFormatEx.setNumericDescriptorAsInt(this.videoSourceNr);
                            confVideoInputFormatEx.setWrite();
                            confVideoInputFormatEx.setMode(ConfVideoInputFormatEx.MODE.FIXED);
                            confVideoInputFormatEx.setVideoFormat(configuredVideoFormat);
                            this.setOfNewCaptureModeRequested = true;
                            this.sendRCPDataPacket(confVideoInputFormatEx);
                        } else {
                            this.logger.info("Correct capture mode (" + (Object)((Object)configuredVideoFormat) + ") already set for " + this);
                            this.setOfNewCaptureModeSuccessfull = true;
                        }
                    } else {
                        this.setOfNewCaptureModeSuccessfull = true;
                    }
                } else if (rsp.isActionError()) {
                    this.logger.info("Command unknown. Probably old device. Go on without for " + this);
                    this.setOfNewCaptureModeSuccessfull = true;
                }
                if (this.setOfNewCaptureModeSuccessfull) {
                    BaseFramerate reqBaseFramerate = new BaseFramerate();
                    reqBaseFramerate.setClientID(this.clientID);
                    reqBaseFramerate.setRead();
                    reqBaseFramerate.setActionRequest();
                    reqBaseFramerate.setNumericDescriptorAsInt(this.videoSourceNr);
                    this.sendRCPDataPacket(reqBaseFramerate);
                }
            } else if (p instanceof ConfAudio) {
                ConfAudio rsp = (ConfAudio)p;
                if (!rsp.isActionError() && this.isAudioEnabled && !rsp.getState()) {
                    ConfAudio reqAudioCap = new ConfAudio();
                    reqAudioCap.setClientID(this.clientID);
                    reqAudioCap.setWrite();
                    reqAudioCap.setState(true);
                    this.sendRCPDataPacket(reqAudioCap);
                }
            } else if (p instanceof BaseFramerate) {
                BaseFramerate rsp = (BaseFramerate)p;
                if (!rsp.isActionError()) {
                    this.baseFramerate = rsp.getBaseFramerate();
                    this.logger.info("Read base framerate: " + this.baseFramerate + " for " + this);
                } else {
                    this.logger.info("Reading base framerate failed. Stay with default: " + this.baseFramerate + " for " + this);
                }
                if (this.videoCodec != Codec.MJPEG) {
                    this.fps /= 1000L;
                    this.fps = this.fps < 1L ? 1L : this.fps;
                    this.fps = (long)this.baseFramerate / this.fps;
                }
                if (this.videoCodec == Codec.MJPEG) {
                    if (this.baseFramerate >= 50000) {
                        this.fps *= 2L;
                    }
                    this.quality /= 1000;
                    this.qualityForJpeg = this.quality;
                } else if (this.isConstantBitrateUsed) {
                    this.quality = 0;
                } else {
                    this.quality /= 3000;
                    this.quality = this.quality < 4 ? 4 : this.quality;
                    this.quality = this.quality > 31 ? 31 : this.quality;
                }
                this.logger.info(String.format("Image parameter: codec=%s, source=%s, quality=%s, bandwidth=%s, res=%sx%s, skip ratio=%s for %s", this.videoCodec, this.videoSourceNr, this.quality, this.bandwidth, this.width, this.height, this.fps, this.getVideoSrv()));
                ConfAudio reqAudioCap = new ConfAudio();
                reqAudioCap.setClientID(this.clientID);
                this.sendRCPDataPacket(reqAudioCap);
                MulticastGroupIP reqMulticastIP = new MulticastGroupIP();
                reqMulticastIP.setClientID(this.clientID);
                reqMulticastIP.setRead();
                reqMulticastIP.setNumericDescriptor(this.coderToUse);
                reqMulticastIP.setActionRequest();
                this.sendRCPDataPacket(reqMulticastIP);
                MulticastGroupPort reqMulticastPort = new MulticastGroupPort();
                reqMulticastPort.setClientID(this.clientID);
                reqMulticastPort.setRead();
                reqMulticastPort.setNumericDescriptor(this.coderToUse);
                reqMulticastPort.setActionRequest();
                this.sendRCPDataPacket(reqMulticastPort);
                if (this.isAudioEnabled) {
                    MulticastGroupPortAudio reqMulticastPortAudio = new MulticastGroupPortAudio();
                    reqMulticastPortAudio.setClientID(this.clientID);
                    reqMulticastPortAudio.setRead();
                    reqMulticastPortAudio.setNumericDescriptor(this.coderToUse);
                    reqMulticastPortAudio.setActionRequest();
                    this.sendRCPDataPacket(reqMulticastPortAudio);
                }
                StreamingVal reqStreaming = new StreamingVal();
                reqStreaming.setClientID(this.clientID);
                reqStreaming.setWrite();
                if (!this.isMulticastEnabled) {
                    reqStreaming.setStreamingOff();
                } else {
                    reqStreaming.setStreamingMpeg4();
                }
                reqStreaming.setActionRequest();
                this.sendRCPDataPacket(reqStreaming);
                TimeStampVal reqTime = new TimeStampVal();
                reqTime.setClientID(this.clientID);
                reqTime.setWrite();
                if (this.useDateTime) {
                    reqTime.setTimeStampOnTop();
                } else {
                    reqTime.setTimeStampOff();
                }
                reqTime.setActionRequest();
                this.sendRCPDataPacket(reqTime);
                if (this.videoCodec != Codec.MJPEG) {
                    Mpeg4IFrameDistance reqIFrame = new Mpeg4IFrameDistance();
                    reqIFrame.setClientID(this.clientID);
                    reqIFrame.setWrite();
                    reqIFrame.setActionRequest();
                    reqIFrame.setNumericDescriptorAsInt(this.profile);
                    reqIFrame.setDistance((int)this.iFrameDist);
                    this.sendRCPDataPacket(reqIFrame);
                    Mpeg4GopStructure reqGop = new Mpeg4GopStructure();
                    reqGop.setClientID(this.clientID);
                    reqGop.setWrite();
                    reqGop.setActionRequest();
                    reqGop.setNumericDescriptorAsInt(this.profile);
                    reqGop.setValue(Mpeg4GopStructure.GOP_VALUES.IP.getValue());
                    this.sendRCPDataPacket(reqGop);
                    Mpeg4Bandwidth reqBand = new Mpeg4Bandwidth();
                    reqBand.setClientID(this.clientID);
                    reqBand.setWrite();
                    reqBand.setActionRequest();
                    reqBand.setNumericDescriptorAsInt(this.profile);
                    reqBand.setBandwidth(this.bandwidth);
                    this.sendRCPDataPacket(reqBand);
                    Mpeg4BandwidthSoft reqBandS = new Mpeg4BandwidthSoft();
                    reqBandS.setClientID(this.clientID);
                    reqBandS.setWrite();
                    reqBandS.setActionRequest();
                    reqBandS.setNumericDescriptorAsInt(this.profile);
                    reqBandS.setBandwidth(this.bandwidth);
                    this.sendRCPDataPacket(reqBandS);
                    Mpeg4BandwidthHard reqBandH = new Mpeg4BandwidthHard();
                    reqBandH.setClientID(this.clientID);
                    reqBandH.setWrite();
                    reqBandH.setActionRequest();
                    reqBandH.setNumericDescriptorAsInt(this.profile);
                    reqBandH.setBandwidth(this.bandwidth);
                    this.sendRCPDataPacket(reqBandH);
                }
                Mpeg4Resolution reqRes = new Mpeg4Resolution();
                reqRes.setClientID(this.clientID);
                reqRes.setWrite();
                reqRes.setActionRequest();
                reqRes.setNumericDescriptorAsInt(this.profile);
                reqRes.setResolution(this.res);
                this.sendRCPDataPacket(reqRes);
                Mpeg4FrameSkipRatio reqSkip = new Mpeg4FrameSkipRatio();
                reqSkip.setClientID(this.clientID);
                reqSkip.setWrite();
                reqSkip.setActionRequest();
                reqSkip.setNumericDescriptorAsInt(this.profile);
                reqSkip.setSkipRatio((int)this.fps);
                this.sendRCPDataPacket(reqSkip);
                VideoOperationMode reqViMode = new VideoOperationMode();
                reqViMode.setClientID(this.clientID);
                reqViMode.setWrite();
                reqViMode.setActionRequest();
                reqViMode.setNumericDescriptor(this.coderToUse);
                reqViMode.setMode(this.videoCodec == Codec.H264 ? 2 : 1);
                this.sendRCPDataPacket(reqViMode);
                Mpeg4CurrentParams reqCurr = new Mpeg4CurrentParams();
                reqCurr.setClientID(this.clientID);
                reqCurr.setWrite();
                reqCurr.setActionRequest();
                reqCurr.setNumericDescriptor(this.coderToUse);
                reqCurr.setParams(this.profile);
                this.sendRCPDataPacket(reqCurr);
                BoschDevice boschDevice = (BoschDevice)this.getVideoSrv().getDevice();
                if (this.videoCodec == Codec.MJPEG && boschDevice.getDeviceType() != 201715L) {
                    JpegStreamSetup jpegStreamSetupRequest = new JpegStreamSetup();
                    jpegStreamSetupRequest.setClientID(this.clientID);
                    jpegStreamSetupRequest.setWrite();
                    jpegStreamSetupRequest.setActionRequest();
                    jpegStreamSetupRequest.setNumericDescriptorAsInt(this.profile);
                    jpegStreamSetupRequest.setResolution(this.res);
                    jpegStreamSetupRequest.setFPS((int)this.fps);
                    jpegStreamSetupRequest.setQuality(this.qualityForJpeg);
                    this.sendRCPDataPacket(jpegStreamSetupRequest);
                }
                this.myThread = new Thread((Runnable)this, this.toString());
                this.myThread.start();
            } else if (p instanceof StreamingVal) {
                StreamingVal rsp = (StreamingVal)p;
                if (rsp.isActionError()) {
                    this.evaluateActionError(rsp);
                }
            } else if (p instanceof MulticastGroupIP) {
                MulticastGroupIP rsp = (MulticastGroupIP)p;
                if (rsp.isActionError()) {
                    this.evaluateActionError(rsp);
                }
                this.multicastIP = rsp.getIp();
            } else if (p instanceof MulticastGroupPort) {
                MulticastGroupPort rsp = (MulticastGroupPort)p;
                if (rsp.isActionError()) {
                    this.evaluateActionError(rsp);
                    return;
                }
                this.multicastPort = rsp.getPort();
                if (this.isMulticastEnabled && this.multicastIP != null && this.multicastPort > 0) {
                    this.logger.info("Using multicast address: " + this.multicastIP + ":" + this.multicastPort);
                    this.udpReaderMulticast = new UdpReaderMulticast(this, this.multicastIP, this.multicastPort);
                    this.udpReaderMulticast.init(524288, 5000, true);
                }
            } else if (p instanceof MulticastGroupPortAudio) {
                MulticastGroupPortAudio rsp = (MulticastGroupPortAudio)p;
                if (rsp.isActionError()) {
                    this.evaluateActionError(rsp);
                    return;
                }
                this.multicastPortAudio = rsp.getPort();
                if (this.isMulticastEnabled && this.multicastIP != null && this.multicastPortAudio > 0) {
                    this.logger.info("Using multicast audio address: " + this.multicastIP + ":" + this.multicastPortAudio);
                    this.udpReaderMulticastAudio = new UdpReaderMulticast(this.adapter, this.multicastIP, this.multicastPortAudio);
                    this.udpReaderMulticastAudio.init(524288, 5000, true);
                }
            } else if (p instanceof Disconnect) {
                Disconnect rsp = (Disconnect)p;
                if (rsp.getStatus() != 1) {
                    this.logger.warn("Disconnect failed for " + this.getVideoSrv());
                }
                if (this.isShutdown()) {
                    this.logger.warn("shutting down, disconnected from server [" + rsp + "]");
                    this.listener.sendStatusService(-21603);
                    this.shutdown();
                }
            } else if (p instanceof ClientUnregister) {
                ClientUnregister rsp = (ClientUnregister)p;
                if (rsp.getStatus() != 1) {
                    this.logger.warn("ClientUnregister failed for " + this.getVideoSrv());
                }
                this.logger.warn("shutting down, unregistered from server [" + rsp + "]");
                this.listener.sendStatusService(-21603);
                this.shutdown();
            } else if (p instanceof TimeoutWarning) {
                HardwareVersion req = new HardwareVersion();
                req.setClientID(this.clientID);
                this.sendRCPDataPacket(req);
            } else if (p instanceof VideoAlarmState) {
                VideoAlarmState rsp = (VideoAlarmState)p;
                if (rsp.getNumericDescriptorAsInt() == this.videoSourceNr) {
                    try {
                        if (!this.listener.getVideoSourceParameter().isEnableVideoloss()) break block100;
                        if (rsp.getState()) {
                            if (this.listener.hasHardwareMotionDetection()) {
                                ((LiveCameraSrv)this.getVideoSrv()).evaluateVideoLoss();
                                if (System.currentTimeMillis() > this.lastVideoLossEventSent + 5000L) {
                                    this.lastVideoLossEventSent = System.currentTimeMillis();
                                    this.getVideoSrv().getCore().sendVideoLossEvent(this.getVideoSrv());
                                }
                            }
                            break block100;
                        }
                        this.getCore().sendOPCEvent("false", OPCLowerNodeIDType.CAMERA_VIDEOLOSS_STATUS, this.getVideoSrv().getEntityID());
                    }
                    catch (ConfigurationException ce) {
                        this.logger.error("Error evaluating videoLoss flag for " + this);
                    }
                }
            } else if (p instanceof MotionAlarmState) {
                MotionAlarmState rsp = (MotionAlarmState)p;
                if (rsp.getState()) {
                    try {
                        if (this.getVideoSrv() != null && this.getVideoSrv().getVideoSourceCnf() != null && this.getVideoSrv().getHardwareMotionDetection() != null && rsp.getNumericDescriptorAsInt() == this.getVideoSrv().getVideoSourceCnf().getServerEntryNo()) {
                            ((BoschMotionDetectionHandler)((Object)((BoschHardwareMotionDetection)this.getVideoSrv().getHardwareMotionDetection()).getMotionDetectionHandler())).processMotionDetection();
                        }
                    }
                    catch (Exception i) {
                        this.logger.error("Error while forwarding of motion detection for " + this.getVideoSrv(), (Throwable)i);
                    }
                }
            } else if (!(p instanceof H264EncBaseOperationMode) && p instanceof Mpeg4CurrentParams) {
                Mpeg4CurrentParams rsp = (Mpeg4CurrentParams)p;
                if (rsp.isActionError()) {
                    this.evaluateActionError(rsp);
                } else {
                    Connect req = new Connect();
                    req.setClientID(this.clientID);
                    req.setSessionID(this.sessionID);
                    MediaDescriptor md = MediaDescriptor.createMpeg4VideoMediaDescriptor();
                    md.setLine((byte)this.videoSourceNr);
                    md.setCoder(this.coderToUse[1]);
                    if (this.videoCodec == Codec.H264) {
                        md.setCoding(MediaDescriptor.CODING_H264);
                    } else if (this.videoCodec == Codec.MJPEG) {
                        md.setCoding(MediaDescriptor.CODING_JPEG);
                    } else {
                        md.setCoding(MediaDescriptor.CODING_MPEG4_ELEM);
                    }
                    if (!this.isMulticastEnabled) {
                        md.setMTAPort(this.udpReader.getPort());
                    } else {
                        md.setMTAPort(this.multicastPort);
                        md.setMTAAddress(new byte[]{-32, 0, 0, 0});
                    }
                    req.addDescriptor(md);
                    this.sendRCPDataPacket(req);
                    if (this.isAudioEnabled) {
                        Connect reqAudio = new Connect();
                        reqAudio.setClientID(this.clientID);
                        reqAudio.setSessionID(this.sessionIDAudio);
                        MediaDescriptor mdAudio = MediaDescriptor.createMpeg4VideoMediaDescriptor();
                        mdAudio.setMediaAudio();
                        mdAudio.setCoding(MediaDescriptor.CODING_G711);
                        mdAudio.setLine((byte)1);
                        if (!this.isMulticastEnabled) {
                            mdAudio.setMTAPort(this.udpReaderAudio.getPort());
                        } else {
                            mdAudio.setMTAPort(this.multicastPortAudio);
                            mdAudio.setMTAAddress(new byte[]{-32, 0, 0, 0});
                        }
                        reqAudio.addDescriptor(mdAudio);
                        this.sendRCPDataPacket(reqAudio);
                    }
                }
            }
        }
    }

    private void evaluateActionError(Packet rsp) {
        if (rsp.isActionError()) {
            this.logger.warn(rsp.toString());
            if (rsp.getErrorCode() == -96) {
                this.listener.sendStatusService(-21657);
            }
            this.shutdown();
        }
    }

    protected void onConnect(Connect rsp) {
        if (rsp.isActionError()) {
            this.logger.warn("shutting down due to [ " + rsp + "] for " + this.getVideoSrv());
            this.listener.sendStatusService(-21603);
            this.shutdown();
        }
        for (MediaDescriptor mediaDescriptor : rsp.getDescriptors()) {
            if (mediaDescriptor.isStatusError()) {
                this.logger.warn("MediaDescriptor error:" + mediaDescriptor.toStringRsp());
                this.logger.warn("Shutting down due to errors in MediaDescriptors for " + this.getVideoSrv());
                this.shutdown();
                return;
            }
            if (mediaDescriptor.isMediaVideo()) {
                this.sessionID = rsp.getSessionID();
                continue;
            }
            if (!mediaDescriptor.isMediaAudio()) continue;
            this.sessionIDAudio = rsp.getSessionID();
        }
        this.listener.sendStatusService(0);
    }

    public void setStreamID(long streamID) {
        this.streamID = streamID;
    }

    @Override
    public String toString() {
        String sThis = "de.seetec.v5.re.cm.devide.video.bosch.mpeg.BoschMPEGVideoSourceClient@" + Integer.toHexString(this.hashCode());
        return "[" + sThis.substring(sThis.lastIndexOf(46) + 1) + ", " + this.getVideoSrv() + "]";
    }

    @Override
    public void processData(byte[] data) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void sendStatusService(int errorCode) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

