/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.bosch;

import de.seetec.v5.re.cm.device.shared.VideoSrv;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.SSLConstantsIntf;
import de.seetec.v5.shared.util.ConfigurationException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PelcoDHandler
implements SSLConstantsIntf {
    public static final int PAN = 0;
    public static final int PAN_PLUS = 1;
    public static final int PAN_MINUS = 2;
    public static final int TILT = 3;
    public static final int TILT_PLUS = 4;
    public static final int TILT_MINUS = 5;
    public static final int ZOOM = 6;
    public static final int ZOOM_PLUS = 7;
    public static final int ZOOM_MINUS = 8;
    public static final int IRIS_PLUS = 9;
    public static final int IRIS_MINUS = 10;
    public static final int AUTO_IRIS = 11;
    public static final int FOCUS_PLUS = 12;
    public static final int FOCUS_MINUS = 13;
    public static final int AUTO_FOCUS = 14;
    public static final int ADD_PRESET = 15;
    public static final int SET_PRESET = 16;
    public static final int REMOVE_PRESET = 17;
    public static final int STOP = 18;
    public static final int DO_NOTHING = 19;
    public static final int ABSOLUTE_ZOOM_SET = 20;
    public static final int ABSOLUTE_ZOOM_GET = 21;
    public static final int ABSOLUTE_PAN_GET = 23;
    public static final int ABSOLUTE_TILT_GET = 25;
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.bosch.PelcoDHandler";
    private byte[] hexCommand = null;
    private int videoSourceID = Integer.MIN_VALUE;
    private Logger logger = null;

    public int init(VideoSrv videoSrv) {
        this.logger = LogManager.getLogger((String)CLASS_NAME);
        if (videoSrv != null && videoSrv.getVideoSourceCnf() != null) {
            try {
                this.videoSourceID = (byte)videoSrv.getVideoSourceCnf().getPtzAddress();
            }
            catch (ConfigurationException ce) {
                this.logger.warn("Error when reading 'VideoSourceID'. Set to 01.");
                this.videoSourceID = 1;
            }
        } else {
            this.logger.warn("'VideoSourceID' not specified. Set to 01.");
            this.videoSourceID = 1;
        }
        this.hexCommand = new byte[7];
        for (int i = 0; i < this.hexCommand.length; ++i) {
            this.hexCommand[i] = 0;
        }
        return 0;
    }

    @SuppressFBWarnings(value={"EI"})
    public byte[] getCommandAsByteArray() {
        return this.hexCommand;
    }

    public String getCommandAsHexString() {
        return Basic.byteArrayToHexString((byte[])this.hexCommand);
    }

    @SuppressFBWarnings(value={"PZLA"})
    private byte[] calculateChecksum(byte[] field) {
        int checksum = 0;
        if (field.length != 7) {
            this.logger.warn("Given field has length != 7");
            return null;
        }
        for (int i = 1; i <= 5; ++i) {
            checksum = (byte)(checksum + field[i]);
        }
        field[6] = checksum = (int)((byte)(checksum % 256));
        return field;
    }

    public int setPresetCommand(int command, int number) {
        byte[] data = Basic.int4ToByteArray((int)number, (int)2);
        return this.setCameraCommand(command, data);
    }

    public int setGenericCommand(int command, int number) {
        byte[] data = Basic.int4ToByteArray((int)number, (int)2);
        return this.setCameraCommand(command, data);
    }

    public int setPTZCommand(int command, int number) {
        int step = 1587;
        if (command == 0) {
            command = number != 0 ? (number > 0 ? 1 : 2) : 19;
        } else if (command == 3) {
            command = number != 0 ? (number > 0 ? 4 : 5) : 19;
        } else if (command == 6) {
            if (number != 0) {
                command = number > 0 ? 7 : 8;
            } else if (this.hexCommand[4] == 0 && this.hexCommand[5] == 0) {
                command = 18;
            }
        } else {
            return -20000;
        }
        number = Math.abs(number);
        number = (number /= step) < 0 ? 0 : number;
        int n = number = number > 63 ? 63 : number;
        if (command == 1 || command == 2) {
            this.hexCommand[4] = (byte)number;
        } else if (command == 4 || command == 5) {
            this.hexCommand[5] = (byte)number;
        }
        return this.setCameraCommand(command, null);
    }

    public int setAbsolutePTZCommand(int command, short data) {
        byte[] ptzValue = new byte[]{(byte)(data >> 8 & 0xFF), (byte)data};
        return this.setCameraCommand(command, ptzValue);
    }

    public int setCameraCommand(int command, boolean enable) {
        byte[] data = new byte[]{0, 0};
        data[1] = enable ? 1 : 2;
        data[1] = enable ? 0 : 2;
        return this.setCameraCommand(command, data);
    }

    private int setCameraCommand(int command, byte[] data) {
        if (command == 1) {
            this.hexCommand[3] = (byte)(this.hexCommand[3] | 2);
        } else if (command == 2) {
            this.hexCommand[3] = (byte)(this.hexCommand[3] | 4);
        } else if (command == 4) {
            this.hexCommand[3] = (byte)(this.hexCommand[3] | 8);
        } else if (command == 5) {
            this.hexCommand[3] = (byte)(this.hexCommand[3] | 0x10);
        } else if (command == 7) {
            this.hexCommand[3] = (byte)(this.hexCommand[3] | 0x20);
        } else if (command == 8) {
            this.hexCommand[3] = (byte)(this.hexCommand[3] | 0x40);
        } else if (command == 9) {
            this.hexCommand[2] = 2;
        } else if (command == 10) {
            this.hexCommand[2] = 4;
        } else if (command == 11) {
            this.hexCommand[3] = 45;
        } else if (command == 12) {
            this.hexCommand[2] = 1;
        } else if (command == 13) {
            this.hexCommand[3] = -128;
        } else if (command == 14) {
            this.hexCommand[3] = 43;
        } else if (command == 15) {
            this.hexCommand[3] = 3;
        } else if (command == 16) {
            this.hexCommand[3] = 7;
        } else if (command == 17) {
            this.hexCommand[3] = 5;
        } else if (command == 18) {
            this.hexCommand[2] = 0;
            this.hexCommand[3] = 0;
        } else if (command == 20) {
            this.hexCommand[3] = 79;
        } else if (command == 21) {
            this.hexCommand[3] = 85;
        } else if (command == 23) {
            this.hexCommand[3] = 81;
        } else if (command == 25) {
            this.hexCommand[3] = 83;
        } else if (command != 19) {
            return -20000;
        }
        this.hexCommand[0] = -1;
        this.hexCommand[1] = (byte)this.videoSourceID;
        if (data != null) {
            this.hexCommand[4] = data[0];
            this.hexCommand[5] = data[1];
        }
        this.hexCommand = this.calculateChecksum(this.hexCommand);
        return 0;
    }
}

