/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.bosch;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public enum EncoderOperationMode {
    BOSCH_OPERATION_MODE_COPY(0, 8, ""),
    BOSCH_OPERATION_MODE_COMPATIBILITY_MODE_H264_BP(1, 8, ""),
    BOSCH_OPERATION_MODE_H264_MP_SD(3, 8, ""),
    BOSCH_OPERATION_MODE_H264_MP_FIXED_720P(4, 15, "1280x720"),
    BOSCH_OPERATION_MODE_H264_MP_FIXED_720P_FULL_FPS(5, 15, "1280x720"),
    BOSCH_OPERATION_MODE_H264_MP_FIXED_1080P(6, 22, "1920x1080"),
    BOSCH_OPERATION_MODE_H264_MP_FIXED_720P_SKIP3(7, 15, "1280x720"),
    BOSCH_OPERATION_MODE_H264_MP_FIXED_720P_SKIP4(8, 15, "1280x720"),
    BOSCH_OPERATION_MODE_H264_MP_FIXED_1080P_SKIP7(9, 22, "1920x1080"),
    BOSCH_OPERATION_MODE_H264_MP_SD_ROI_PTZ(10, 8, ""),
    BOSCH_OPERATION_MODE_H264_MP_HD_5MP(11, 23, "2592x1944"),
    BOSCH_OPERATION_MODE_H264_MP_SD_UPRIGHT(12, 8, ""),
    BOSCH_OPERATION_MODE_H264_MP_SD_4CIF_4_3(13, 8, "704x576"),
    BOSCH_OPERATION_MODE_H264_MP_SD_MAX288P(14, 8, "704x288"),
    BOSCH_OPERATION_MODE_H264_MP_HD_1280_960_4_3(15, 17, "1280x960"),
    BOSCH_OPERATION_MODE_H264_MP_HD_1440_1080(16, 19, "1440x1080"),
    BOSCH_OPERATION_MODE_H264_MP_HD_1280_1024(17, 18, "1280x1024"),
    BOSCH_OPERATION_MODE_H264_MP_576_1024_UPRIGHT(18, 8, "576x1024"),
    BOSCH_OPERATION_MODE_H264_MP_HD_720P_CROPPED(19, 15, "1280x720"),
    BOSCH_OPERATION_MODE_H264_MP_HD_2704_2032(20, 24, "2704x2032"),
    BOSCH_OPERATION_MODE_H264_MP_HD_2992_1680(21, 25, "2992x1680"),
    BOSCH_OPERATION_MODE_H264_MP_HD_3840_2160(22, 27, "3840x2160"),
    BOSCH_OPERATION_MODE_H264_MP_HD_4000_3000(23, 28, "4000x3000"),
    BOSCH_OPERATION_MODE_H264_MP_HD_3584_2016(24, 26, "3584x2016"),
    BOSCH_OPERATION_MODE_H264_MP_HD_800_600(25, 9, "800x600"),
    BOSCH_OPERATION_MODE_H264_MP_HD_1024_768(26, 10, "1024x768"),
    BOSCH_OPERATION_MODE_H264_MP_HD_1280_960(27, 17, "1280x960"),
    BOSCH_OPERATION_MODE_H264_MP_HD_1600_1200(28, 20, "1600x1200");

    private final int operationTag;
    private int sortingOrder = -1;
    private String resolution = null;

    private EncoderOperationMode(int operationTag, int sortingOrder, String resolution) {
        this.operationTag = operationTag;
        this.sortingOrder = sortingOrder;
        this.resolution = resolution;
    }

    public int getOperationTag() {
        return this.operationTag;
    }

    public int getSortingOrder() {
        return this.sortingOrder;
    }

    public String getResolution() {
        return this.resolution;
    }

    public static EncoderOperationMode valueOf(int resolutionTag) {
        EncoderOperationMode mapping = null;
        for (EncoderOperationMode t : EncoderOperationMode.values()) {
            if (resolutionTag != t.getOperationTag()) continue;
            mapping = t;
            break;
        }
        return mapping;
    }

    public static List<EncoderOperationMode> getListOfMatchingModes(String matcher) {
        ArrayList<EncoderOperationMode> mapping = new ArrayList<EncoderOperationMode>();
        if (matcher != null) {
            for (EncoderOperationMode t : EncoderOperationMode.values()) {
                if (!t.name().contains(matcher)) continue;
                mapping.add(t);
            }
        }
        return mapping;
    }

    public static List<EncoderOperationMode> getSortedList() {
        ArrayList<EncoderOperationMode> sortedList = new ArrayList<EncoderOperationMode>(Arrays.asList(EncoderOperationMode.values()));
        Collections.sort(sortedList, new EncoderOperationModeComparator());
        return sortedList;
    }

    public static class EncoderOperationModeComparator
    implements Comparator<EncoderOperationMode>,
    Serializable {
        private static final long serialVersionUID = 1298685239937646952L;

        @Override
        public int compare(EncoderOperationMode mode1, EncoderOperationMode mode2) {
            int mode1Order = mode1.getSortingOrder();
            int mode2Order = mode2.getSortingOrder();
            return mode1Order - mode2Order;
        }
    }
}

