/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.bosch;

import de.seetec.v5.re.cm.device.shared.Device;
import de.seetec.v5.re.cm.device.shared.MotionRecording;
import de.seetec.v5.re.cm.device.shared.genericevent.GenericEventTriggerCnf;
import de.seetec.v5.re.cm.device.shared.genericevent.GenericEventTriggerHandler;
import de.seetec.v5.re.cm.device.shared.net.RCPNetworkCallback;
import de.seetec.v5.re.cm.device.video.bosch.BoschCameraSrv;
import de.seetec.v5.re.cm.device.video.bosch.BoschDevice;
import de.seetec.v5.re.cm.device.video.bosch.TpktStreamReader;
import de.seetec.v5.re.cm.device.video.bosch.TpktStreamWriter;
import de.seetec.v5.re.cm.device.video.bosch.rcp.AlarmOverview;
import de.seetec.v5.re.cm.device.video.bosch.rcp.AuprocAlarm;
import de.seetec.v5.re.cm.device.video.bosch.rcp.ClientRegistrationReq;
import de.seetec.v5.re.cm.device.video.bosch.rcp.ClientRegistrationRsp;
import de.seetec.v5.re.cm.device.video.bosch.rcp.ClientUnregister;
import de.seetec.v5.re.cm.device.video.bosch.rcp.Connect;
import de.seetec.v5.re.cm.device.video.bosch.rcp.Disconnect;
import de.seetec.v5.re.cm.device.video.bosch.rcp.HardwareVersion;
import de.seetec.v5.re.cm.device.video.bosch.rcp.MotionAlarmState;
import de.seetec.v5.re.cm.device.video.bosch.rcp.Packet;
import de.seetec.v5.re.cm.device.video.bosch.rcp.Retrigger;
import de.seetec.v5.re.cm.device.video.bosch.rcp.TimeoutWarning;
import de.seetec.v5.re.cm.device.video.bosch.rcp.VideoAlarmState;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.AlarmEntry;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.AlarmFlag;
import de.seetec.v5.shared.SSLConstantsIntf;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.ConfigurationException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.List;
import java.util.concurrent.Semaphore;
import org.apache.logging.log4j.LogManager;

class BoschTriggerHandler
extends GenericEventTriggerHandler
implements RCPNetworkCallback,
SSLConstantsIntf {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.bosch.BoschMotionDetectionHandlerGeneric";
    private NetworkParameter networkParameter = null;
    private Socket socket = null;
    private TpktStreamReader rcpReader = null;
    private TpktStreamWriter rcpWriter = null;
    private static final int RCP_PORT = 1756;
    private String passphrase = null;
    private final Semaphore semaphore = new Semaphore(1);
    private boolean registered;
    private byte[] clientID;
    private boolean shutdown = true;
    private byte[] session;

    public BoschTriggerHandler(MotionRecording motionRecording) {
        super(motionRecording);
        this.logger = LogManager.getLogger((String)CLASS_NAME);
    }

    @Override
    public int init(Device device, List<GenericEventTriggerCnf> genericEventTriggerCnfs) {
        super.init(device, genericEventTriggerCnfs);
        this.shutdown = false;
        try {
            if (device.getDeviceCnf() == null) {
                return -20036;
            }
            this.networkParameter = device.getDeviceCnf().getNetworkParameter();
            int legacyTimeout = ((BoschDevice)device).getBoschLegacyTimeout();
            this.networkParameter.checkAndSetTimeout(legacyTimeout);
        }
        catch (Exception e) {
            return -20036;
        }
        return this.initializeRCP();
    }

    @Override
    public synchronized int shutdown() {
        if (this.shutdown) {
            this.logger.info("Shutdown already in progress for " + this);
            return 0;
        }
        Disconnect rtReq = new Disconnect();
        rtReq.setActionRequest();
        rtReq.setClientID(this.clientID);
        this.shutdown = true;
        if (this.rcpReader != null) {
            this.rcpReader.shutdown();
            this.rcpReader = null;
        }
        if (this.rcpWriter != null) {
            ClientUnregister unReq = new ClientUnregister();
            unReq.setActionRequest();
            unReq.setClientID(this.clientID);
            try {
                this.sendRCPDataPacket(unReq);
            }
            catch (Exception ex) {
                this.logger.warn("Exception while trying to send RCP Data Packet for " + this);
            }
            this.rcpWriter.shutdown();
            this.rcpWriter = null;
        }
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (Exception e) {
                this.logger.debug("Error while closing socket for " + this);
            }
        }
        super.shutdown();
        this.socket = null;
        this.passphrase = null;
        this.logger.info("shutdown done for " + this);
        return 0;
    }

    public int initializeRCP() {
        OutputStream outStream;
        InputStream inStream;
        if (this.isShutdown()) {
            this.logger.warn("Trigger Handler already shut down.");
            return 0;
        }
        try {
            this.socket = new Socket(this.networkParameter.getHost(), 1756);
            this.socket.setSoTimeout(5000);
            inStream = this.socket.getInputStream();
            outStream = this.socket.getOutputStream();
        }
        catch (Exception e) {
            this.logger.error("Cannot connect to " + this.networkParameter.getHost() + ":" + 1756 + " for " + this);
            return -21603;
        }
        this.rcpReader = new TpktStreamReader();
        this.rcpReader.init(inStream, this);
        this.rcpWriter = new TpktStreamWriter(outStream, this);
        ClientRegistrationReq req = new ClientRegistrationReq();
        this.passphrase = BoschCameraSrv.createPassphrase(this.networkParameter);
        req.setPass(this.passphrase);
        this.sendRCPDataPacket(req);
        return 0;
    }

    public void sendRCPDataPacket(Packet p) {
        if (this.rcpWriter != null) {
            this.rcpWriter.send(p.serialize());
        } else {
            this.logger.warn("rcpWriter is null for " + this);
            this.shutdown();
        }
    }

    @Override
    public void onRCPDataPacket(byte[] data) {
        Packet p = Packet.deserialize(data);
        if (this.isShutdown()) {
            return;
        }
        if (p == null) {
            return;
        }
        if (!this.registered) {
            if (p instanceof ClientRegistrationRsp) {
                ClientRegistrationRsp rsp = (ClientRegistrationRsp)p;
                if (rsp.registerFailed()) {
                    this.logger.warn("Register failed for " + this);
                    this.shutdown();
                } else {
                    this.clientID = rsp.getClientID();
                    this.session = rsp.getSessionID();
                    this.logger.info("Register success, clientID is [ " + Packet.hexString(this.clientID) + "] for " + this);
                    this.registered = true;
                }
            }
        } else {
            try {
                List triggerEvents;
                VideoAlarmState rsp;
                if (p instanceof ClientUnregister) {
                    ClientUnregister rsp2 = (ClientUnregister)p;
                    if (rsp2.getStatus() != 1) {
                        this.logger.warn("ClientUnregister failed for " + this);
                    }
                    this.logger.warn("shutting down, unregistered from server [" + rsp2 + "]");
                    this.shutdown();
                } else if (p instanceof TimeoutWarning) {
                    HardwareVersion req = new HardwareVersion();
                    req.setClientID(this.clientID);
                    this.sendRCPDataPacket(req);
                } else if (p instanceof AlarmOverview) {
                    AlarmOverview alarm = (AlarmOverview)p;
                    if (alarm.getFlags() == 0) {
                        List<AlarmEntry> alarmEntries = alarm.getAlarmEntries();
                        for (int i = 0; i < alarmEntries.size(); ++i) {
                            AlarmEntry alarmEntry = alarmEntries.get(i);
                            List triggerEvents2 = this.genericEventTriggerCnfs;
                            if (triggerEvents2 == null) continue;
                            for (GenericEventTriggerCnf event : triggerEvents2) {
                                String eventName;
                                if (event == null || !event.isEnabled() || !(eventName = event.getGenericEventTriggerType().toLowerCase()).equals(alarmEntry.getAlarmName().toLowerCase()) || (!alarmEntry.containsFlag(AlarmFlag.STATE_SET) || !alarmEntry.containsFlag(AlarmFlag.STATE)) && alarmEntry.containsAnyFlag()) continue;
                                int numericDescriptor = alarm.getNumericDescriptorAsInt();
                                if (event.getSourceNumber() == numericDescriptor) {
                                    this.forwardTrigger(event);
                                    continue;
                                }
                                if (event.getSourceNumber() == 0 && alarmEntry.isDeviceAlarm()) {
                                    this.forwardTrigger(event);
                                    continue;
                                }
                                this.logger.info("Channel number does not match, or alarm is no device alarm");
                                this.logger.info("Trigger: " + alarmEntry.getAlarmName());
                                this.logger.info("Channel number:" + numericDescriptor);
                                this.logger.info("Event channel number on SeeTec: " + event.getSourceNumber());
                                this.logger.info("Is Device Alarm? " + alarmEntry.isDeviceAlarm());
                            }
                        }
                    }
                } else if (p instanceof MotionAlarmState) {
                    List triggerEvents3;
                    MotionAlarmState alarm = (MotionAlarmState)p;
                    if (alarm.getState() && (triggerEvents3 = this.genericEventTriggerCnfs) != null) {
                        for (GenericEventTriggerCnf event : triggerEvents3) {
                            String eventName;
                            if (event == null || !event.isEnabled() || !(eventName = event.getGenericEventTriggerType()).toLowerCase().equals("detect any motion")) continue;
                            int numericDescriptor = alarm.getNumericDescriptorAsInt();
                            if (event.getSourceNumber() == numericDescriptor) {
                                this.logger.info("Trigger: Motion alarm");
                                this.logger.info("Channel number: " + numericDescriptor);
                                this.forwardTrigger(event);
                                continue;
                            }
                            this.logger.info("Channel number does not match");
                            this.logger.info("Channel number:" + numericDescriptor);
                            this.logger.info("Event channel number on SeeTec: " + event.getSourceNumber());
                        }
                    }
                } else if (p instanceof AuprocAlarm) {
                    List triggerEvents4;
                    AuprocAlarm rsp3 = (AuprocAlarm)p;
                    if (rsp3.isAudioAlarmDetected() && (triggerEvents4 = this.genericEventTriggerCnfs) != null) {
                        for (GenericEventTriggerCnf event : triggerEvents4) {
                            String eventName;
                            if (event == null || !event.isEnabled() || !(eventName = event.getGenericEventTriggerType()).toLowerCase().equals("audio")) continue;
                            this.forwardTrigger(event);
                        }
                    }
                } else if (p instanceof VideoAlarmState && (rsp = (VideoAlarmState)p).getState() && (triggerEvents = this.genericEventTriggerCnfs) != null) {
                    for (GenericEventTriggerCnf event : triggerEvents) {
                        String eventName;
                        if (event == null || !event.isEnabled() || !(eventName = event.getGenericEventTriggerType()).toLowerCase().equals("signal loss")) continue;
                        int numericDescriptor = rsp.getNumericDescriptorAsInt();
                        if (event.getSourceNumber() == numericDescriptor) {
                            this.logger.info("Trigger: Video loss");
                            this.logger.info("Channel number: " + numericDescriptor);
                            this.forwardTrigger(event);
                            continue;
                        }
                        this.logger.info("Channel number does not match");
                        this.logger.info("Channel number:" + numericDescriptor);
                        this.logger.info("Event channel number on SeeTec: " + event.getSourceNumber());
                    }
                }
            }
            catch (ConfigurationException ex) {
                this.logger.error("Exception while reading Output alarm for " + this + ": " + ex.getMessage());
            }
        }
    }

    @Override
    public void onNetworkError(int errorCode) {
        this.logger.info("Stopping re-triggering of generic event triggers because of network error [" + errorCode + "] for " + this.device);
        this.reinitialize();
    }

    public String toString() {
        String sThis = "de.seetec.v5.re.cm.device.video.bosch.BoschMotionDetectionHandlerGeneric@" + Integer.toHexString(this.hashCode());
        return "[" + sThis.substring(sThis.lastIndexOf(46) + 1) + "]";
    }

    @Override
    public void run() {
        long keepAliveInterval = 10000L;
        long time = System.currentTimeMillis();
        while (!this.isShutdown()) {
            try {
                Thread.sleep(500L);
            }
            catch (Exception e) {
                this.logger.error("Error while sleep. " + e.getMessage());
            }
            if (this.isShutdown()) break;
            if (System.currentTimeMillis() <= time + keepAliveInterval || this.isShutdown()) continue;
            Retrigger rtReq = new Retrigger();
            rtReq.setActionRequest();
            rtReq.setClientID(this.clientID);
            rtReq.setSessionID(this.session);
            this.sendRCPDataPacket(rtReq);
            time = System.currentTimeMillis();
        }
    }

    protected void onConnect(Connect rsp) {
        if (rsp.isActionError()) {
            this.shutdown();
        }
    }

    private void reinitialize() {
        if (this.isShutdown()) {
            return;
        }
        if (!this.semaphore.tryAcquire()) {
            this.logger.info("Cannot aquire [semaphore] for " + this);
            return;
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                BoschTriggerHandler.this.semaphore.release();
                int errorCode = BoschTriggerHandler.this.initializeRCP();
                if (errorCode != 0) {
                    BoschTriggerHandler.this.reinitialize();
                }
            }
        }, "BoschReInitializeTrigger " + this.device).start();
    }
}

