/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.bosch;

import de.seetec.v5.re.cm.QognifyMetadataManagerRepository;
import de.seetec.v5.re.cm.device.shared.Device;
import de.seetec.v5.re.cm.device.shared.LiveCameraSrv;
import de.seetec.v5.re.cm.device.shared.Resolution;
import de.seetec.v5.re.cm.device.shared.metadata.Metadata;
import de.seetec.v5.re.cm.device.shared.metadata.MetadataReader;
import de.seetec.v5.re.cm.device.shared.metadata.QmmData;
import de.seetec.v5.re.cm.device.shared.metadata.capabilities.BehaviourCapabilities;
import de.seetec.v5.re.cm.device.shared.metadata.capabilities.ClassCapabilities;
import de.seetec.v5.re.cm.device.shared.metadata.capabilities.ColorDescriptorType;
import de.seetec.v5.re.cm.device.shared.metadata.capabilities.DataType;
import de.seetec.v5.re.cm.device.shared.metadata.capabilities.MetadataCapabilities;
import de.seetec.v5.re.cm.device.shared.metadata.capabilities.Parameter;
import de.seetec.v5.re.cm.device.shared.metadata.capabilities.ShapeCapabilities;
import de.seetec.v5.re.cm.device.shared.metadata.capabilities.VehicleInfoCapabilities;
import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPHandlerIntf;
import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPHandlerSuper;
import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPResponse;
import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPStreamSettings;
import de.seetec.v5.re.cm.device.shared.net.rtsp.mikey.Mikey;
import de.seetec.v5.re.cm.device.shared.onvif.metadata.Frame;
import de.seetec.v5.re.cm.device.shared.onvif.metadata.MetadataObject;
import de.seetec.v5.re.cm.device.shared.onvif.metadata.MetadataStream;
import de.seetec.v5.re.cm.device.shared.onvif.metadata.VideoAnalytics;
import de.seetec.v5.re.cm.device.shared.videosource.PacketType;
import de.seetec.v5.re.cm.device.shared.videosource.PacketTypeParser;
import de.seetec.v5.re.cm.device.shared.videosource.RtpPacket;
import de.seetec.v5.re.cm.device.video.bosch.BoschDevice;
import de.seetec.v5.re.cm.device.video.bosch.CppVersion;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.Direction;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.EncodeCurrentResolutionXML;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.re.shared.TransmissionType;
import de.seetec.v5.shared.net.NetworkParameter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import org.jdom.Document;
import org.jdom.input.SAXBuilder;

public class BoschMetadataReader
extends MetadataReader
implements RTSPHandlerIntf {
    public static final String CLASSNAME = "de.seetec.v5.re.cm.device.video.bosch.BoschMetadataReader";
    private BoschDevice boschDevice;
    private String rtspUrl;
    private RTSPStreamSettings rtspSettings;
    private boolean isMultiChannelDevice;
    private final ByteArrayOutputStream buffer = new ByteArrayOutputStream();
    private final int videoSource;
    private RTSPHandlerSuper rtspHandler;
    private final long videoSourceEntityId;
    private final String videoSourceName;
    private final TransmissionType transmissionType;
    private Resolution resolution;

    public BoschMetadataReader(LiveCameraSrv liveCameraSrv, QognifyMetadataManagerRepository qognifyMetadataManagerRepository) throws Exception {
        super(qognifyMetadataManagerRepository);
        this.videoSource = liveCameraSrv.getVideoSourceCnf().getServerEntryNo();
        this.videoSourceName = liveCameraSrv.getVideoSourceCnf().getEntity().getEntityName();
        this.videoSourceEntityId = liveCameraSrv.getVideoSourceCnf().getEntityID();
        this.transmissionType = liveCameraSrv.getBasicVideoProfileHandler().getVideoSourceParameter().getTransmissionID();
    }

    @Override
    public int shutdown() {
        this.getLogger().info("Shutting down " + this);
        this.startShutdown(CLASSNAME);
        if (this.rtspHandler != null) {
            this.rtspHandler.shutdown();
        }
        return super.shutdown();
    }

    @Override
    public int init(Device device) {
        int errorCode = 0;
        super.init(device);
        try {
            this.resolution = this.getResolutionFromCamera();
            MetadataCapabilities metadataCapabilities = this.getMetadataCapabilities();
            this.getLogger().info(metadataCapabilities.toString());
            this.deliverMetadata(metadataCapabilities);
            errorCode = this.startMetadataStream();
        }
        catch (Exception ex) {
            this.getLogger().warn("Exception while starting metadata reading for " + this + " : " + ex.getMessage());
        }
        return errorCode;
    }

    protected Resolution getResolutionFromCamera() {
        EncodeCurrentResolutionXML encodeCurrentResolutionXml = new EncodeCurrentResolutionXML();
        encodeCurrentResolutionXml.setStreamNumber((byte)1);
        encodeCurrentResolutionXml.setVideoSource((byte)this.videoSource);
        try {
            encodeCurrentResolutionXml.send(this.getBoschDevice(), Direction.READ);
            this.resolution = new Resolution(encodeCurrentResolutionXml.getWidth(), encodeCurrentResolutionXml.getHeight());
            this.getLogger().info("Resolution used for metadata: " + encodeCurrentResolutionXml.getWidth() + "x" + encodeCurrentResolutionXml.getHeight());
        }
        catch (Exception ex) {
            this.getLogger().warn("Exception while setting resolution for " + this + " : " + ex.getMessage());
        }
        return this.resolution;
    }

    private int startMetadataStream() {
        int errorCode;
        this.getLogger().info("Starting metadata stream for " + this);
        try {
            int numberOfVideoSources = this.getBoschDevice().getNumberOfCameras();
            if (numberOfVideoSources > 1) {
                this.isMultiChannelDevice = true;
            }
            NetworkParameter networkParameter = this.getBoschDevice().getDeviceCnf().getNetworkParameter();
            String rtspPath = "/?meta=1&vcd=2&metaline=1";
            this.rtspUrl = "rtsp://" + networkParameter.getHost() + rtspPath;
            this.rtspSettings = new RTSPStreamSettings();
            String keepAliveUrl = this.isMultiChannelDevice ? this.rtspUrl : "*";
            errorCode = this.rtspSettings.init(this, null, networkParameter, 554, this.rtspUrl, false, this.transmissionType, 5000, false, 4, keepAliveUrl);
            if (errorCode != 0) {
                this.getLogger().error("Initialization of RTSPsettings failes with errorCode: " + errorCode + " for " + this);
            }
            this.rtspSettings.setIsVideoEnabled(false);
            this.rtspSettings.enableMetadata(this);
            this.rtspSettings.setMetadataTimeout(0);
            this.rtspSettings.setUseSdpData(true);
            this.rtspSettings.setPlaybackCodec(Codec.MJPEG);
            this.rtspHandler = this.rtspSettings.getRTSPHandler();
            this.rtspHandler.start();
        }
        catch (Exception ex) {
            this.getLogger().error("Exception while starting metadata stream for " + this + " : " + ex.getMessage());
            errorCode = -20100;
        }
        return errorCode;
    }

    protected BoschDevice getBoschDevice() {
        if (this.boschDevice == null) {
            this.boschDevice = (BoschDevice)this.getDevice();
        }
        return this.boschDevice;
    }

    @Override
    public void processData(byte[] data) {
        try {
            PacketType packetType = PacketTypeParser.parsePacketType(data);
            if (packetType == PacketType.RTCP_SENDER_REPORT) {
                byte[] receiverReport = this.generateRTCPReceiverReport(data);
                if (this.rtspHandler != null) {
                    this.rtspHandler.sendReceiverReportMetadata(receiverReport);
                }
            } else {
                RtpPacket rtpPacket = new RtpPacket(data);
                this.buffer.write(rtpPacket.getContent());
                if (rtpPacket.hasMarkerFlag()) {
                    ByteArrayInputStream bais = new ByteArrayInputStream(this.buffer.toByteArray());
                    this.buffer.reset();
                    Document document = new SAXBuilder().build((InputStream)bais);
                    List<QmmData> metadataList = this.createMetadata(document, this.videoSourceEntityId);
                    super.deliverMetadata(metadataList);
                }
            }
        }
        catch (Exception ex) {
            this.getLogger().warn("RTP Data not correct for " + this);
        }
    }

    protected List<QmmData> createMetadata(Document document, long videoSourceEntityId) {
        try {
            MetadataStream metadataStream = new MetadataStream(document);
            List<VideoAnalytics> videoAnalyticsList = metadataStream.getVideoAnalytics();
            ArrayList<QmmData> metadataList = new ArrayList<QmmData>();
            for (VideoAnalytics videoAnalytics : videoAnalyticsList) {
                List<Frame> frameList = videoAnalytics.getFrames();
                for (Frame frame : frameList) {
                    String timestamp = frame.getUtcTime();
                    List<MetadataObject> objectList = frame.getObjects();
                    for (MetadataObject object : objectList) {
                        Metadata metadata = new Metadata();
                        metadata.setSource("Qognify VMS");
                        metadata.setPlace(this.videoSourceName);
                        metadata.setMessageId(UUID.randomUUID());
                        metadata.setCameraId(videoSourceEntityId);
                        metadata.setExternalCameraId(videoSourceEntityId);
                        metadata.setResolutionWidth(this.getResolution().getWidth());
                        metadata.setResolutionHeight(this.getResolution().getHeight());
                        if (object.getAppearance().getClassDescriptor() == null || object.getAppearance().getClassDescriptor().getClassTypes().isEmpty()) continue;
                        try {
                            metadata.setVmsAssumedLikelihood(object.getAppearance().getClassDescriptor().getClassTypes().get(0).getLikelihood());
                        }
                        catch (Exception ex) {
                            this.getLogger().warn("Could not calculate VMS Assumed Likelihood for " + this.videoSourceName + ": " + ex.getMessage());
                        }
                        metadata.setTimestamp(timestamp);
                        metadata.setObject(object);
                        metadataList.add(metadata);
                    }
                }
            }
            return metadataList;
        }
        catch (Exception ex) {
            this.getLogger().warn("Exception while reading metadata for " + this.getBoschDevice() + (ex.getMessage() != null ? " : " + ex.getMessage() : ""));
            return null;
        }
    }

    @Override
    public void onNetworkError(int errorCode) {
        if (!this.isShutdown(CLASSNAME)) {
            this.getLogger().error("Network error while reading metadata for " + this);
            if (this.rtspHandler != null) {
                int error = errorCode;
                while (!this.isShutdown(CLASSNAME) && error != 0) {
                    this.getLogger().info("Will restart metadata stream for " + this);
                    this.rtspHandler.shutdown();
                    error = this.startMetadataStream();
                }
            }
        } else {
            this.getLogger().info(this + " is already shutting down");
        }
    }

    @Override
    public void sendStatusService(int errorCode) {
    }

    @Override
    public void sendDescribeResponse(RTSPResponse response) {
    }

    @Override
    public void setSsrcfromRtsp(String ssrc) {
    }

    private byte[] generateRTCPReceiverReport(byte[] data) {
        byte[] receiverReport = new byte[32];
        receiverReport[0] = -127;
        receiverReport[1] = -55;
        receiverReport[2] = 0;
        receiverReport[3] = 7;
        byte[] receiverSSRC = new byte[4];
        new Random().nextBytes(receiverSSRC);
        System.arraycopy(receiverSSRC, 0, receiverReport, 4, 4);
        System.arraycopy(data, 4, receiverReport, 8, 4);
        System.arraycopy(data, 10, receiverReport, 24, 4);
        return receiverReport;
    }

    @Override
    public void setMikey(Mikey mikey) throws Exception {
    }

    protected Resolution getResolution() {
        if (this.resolution == null) {
            this.resolution = this.getResolutionFromCamera();
        }
        return this.resolution;
    }

    private MetadataCapabilities getMetadataCapabilities() {
        ClassCapabilities classCapabilities;
        MetadataCapabilities metadataCapabilities = new MetadataCapabilities(false);
        metadataCapabilities.setVideoSource(this.videoSourceEntityId);
        int firmwareMajor = Integer.parseInt(this.getBoschDevice().getFirmware().getMajor());
        int firmwareMinor = Integer.parseInt(this.getBoschDevice().getFirmware().getMinor());
        CppVersion cppVersion = CppVersion.CPP6;
        try {
            cppVersion = this.getBoschDevice().getCppVersion();
        }
        catch (Exception ex) {
            this.getLogger().warn("Error while retrieving CPP version from device. Will asume CPP6 for " + this);
        }
        this.getLogger().info("CPP Version is: " + (Object)((Object)cppVersion));
        String[] objectTypesCpp7 = new String[]{"Human", "HumanFace", "Car", "Truck", "Bike"};
        String[] objectTypesCpp14 = new String[]{"Human", "HumanFace", "Car", "Truck", "Bike"};
        String[] objectTypesCpp13 = new String[]{"Human", "HumanFace", "Car", "Bus", "Truck", "Bike", "Bicycle", "Motorbike"};
        if (firmwareMajor > 6 || firmwareMajor == 6 && firmwareMinor >= 50) {
            classCapabilities = new ClassCapabilities(true);
            classCapabilities.getType().removeAvailableStringValues();
            classCapabilities.getType().addAvailableStringValues(objectTypesCpp7);
            metadataCapabilities.setClassCapabilities(classCapabilities);
            ShapeCapabilities shapeCapabilities = new ShapeCapabilities(true);
            metadataCapabilities.setShapeCapabilities(shapeCapabilities);
        }
        if (firmwareMajor >= 7) {
            if (cppVersion == CppVersion.CPP14_1 || cppVersion == CppVersion.CPP14_2 || cppVersion == CppVersion.CPP14m) {
                classCapabilities = new ClassCapabilities(true);
                classCapabilities.getType().removeAvailableStringValues();
                classCapabilities.getType().addAvailableStringValues(objectTypesCpp14);
                metadataCapabilities.setClassCapabilities(classCapabilities);
            } else if (cppVersion == CppVersion.CPP13) {
                classCapabilities = new ClassCapabilities(true);
                classCapabilities.getType().removeAvailableStringValues();
                classCapabilities.getType().addAvailableStringValues(objectTypesCpp13);
                metadataCapabilities.setClassCapabilities(classCapabilities);
            }
            if (firmwareMajor >= 8 || firmwareMinor >= 80) {
                BehaviourCapabilities behaviourCapabilities = new BehaviourCapabilities(false);
                Parameter speed = new Parameter();
                speed.setDataType(DataType.FLOAT);
                speed.setName("Speed");
                speed.setPath("Object.Behaviour.Speed");
                behaviourCapabilities.addExtension(speed);
                VehicleInfoCapabilities vehicleInfoCapabilities = new VehicleInfoCapabilities(true);
                vehicleInfoCapabilities.setVehicleBrand(null);
                vehicleInfoCapabilities.setVehicleModel(null);
                String[] vehicleInfoTypes = new String[]{"Car", "Truck", "Bicycle"};
                vehicleInfoCapabilities.getVehicleType().removeAvailableStringValues();
                vehicleInfoCapabilities.getVehicleType().addAvailableStringValues(vehicleInfoTypes);
                metadataCapabilities.setVehicleInfoCapabilities(vehicleInfoCapabilities);
                Parameter vehicleColor = new Parameter();
                vehicleColor.setDataType(DataType.COLOR);
                vehicleColor.setColorType(ColorDescriptorType.RGB);
                vehicleColor.setName("Color");
                vehicleColor.setPath("Object.Appearance.VehicleInfo.Color.ColorCluster");
                metadataCapabilities.setColorCapabilities(vehicleColor);
                metadataCapabilities.setBehaviourCapabilities(behaviourCapabilities);
                if (firmwareMajor >= 8 || firmwareMinor >= 84) {
                    Parameter color = new Parameter();
                    color.setDataType(DataType.COLOR);
                    color.setColorType(ColorDescriptorType.RGB);
                    color.setName("Color");
                    color.setPath("Object.Appearance.Color");
                    metadataCapabilities.setColorCapabilities(color);
                }
            }
        }
        return metadataCapabilities;
    }
}

