/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.bosch;

import de.seetec.v5.re.cm.Core;
import de.seetec.v5.re.cm.configuration.definition.camera.VideoCameraDefinition;
import de.seetec.v5.re.cm.configuration.device.shared.ArrayOfCameraPreset.ArrayOfCameraPreset;
import de.seetec.v5.re.cm.configuration.device.shared.ArrayOfCameraPreset.CameraPreset;
import de.seetec.v5.re.cm.device.shared.Device;
import de.seetec.v5.re.cm.device.shared.VideoSrv;
import de.seetec.v5.re.cm.device.shared.cameracontrol.CameraControl;
import de.seetec.v5.re.cm.device.shared.cameracontrol.PresetCnf;
import de.seetec.v5.re.cm.device.shared.net.RCPNetworkCallback;
import de.seetec.v5.re.cm.device.video.bosch.AutoDomeHandler;
import de.seetec.v5.re.cm.device.video.bosch.BiComHandler;
import de.seetec.v5.re.cm.device.video.bosch.BoschCameraSrv;
import de.seetec.v5.re.cm.device.video.bosch.BoschDevice;
import de.seetec.v5.re.cm.device.video.bosch.PelcoDHandler;
import de.seetec.v5.re.cm.device.video.bosch.TpktStreamReader;
import de.seetec.v5.re.cm.device.video.bosch.TpktStreamWriter;
import de.seetec.v5.re.cm.device.video.bosch.bicomoverrcp.BicomOverRCPQuery;
import de.seetec.v5.re.cm.device.video.bosch.rcp.ClientRegistrationReq;
import de.seetec.v5.re.cm.device.video.bosch.rcp.ClientRegistrationRsp;
import de.seetec.v5.re.cm.device.video.bosch.rcp.ClientUnregister;
import de.seetec.v5.re.cm.device.video.bosch.rcp.Disconnect;
import de.seetec.v5.re.cm.device.video.bosch.rcp.HardwareVersion;
import de.seetec.v5.re.cm.device.video.bosch.rcp.Packet;
import de.seetec.v5.re.cm.device.video.bosch.rcp.TimeoutWarning;
import de.seetec.v5.re.cm.device.video.bosch.rcp.TransparentData;
import de.seetec.v5.re.cm.device.video.bosch.rcp.TransparentDataMsg;
import de.seetec.v5.re.cm.device.video.bosch.rcp.TransparentDataQueryQueue;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.Direction;
import de.seetec.v5.re.cm.device.video.bosch.rcpXml.PresetPositionsXML;
import de.seetec.v5.re.cm.shared.PtzInfo;
import de.seetec.v5.re.cm.shared.communication.VideoServiceClientRequestHandler;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class BoschCameraControl
extends CameraControl
implements RCPNetworkCallback {
    public static final int AUTODOME = 1;
    public static final int PELCO_D = 2;
    public static final int BICOM = 3;
    private static final int DELAY = 10000;
    private static final String PELCO_D_OSD_TAG = "Pelco-D OSD";
    private static final int PRESET_POSITION_FOR_OSD = 95;
    private static final int PELCO_QUEUE_DELAY = 1000;
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.bosch.BoschCameraControl";
    private int protocol = 3;
    private String passphrase = null;
    private BoschDevice boschDevice = null;
    private VideoSrv videoSrv = null;
    private int videoSourceID = 1;
    private int channelNumber;
    private VideoCameraDefinition cameraConfig;
    private Socket socket = null;
    private TpktStreamReader rcpReader = null;
    private TpktStreamWriter rcpWriter = null;
    private final TransparentDataQueryQueue queue;
    private boolean registered = false;
    private boolean registerAnswered = false;
    private byte[] clientID;
    private byte requestId = 0;

    private static String getPresetPositionFromXML(byte[] inputData) throws JDOMException {
        Element ptzPosition;
        String input = new String(inputData);
        ByteArrayInputStream stream = new ByteArrayInputStream(input.getBytes(StandardCharsets.UTF_8));
        Document ptzDocument = new SAXBuilder().build((InputStream)stream);
        String presetPosition = "1";
        Element root = ptzDocument.getRootElement();
        if (root != null && (ptzPosition = root.getChild("PresetPosition")) != null) {
            presetPosition = ptzPosition.getText().trim();
        }
        return presetPosition;
    }

    public BoschCameraControl(int protocolType) {
        this.protocol = protocolType;
        this.queue = new TransparentDataQueryQueue(this);
    }

    public int init(Core core, Device device, VideoSrv videoSrv, Vector<PresetCnf> presetList) {
        this.clientID = new byte[]{0, 0};
        this.boschDevice = (BoschDevice)device;
        if (this.boschDevice == null || (this.videoSrv = videoSrv) == null || (this.presetList = presetList) == null) {
            return -21601;
        }
        try {
            if (videoSrv.getVideoSourceCnf() != null) {
                this.videoSourceID = (byte)videoSrv.getVideoSourceCnf().getPtzAddress();
                this.channelNumber = videoSrv.getVideoSourceCnf().getServerEntryNo();
            } else {
                this.logger.warn("'VideoSourceID' not specified. Keep 01.");
            }
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
            return -21601;
        }
        if (this.protocol != 3) {
            OutputStream outStream;
            InputStream inStream;
            try {
                this.networkParameter = device.getDeviceCnf().getNetworkParameter();
            }
            catch (Exception cex) {
                this.logger.error("Cannot determine NetworkParameter of " + this.videoSrv, (Throwable)cex);
                return -21601;
            }
            int rcpPort = 1756;
            try {
                this.socket = new Socket(this.networkParameter.getHost(), 1756);
                this.socket.setSoTimeout(10000);
                inStream = this.socket.getInputStream();
                outStream = this.socket.getOutputStream();
            }
            catch (Exception e) {
                this.logger.error("Cannot connect to " + this.networkParameter.getHost() + ":" + 1756 + " for " + device);
                return -21603;
            }
            this.rcpReader = new TpktStreamReader();
            this.rcpReader.init(inStream, this);
            this.rcpWriter = new TpktStreamWriter(outStream, this);
            ClientRegistrationReq req = new ClientRegistrationReq();
            this.passphrase = BoschCameraSrv.createPassphrase(this.networkParameter);
            req.setPass(this.passphrase);
            req.setNumericDescriptorAsInt(1);
            this.sendRCPDataPacket(req);
            long time = System.currentTimeMillis();
            while (time + 10000L > System.currentTimeMillis() && !this.registerAnswered) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (!this.registerAnswered) {
                this.logger.info("No reply to registration for 10000[ms] on " + device);
                this.shutdown();
                return -21603;
            }
            if (!this.registered) {
                this.logger.info("Register failed for " + device);
                return -21657;
            }
        }
        this.cameraConfig = device.getVideoCameraDefinitionFromConfiguration();
        if (this.cameraConfig != null) {
            this.ptzInfo = new PtzInfo();
            this.ptzInfo.setMinZoom(this.cameraConfig.getFeatures().getMinAbsoluteZoom());
            this.ptzInfo.setMaxZoom(this.cameraConfig.getFeatures().getMaxAbsoluteZoom());
            this.refreshAbsolutePosition(true);
        }
        return 0;
    }

    @Override
    public synchronized int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        if (this.registered) {
            ClientUnregister unReq = new ClientUnregister();
            unReq.setActionRequest();
            unReq.setClientID(this.clientID);
            this.sendRCPDataPacket(unReq);
        }
        if (this.rcpReader != null) {
            this.rcpReader.shutdown();
        }
        this.rcpReader = null;
        if (this.rcpWriter != null) {
            this.rcpWriter.shutdown();
        }
        this.rcpWriter = null;
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (Exception e) {
                this.logger.warn("Exception while trying to close socket for " + this);
            }
        }
        this.socket = null;
        this.passphrase = null;
        super.shutdown();
        this.logger.info("shutdown done for " + this.boschDevice);
        return 0;
    }

    @Override
    public final boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    @Override
    public void onNetworkError(int error) {
        if (this.isShutdown()) {
            return;
        }
        this.logger.warn("Shutting down : " + error);
        this.shutdown();
    }

    public void sendRCPDataPacket(Packet p) {
        if (this.rcpWriter != null) {
            this.rcpWriter.send(p.serialize());
        } else {
            this.logger.warn("rcpWriter is null for " + this.boschDevice);
            this.shutdown();
        }
    }

    @Override
    public void onRCPDataPacket(byte[] data) {
        Packet p = Packet.deserialize(data);
        if (this.isShutdown() || p == null) {
            return;
        }
        if (p instanceof TransparentData) {
            this.queue.gotResponse((TransparentData)p);
            if (p.isActionMessage()) {
                TransparentDataMsg msgPacket = (TransparentDataMsg)p;
                switch (msgPacket.getMsgCommand()) {
                    case 89: {
                        this.ptzInfo.setPan(msgPacket.getData());
                        break;
                    }
                    case 91: {
                        this.ptzInfo.setTilt(msgPacket.getData());
                        break;
                    }
                    case 93: {
                        this.ptzInfo.setZoom(msgPacket.getData());
                        break;
                    }
                    default: {
                        this.logger.error("Got Unknown transparent data response msg type in onRCPDataPacket.");
                        break;
                    }
                }
            }
        } else if (p instanceof ClientRegistrationRsp && !this.registered) {
            ClientRegistrationRsp rsp = (ClientRegistrationRsp)p;
            if (!rsp.registerFailed()) {
                this.clientID = rsp.getClientID();
                this.logger.info("Register success, clientID is [ " + Packet.hexString(this.clientID) + "] for " + this.boschDevice);
                this.registered = true;
            }
            this.registerAnswered = true;
        } else if (p instanceof ClientUnregister) {
            ClientUnregister rsp = (ClientUnregister)p;
            if (rsp.getStatus() != 1) {
                this.logger.warn("ClientUnregister failed for " + this.boschDevice);
            }
            this.logger.warn("shutting down, unregistered from server [" + rsp + "]");
            this.shutdown();
        } else if (p instanceof TimeoutWarning) {
            HardwareVersion req = new HardwareVersion();
            req.setClientID(this.clientID);
            this.sendRCPDataPacket(req);
        } else if (p instanceof Disconnect && !this.isShutdown()) {
            this.shutdown();
        }
    }

    @Override
    public int setAbsolutePTZ(VideoServiceClientRequestHandler sender, Integer pan, Integer tilt, Integer zoom) {
        return 0;
    }

    @Override
    public int setAbsoluteZ(VideoServiceClientRequestHandler sender, Integer zoom) {
        if (this.cameraConfig != null && !this.cameraConfig.getFeatures().isCanAbsoluteZoom()) {
            this.logger.error("Cannot setAbsoluteZ for device " + this.boschDevice + " when the absolute zoom is not supported.");
            return -21611;
        }
        try {
            if (this.protocol == 3) {
                BicomOverRCPQuery.setZoom(zoom).send(this.boschDevice);
            } else {
                this.sendPelcoCommand(20, zoom.shortValue());
            }
            this.refreshAbsolutePosition(false);
            this.ptzInfo.setZoom(zoom);
        }
        catch (Exception ex) {
            this.logger.error("SetAbsoluteZ failed for " + this.boschDevice, (Throwable)ex);
        }
        return 0;
    }

    private void refreshAbsolutePosition(boolean sendStatus) {
        if (this.cameraConfig == null || !this.cameraConfig.getFeatures().isCanAbsoluteZoom()) {
            return;
        }
        try {
            if (this.protocol == 3) {
                this.refreshAbsolutePositionBicom();
            } else {
                this.refreshAbsolutePositionPelcoD();
            }
            if (sendStatus) {
                this.videoSrv.sendStatusAbsolutePTZ(null, this.ptzInfo.getPan(), this.ptzInfo.getTilt(), this.ptzInfo.getZoom());
            }
        }
        catch (Exception ex) {
            this.logger.error("RefreshAbsolutePosition failed for " + this.boschDevice, (Throwable)ex);
        }
    }

    private void refreshAbsolutePositionBicom() {
        BicomOverRCPQuery zoomQuery = BicomOverRCPQuery.getZoom();
        zoomQuery.send(this.boschDevice);
        int zoom = Integer.parseInt(zoomQuery.getResultAsString(), 16);
        BicomOverRCPQuery panQuery = BicomOverRCPQuery.getPan();
        panQuery.send(this.boschDevice);
        short pan = (short)Integer.parseInt(panQuery.getResultAsString(), 16);
        BicomOverRCPQuery tiltQuery = BicomOverRCPQuery.getTilt();
        tiltQuery.send(this.boschDevice);
        short tilt = (short)Integer.parseInt(tiltQuery.getResultAsString(), 16);
        this.ptzInfo.setPan(pan);
        this.ptzInfo.setTilt(tilt);
        this.ptzInfo.setZoom(zoom);
    }

    private void refreshAbsolutePositionPelcoD() {
        this.queue.clearQueue();
        this.queuePelcoQuery(23);
        this.queuePelcoQuery(25);
        this.queuePelcoQuery(21);
        this.waitTillQueueClears();
    }

    private void waitTillQueueClears() {
        for (int currentDelay = 0; currentDelay < 1000; currentDelay += 50) {
            try {
                if (this.queue.isEmpty()) break;
                Thread.sleep(50L);
                continue;
            }
            catch (InterruptedException ex) {
                this.logger.error("Could not wait till transparent data query cleared, because of the thread shutdown.");
                break;
            }
        }
    }

    private void queuePelcoQuery(int pelcoHandlerCommand) {
        PelcoDHandler handler = this.getPelcoHandler(pelcoHandlerCommand, (short)0);
        this.queue.queueQuery(this.getTransparentDataPacket(handler.getCommandAsByteArray()));
    }

    private void sendPelcoCommand(int pelcoHandlerCommand, short value) {
        this.sendCameraCommand(this.getPelcoHandler(pelcoHandlerCommand, value).getCommandAsByteArray());
    }

    private PelcoDHandler getPelcoHandler(int pelcoHandlerCommand, short value) {
        PelcoDHandler handler = new PelcoDHandler();
        handler.init(this.videoSrv);
        handler.setAbsolutePTZCommand(pelcoHandlerCommand, value);
        return handler;
    }

    @Override
    public int setContinuousPTZ(Integer panSpeed, Integer tiltSpeed, Integer zoomSpeed) {
        int zoom;
        int tilt;
        int pan;
        if (panSpeed != null) {
            this.previousPanSpeed = pan = panSpeed.intValue();
        } else {
            pan = this.previousPanSpeed;
        }
        if (tiltSpeed != null) {
            this.previousTiltSpeed = tilt = tiltSpeed.intValue();
        } else {
            tilt = this.previousTiltSpeed;
        }
        if (zoomSpeed != null) {
            this.previousZoomSpeed = zoom = zoomSpeed.intValue();
        } else {
            zoom = this.previousZoomSpeed;
        }
        if (this.protocol == 2) {
            PelcoDHandler handler = new PelcoDHandler();
            handler.init(this.videoSrv);
            handler.setPTZCommand(0, pan);
            handler.setPTZCommand(3, tilt);
            handler.setPTZCommand(6, zoom);
            return this.sendCameraCommand(handler.getCommandAsByteArray());
        }
        if (this.protocol == 1) {
            int boschPanSpeed = 0;
            int zoomDirection = 0;
            int tiltDirection = 0;
            int panDirection = 0;
            if (panSpeed != null) {
                boschPanSpeed = pan / 6250;
                int n = panDirection = boschPanSpeed < 0 ? 2 : 1;
            }
            if (tiltSpeed != null) {
                int n = tiltDirection = (tilt /= 6250) < 0 ? 4 : 8;
            }
            if (zoomSpeed != null) {
                zoomDirection = (zoom /= 12500) == 0 ? 0 : (zoom < 0 ? 16 : 32);
            }
            int data1 = Math.abs(zoom) << 4 | Math.abs(tilt);
            int data2 = Math.abs(boschPanSpeed) << 3;
            int data3 = zoomDirection | tiltDirection | panDirection;
            byte[] data = new byte[]{(byte)data1, (byte)data2, (byte)data3};
            AutoDomeHandler handler = new AutoDomeHandler();
            handler.init(this.videoSrv);
            handler.setCameraCommand((byte)5, data);
            return this.sendCameraCommand(handler.getCommandAsByteArray());
        }
        if (this.protocol == 3) {
            if ((pan /= 6250) != 0) {
                pan = pan < 0 ? --pan : pan;
                pan = pan < -15 ? -15 : pan;
                pan = pan > 15 ? 15 : pan;
            }
            int panDirection = pan < 0 ? 0 : -128;
            pan = Math.abs(pan);
            pan |= panDirection;
            if ((tilt /= 6250) != 0) {
                tilt = tilt < 0 ? --tilt : tilt;
                tilt = tilt < -15 ? -15 : tilt;
                tilt = tilt > 15 ? 15 : tilt;
            }
            int tiltDirection = tilt < 0 ? 0 : -128;
            tilt = Math.abs(tilt);
            tilt |= tiltDirection;
            if ((zoom /= 12500) != 0) {
                zoom = zoom < 0 ? --zoom : zoom;
                zoom = zoom < -7 ? -7 : zoom;
                int n = zoom = zoom > 7 ? 7 : zoom;
            }
            int zoomDirection = zoom == 0 ? 0 : (zoom < 0 ? 0 : -128);
            zoom = Math.abs(zoom);
            byte[] data = new byte[]{0, 6, 1, 16, -123, 0, 0, 0};
            data[5] = (byte)pan;
            data[6] = (byte)tilt;
            data[7] = (byte)(zoom |= zoomDirection);
            BiComHandler handler = new BiComHandler();
            handler.setCameraCommand(data);
            return this.sendBiComCameraCommand(handler.getCommandAsHexString());
        }
        return 0;
    }

    @Override
    public int setCenterPT(Integer xPosition, Integer yPosition, int[] resolution) {
        if (this.protocol == 3) {
            byte[] xPositionAsBytes = Basic.int4ToByteArray((int)(xPosition * 100), (int)2);
            byte[] yPositionAsBytes = Basic.int4ToByteArray((int)(yPosition * 100), (int)2);
            byte[] data = new byte[]{0, 6, 64, 113, 2, xPositionAsBytes[0], xPositionAsBytes[1], yPositionAsBytes[0], yPositionAsBytes[1]};
            BiComHandler handler = new BiComHandler();
            handler.setCameraCommand(data);
            return this.sendBiComCameraCommand(handler.getCommandAsHexString());
        }
        return 0;
    }

    @Override
    public int setZoomArea(Integer xPosition, Integer yPosition, Integer width, Integer height, int[] resolution) {
        if (this.protocol == 3) {
            byte[] xLeftPositionAsBytes = Basic.int4ToByteArray((int)(xPosition * 100), (int)2);
            byte[] xRightPositionAsBytes = Basic.int4ToByteArray((int)((xPosition + width) * 100), (int)2);
            byte[] yTopPositionAsBytes = Basic.int4ToByteArray((int)(yPosition * 100), (int)2);
            byte[] yBottomPositionAsBytes = Basic.int4ToByteArray((int)((yPosition + height) * 100), (int)2);
            byte[] data = new byte[]{0, 6, 64, 112, 2, xLeftPositionAsBytes[0], xLeftPositionAsBytes[1], yTopPositionAsBytes[0], yTopPositionAsBytes[1], xRightPositionAsBytes[0], xRightPositionAsBytes[1], yBottomPositionAsBytes[0], yBottomPositionAsBytes[1]};
            BiComHandler handler = new BiComHandler();
            handler.setCameraCommand(data);
            int errorCode = this.sendBiComCameraCommand(handler.getCommandAsHexString());
            this.setAutoFocus(true);
            return errorCode;
        }
        return 0;
    }

    @Override
    public int setAbsoluteIris(Integer value) {
        throw new RuntimeException("NOT YET IMPLEMENTED :-(");
    }

    @Override
    public int setContinuousIris(Integer value) {
        if (this.protocol == 2) {
            PelcoDHandler handler = new PelcoDHandler();
            handler.init(this.videoSrv);
            if (value != null && value != 0) {
                if (value > 0) {
                    handler.setGenericCommand(9, value);
                } else {
                    handler.setGenericCommand(10, value);
                }
            } else {
                handler.setGenericCommand(18, 0);
            }
            return this.sendCameraCommand(handler.getCommandAsByteArray());
        }
        if (this.protocol == 1) {
            int iris = value != null ? value : 0;
            boolean data1 = false;
            boolean data2 = false;
            if (iris > 0) {
                data1 |= true;
            } else if (iris < 0) {
                data2 |= true;
            }
            byte[] data = new byte[]{(byte)(data1 ? 1 : 0), (byte)(data2 ? 1 : 0)};
            AutoDomeHandler handler = new AutoDomeHandler();
            handler.init(this.videoSrv);
            handler.setCameraCommand((byte)2, data);
            return this.sendCameraCommand(handler.getCommandAsByteArray());
        }
        if (this.protocol == 3) {
            int iris = value != null ? value : 0;
            byte[] data = new byte[]{0, 4, 1, -80, -126, 0, 0};
            if (iris > 0) {
                data[6] = 2;
            } else if (iris < 0) {
                data[6] = 1;
            }
            BiComHandler handler = new BiComHandler();
            handler.setCameraCommand(data);
            return this.sendBiComCameraCommand(handler.getCommandAsHexString());
        }
        return 0;
    }

    @Override
    public int setAutoIris(Boolean active) {
        if (this.protocol == 2) {
            PelcoDHandler handler = new PelcoDHandler();
            handler.init(this.videoSrv);
            if (active != null) {
                handler.setCameraCommand(11, active);
            }
            return this.sendCameraCommand(handler.getCommandAsByteArray());
        }
        if (this.protocol != 1 && this.protocol == 3) {
            byte[] data = new byte[]{0, 4, 1, -80, 3, 0, 0};
            if (active.booleanValue()) {
                data[6] = 0;
            }
            BiComHandler handler = new BiComHandler();
            handler.setCameraCommand(data);
            return this.sendBiComCameraCommand(handler.getCommandAsHexString());
        }
        return 0;
    }

    @Override
    public int setAbsoluteFocus(Integer value) {
        throw new RuntimeException("NOT YET IMPLEMENTED :-(");
    }

    @Override
    public int setContinuousFocus(Integer value) {
        if (this.protocol == 2) {
            PelcoDHandler handler = new PelcoDHandler();
            handler.init(this.videoSrv);
            if (value != null && value != 0) {
                if (value > 0) {
                    handler.setGenericCommand(12, value);
                } else {
                    handler.setGenericCommand(13, value);
                }
            } else {
                handler.setGenericCommand(18, 0);
            }
            return this.sendCameraCommand(handler.getCommandAsByteArray());
        }
        if (this.protocol == 1) {
            int focus;
            int data1 = 0;
            int data2 = 0;
            int n = focus = value != null ? value : 0;
            if (focus > 0) {
                data1 |= 2;
            } else if (focus < 0) {
                data2 |= 2;
            }
            byte[] data = new byte[]{(byte)data1, (byte)data2};
            AutoDomeHandler handler = new AutoDomeHandler();
            handler.init(this.videoSrv);
            handler.setCameraCommand((byte)2, data);
            return this.sendCameraCommand(handler.getCommandAsByteArray());
        }
        if (this.protocol == 3) {
            int focus = value != null ? value : 0;
            byte[] data = new byte[]{0, 4, 1, -16, -126, 0, 0};
            if (focus > 0) {
                data[6] = 2;
            } else if (focus < 0) {
                data[6] = 1;
            }
            BiComHandler handler = new BiComHandler();
            handler.setCameraCommand(data);
            return this.sendBiComCameraCommand(handler.getCommandAsHexString());
        }
        return 0;
    }

    @Override
    public int setAutoFocus(Boolean active) {
        if (this.protocol == 2) {
            PelcoDHandler handler = new PelcoDHandler();
            handler.init(this.videoSrv);
            if (active != null) {
                handler.setCameraCommand(14, active);
            }
            return this.sendCameraCommand(handler.getCommandAsByteArray());
        }
        if (this.protocol != 1 && this.protocol == 3) {
            byte[] data = new byte[]{0, 4, 1, -16, 3, 0, 0};
            if (active.booleanValue()) {
                data[6] = 1;
            }
            BiComHandler handler = new BiComHandler();
            handler.setCameraCommand(data);
            return this.sendBiComCameraCommand(handler.getCommandAsHexString());
        }
        return 0;
    }

    @Override
    public int setZeroLux(Boolean active) {
        if (active != null) {
            if (this.protocol == 2) {
                return 0;
            }
            if (this.protocol == 1) {
                return 0;
            }
            if (this.protocol == 3) {
                byte[] data = new byte[]{0, 4, 1, 64, 3, 0, 0};
                if (active.booleanValue()) {
                    data[6] = 1;
                }
                BiComHandler handler = new BiComHandler();
                handler.setCameraCommand(data);
                return this.sendBiComCameraCommand(handler.getCommandAsHexString());
            }
        }
        return 0;
    }

    @Override
    public int setAutoZeroLux(Boolean active) {
        throw new RuntimeException("NOT YET IMPLEMENTED :-(");
    }

    @Override
    public int setHomePosition() {
        if (this.protocol == 2) {
            return 0;
        }
        if (this.protocol == 1) {
            return 0;
        }
        if (this.protocol == 3) {
            byte[] data = new byte[]{0, 6, 1, 80, -128};
            BiComHandler handler = new BiComHandler();
            handler.setCameraCommand(data);
            return this.sendBiComCameraCommand(handler.getCommandAsHexString());
        }
        return 0;
    }

    @Override
    public int addPresetPosition(Vector<byte[]> vResult, Long presetID, String presetName) {
        int presetPosition = -1;
        if (presetName == null) {
            this.logger.warn("Argument presetName is null!");
            return -20002;
        }
        try {
            int i;
            int bitVector = 0;
            for (i = 0; i < this.presetList.size(); ++i) {
                PresetCnf presetCnf = this.presetList.elementAt(i);
                bitVector |= 1 << Integer.parseInt(presetCnf.getPresetPosition());
            }
            for (i = 1; i <= 32; ++i) {
                if ((bitVector & 1 << i) != 0) continue;
                presetPosition = i;
                break;
            }
            if (this.protocol == 2) {
                int n = presetPosition = presetName.equalsIgnoreCase(PELCO_D_OSD_TAG) ? 95 : presetPosition;
            }
            if (presetPosition < 0) {
                this.logger.error("Cannot add preset [" + presetName + "], 'cause no more free preset positions are available for " + this + " :-(");
                return -21600;
            }
            if (this.protocol == 2) {
                PelcoDHandler handler = new PelcoDHandler();
                handler.init(this.videoSrv);
                if (presetPosition >= 1 && presetPosition <= 32) {
                    this.logger.info("Add preset '" + presetName + "'. ID = " + presetID + ". Position = " + presetPosition);
                    handler.setPresetCommand(15, presetPosition);
                    int errorCode = this.sendCameraCommand(handler.getCommandAsByteArray());
                    if (errorCode != 0) {
                        this.logger.warn("Error setting preset on camera. errorCode: " + errorCode);
                        return -21600;
                    }
                } else if (presetPosition != 95) {
                    this.logger.warn("presetID has invalid value. Must be 0x01 <= n <= 0x20. Given: " + presetPosition);
                    return -21600;
                }
            } else if (this.protocol == 1) {
                AutoDomeHandler handler = new AutoDomeHandler();
                handler.init(this.videoSrv);
                this.logger.info("Add preset '" + presetName + "'. ID = " + presetID + ". Position = " + presetPosition);
                byte data1 = 4;
                byte data2 = (byte)presetPosition;
                byte[] data = new byte[]{data1, data2};
                handler.setCameraCommand((byte)7, data);
                this.sendCameraCommand(handler.getCommandAsByteArray());
                this.setContinuousIris(-1);
                this.setContinuousIris(null);
            } else if (this.protocol == 3) {
                if (presetPosition < 0 || presetPosition > 255) {
                    this.logger.warn("presetID has invalid value. Must be 0x00 <= n <= 0xFF. Given: " + presetPosition);
                    return -21600;
                }
                if (this.boschDevice.getDeviceType() == 201748L || this.boschDevice.getDeviceType() == 200657L) {
                    String limitedPresetName = presetName;
                    if (limitedPresetName.length() > 20) {
                        limitedPresetName = limitedPresetName.substring(0, 20);
                    }
                    this.logger.info("Add preset '" + limitedPresetName + "'. ID = " + presetID + ". Position = " + presetPosition);
                    ArrayOfCameraPreset arrayOfCameraPreset = this.getPresetsFromCamera();
                    int positionOnBicom = -1;
                    for (int i2 = 1; i2 <= arrayOfCameraPreset.getCameraPreset().size(); ++i2) {
                        CameraPreset cameraPreset = arrayOfCameraPreset.getCameraPreset().get(i2 - 1);
                        String preset = BoschCameraControl.getPresetPositionFromXML(cameraPreset.getPtzData().getBytes());
                        if (presetName.equals(cameraPreset.getName()) || limitedPresetName.equals(cameraPreset.getName())) {
                            this.logger.error("Cannot set preset name " + presetName + ". Name already exists for " + this);
                            return -21683;
                        }
                        if (preset.equals("" + i2)) continue;
                        positionOnBicom = i2 - 1;
                        break;
                    }
                    if (positionOnBicom == -1) {
                        positionOnBicom = arrayOfCameraPreset.getCameraPreset().size();
                    }
                    byte[] dataDel = new byte[]{0, 6, 32, 0, 3, 0, 1};
                    byte[] data = new byte[]{0, 6, 32, 0, -128};
                    byte lowerPart = (byte)(positionOnBicom >> 4);
                    dataDel[2] = lowerPart = (byte)(lowerPart | 0x20);
                    byte higherPart = (byte)(positionOnBicom << 4);
                    dataDel[3] = higherPart = (byte)(higherPart | 7);
                    BiComHandler handler = new BiComHandler();
                    handler.setCameraCommand(dataDel);
                    this.sendBiComCameraCommand(handler.getCommandAsHexString());
                    data[2] = lowerPart;
                    data[3] = (byte)(positionOnBicom << 4);
                    handler.setCameraCommand(data);
                    this.sendBiComCameraCommand(handler.getCommandAsHexString());
                    data[3] = (byte)(data[3] | 2);
                    data[4] = 3;
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    baos.write(data);
                    this.encodePresetName(limitedPresetName, baos);
                    data = baos.toByteArray();
                    handler.setCameraCommand(data);
                    this.sendBiComCameraCommand(handler.getCommandAsHexString());
                } else {
                    this.logger.info("Add preset '" + presetName + "'. ID = " + presetID + ". Position = " + presetPosition);
                    int positionOnBicom = presetPosition - 1;
                    positionOnBicom = positionOnBicom < 0 ? 0 : positionOnBicom;
                    byte[] dataDel = new byte[]{0, 6, 32, 0, 3, 0, 1};
                    byte[] data = new byte[]{0, 6, 32, 0, -128};
                    byte lowerPart = (byte)(positionOnBicom >> 4);
                    dataDel[2] = lowerPart = (byte)(lowerPart | 0x20);
                    byte higherPart = (byte)(positionOnBicom << 4);
                    dataDel[3] = higherPart = (byte)(higherPart | 7);
                    BiComHandler handler = new BiComHandler();
                    handler.setCameraCommand(dataDel);
                    this.sendBiComCameraCommand(handler.getCommandAsHexString());
                    data[2] = lowerPart;
                    data[3] = (byte)(positionOnBicom << 4);
                    handler.setCameraCommand(data);
                    this.sendBiComCameraCommand(handler.getCommandAsHexString());
                }
            }
            PresetCnf presetCnf = PresetCnf.createPresetCnf(presetID, "" + presetPosition, presetName);
            this.presetList.addElement(presetCnf);
            vResult.addElement(presetCnf.getPresetCnf());
            return 0;
        }
        catch (Throwable ex) {
            this.logger.error("Adding preset [" + presetName + "] failed :-(", ex);
            return -21600;
        }
    }

    private void encodePresetName(String limitedPresetName, ByteArrayOutputStream byteArrayOutputStream) throws UnsupportedEncodingException, IOException {
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)byteArrayOutputStream, "UTF-16BE");){
            writer.write(limitedPresetName);
            writer.flush();
        }
    }

    @Override
    public int setPresetPosition(String presetName) {
        if (presetName == null) {
            this.logger.warn("Argument presetName is null!");
            return -20002;
        }
        try {
            for (int i = 0; i < this.presetList.size(); ++i) {
                PresetCnf presetCnf = this.presetList.elementAt(i);
                String limitedPresetName = presetName;
                if (limitedPresetName.length() > 20) {
                    limitedPresetName = limitedPresetName.substring(0, 20);
                }
                if (!presetName.equals(presetCnf.getPresetName()) && (this.protocol != 3 || !limitedPresetName.equals(presetCnf.getPresetName()))) continue;
                if (this.protocol == 2) {
                    if (presetName.equalsIgnoreCase(PELCO_D_OSD_TAG)) {
                        this.setOSD(true);
                        continue;
                    }
                    PelcoDHandler handler = new PelcoDHandler();
                    handler.init(this.videoSrv);
                    handler.setPresetCommand(16, Integer.parseInt(presetCnf.getPresetPosition()));
                    return this.sendCameraCommand(handler.getCommandAsByteArray());
                }
                if (this.protocol == 1) {
                    AutoDomeHandler handler = new AutoDomeHandler();
                    handler.init(this.videoSrv);
                    byte data1 = 5;
                    byte data2 = (byte)Integer.parseInt(presetCnf.getPresetPosition());
                    byte[] data = new byte[]{data1, data2};
                    handler.setCameraCommand((byte)7, data);
                    return this.sendCameraCommand(handler.getCommandAsByteArray());
                }
                if (this.protocol != 3) continue;
                int presetPosition = Integer.parseInt(presetCnf.getPresetPosition()) - 1;
                if (this.boschDevice.getDeviceType() == 201748L || this.boschDevice.getDeviceType() == 200657L) {
                    for (CameraPreset cameraPreset : this.getPresetsFromCamera().getCameraPreset()) {
                        if (!cameraPreset.getName().equals(limitedPresetName)) continue;
                        String pos = BoschCameraControl.getPresetPositionFromXML(cameraPreset.getPtzData().getBytes());
                        presetPosition = Integer.parseInt(pos) - 1;
                        break;
                    }
                }
                if (presetPosition >= 0 && presetPosition <= 255) {
                    byte[] data = new byte[]{0, 6, 32, 0, -127};
                    byte lowerPart = (byte)(presetPosition >> 4);
                    data[2] = lowerPart = (byte)(lowerPart | 0x20);
                    data[3] = (byte)(presetPosition << 4);
                    BiComHandler handler = new BiComHandler();
                    handler.setCameraCommand(data);
                    return this.sendBiComCameraCommand(handler.getCommandAsHexString());
                }
                this.logger.warn("presetID has invalid value. Must be 0x00 <= n <= 0xFF. Given: " + presetPosition);
                return -21600;
            }
            return 0;
        }
        catch (Exception ex) {
            this.logger.error("Setting preset [" + presetName + "] failed", (Throwable)ex);
            return -21600;
        }
    }

    @Override
    public int removePresetPosition(String presetName) {
        int errorCode = 0;
        if (presetName == null) {
            this.logger.warn("Argument presetName is null!");
            return -20002;
        }
        String limitedPresetName = presetName;
        if (limitedPresetName.length() > 20) {
            limitedPresetName = limitedPresetName.substring(0, 20);
        }
        try {
            for (int i = 0; i < this.presetList.size(); ++i) {
                PresetCnf presetCnf = (PresetCnf)this.presetList.elementAt(i);
                if (!presetName.equals(presetCnf.getPresetName()) && (this.protocol != 3 || !limitedPresetName.equals(presetCnf.getPresetName()))) continue;
                this.presetList.removeElementAt(i);
                if (this.protocol == 2) {
                    PelcoDHandler handler = new PelcoDHandler();
                    handler.init(this.videoSrv);
                    handler.setPresetCommand(17, i + 1);
                    return this.sendCameraCommand(handler.getCommandAsByteArray());
                }
                if (this.protocol == 1) {
                    return errorCode;
                }
                if (this.protocol != 3) continue;
                if (this.boschDevice.getDeviceType() == 201748L || this.boschDevice.getDeviceType() == 200657L) {
                    int positionOnBicom = -1;
                    for (CameraPreset cameraPreset : this.getPresetsFromCamera().getCameraPreset()) {
                        if (!cameraPreset.getName().equals(limitedPresetName)) continue;
                        String pos = BoschCameraControl.getPresetPositionFromXML(cameraPreset.getPtzData().getBytes());
                        positionOnBicom = Integer.parseInt(pos) - 1;
                        break;
                    }
                    if (positionOnBicom == -1) {
                        return errorCode;
                    }
                    byte[] dataDel = new byte[]{0, 6, 32, 0, 3, 0, 1};
                    byte lowerPart = (byte)(positionOnBicom >> 4);
                    dataDel[2] = lowerPart = (byte)(lowerPart | 0x20);
                    byte higherPart = (byte)(positionOnBicom << 4);
                    dataDel[3] = higherPart = (byte)(higherPart | 7);
                    BiComHandler handler = new BiComHandler();
                    handler.setCameraCommand(dataDel);
                    this.sendBiComCameraCommand(handler.getCommandAsHexString());
                    continue;
                }
                return errorCode;
            }
        }
        catch (Exception ex) {
            this.logger.error("Removing preset [" + presetName + "] failed for " + this + " : " + ex.getMessage());
            return -21600;
        }
        return errorCode;
    }

    public int setOSD(Boolean activate) {
        if (this.protocol == 2) {
            PelcoDHandler handler = new PelcoDHandler();
            handler.init(this.videoSrv);
            if (activate != null && activate.booleanValue()) {
                handler.setPresetCommand(15, 95);
            }
            return this.sendCameraCommand(handler.getCommandAsByteArray());
        }
        return 0;
    }

    private TransparentData getTransparentDataPacket(byte[] payload) {
        TransparentData req = new TransparentData();
        req.setActionRequest();
        req.setClientID(this.clientID);
        byte by = this.requestId;
        this.requestId = (byte)(by + 1);
        req.setReserved(by);
        req.setTransparentData(payload);
        req.setNumericDescriptorAsInt(1);
        return req;
    }

    private int sendCameraCommand(byte[] payload) {
        try {
            TransparentData req = this.getTransparentDataPacket(payload);
            this.sendRCPDataPacket(req);
            if (this.videoSrv != null) {
                this.videoSrv.notifyForCameraControl();
            }
            return 0;
        }
        catch (Throwable ex) {
            this.logger.error("Error while sending RCP + camera control command.");
            this.logger.error("Exception: " + ex.getMessage(), ex);
            this.shutdown();
            return -21600;
        }
    }

    private int sendBiComCameraCommand(String url) {
        String completeURL = "/rcp.xml?command=0x09A5&type=P_OCTET&direction=WRITE&num=" + this.videoSourceID + "&payload=0x" + url;
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.info("Sending URL=[" + completeURL + "] for " + this + " ...");
            }
            if (((CameraControl)this).videoSrv == null) {
                return 0;
            }
            ((CameraControl)this).videoSrv.notifyForCameraControl();
            this.boschDevice.getHttpHandler().readGetRequest(completeURL);
            return 0;
        }
        catch (SeeTecException ex) {
            this.logger.error("Sending HTTP request [" + completeURL + "] failed with error [" + ex.getErrorCode() + "] :-(");
            this.logger.error("Error: " + ex.getMessage());
            return ex.getErrorCode();
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
            return -21600;
        }
    }

    @Override
    public int addCameraPresets(ArrayOfCameraPreset presets) {
        if (presets == null) {
            this.logger.warn("Received null camera presets object in addCameraPresets!");
            return -20002;
        }
        List<CameraPreset> cameraPresets = presets.getCameraPreset();
        for (CameraPreset cameraPreset : cameraPresets) {
            try {
                String presetPosition = BoschCameraControl.getPresetPositionFromXML(cameraPreset.getPtzData().getBytes());
                PresetCnf presetCnf = PresetCnf.createPresetCnf(cameraPreset.getId(), presetPosition, cameraPreset.getName());
                this.presetList.addElement(presetCnf);
                this.logger.info("Adding preset configuration: " + presetCnf);
            }
            catch (JDOMException ex) {
                this.logger.warn("Exception while adding camera preset for " + this + ": " + ex.getMessage());
            }
        }
        return 0;
    }

    @Override
    public ArrayOfCameraPreset getPresetsFromCamera() {
        try {
            byte nameLength;
            PresetPositionsXML presetPositionsXML = new PresetPositionsXML();
            presetPositionsXML.setNum(this.channelNumber);
            presetPositionsXML.send(this.boschDevice, Direction.READ);
            String presets = presetPositionsXML.getPresetList();
            presets = presets.replace(" ", "").replace("\r", "").replace("\n", "");
            byte[] data = Basic.hexStringToByteArray((String)presets);
            ArrayOfCameraPreset arrayOfCameraPreset = new ArrayOfCameraPreset();
            for (int pointer = 0; pointer < data.length - 1; pointer += nameLength + 2) {
                int presetPosition = data[pointer] & 0xFF;
                nameLength = data[pointer + 1];
                String presetName = new String(Arrays.copyOfRange(data, pointer + 2, pointer + nameLength + 2), "UTF-16BE");
                CameraPreset cameraPreset = new CameraPreset();
                PresetCnf presetCnf = PresetCnf.createPresetCnf(cameraPreset.getId(), "" + presetPosition, presetName);
                cameraPreset.setName(presetName);
                cameraPreset.setPtzData(new String(presetCnf.getPresetCnf(), "UTF-8"));
                arrayOfCameraPreset.getCameraPreset().add(cameraPreset);
            }
            return arrayOfCameraPreset;
        }
        catch (Exception ex) {
            this.logger.error(ex + " for " + this, (Throwable)ex);
            return new ArrayOfCameraPreset();
        }
    }
}

