/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.bosch;

import de.seetec.v5.re.cm.device.shared.VideoSrv;
import de.seetec.v5.shared.util.ConfigurationException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AutoDomeHandler {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.bosch.AutoDomeHandler";
    public static final byte OP_CODE_CON_PTZ = 5;
    public static final byte OP_CODE_FIX_CONTROL = 2;
    public static final byte OP_CODE_AUX = 7;
    public static final byte OP_CODE_REP_CONTROL = 8;
    private byte[] hexCommand = null;
    private int videoSourceID = Integer.MIN_VALUE;
    private Logger logger = null;

    public int init(VideoSrv videoSrv) {
        this.logger = LogManager.getLogger((String)CLASS_NAME);
        if (videoSrv != null && videoSrv.getVideoSourceCnf() != null) {
            try {
                this.videoSourceID = (byte)videoSrv.getVideoSourceCnf().getPtzAddress();
            }
            catch (ConfigurationException ce) {
                this.logger.warn("Error when reading 'VideoSourceID'. Set to 01.");
                this.videoSourceID = 1;
            }
            --this.videoSourceID;
        } else {
            this.logger.warn("'VideoSourceID' not specified. Set to 01.");
            this.videoSourceID = 1;
        }
        return 0;
    }

    private void initializeHexCommand(int length) {
        this.hexCommand = new byte[5 + length];
        for (int i = 0; i < this.hexCommand.length; ++i) {
            this.hexCommand[i] = 0;
        }
    }

    public byte[] getCommandAsByteArray() {
        byte[] ret = new byte[this.hexCommand.length];
        System.arraycopy(this.hexCommand, 0, ret, 0, this.hexCommand.length);
        return ret;
    }

    public int setCameraCommand(byte command, byte[] data) {
        if (data == null) {
            return -20000;
        }
        this.initializeHexCommand(data.length);
        this.hexCommand[0] = (byte)(132 + data.length);
        this.hexCommand[1] = (byte)((byte)this.videoSourceID >> 7);
        this.hexCommand[2] = (byte)((byte)this.videoSourceID & 0x7F);
        this.hexCommand[3] = command;
        System.arraycopy(data, 0, this.hexCommand, 4, data.length);
        for (int i = 0; i < this.hexCommand.length - 1; ++i) {
            int n = this.hexCommand.length - 1;
            this.hexCommand[n] = (byte)(this.hexCommand[n] + this.hexCommand[i]);
        }
        this.hexCommand[this.hexCommand.length - 1] = (byte)(this.hexCommand[this.hexCommand.length - 1] & 0x7F);
        return 0;
    }
}

