/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.basler.mpeg;

import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPStreamSettings;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingHelper;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingHelperMpeg4;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingVideoSourceClientRTSP;
import de.seetec.v5.re.cm.device.video.basler.BaslerDevice;
import de.seetec.v5.re.cm.device.video.basler.BaslerHardwareMotionDetection;
import de.seetec.v5.re.cm.device.video.basler.BaslerMotionDetectionHandler;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.re.shared.MediaFrame;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.Hashtable;
import java.util.Map;
import java.util.Random;

public class BaslerMPEGVideoSourceClient
extends StreamingVideoSourceClientRTSP {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.basler.mpeg.BaslerMPEGVideoSourceClient";
    final byte[] MOTIONTAG = new byte[]{77, 111, 116, 105, 111, 110, 61};
    private int rtspPort = 554;
    private String fpsAsString = null;
    private StringBuffer parameterUrl = null;
    private String url = null;
    private long streamID = 0L;
    private String codecAPIString = "mpeg4";
    private String codecParameterString = "MPEG4";
    private MediaFrame mediaFrame;

    @Override
    public int init() {
        Hashtable<String, String> htParameters = new Hashtable<String, String>();
        boolean rtspPortAlreadySet = false;
        byte[] result = null;
        String outputScale = null;
        Random random = new Random(System.currentTimeMillis());
        byte[] myssrc = new byte[4];
        random.nextBytes(myssrc);
        System.arraycopy(myssrc, 0, this.receiverReport, 4, myssrc.length);
        this.errorCode = super.init();
        if (this.errorCode != 0) {
            this.logger.error("Error while initializing. Code: " + this.errorCode + " for " + this);
            return this.errorCode;
        }
        if (this.videoCodec == Codec.MPEG4) {
            this.codecAPIString = "mpeg4";
            this.codecParameterString = "MPEG4";
        } else if (this.videoCodec == Codec.H264) {
            this.codecAPIString = "h264";
            this.codecParameterString = "H_264";
        } else {
            this.logger.error("Invalid videoCodec: " + this.videoCodec + " for " + this);
            return -21601;
        }
        this.fps /= 1000L;
        if (((BaslerDevice)this.getVideoSrv().getDevice()).isBIP1Series()) {
            long entityType = this.getVideoSrv().getEntityType();
            if (entityType == 211604L) {
                long l = this.fps = this.fps > 12L ? 12L : this.fps;
            }
            if (this.fps < 4L) {
                this.fpsAsString = "Fps_2_5";
            } else if (this.fps >= 4L && this.fps < 6L) {
                this.fpsAsString = "Fps_5";
            } else if (this.fps >= 6L && this.fps < 8L) {
                this.fpsAsString = "Fps_6_25";
            } else if (this.fps >= 8L && this.fps < 11L) {
                this.fpsAsString = "Fps_10";
            } else if (this.fps >= 11L && this.fps < 13L) {
                this.fpsAsString = "Fps_12_5";
            } else if (this.fps >= 13L && this.fps < 18L) {
                this.fpsAsString = "Fps_15";
            } else if (this.fps >= 18L && this.fps < 23L) {
                this.fpsAsString = "Fps_20";
            } else if (this.fps >= 23L && this.fps < 27L) {
                this.fpsAsString = "Fps_25";
            } else if (this.fps >= 27L && this.fps < 35L) {
                this.fpsAsString = "Fps_30";
            } else if (this.fps >= 35L && this.fps < 45L) {
                this.fpsAsString = "Fps_40";
            } else if (this.fps >= 45L && this.fps < 55L) {
                this.fpsAsString = "Fps_50";
            } else if (this.fps >= 55L && this.fps < 65L) {
                this.fpsAsString = "Fps_60";
            } else if (this.fps >= 65L && this.fps < 75L) {
                this.fpsAsString = "Fps_70";
            } else if (this.fps >= 75L && this.fps < 85L) {
                this.fpsAsString = "Fps_80";
            } else if (this.fps >= 85L && this.fps < 95L) {
                this.fpsAsString = "Fps_90";
            } else if (this.fps >= 95L) {
                this.fpsAsString = "Fps_100";
            }
        } else {
            this.fpsAsString = "FpsScale_1_" + 100L / this.fps;
        }
        this.bandwidth /= 1024;
        if (((BaslerDevice)this.getVideoSrv().getDevice()).isBIP1Series()) {
            this.bandwidth = this.bandwidth < 100 ? 100 : this.bandwidth;
            this.bandwidth = this.bandwidth > 4000 ? 4000 : this.bandwidth;
        } else {
            this.bandwidth = this.bandwidth < 32 ? 32 : this.bandwidth;
            this.bandwidth = this.bandwidth > 16000 ? 16000 : this.bandwidth;
        }
        this.quality /= 1000;
        this.quality = this.quality < 1 ? 1 : this.quality;
        this.iFrameDistMS = this.iFrameDistMS < 1000 ? 1000 : this.iFrameDistMS;
        int n = this.iFrameDistMS = this.iFrameDistMS > 10000 ? 10000 : this.iFrameDistMS;
        if (this.resolutionTag == null) {
            this.logger.info("ResolutionTag not set in configuration for " + this);
            this.logger.info("OutputScale 1:1 will be used for " + this);
            outputScale = "Scale_1_1";
        } else if (this.resolutionTag.length() == 0) {
            this.logger.info("ResolutionTag not set in configuration for " + this);
            this.logger.info("OutputScale 1:1 will be used for " + this);
            outputScale = "Scale_1_1";
        } else if ("1:1".equalsIgnoreCase(this.resolutionTag)) {
            outputScale = "Scale_1_1";
        } else if ("1:2".equalsIgnoreCase(this.resolutionTag)) {
            outputScale = "Scale_1_2";
        } else if ("1:4".equalsIgnoreCase(this.resolutionTag)) {
            outputScale = "Scale_1_4";
        } else if ("1:8".equalsIgnoreCase(this.resolutionTag)) {
            outputScale = "Scale_1_8";
        } else {
            this.logger.warn("Unknwon resolutionTag '" + this.resolutionTag + "' given  for " + this);
            outputScale = "Scale_1_1";
        }
        try {
            this.rtspPort = this.listener.getVideoSourceParameter().getRtspPort();
        }
        catch (ConfigurationException ex) {
            this.logger.warn("RTSP Port could not be read -> setting to default 554");
            this.logger.warn((Object)ex, (Throwable)ex);
        }
        this.logger.info("Stream: " + this.streamID + ": Image parameter: Q=" + this.quality + ", iFrameDist:" + this.iFrameDistMS + ", rate=" + this.bandwidth + ", fps=" + this.fpsAsString + ", res=" + outputScale);
        String parameters = "/cgi-bin/param_if.cgi?NumActions=11&Action_0=Stream.StreamSelector.SetValue&Parameter_0_0=" + this.streamID + "&Action_1=Stream.EncoderType.GetValue";
        htParameters.put("_1", this.codecParameterString);
        if (this.isConstantBitrateUsed) {
            htParameters.put("_2", "" + this.bandwidth);
            htParameters.put("_3", "CBR");
            parameters = ((BaslerDevice)this.getVideoSrv().getDevice()).isBIP1Series() ? parameters + "&Action_2=Stream.Bitrate.GetValue&Action_3=Stream.EncoderMode.GetValue&Action_4=Sensor.FrameRateMode.GetValue&Action_5=Stream.GopLength_ms.GetValue&Action_6=Stream.OverlayText.GetValue&Action_7=Sensor.ImageRotation.GetValue&Action_8=Streaming.RTSPPort.GetValue&Action_9=Stream.StreamSelector.GetValue&Action_10=Stream.OutputScaling.GetValue" : parameters + "&Action_2=Stream.Bitrate.GetValue&Action_3=Stream.EncoderMode.GetValue&Action_4=Stream.FrameRateScaling.GetValue&Action_5=Stream.GopLength_ms.GetValue&Action_6=Stream.OverlayText.GetValue&Action_7=Sensor.ImageRotation.GetValue&Action_8=Streaming.RTSPPort.GetValue&Action_9=Stream.StreamSelector.GetValue&Action_10=Stream.OutputScaling.GetValue";
        } else {
            htParameters.put("_2", "" + this.quality);
            htParameters.put("_3", "VBR");
            parameters = ((BaslerDevice)this.getVideoSrv().getDevice()).isBIP1Series() ? parameters + "&Action_2=Stream.Quality.GetValue&Action_3=Stream.EncoderMode.GetValue&Action_4=Sensor.FrameRateMode.GetValue&Action_5=Stream.GopLength_ms.GetValue&Action_6=Stream.OverlayText.GetValue&Action_7=Sensor.ImageRotation.GetValue&Action_8=Streaming.RTSPPort.GetValue&Action_9=Stream.StreamSelector.GetValue&Action_10=Stream.OutputScaling.GetValue" : parameters + "&Action_2=Stream.Quality.GetValue&Action_3=Stream.EncoderMode.GetValue&Action_4=Stream.FrameRateScaling.GetValue&Action_5=Stream.GopLength_ms.GetValue&Action_6=Stream.OverlayText.GetValue&Action_7=Sensor.ImageRotation.GetValue&Action_8=Streaming.RTSPPort.GetValue&Action_9=Stream.StreamSelector.GetValue&Action_10=Stream.OutputScaling.GetValue";
        }
        htParameters.put("_4", "" + this.fpsAsString);
        htParameters.put("_5", "" + this.iFrameDistMS);
        try {
            if (this.getVideoSrv().getVideoSourceCnf().isTimeDateEnabled()) {
                htParameters.put("_6", URLEncoder.encode("$date$", "UTF-8"));
            } else {
                htParameters.put("_6", "\n");
            }
        }
        catch (Exception e) {
            this.logger.error("Error while filling htParameters for " + this.getVideoSrv());
            this.logger.error((Object)e, (Throwable)e);
            return -21601;
        }
        htParameters.put("_7", "ROT_" + this.rotationAngle);
        htParameters.put("_8", "" + this.rtspPort);
        htParameters.put("_10", outputScale);
        int numberOfCorrectSetting = 0;
        try {
            result = NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)parameters, (int)Integer.MAX_VALUE);
            String resultAsString = new String(result);
            for (Map.Entry entry : htParameters.entrySet()) {
                String searchString = "Return" + (String)entry.getKey() + "=" + (String)entry.getValue();
                searchString = searchString.endsWith("\n") ? searchString : searchString + "\n";
                if (!resultAsString.contains(searchString)) continue;
                ++numberOfCorrectSetting;
                if (!"_8".equals(entry.getKey())) continue;
                rtspPortAlreadySet = true;
            }
        }
        catch (SeeTecException e) {
            this.logger.error("Exception while requesting current data for " + this.getVideoSrv(), (Throwable)e);
            return e.getErrorCode();
        }
        if (numberOfCorrectSetting == 9) {
            this.logger.info("All parameteres already set up for " + this.getVideoSrv());
        } else {
            int numberOfParameters = 8;
            this.parameterUrl = new StringBuffer("&Action_0=Stream.StreamSelector.SetValue&Parameter_0_0=");
            this.parameterUrl.append(this.streamID);
            this.parameterUrl.append("&Action_1=Stream.EncoderType.SetValue&Parameter_1_0=");
            this.parameterUrl.append((String)htParameters.get("_1"));
            if (this.isConstantBitrateUsed) {
                this.parameterUrl.append("&Action_2=Stream.Bitrate.SetValue&Parameter_2_0=");
            } else {
                this.parameterUrl.append("&Action_2=Stream.Quality.SetValue&Parameter_2_0=");
            }
            this.parameterUrl.append((String)htParameters.get("_2"));
            this.parameterUrl.append("&Action_3=Stream.EncoderMode.SetValue&Parameter_3_0=");
            this.parameterUrl.append((String)htParameters.get("_3"));
            if (((BaslerDevice)this.getVideoSrv().getDevice()).isBIP1Series()) {
                this.parameterUrl.append("&Action_4=Sensor.FrameRateMode.SetValue&Parameter_4_0=");
            } else {
                this.parameterUrl.append("&Action_4=Stream.FrameRateScaling.SetValue&Parameter_4_0=");
            }
            this.parameterUrl.append((String)htParameters.get("_4"));
            this.parameterUrl.append("&Action_5=Stream.GopLength_ms.SetValue&Parameter_5_0=");
            this.parameterUrl.append((String)htParameters.get("_5"));
            try {
                if (this.getVideoSrv().getVideoSourceCnf().isTimeDateEnabled()) {
                    htParameters.put("_6", URLEncoder.encode("$date$", "UTF-8"));
                } else {
                    htParameters.put("_6", "");
                }
            }
            catch (Exception e) {
                this.logger.error("Error while filling htParameters for " + this.getVideoSrv());
                this.logger.error((Object)e, (Throwable)e);
                return -21601;
            }
            this.parameterUrl.append("&Action_6=Stream.OverlayText.SetValue&Parameter_6_0=");
            this.parameterUrl.append((String)htParameters.get("_6"));
            this.parameterUrl.append("&Action_7=Sensor.ImageRotation.SetValue&Parameter_7_0=");
            this.parameterUrl.append((String)htParameters.get("_7"));
            if (!rtspPortAlreadySet) {
                try {
                    if (this.listener.getVideoSourceParameter().getRtspPort() > 0) {
                        if (this.listener.getVideoSourceParameter().getRtspPort() != 554 && this.listener.getVideoSourceParameter().getRtspPort() < 1024) {
                            this.logger.error("Invalid customized RTSP port: " + this.listener.getVideoSourceParameter().getRtspPort() + ". Valid values 554,1024..65535");
                            return -21601;
                        }
                        numberOfParameters += 2;
                        this.rtspPort = this.listener.getVideoSourceParameter().getRtspPort();
                        this.logger.info("Using RTSP port: " + this.rtspPort);
                        this.parameterUrl.append("&Action_8=Streaming.RTSPPort.SetValue&Parameter_8_0=");
                        this.parameterUrl.append((String)htParameters.get("_8"));
                        this.parameterUrl.append("&Action_9=Streaming.Commit.Execute");
                    }
                }
                catch (ConfigurationException ex) {
                    this.logger.warn("RTSP port could not be read -> setting to 554");
                    this.logger.warn((Object)ex, (Throwable)ex);
                    this.rtspPort = 554;
                }
            }
            this.parameterUrl.append("&Action_" + numberOfParameters + "=Stream.OutputScaling.SetValue&Parameter_" + numberOfParameters + "_0=");
            this.parameterUrl.append((String)htParameters.get("_10"));
            this.parameterUrl.insert(0, "/cgi-bin/param_if.cgi?NumActions=" + ++numberOfParameters);
            if (this.getVideoSrv() != null && this.getVideoSrv().getDevice() != null && (this.errorCode = ((BaslerDevice)this.getVideoSrv().getDevice()).setParameter(this.parameterUrl.toString())) != 0) {
                this.logger.error("Error '" + this.errorCode + "' setting parameters for " + this);
                return -20000;
            }
            try {
                Thread.sleep(800L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.url = "rtsp://" + this.getHost() + "/" + this.codecAPIString + "?metainfo=sei";
        if (!((BaslerDevice)this.getVideoSrv().getDevice()).isBIP1Series()) {
            this.url = this.url + "&stream=";
            this.url = this.url + this.streamID;
        }
        this.rtspSettings = new RTSPStreamSettings();
        this.networkParameter.setSoTimeout(Math.max(10000, this.iFrameDistMS * 3));
        try {
            this.errorCode = this.rtspSettings.init(this, this.audioSourceClient, this.networkParameter, this.listener.getVideoSourceParameter().getRtspPort(), this.url, this.printDebug, this.transmissionID, this.networkParameter.getSoTimeout(), this.isAudioEnabled, 1);
            if (this.errorCode != 0) {
                this.logger.error("Initialization of RTSPSettings failed with errorCode: " + this.errorCode + " for " + this.getVideoSrv());
                return this.errorCode;
            }
        }
        catch (ConfigurationException ex) {
            this.logger.warn("Could not initialize rtspSettings for " + this);
            this.logger.warn((Object)ex, (Throwable)ex);
        }
        try {
            this.rtspHandler = this.rtspSettings.getRTSPHandler();
        }
        catch (SeeTecException ex) {
            this.logger.error("Exception while starting RTSP Handling for " + this.getVideoSrv() + " : " + ex.getMessage());
            return ex.getErrorCode();
        }
        this.errorCode = this.rtspHandler.start();
        if (this.errorCode != 0) {
            this.logger.error("Start of RTSPHandler failed with errorCode: " + this.errorCode + " for " + this.getVideoSrv());
            return this.errorCode;
        }
        this.logger.info("init done for" + this.getVideoSrv());
        return 0;
    }

    @Override
    public synchronized int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        return super.shutdown();
    }

    @Override
    public void onNetworkError(int error) {
        if (this.isShutdown()) {
            return;
        }
        this.listener.sendStatusService(error);
        this.shutdown();
    }

    @Override
    public final boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    public void setStreamID(long streamID) {
        this.streamID = streamID;
    }

    @Override
    public void processData(byte[] data) {
        if ((data[12] & 6) == 6) {
            int index = 0;
            index = Basic.indexOfByteArray((byte[])data, (byte[])this.MOTIONTAG, (int)0, (int)data.length);
            if (index != -1 && Basic.indexOfByteArray((byte[])data, (byte[])new byte[]{10}, (int)index, (int)(data.length - index)) != -1) {
                byte[] motionData = new byte[5];
                System.arraycopy(data, index, motionData, 0, 5);
                if (this.listener.hasHardwareMotionDetection() && this.getVideoSrv().getHardwareMotionDetection() != null) {
                    ((BaslerMotionDetectionHandler)((Object)((BaslerHardwareMotionDetection)this.getVideoSrv().getHardwareMotionDetection()).getMotionDetectionHandler())).processMotionDetection(motionData);
                }
            }
        }
        if (this.videoCodec == Codec.MPEG4) {
            this.processMPEG4Data(data);
        } else {
            this.processRtpData(data);
        }
    }

    private void processMPEG4Data(byte[] data) {
        boolean isFrameCompleted = false;
        byte[] completeFrameAsByteArray = null;
        if (this.isShutdown()) {
            return;
        }
        if (data == null) {
            this.logger.error("Incoming data is null");
            return;
        }
        try {
            int mediaType;
            if (data.length >= 2 && data[0] == -128 && data[1] == -56) {
                System.arraycopy(data, 4, this.receiverReport, 8, 4);
                System.arraycopy(data, 10, this.receiverReport, 24, 4);
                this.rtspHandler.sendReceiverReportVideo(this.receiverReport);
                return;
            }
            System.arraycopy(data, 2, this.receiverReport, 18, 2);
            this.rtspHandler.storeReceiverReportVideo(this.receiverReport);
            this.checkForPacketLoss(data);
            try {
                if (data.length <= 13) {
                    return;
                }
                this.completeFrame.write(data, 12, data.length - 12);
                this.completeFrame.flush();
            }
            catch (IOException e) {
                this.logger.error("Error cummulating data for a frame.");
                this.logger.error((Object)e, (Throwable)e);
            }
            if (!StreamingHelper.isFollowUp(data)) {
                completeFrameAsByteArray = this.completeFrame.toByteArray();
                this.completeFrame.reset();
                isFrameCompleted = true;
            }
            if (isFrameCompleted && (mediaType = StreamingHelperMpeg4.checkForMPEG4Part2MediaType(completeFrameAsByteArray)) >= 0) {
                if (mediaType == 33) {
                    if (!((BaslerDevice)this.getVideoSrv().getDevice()).isBIP1Series() && this.videoCodec == Codec.MPEG4) {
                        this.configHeader = new byte[0];
                    }
                    if (this.firstDeliver && this.configHeader == null) {
                        if (completeFrameAsByteArray.length < 31) {
                            this.logger.fatal("Config header awaited in 1st frame. Therefore it's too short. Length: " + completeFrameAsByteArray.length);
                        } else if (completeFrameAsByteArray.length > 500) {
                            this.logger.fatal("Config header awaited in 1st frame. Therefore it's too long. Length: " + completeFrameAsByteArray.length);
                        } else {
                            this.configHeader = completeFrameAsByteArray;
                            return;
                        }
                    }
                    if (this.configHeader == null) {
                        this.logger.fatal("Config frame not arrived as first frame. Abort!");
                        this.shutdown();
                    } else {
                        int[] currentResolution = !((BaslerDevice)this.getVideoSrv().getDevice()).isBIP1Series() ? StreamingHelperMpeg4.extractMPEG4Part2Resolution(completeFrameAsByteArray) : StreamingHelperMpeg4.extractMPEG4Part2Resolution(this.configHeader);
                        if (currentResolution != null) {
                            this.width = currentResolution[0];
                            this.height = currentResolution[1];
                        }
                        this.mediaFrame = StreamingHelper.createSeeTecVideoFrameHeader(Codec.MPEG4, this.width, this.height, completeFrameAsByteArray, this.configHeader);
                        long timestamp = this.calculateTimestampFromRTP(data, mediaType);
                        this.deliverFrame(mediaType, this.mediaFrame, timestamp);
                    }
                } else if (mediaType == 35) {
                    this.mediaFrame = StreamingHelper.createSeeTecVideoFrameHeader(Codec.MPEG4, this.width, this.height, completeFrameAsByteArray);
                    long timestamp = this.calculateTimestampFromRTP(data, mediaType);
                    this.deliverFrame(mediaType, this.mediaFrame, timestamp);
                } else {
                    this.logger.info("Unknown packet ");
                }
            }
        }
        catch (Throwable t) {
            this.logger.error("Ignoring packet due to unexpected error: " + t.getMessage());
            this.logger.error((Object)t, t);
        }
    }

    @Override
    public void sendStatusService(int errorCode) {
        this.listener.sendStatusService(errorCode);
    }
}

