/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.basler;

import de.seetec.v5.re.cm.device.shared.motiondetection.HardwareMotionDetection;
import de.seetec.v5.re.cm.device.shared.motiondetection.MotionDetectionHandler;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;

public class BaslerMotionDetectionHandler
extends MotionDetectionHandler {
    @Override
    public int init(HardwareMotionDetection<? extends MotionDetectionHandler> hardwareMotionDetection) {
        this.listener = hardwareMotionDetection;
        if (this.listener == null) {
            return -20003;
        }
        try {
            NetworkParameter networkParameter = this.listener.getVideoSrv().getDevice().getDeviceCnf().getNetworkParameter();
            if (new String(NetworkHelper.readGetRequest((NetworkParameter)networkParameter, (String)"/cgi-bin/param_if.cgi?NumActions=1&Action_0=Motion.MotionDetectionMode.GetValue", (int)Integer.MAX_VALUE)).indexOf("Return_0=Off ") == -1) {
                this.logger.warn("Motion Detection on camera DISABLED for " + this.listener.getVideoSrv());
                this.logger.warn("Try to enable one motion detection window");
                if (NetworkHelper.readGetRequest((NetworkParameter)networkParameter, (String)"/cgi-bin/param_if.cgi?NumActions=1&Action_0=Motion.MotionDetectionMode.SetValue&Parameter_0_0=On", (int)Integer.MAX_VALUE) == null) {
                    this.logger.warn("Could not enable motion detection window. Enable it on the camera or disable motion detection windows in SeeTec 5 system.");
                    return -21664;
                }
            }
        }
        catch (Exception e) {
            this.logger.error("Error while testing connectivity to motion detection for " + this.listener.getVideoSrv(), (Throwable)e);
            return -20053;
        }
        return 0;
    }

    public void processMotionDetection(byte[] bytesToCheck) {
        try {
            for (int i = 0; i < bytesToCheck.length; ++i) {
                if (bytesToCheck[i] != 49 || this.listener == null) continue;
                this.listener.evaluateWindow(i);
            }
        }
        catch (Exception ee) {
            this.logger.error("Error extracting MD info for " + this.listener.getVideoSrv().getDevice(), (Throwable)ee);
        }
    }

    public void notifyForNetworkProblems() {
        this.logger.info("Network problem signaled for " + this.listener.getVideoSrv());
    }
}

