/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.basler;

import de.seetec.v5.re.cm.device.shared.io.DigitalInputSrv;
import de.seetec.v5.re.cm.device.shared.io.IOHandler;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.IOException;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.UnknownHostException;

public class BaslerIOHandler
extends IOHandler {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.basler.BaslerIOHandler";
    private boolean isBIP1Series = true;

    @Override
    public void run() {
        super.setRunFinished(CLASS_NAME, false);
        this.isBIP1Series = this.device.getDeviceType() == 201601L || this.device.getDeviceType() == 201602L || this.device.getDeviceType() == 201600L || this.device.getDeviceType() == 201603L || this.device.getDeviceType() == 201604L || this.device.getDeviceType() == 201605L || this.device.getDeviceType() == 201606L;
        try {
            boolean bPreviousLoopWithError = false;
            while (!(this.isShutdown(CLASS_NAME) || super.isShutdown() || this.device.isShutdown())) {
                try {
                    long duration;
                    long ts = System.currentTimeMillis();
                    this.readDigitalInputs();
                    if (bPreviousLoopWithError) {
                        DigitalInputSrv[] iServices;
                        bPreviousLoopWithError = false;
                        this.logger.info("Publishing input stati after error for " + this + " ...");
                        DigitalInputSrv[] digitalInputSrvArray = iServices = super.getDigitalInputSrv();
                        int n = digitalInputSrvArray.length;
                        for (int i = 0; i < n; ++i) {
                            DigitalInputSrv iService = digitalInputSrvArray[i];
                            if (!iService.getEntity().isEnabled().booleanValue()) continue;
                            iService.publishServiceStatus(iService.getInputStatus());
                        }
                    }
                    if ((duration = System.currentTimeMillis() - ts) < 0L || duration >= 190L) continue;
                    try {
                        Thread.sleep(200L - duration);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                catch (Throwable ex) {
                    bPreviousLoopWithError = true;
                    if (ex instanceof IOException || ex instanceof UnknownHostException || ex instanceof NoRouteToHostException || ex instanceof ConnectException) {
                        this.logger.warn("Network trouble for " + this);
                    } else {
                        this.logger.warn((Object)ex, ex);
                        if (ex.getMessage().indexOf("Address already in use") >= 0) {
                            this.logger.warn("TCP stack seems to be overloaded, so there are problems for " + this);
                        } else {
                            this.logger.warn("Unknown trouble for " + this);
                        }
                    }
                    try {
                        DigitalInputSrv[] iServices;
                        for (DigitalInputSrv iService : iServices = super.getDigitalInputSrv()) {
                            if (!iService.getEntity().isEnabled().booleanValue()) continue;
                            iService.publishServiceStatus(-21603);
                        }
                    }
                    catch (Throwable t) {
                        this.logger.warn((Object)t, t);
                    }
                    long tsTimeout = System.currentTimeMillis() + 10000L;
                    while (tsTimeout > System.currentTimeMillis() && !this.isShutdown(CLASS_NAME) && !this.device.isShutdown()) {
                        try {
                            Thread.sleep(250L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
        }
        this.logger.info("Thread of this " + this + " finished :-)");
        super.setRunFinished(CLASS_NAME, true);
        this.shutdown();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int readDigitalInputs() {
        DigitalInputSrv[] iServices = super.getDigitalInputSrv();
        String sDigitalInput = null;
        try {
            sDigitalInput = this.isBIP1Series ? new String(NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)"/cgi-bin/param_if.cgi?NumActions=1&Action_0=IOPins.InputPin0.GetValue", (int)65536)) : new String(NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)"/cgi-bin/param_if.cgi?NumActions=1&Action_0=IO.MonitorAll.GetValue", (int)65536));
        }
        catch (SeeTecException sex) {
            this.logger.error((Object)sex, (Throwable)sex);
            return sex.getErrorCode();
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
            return -21600;
        }
        String[] headerAndBody = sDigitalInput.split("\r\n\r\n");
        if (headerAndBody.length < 2) {
            this.logger.error("Error while parsing IO state for " + this);
            return -21600;
        }
        String[] part = headerAndBody[1].split("=");
        if (part.length < 2) {
            this.logger.error("Error while parsing IO state for " + this);
            return -21600;
        }
        part[1] = part[1].substring(0, part[1].length() - 1);
        if (this.isBIP1Series) {
            for (DigitalInputSrv iService : iServices) {
                iService.checkInput(Integer.parseInt(part[1].trim()));
            }
            return 0;
        } else {
            int[] nInputValues = new int[super.getHighestInputNumber()];
            for (int i = 1; i <= nInputValues.length; ++i) {
                int mask = (int)Math.pow(2.0, i);
                nInputValues[i - 1] = Integer.parseInt(part[1]) & mask;
            }
            for (DigitalInputSrv iService : iServices) {
                iService.checkInput(nInputValues);
            }
        }
        return 0;
    }

    @Override
    public int writeDigitalOutput(int nNumber, int value, long holdTime) {
        StringBuilder url = new StringBuilder();
        try {
            IOHandler.HoldTimer holdTimer;
            int errorCode;
            if (this.logger.isDebugEnabled()) {
                this.logger.info("Writing value [" + value + "] to output [" + nNumber + "] with HoldTime [" + holdTime + "] for " + this + " ...");
            }
            url.append("/cgi-bin/param_if.cgi?NumActions=2&Action_0=IOPins.OutputPin0Function.SetValue&Parameter_0_0=UserOutput&Action_1=IOPins.OutputPin0.SetValue&Parameter_1_0=" + value);
            NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url.toString());
            if (holdTime > 0L && (errorCode = (holdTimer = new IOHandler.HoldTimer()).init(nNumber, value > 0 ? 0 : 1, holdTime)) != 0) {
                holdTimer.shutdown();
                this.logger.warn("Creating " + holdTimer + " failed with error [" + errorCode + "] :-(");
            }
            return 0;
        }
        catch (SeeTecException sex) {
            this.logger.error((Object)sex, (Throwable)sex);
            return sex.getErrorCode();
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
            return -21600;
        }
    }
}

