/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.basler;

import de.seetec.v5.re.cm.configuration.definition.camera.VideoCameraDefinition;
import de.seetec.v5.re.cm.configuration.definition.device.DeviceDefinition;
import de.seetec.v5.re.cm.device.shared.VideoServer;
import de.seetec.v5.re.cm.device.shared.io.IOHandler;
import de.seetec.v5.re.cm.device.video.basler.BaslerIOHandler;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.SeeTecException;

public class BaslerDevice
extends VideoServer {
    private boolean isBIP1Series = true;

    private int setOperationMode(String mode) {
        String operationMode = "/cgi-bin/param_if.cgi?NumActions=1&Action_0=Global.OperationMode.SetValue&Parameter_0_0=";
        if (mode == null) {
            return -20002;
        }
        try {
            this.logger.info("Setting operation mode to '" + mode + "' for " + this);
            NetworkHelper.readGetRequest((NetworkParameter)this.getDeviceCnf().getNetworkParameter(), (String)(operationMode + mode), (int)Integer.MAX_VALUE);
        }
        catch (Exception e) {
            this.logger.error("Exception while setting camera to normal mode " + this, (Throwable)e);
            return -20000;
        }
        return 0;
    }

    public final synchronized int setParameter(String parameterURL) {
        if (parameterURL == null) {
            return -20002;
        }
        if (this.setOperationMode("Configure") != 0) {
            return -20000;
        }
        try {
            NetworkHelper.readGetRequest((NetworkParameter)this.getDeviceCnf().getNetworkParameter(), (String)parameterURL, (int)Integer.MAX_VALUE);
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
            return -20000;
        }
        if (this.setOperationMode("Normal") != 0) {
            return -20000;
        }
        return 0;
    }

    @Override
    public int initializeDevice(long nSrvType) {
        super.initializeDevice(nSrvType);
        if (nSrvType == 211601L || nSrvType == 211602L || nSrvType == 211600L || nSrvType == 211603L || nSrvType == 211604L || nSrvType == 211605L || nSrvType == 211606L) {
            this.setBIP1Series(true);
        } else {
            this.setBIP1Series(false);
            try {
                String fpsTag = "Fps_";
                byte[] result = NetworkHelper.readGetRequest((NetworkParameter)this.getDeviceCnf().getNetworkParameter(), (String)"/cgi-bin/param_if.cgi?NumActions=1&Action_0=Sensor.FrameRateMode.GetEntries", (int)Integer.MAX_VALUE);
                String resultAsString = new String(result);
                int index = resultAsString.indexOf(fpsTag);
                if (index != -1) {
                    if ((index = (resultAsString = resultAsString.substring(index)).indexOf("\"")) == -1) {
                        this.logger.error("Can't read max frame rate.");
                        return -20000;
                    }
                } else {
                    this.logger.error("Can't read max frame rate.");
                    return -20000;
                }
                resultAsString = resultAsString.substring(0, index);
                String request = "/cgi-bin/param_if.cgi?NumActions=1&Action_0=Sensor.FrameRateMode.SetValue&Parameter_0_0=" + resultAsString;
                NetworkHelper.readGetRequest((NetworkParameter)this.getDeviceCnf().getNetworkParameter(), (String)request, (int)Integer.MAX_VALUE);
            }
            catch (SeeTecException ex) {
                this.logger.error("Exception while evaluating/setting max global frame rate " + this + ": " + ex.getMessage(), (Throwable)ex);
                if (ex.getErrorCode() == -20001) {
                    return -21656;
                }
                return ex.getErrorCode();
            }
            catch (Exception e) {
                this.logger.error("Exception while evaluating/setting max global frame rate " + this, (Throwable)e);
                return -20000;
            }
        }
        return 0;
    }

    @Override
    protected IOHandler createIOHandler() {
        return new BaslerIOHandler();
    }

    @Override
    protected boolean isSupportingIO() {
        return true;
    }

    public boolean isBIP1Series() {
        return this.isBIP1Series;
    }

    public void setBIP1Series(boolean flag) {
        this.isBIP1Series = flag;
    }

    @Override
    protected DeviceDefinition getDeviceDefinitionFromDevice(String signature, String manufacturer, String name, String comments) throws SeeTecException {
        return null;
    }

    @Override
    protected VideoCameraDefinition getVideoCameraDefinitionFromDevice() throws SeeTecException {
        return null;
    }
}

