/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.basler;

import de.seetec.v5.re.cm.Core;
import de.seetec.v5.re.cm.device.shared.LiveCameraSrv;
import de.seetec.v5.re.cm.device.shared.cameracontrol.CameraControl;
import de.seetec.v5.re.cm.device.shared.cameracontrol.DoNothingCameraControl;
import de.seetec.v5.re.cm.device.shared.videoprofile.VideoProfileHandler;
import de.seetec.v5.re.cm.device.shared.videosource.VideoSourceClient;
import de.seetec.v5.re.cm.device.video.basler.jpeg.BaslerJPEGVideoSourceClient;
import de.seetec.v5.re.cm.device.video.basler.mpeg.BaslerMPEGVideoSourceClient;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.re.shared.ContentFrame;
import de.seetec.v5.re.shared.VideoSourceParameter;
import de.seetec.v5.shared.util.SeeTecException;
import java.util.Hashtable;

public class BaslerCameraSrv
extends LiveCameraSrv {
    private int streamID = 1;
    private Hashtable<String, Integer> dynToStream = new Hashtable();

    @Override
    public CameraControl createCameraControl(Long entityType) {
        return new DoNothingCameraControl();
    }

    @Override
    public VideoSourceClient createVideoSourceClient(Core core, VideoProfileHandler listener) throws SeeTecException {
        int errorCode = 0;
        VideoSourceClient videoSourceClient = null;
        try {
            long entityType = super.getEntityType();
            if (entityType == 211601L || entityType == 211602L || entityType == 211600L || entityType == 211603L || entityType == 211604L || entityType == 211605L || entityType == 211606L) {
                if (listener.getVideoSourceParameter().getMediaCodec() == Codec.MPEG4 || listener.getVideoSourceParameter().getMediaCodec() == Codec.H264) {
                    videoSourceClient = new BaslerMPEGVideoSourceClient();
                    ((BaslerMPEGVideoSourceClient)videoSourceClient).setStreamID(0L);
                } else {
                    videoSourceClient = new BaslerJPEGVideoSourceClient();
                    if (VideoSourceParameter.getAdditionalVideoProfiles((byte[])this.getEntity().getConfiguration()).length == 0) {
                        ((BaslerJPEGVideoSourceClient)videoSourceClient).setStreamID(0L);
                    } else {
                        if (this.dynToStream.get("" + listener.getDynamicVideoProfileID()) == null) {
                            this.dynToStream.put("" + listener.getDynamicVideoProfileID(), this.streamID);
                            ++this.streamID;
                        }
                        ((BaslerJPEGVideoSourceClient)videoSourceClient).setStreamID(this.dynToStream.get("" + listener.getDynamicVideoProfileID()).intValue());
                    }
                }
            } else if (listener.getVideoSourceParameter().getMediaCodec() == Codec.MPEG4 || listener.getVideoSourceParameter().getMediaCodec() == Codec.H264) {
                videoSourceClient = new BaslerMPEGVideoSourceClient();
                ((BaslerMPEGVideoSourceClient)videoSourceClient).setStreamID(listener.getDynamicVideoProfileID());
            } else {
                videoSourceClient = new BaslerJPEGVideoSourceClient();
                ((BaslerJPEGVideoSourceClient)videoSourceClient).setStreamID(listener.getDynamicVideoProfileID());
            }
            errorCode = videoSourceClient.init(core, this, listener);
            if (errorCode != 0) {
                videoSourceClient.shutdown();
                videoSourceClient = null;
                this.logger.error("Initializing [VideoSourceClient] for " + this + " failed with error [" + errorCode + "] :-(");
                throw new SeeTecException(errorCode, "Initializing [VideoSourceClient] for " + this + " failed with error [" + errorCode + "]");
            }
        }
        catch (SeeTecException seetecEx) {
            throw seetecEx;
        }
        catch (Throwable ex) {
            if (videoSourceClient != null) {
                videoSourceClient.shutdown();
                videoSourceClient = null;
            }
            this.logger.error((Object)ex, ex);
            this.logger.error("Creating [VideoSourceClient] for " + this + " failed :-(");
            throw new SeeTecException(-20001, "Creating [VideoSourceClient] for " + this + " failed");
        }
        return videoSourceClient;
    }

    @Override
    public ContentFrame getJpegSnapshot(Integer[] nResolution) throws SeeTecException {
        throw new SeeTecException(-20009, "NOT YET IMPLEMENTED :-(");
    }
}

