/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.axis.videosource;

import de.seetec.v5.re.cm.device.shared.videosource.PlaybackVideoSourceClient;
import de.seetec.v5.re.cm.device.video.axis.AxisDevice;
import de.seetec.v5.re.cm.shared.Tools;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Date;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public final class AxisPlaybackVideoSourceClient
extends PlaybackVideoSourceClient {
    private AxisDevice device;

    @Override
    public int init() {
        this.errorCode = super.init();
        if (this.errorCode != 0) {
            this.logger.error("Error while initializing. Code: " + this.errorCode + " for " + this);
            return this.errorCode;
        }
        this.device = (AxisDevice)this.getVideoSrv().getDevice();
        try {
            this.networkParameter = this.device.getAxisNetworkParameter();
        }
        catch (ConfigurationException ex) {
            this.logger.error("Failed to get AxisDeviceNetworkParameter for " + this, (Throwable)ex);
            return -20000;
        }
        try {
            this.setTimeDifference(this.device.getTimeDifferenceFromDevice());
        }
        catch (Throwable ex) {
            this.logger.error("Exception while calculating time difference : " + ex);
        }
        this.logger.info("Init: TimeDifference from Device is: " + this.getTimeDifference() + " miliseconds for " + this);
        this.setLocalStorageReady(true);
        return 0;
    }

    public static final String convertDateToAxisValue(long timeInMilliSeconds, long timeDifference) throws SeeTecException {
        if (timeInMilliSeconds < 0L) {
            throw new SeeTecException(-21600, "Error while converting date to HEX value because value is less than 0");
        }
        long time = timeInMilliSeconds;
        time += timeDifference;
        time -= Tools.getMilliSecondsSinceYear(2000);
        String hexValue = Long.toHexString(time /= 1000L);
        if (hexValue.length() > 8) {
            hexValue = hexValue.substring(hexValue.length() - 8);
        } else if (hexValue.length() < 8) {
            while (hexValue.length() < 8) {
                hexValue = "0" + hexValue;
            }
        }
        return hexValue;
    }

    @Override
    protected Long getTimeDifferenceFromDevice() throws Exception {
        return this.device.getTimeDifferenceFromDevice();
    }

    @Override
    protected final double getMaxPlaybackSpeed() {
        return 10.0;
    }

    @Override
    protected final String getRtspUrl(long startTimestamp, long stopTimestamp, String nameOfRecording) throws ConfigurationException {
        double edgeStorageSpeed = this.getEdgeStorageParameter().getPlaybackSpeed();
        this.logger.info("Edge Storage Speed: " + edgeStorageSpeed + " for " + this);
        StringBuilder tempRtspUrl = new StringBuilder();
        tempRtspUrl.append("rtsp://");
        tempRtspUrl.append(this.getHost());
        tempRtspUrl.append("/axis-media/media.amp?recordingid=");
        tempRtspUrl.append(nameOfRecording);
        tempRtspUrl.append("&pull=");
        tempRtspUrl.append(edgeStorageSpeed > 1.0 ? "1" : "0");
        this.logger.info("Playback Rtsp URL: " + tempRtspUrl + " for " + this);
        return tempRtspUrl.toString();
    }

    public static String convertTimeStampToAxisDate(long timestamp) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date(timestamp));
        StringBuilder res = new StringBuilder();
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        int day = calendar.get(5);
        int hour = calendar.get(11);
        int minutes = calendar.get(12);
        int seconds = calendar.get(13);
        int milliseconds = calendar.get(14);
        res.append(year);
        res.append(month < 10 ? "0" + month : Integer.valueOf(month));
        res.append(day < 10 ? "0" + day : Integer.valueOf(day));
        res.append("T");
        res.append(hour < 10 ? "0" + hour : Integer.valueOf(hour));
        res.append(minutes < 10 ? "0" + minutes : Integer.valueOf(minutes));
        res.append(seconds < 10 ? "0" + seconds : Integer.valueOf(seconds));
        res.append(".");
        res.append(milliseconds);
        res.append("Z");
        return res.toString();
    }

    public static long convertAxisDateToTimestamp(String dateTime) {
        String[] date = dateTime.split(" ");
        if (date.length == 4) {
            Calendar calendar = Calendar.getInstance();
            String month = date[0].toLowerCase();
            if (month.equals("jan")) {
                calendar.set(2, 0);
            } else if (month.equals("feb")) {
                calendar.set(2, 1);
            } else if (month.equals("mar")) {
                calendar.set(2, 2);
            } else if (month.equals("apr")) {
                calendar.set(2, 3);
            } else if (month.equals("may")) {
                calendar.set(2, 4);
            } else if (month.equals("jun")) {
                calendar.set(2, 5);
            } else if (month.equals("jul")) {
                calendar.set(2, 6);
            } else if (month.equals("aug")) {
                calendar.set(2, 7);
            } else if (month.equals("sep")) {
                calendar.set(2, 8);
            } else if (month.equals("oct")) {
                calendar.set(2, 9);
            } else if (month.equals("nov")) {
                calendar.set(2, 10);
            } else if (month.equals("dec")) {
                calendar.set(2, 11);
            }
            String dayOfMonth = date[1].replace(",", "");
            int dayOfMonthAsInt = Integer.parseInt(dayOfMonth);
            calendar.set(5, dayOfMonthAsInt);
            int year = Integer.parseInt(date[2]);
            calendar.set(1, year);
            String[] time = date[3].split(":");
            if (time.length == 3) {
                int hour = Integer.parseInt(time[0]);
                int minutes = Integer.parseInt(time[1]);
                int seconds = Integer.parseInt(time[2]);
                calendar.set(11, hour);
                calendar.set(12, minutes);
                calendar.set(13, seconds);
                calendar.set(14, 0);
                return calendar.getTimeInMillis();
            }
        }
        return 0L;
    }

    public static long convertAxisRecordingDateToTimestamp(String startTimeLocal) {
        String[] date;
        Calendar calendar = Calendar.getInstance();
        String[] dateTime = startTimeLocal.split("T");
        if (dateTime.length == 2 && (date = dateTime[0].split("-")).length == 3) {
            String[] time;
            int year = Integer.parseInt(date[0]);
            int month = Integer.parseInt(date[1]);
            int day = Integer.parseInt(date[2]);
            calendar.set(1, year);
            calendar.set(2, month - 1);
            calendar.set(5, day);
            int index = dateTime[1].indexOf(43);
            if (index == -1) {
                index = dateTime[1].indexOf(45);
            }
            String dateString = dateTime[1].trim();
            if (index != -1) {
                dateString = dateTime[1].substring(0, index).trim();
            }
            if ((time = dateString.split(":")).length == 3) {
                int hour = Integer.parseInt(time[0]);
                int minute = Integer.parseInt(time[1]);
                calendar.set(11, hour);
                calendar.set(12, minute);
                String[] seconds = time[2].split("\\.");
                if (seconds.length == 2) {
                    int second = Integer.parseInt(seconds[0]);
                    int milliseconds = Integer.parseInt(seconds[1].replace("Z", "")) / 1000;
                    calendar.set(13, second);
                    calendar.set(14, milliseconds);
                    return calendar.getTimeInMillis();
                }
            }
        }
        return 0L;
    }

    @Override
    protected String getTimeRange(long startTimestamp, long endTimestamp, String timeRangeName) {
        try {
            Element recordings;
            Element recording;
            String url = "/axis-cgi/record/list.cgi?recordingid=" + timeRangeName;
            String xmlString = this.device.getHttpHandler().readGetRequest(url);
            ByteArrayInputStream bais = new ByteArrayInputStream(xmlString.getBytes());
            Document xmlDoc = new SAXBuilder().build((InputStream)bais);
            Element root = xmlDoc.getRootElement();
            if (root != null && (recording = (recordings = root.getChild("recordings")).getChild("recording")) != null) {
                long localTimeDifference;
                float diff;
                String startTime = recording.getAttributeValue("starttimelocal");
                long start = AxisPlaybackVideoSourceClient.convertAxisRecordingDateToTimestamp(startTime);
                if (this.getTimeDifference() == null) {
                    this.setTimeDifference(this.getTimeDifferenceFromDevice());
                }
                if ((diff = (float)((localTimeDifference = startTimestamp - start + this.getTimeDifference()) / 1000L + 1L)) < 0.0f) {
                    diff = 0.0f;
                }
                return "npt=" + diff + "-";
            }
        }
        catch (Throwable ex) {
            this.logger.error("Error while getting time range (from: " + startTimestamp + " | end: " + endTimestamp + " | name: " + timeRangeName + ") for " + this, ex);
            return null;
        }
        return "";
    }

    public boolean isVideoSourceCorrect(String source, int videoSourceNr) {
        boolean isVideoSourceCorrect = false;
        try {
            if (source.equalsIgnoreCase("quad") && videoSourceNr == 5) {
                isVideoSourceCorrect = true;
            } else if (videoSourceNr == Integer.parseInt(source)) {
                isVideoSourceCorrect = true;
            }
        }
        catch (NumberFormatException e) {
            this.logger.error("Video source:" + source + " could not be mapped to the Camera, Recording not added.");
        }
        return isVideoSourceCorrect;
    }

    @Override
    protected String getRequireField() {
        return "";
    }
}

