/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.axis.videosource;

import de.seetec.v5.re.cm.device.shared.net.httpserverpush.HttpServerPushContent;
import de.seetec.v5.re.cm.device.shared.videosource.JPEGVideoSourceClient;
import de.seetec.v5.re.cm.device.video.axis.AxisCameraSrv;
import de.seetec.v5.re.cm.device.video.axis.AxisDevice;
import de.seetec.v5.re.cm.device.video.axis.utils.AxisSEIUserDataReader;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.HttpVersion;
import de.seetec.v5.shared.net.HttpHandler;
import de.seetec.v5.shared.net.HttpHandlerImpl;
import de.seetec.v5.shared.net.HttpHandlerIntf;

public class AxisJPEGVideoSourceClient
extends JPEGVideoSourceClient
implements HttpHandlerIntf {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.axis.jpeg.AxisJPEGVideoSourceClient";
    HttpHandler httpHandlerImpl = null;

    @Override
    public int init() {
        try {
            int errorCode = super.init(false);
            if (errorCode != 0) {
                this.logger.error("Error while initializing [" + errorCode + "] for " + this);
                return errorCode;
            }
            this.networkParameter = this.getVideoSrv().getDevice().getDeviceCnf().getNetworkParameter();
            if (this.getVideoSrv().getDevice().getDeviceType() == 200054L) {
                try {
                    Thread.sleep(1100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            try {
                errorCode = ((AxisCameraSrv)this.getVideoSrv()).setViewAreas(this.listener);
                if (errorCode != 0) {
                    return errorCode;
                }
            }
            catch (Exception e) {
                this.logger.error("Exception while setting view area for " + this.getVideoSrv(), (Throwable)e);
                return -20000;
            }
            try {
                ((AxisDevice)this.getVideoSrv().getDevice()).getHttpHandler().readGetRequest("/axis-cgi/param.cgi?action=list&group=Properties.Image.Resolution");
            }
            catch (Exception e) {
                this.logger.debug("Error issueing test request for " + this);
            }
            try {
                AxisCameraSrv axisCameraSrv = (AxisCameraSrv)this.getVideoSrv();
                axisCameraSrv.setChannelParameters(this.useTitle, this.title, this.useDateTime, this.rotationAngle);
            }
            catch (Exception ex) {
                this.logger.info("Could net set title and date/time over API. Will set them over RTSP command for " + this);
            }
            this.myThread = new Thread((Runnable)this, this.toString());
            this.myThread.start();
            return errorCode;
        }
        catch (Throwable t) {
            this.logger.error("Unexpected exception while initialization for " + this, t);
            return -20000;
        }
    }

    @Override
    public void run() {
        super.setRunFinished(CLASS_NAME, false);
        try {
            AxisCameraSrv axisCameraSrv = (AxisCameraSrv)this.getVideoSrv();
            AxisDevice axisDevice = (AxisDevice)axisCameraSrv.getDevice();
            StringBuilder sb = new StringBuilder(256);
            long fps = (this.highestFramerate + 999L) / 1000L;
            this.compression = (this.compression + 999) / 1000;
            String keyFps = null;
            String seetecId = Long.toHexString(System.currentTimeMillis() & 0xFFFFFFFFL);
            if (this.api.startsWith("0")) {
                sb.append("/fullsize.jpg?sid=");
                sb.append(seetecId);
                super.readSingleImages(sb.toString());
                return;
            }
            if (this.api.startsWith("1")) {
                keyFps = "req_fps";
            } else if (this.api.startsWith("2") || this.api.contains("Version 3")) {
                keyFps = "fps";
            } else {
                throw new RuntimeException("API [" + this.api + "] not supported for " + this);
            }
            sb.append("/axis-cgi/mjpg/video.cgi?sid=");
            sb.append(seetecId);
            sb.append("&camera=");
            if (((AxisDevice)this.getVideoSrv().getDevice()).getAxisDeviceParameters().isDewarpEnabled()) {
                sb.append(this.videoSourceNr);
            } else if (this.videoSourceNr == 5 && !AxisDevice.isFisheyeCamera(this.getVideoSrv().getDevice().getDeviceType())) {
                if (this.getVideoSrv().getDevice().getDeviceCnf().isVirtualCameraUsed()) {
                    sb.append(this.videoSourceNr);
                } else {
                    sb.append(axisDevice.getVideoSourceSpecifier(axisDevice.getAxisDeviceParameters(), this.videoSourceNr));
                }
            } else {
                sb.append(this.videoSourceNr);
            }
            if (this.videoCodec != Codec.RTSP) {
                if (AxisDevice.isFisheyeCamera(axisDevice.getDeviceType())) {
                    this.resolutionTag = axisCameraSrv.getNearestResolution(this.videoSourceNr, this.width, this.height);
                }
                sb.append("&resolution=");
                if (this.resolutionTag != null && this.resolutionTag.trim().length() > 0) {
                    sb.append(this.resolutionTag.trim());
                } else {
                    sb.append(this.width);
                    sb.append("x");
                    sb.append(this.height);
                }
                sb.append("&");
                sb.append(keyFps);
                sb.append("=");
                sb.append(fps);
                sb.append("&compression=");
                sb.append(this.compression);
                if (!axisDevice.getAxisDeviceParameters().canSourceImageRotation(this.videoSourceNr - 1)) {
                    sb.append("&rotation=");
                    sb.append(this.rotationAngle);
                }
                sb.append("&text=");
                sb.append(this.useTitle ? "1" : "0");
                sb.append("&date=");
                sb.append(this.useDateTime ? "1" : "0");
                sb.append("&clock=");
                sb.append(this.useDateTime ? "1" : "0");
                if (this.title != null && this.title.length() > 0) {
                    sb.append("&textstring=");
                    sb.append(this.title);
                }
            }
            int errorCode = 0;
            errorCode = axisDevice.setRTSPPort(this.listener.getVideoSourceParameter().getRtspPort());
            if (errorCode != 0) {
                this.logger.error("Exception while setting RTSP Port: " + errorCode);
            }
            if (axisDevice.getDeviceType() == 202334L) {
                this.networkParameter.setHttpVersion(HttpVersion.HTTP_1_0);
            }
            this.httpHandlerImpl = new HttpHandlerImpl(this.networkParameter);
            this.httpHandlerImpl.readServerPushRequest(sb.toString(), (HttpHandlerIntf)this, HttpVersion.HTTP_1_0);
        }
        catch (Throwable t) {
            this.logger.error("Trouble with JPEGServerPushStream of " + super.getVideoSrv(), t);
        }
        if (this.httpHandlerImpl != null) {
            this.httpHandlerImpl.shutdown();
        }
        super.setRunFinished(CLASS_NAME, true);
        this.shutdown();
    }

    @Override
    public synchronized int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        if (this.httpHandlerImpl != null) {
            this.httpHandlerImpl.shutdown();
            this.httpHandlerImpl = null;
        }
        return super.shutdown();
    }

    @Override
    protected boolean isRunFinished() {
        return super.isRunFinished(CLASS_NAME);
    }

    public void sendStatusService(int statusCode) {
        this.listener.sendStatusService(statusCode);
    }

    @Override
    public void deliverContent(HttpServerPushContent httpServerPushContent) {
        byte[] contentData = httpServerPushContent.getContentBody();
        try {
            byte[] pattern = new byte[]{-1, -2};
            byte[] eofPattern = new byte[]{-1, -39};
            int indexAfterContentMarker = 0;
            int endOfFile = Basic.indexOfByteArray((byte[])contentData, (byte[])eofPattern, (int)0);
            while ((indexAfterContentMarker = Basic.indexOfByteArray((byte[])contentData, (byte[])pattern, (int)indexAfterContentMarker)) != -1 && indexAfterContentMarker < endOfFile) {
                int lengthOfUserData = Basic.byteArrayToInt4((byte[])new byte[]{contentData[indexAfterContentMarker], contentData[indexAfterContentMarker + 1]});
                if (contentData[indexAfterContentMarker + 2] == 10 && contentData[indexAfterContentMarker + 3] == 3) {
                    byte[] triggerData = new byte[lengthOfUserData - 4];
                    System.arraycopy(contentData, indexAfterContentMarker + 4, triggerData, 0, lengthOfUserData - 4);
                    AxisCameraSrv axisCameraSrv = (AxisCameraSrv)this.getVideoSrv();
                    String triggerDataAsString = new String(triggerData);
                    AxisSEIUserDataReader seiUserData = new AxisSEIUserDataReader(axisCameraSrv, triggerDataAsString);
                    axisCameraSrv.evaluateSeiUserData(this.listener, seiUserData);
                }
                indexAfterContentMarker += lengthOfUserData + 2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.deliverContent(httpServerPushContent);
    }
}

