/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.axis.videosource;

import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPStreamSettings;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingVideoSourceClientRTSP;
import de.seetec.v5.re.cm.device.video.axis.AxisCameraSrv;
import de.seetec.v5.re.cm.device.video.axis.AxisDevice;
import de.seetec.v5.re.cm.device.video.axis.utils.AxisAPIVersion;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.shared.util.SeeTecException;
import org.apache.logging.log4j.LogManager;

public class AxisAudioSourceClient
extends StreamingVideoSourceClientRTSP {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.axis.mpeg.AxisAudioSourceClient";

    @Override
    public int init() {
        try {
            this.errorCode = super.init();
            if (this.errorCode != 0) {
                this.logger.error("Error [" + this.errorCode + "] while initializing for " + this);
                return this.errorCode;
            }
            AxisDevice axisDevice = (AxisDevice)this.getVideoSrv().getDevice();
            try {
                axisDevice.getHttpHandler().readGetRequest("/axis-cgi/param.cgi?action=list&group=Properties.Image.Resolution");
            }
            catch (Exception e) {
                this.logger.debug("Error issueing test request for " + this);
            }
            StringBuilder url = AxisAudioSourceClient.generateAudioParameterURL(this.isAudioEnabled, this.audioCodec, this.audioBitrate, this.videoSourceNr, (AxisDevice)this.getVideoSrv().getDevice());
            try {
                axisDevice.getHttpHandler().readGetRequest(url.toString());
            }
            catch (SeeTecException ex) {
                this.logger.error("Exception [" + ex.getErrorCode() + "|" + ex.getMessage() + "] while setting Audio association for " + this.getVideoSrv(), (Throwable)ex);
                return ex.getErrorCode();
            }
            this.rtspUrl = "rtsp://" + this.getHost() + "/axis-media/media.amp";
            this.rtspSettings = new RTSPStreamSettings();
            this.rtspSettings.setIsVideoEnabled(false);
            this.rtspSettings.disableBasicAuthentication();
            boolean useNewHttp = ((AxisDevice)this.videoSrv.getDevice()).useNewHttp;
            this.errorCode = this.rtspSettings.init(this, this.audioSourceClient, this.networkParameter, this.listener.getVideoSourceParameter().getRtspPort(), this.rtspUrl, this.printDebug, this.transmissionID, this.networkParameter.getSoTimeout(), this.isAudioEnabled, 4, "*", useNewHttp);
            if (this.errorCode != 0) {
                this.logger.error("Initialization of RTSPSettings failed with errorCode: " + this.errorCode + " for " + this.getVideoSrv());
                return this.errorCode;
            }
            if (this.errorCode != 0) {
                this.logger.error("Initialization of RTSPSettings failed [" + this.errorCode + "] for " + this.getVideoSrv());
                return this.errorCode;
            }
            this.rtspHandler = this.rtspSettings.getRTSPHandler();
            this.errorCode = this.rtspHandler.start();
            if (this.errorCode != 0) {
                this.logger.error("Starting RTSP Handler failed [" + this.errorCode + "] for " + this.getVideoSrv());
                return this.errorCode;
            }
            return 0;
        }
        catch (Throwable t) {
            this.logger.error("Unexpected exception [" + t.getMessage() + "] while initialization for " + this.getVideoSrv(), t);
            return -20000;
        }
    }

    public static StringBuilder generateAudioParameterURL(boolean audioEnabled, Codec audioCodec, int audioBitrate, int videoSourceNr, AxisDevice device) throws IllegalArgumentException {
        if (audioCodec == null || device == null) {
            throw new IllegalArgumentException();
        }
        StringBuilder url = device.getAxisAPIVersion() == AxisAPIVersion.VERSION_2 ? new StringBuilder("/axis-cgi/admin/param.cgi?action=update") : new StringBuilder("/axis-cgi/param.cgi?action=update");
        if (audioEnabled) {
            LogManager.getLogger((String)"de.seetec.v5.shared.SSLConstantsIntf").info("Audio Parameter: " + audioCodec + " with " + audioBitrate + "bit for " + device);
            String availableDuplexModes = null;
            try {
                availableDuplexModes = device.getAxisDeviceParameters().getDeviceParameterValue("root.Properties.Audio.DuplexMode");
            }
            catch (SeeTecException seeTecException) {
                LogManager.getLogger((String)"de.seetec.v5.shared.SSLConstantsIntf").warn("Could not read available duplex modes for " + device);
            }
            if (availableDuplexModes != null) {
                String duplexMode = "get";
                if (availableDuplexModes.contains("full")) {
                    duplexMode = "full";
                } else if (availableDuplexModes.contains("duplex")) {
                    duplexMode = "duplex";
                } else if (availableDuplexModes.contains("half")) {
                    duplexMode = "half";
                } else if (availableDuplexModes.contains("get")) {
                    duplexMode = "get";
                }
                url.append("&root.Audio.DuplexMode=");
                url.append(duplexMode);
            }
            String audioCodecName = "";
            switch (audioCodec) {
                case G711U: {
                    audioCodecName = "g711";
                    break;
                }
                case G726: {
                    audioCodecName = "g726";
                    break;
                }
                case AAC: {
                    audioCodecName = "aac";
                    break;
                }
            }
            url.append("&root.AudioSource.A0.AudioEncoding=");
            url.append(audioCodecName);
            url.append("&root.AudioSource.A0.BitRate=");
            url.append(audioBitrate);
            url.append("&root.Audio.A");
            url.append(videoSourceNr - 1);
            url.append(".Enabled=yes");
        }
        return url;
    }

    public static StringBuilder generateAudioSourceParameterURL(boolean audioEnabled, int videoSourceNr, AxisDevice axisDevice) {
        if (axisDevice == null) {
            throw new IllegalArgumentException();
        }
        StringBuilder url = new StringBuilder("");
        if (audioEnabled) {
            if (axisDevice.getAxisAPIVersion() == AxisAPIVersion.VERSION_2) {
                url.append("/axis-cgi/admin/param.cgi?action=update");
            } else {
                url.append("/axis-cgi/param.cgi?action=update");
            }
            url.append("&root.AudioSource.A0");
            url.append(".AudioSupport=yes");
        }
        return url;
    }

    @Override
    public int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        return super.shutdown();
    }

    @Override
    public void onNetworkError(int error) {
        try {
            if (this.isShutdown()) {
                return;
            }
            this.logger.warn("Shutting down : " + error);
            this.listener.sendStatusService(error);
            this.shutdown();
        }
        catch (Throwable t) {
            this.logger.error("Exception [" + t.getMessage() + "] in onNetworkError for " + this, t);
        }
    }

    @Override
    public final boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    public void notifyForNetworkProblems() {
        this.logger.error("Network problem from HTTPStreamHandler signalied. Shutting down.");
        this.shutdown();
    }

    @Override
    public void sendStatusService(int nStatusCode) {
        if (this.listener != null) {
            this.listener.sendStatusService(nStatusCode);
        } else {
            this.logger.error("Listener null for " + this);
        }
    }

    @Override
    public void processData(byte[] data) {
        ((AxisCameraSrv)this.getVideoSrv()).checkForSeiUserData(this.listener, data, false);
        this.processRtpData(data);
    }
}

