/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.axis.utils;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Query {
    private String target;
    private final List<Parameter> params;

    public Query() {
        this.params = new ArrayList<Parameter>();
    }

    public Query(String target) {
        this.target = target;
        this.params = new ArrayList<Parameter>();
    }

    protected void addParam(Parameter p) {
        this.params.add(p);
    }

    protected void setTarget(String target) {
        this.target = target;
    }

    protected void clear() {
        this.params.clear();
    }

    public String toString() {
        if (this.target == null) {
            throw new IllegalArgumentException("Target not set");
        }
        StringBuilder sb = new StringBuilder(this.target);
        sb.append("?");
        Iterator<Parameter> iter = this.params.iterator();
        while (iter.hasNext()) {
            Parameter param = iter.next();
            sb.append(param.toString());
            if (!iter.hasNext()) continue;
            sb.append("&");
        }
        return sb.toString();
    }

    protected static class Parameter {
        private final String name;
        private final String value;

        public Parameter(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return this.name + "=" + this.value;
        }
    }

    public static class Builder {
        private String target;
        private List<Parameter> params;

        public Builder setTarget(String target) {
            this.target = target;
            return this;
        }

        public Builder addParam(String name, String value) {
            if (this.params == null) {
                this.params = new ArrayList<Parameter>();
            }
            this.params.add(new Parameter(name, value));
            return this;
        }

        public Query build() {
            Query query = new Query(this.target);
            query.params.addAll(this.params);
            return query;
        }
    }
}

