/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.axis.utils;

import de.seetec.v5.re.cm.device.shared.videostatus.AnalogVideoStatus;
import de.seetec.v5.re.cm.device.shared.videostatus.AnalogVideoStatusReader;
import de.seetec.v5.re.cm.device.video.axis.AxisCameraSrv;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AxisSEIUserDataReader
implements AnalogVideoStatusReader {
    private static final Logger LOGGER = LogManager.getLogger(AxisSEIUserDataReader.class);
    private final AxisCameraSrv cameraSrv;
    private final String userData;

    public AxisSEIUserDataReader(AxisCameraSrv cameraSrv, String userData) {
        this.cameraSrv = cameraSrv;
        this.userData = userData;
    }

    @Override
    public AnalogVideoStatus getVideoSignalState(int videoSourceNumber) {
        AnalogVideoStatus videoSignalResult = AnalogVideoStatus.UNKNOWN;
        if (this.userData != null) {
            if (this.eventTriggerNotSet("V" + (videoSourceNumber - 1))) {
                videoSignalResult = AnalogVideoStatus.VIDEOLOSS;
            } else if (this.eventTriggerSet("V" + (videoSourceNumber - 1))) {
                videoSignalResult = AnalogVideoStatus.VIDEOGAIN;
            }
        }
        LOGGER.debug("VideoSourceNr[" + videoSourceNumber + "] Video[" + (Object)((Object)videoSignalResult) + "] for " + this.cameraSrv);
        return videoSignalResult;
    }

    @Override
    public AnalogVideoStatus getTamperingState(int videoSourceNumber) {
        AnalogVideoStatus tamperingResult = AnalogVideoStatus.UNKNOWN;
        if (this.userData != null) {
            if (this.eventTriggerSet("T" + (videoSourceNumber - 1))) {
                tamperingResult = AnalogVideoStatus.TAMPERING;
            } else if (this.eventTriggerNotSet("T" + (videoSourceNumber - 1))) {
                tamperingResult = AnalogVideoStatus.NOTAMPERING;
            }
        }
        LOGGER.debug("VideoSourceNr[" + videoSourceNumber + "] Tampering[" + (Object)((Object)tamperingResult) + "] for " + this.cameraSrv);
        return tamperingResult;
    }

    public boolean eventTriggerSet(String eventIdentifier) {
        boolean result = false;
        if (this.userData != null && eventIdentifier != null && this.userData.contains(eventIdentifier + ":1")) {
            result = true;
        }
        return result;
    }

    public boolean eventTriggerNotSet(String eventIdentifier) {
        boolean result = false;
        if (this.userData != null && eventIdentifier != null && this.userData.contains(eventIdentifier + ":0")) {
            result = true;
        }
        return result;
    }

    public String toString() {
        String seiUserData = "SEIUserdata [" + this.userData + "]";
        return seiUserData;
    }
}

