/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.axis;

import de.seetec.v5.re.cm.device.shared.LiveCameraSrv;
import de.seetec.v5.re.cm.device.shared.motiondetection.HardwareMotionDetection;
import de.seetec.v5.re.cm.device.shared.motiondetection.MotionDetectionHandler;
import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPHandlerIntf;
import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPHandlerSuper;
import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPResponse;
import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPStreamSettings;
import de.seetec.v5.re.cm.device.shared.net.rtsp.mikey.Mikey;
import de.seetec.v5.re.cm.device.video.axis.AxisDevice;
import de.seetec.v5.re.cm.device.video.axis.AxisMotionDetectionHandler;
import de.seetec.v5.re.shared.TransmissionType;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.OPCLowerNodeIDType;
import de.seetec.v5.shared.util.ConfigurationException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;

public class AxisRTSPMotionDetectionHandler
extends AxisMotionDetectionHandler
implements RTSPHandlerIntf {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.axis.AxisRTSPMotionDetectionHandler";
    private RTSPHandlerSuper rtspHandler = null;
    private long lastTamperingEventSent = Long.MIN_VALUE;
    private long videoLossSince = Long.MIN_VALUE;
    private boolean videoLossAlarmTriggered = false;
    private long lastVideoLossEventSent;

    public AxisRTSPMotionDetectionHandler() {
        this.logger = LogManager.getLogger((String)CLASS_NAME);
    }

    @Override
    public int init(HardwareMotionDetection<? extends MotionDetectionHandler> hardwareMotionDetection) {
        int errorCode;
        this.listener = hardwareMotionDetection;
        if (this.listener == null) {
            errorCode = -20003;
        } else {
            errorCode = this.initialMDCheckAndGroupInitialization();
            if (errorCode != 0) {
                return errorCode;
            }
            try {
                try {
                    String rtspUrl = "rtsp://" + this.networkParameter.getHost() + "/axis-media/media.amp?video=0&event=on";
                    RTSPStreamSettings rtspStreamSettings = new RTSPStreamSettings();
                    this.networkParameter.setSoTimeout(10000);
                    rtspStreamSettings.init(this, this.networkParameter, 554, rtspUrl, false, TransmissionType.RTP_OVER_UDP_UNICAST, this.networkParameter.getSoTimeout());
                    rtspStreamSettings.setIsVideoEnabled(false);
                    rtspStreamSettings.enableMetadata(this);
                    rtspStreamSettings.setMetadataTimeout(0);
                    boolean keepAliveResponse = ((AxisDevice)this.listener.getVideoSrv().getDevice()).keepAliveResponse;
                    rtspStreamSettings.setKeepAliveForTimeouts(keepAliveResponse);
                    this.rtspHandler = rtspStreamSettings.getRTSPHandler();
                    errorCode = this.rtspHandler.start();
                    if (errorCode != 0) {
                        this.logger.error("Starting RTSP Handler failed with errorCode: " + errorCode + " for " + this);
                        return errorCode;
                    }
                }
                catch (Exception e) {
                    this.logger.error("Reading configuration from failed " + this.listener.getVideoSrv().getDevice(), (Throwable)e);
                    errorCode = -21601;
                }
            }
            catch (Throwable ex) {
                this.logger.error((Object)ex, ex);
                errorCode = -21651;
            }
        }
        return errorCode;
    }

    @Override
    public int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        if (this.rtspHandler != null) {
            this.rtspHandler.shutdown();
            this.rtspHandler = null;
        }
        super.shutdown();
        return 0;
    }

    @Override
    public void sendStatusService(int statusCode) {
        if (this.isShutdown(CLASS_NAME)) {
            return;
        }
        if (statusCode != 0) {
            this.logger.error(Basic.generateIndentedMultiLineLog((String[])new String[]{"Problems with motion detection of camera [" + this.listener.getVideoSrv().getContentName() + "]"}));
            this.listener.notifyForNetworkProblems();
        }
    }

    @Override
    public void processData(byte[] data) {
        byte[] content = Arrays.copyOfRange(data, 12, data.length);
        ByteArrayInputStream bais = new ByteArrayInputStream(content);
        String contentString = null;
        try {
            Namespace onvifNamespace;
            Document document;
            Element root;
            Element event;
            contentString = new String(content);
            if (this.logger.isDebugEnabled()) {
                this.logger.info("Metadata content String: " + contentString);
            }
            if (contentString.startsWith("<") && (event = (root = (document = new SAXBuilder().build((InputStream)bais)).getRootElement()).getChild("Event", onvifNamespace = root.getNamespace())) != null) {
                onvifNamespace = event.getNamespace();
                List eventChildren = event.getChildren();
                for (Object eventChild : eventChildren) {
                    Attribute sourceValue;
                    Attribute sourceName;
                    String nameTxt;
                    Element simpleItem;
                    Element sources;
                    Element simpleItem2;
                    Element message2;
                    Namespace oasisNamespace;
                    Element message;
                    Element notificationMessage;
                    if (!(eventChild instanceof Element) || !(notificationMessage = (Element)eventChild).getName().equals("NotificationMessage") || (message = notificationMessage.getChild("Message", oasisNamespace = notificationMessage.getNamespace())) == null || (message2 = message.getChild("Message", onvifNamespace)) == null) continue;
                    String eventName = "";
                    boolean eventTriggered = false;
                    onvifNamespace = message2.getNamespace();
                    Element dataElement = message2.getChild("Data", onvifNamespace);
                    if (dataElement != null && (simpleItem2 = dataElement.getChild("SimpleItem", onvifNamespace = dataElement.getNamespace())) != null) {
                        onvifNamespace = simpleItem2.getNamespace();
                        Attribute name = simpleItem2.getAttribute("Name");
                        eventName = name.getValue();
                        Attribute value = simpleItem2.getAttribute("Value");
                        eventTriggered = value.getValue().equals("1");
                    }
                    if (eventTriggered && eventName.toLowerCase().equals("motion")) {
                        sources = message2.getChild("Source", onvifNamespace);
                        if (sources == null || (simpleItem = sources.getChild("SimpleItem", onvifNamespace)) == null || !(nameTxt = (sourceName = simpleItem.getAttribute("Name")).getValue()).toLowerCase().equals("window")) continue;
                        sourceValue = simpleItem.getAttribute("Value");
                        String windowNr = sourceValue.getValue();
                        int windowNumber = Integer.parseInt(windowNr);
                        if (this.listener == null) continue;
                        this.listener.evaluateWindow(windowNumber);
                        continue;
                    }
                    if (eventName.toLowerCase().equals("tampering") && eventTriggered) {
                        this.sendTamperingAlarm();
                        continue;
                    }
                    if (!eventName.toLowerCase().equals("connected") || (sources = message2.getChild("Source", onvifNamespace)) == null || (simpleItem = sources.getChild("SimpleItem", onvifNamespace)) == null || !(nameTxt = (sourceName = simpleItem.getAttribute("Name")).getValue()).toLowerCase().equals("channel")) continue;
                    sourceValue = simpleItem.getAttribute("Value");
                    String channelNr = sourceValue.getValue();
                    int channelNumber = Integer.parseInt(channelNr);
                    if (this.listener == null || channelNumber != this.listener.getVideoSrv().getVideoSourceCnf().getServerEntryNo()) continue;
                    this.sendVideoLossEvent(eventTriggered);
                    if (eventTriggered) continue;
                    this.logger.debug(">>>>>>>>>>>>>>>>>>>>>>>>>>Video Loss detected on channel number " + channelNumber);
                }
            }
        }
        catch (ConfigurationException | NumberFormatException | JDOMException e) {
            this.logger.warn("Execption [" + e.getMessage() + "] while processing alarm data for " + this, e);
            this.logger.warn("Metadata Content-String: " + (contentString == null ? "null" : contentString));
        }
    }

    @Override
    public void onNetworkError(int errorCode) {
        this.sendStatusService(-21659);
    }

    @Override
    public void sendDescribeResponse(RTSPResponse response) {
    }

    private void sendTamperingAlarm() {
        try {
            if (this.listener.getVideoSrv().getVideoSourceCnf().isEnableTampering() && System.currentTimeMillis() > this.lastTamperingEventSent + 10000L) {
                this.lastTamperingEventSent = System.currentTimeMillis();
                ((LiveCameraSrv)this.listener.getVideoSrv()).evaluateTampering();
                this.listener.getVideoSrv().getCore().sendTamperingEvent(this.listener.getVideoSrv());
            }
        }
        catch (ConfigurationException ce) {
            this.logger.error("Error evaluating tampering flag for " + this, (Throwable)ce);
        }
    }

    private void sendVideoLossEvent(boolean connected) {
        try {
            if (!connected) {
                if (this.listener.getVideoSrv().getVideoSourceCnf().isEnableVideoloss()) {
                    if (this.videoLossSince == Long.MIN_VALUE) {
                        this.logger.info("Video loss detected for: " + this);
                        this.videoLossSince = System.currentTimeMillis();
                        this.videoLossAlarmTriggered = false;
                    }
                    if (this.videoLossSince != Long.MIN_VALUE && System.currentTimeMillis() > this.videoLossSince + 5000L && !this.videoLossAlarmTriggered) {
                        this.videoLossAlarmTriggered = true;
                        this.logger.info("Videoloss for longer than 5sec. Trigger alarm!");
                        ((LiveCameraSrv)this.listener.getVideoSrv()).evaluateVideoLoss();
                        if (System.currentTimeMillis() > this.lastVideoLossEventSent + 5000L) {
                            this.lastVideoLossEventSent = System.currentTimeMillis();
                            this.listener.getVideoSrv().getCore().sendVideoLossEvent(this.listener.getVideoSrv());
                        }
                    }
                }
            } else if (this.videoLossSince != Long.MIN_VALUE) {
                this.logger.info("Video gain detected for: " + this);
                this.videoLossSince = Long.MIN_VALUE;
                this.listener.getVideoSrv().getCore().sendOPCEvent("false", OPCLowerNodeIDType.CAMERA_VIDEOLOSS_STATUS, this.listener.getVideoSrv().getEntityID());
            }
        }
        catch (ConfigurationException ex) {
            this.logger.error("Exception while sending Video Loss event for " + this + " , " + ex.getMessage());
        }
    }

    @Override
    public void setSsrcfromRtsp(String ssrc) {
    }

    @Override
    public void setMikey(Mikey mikey) {
    }
}

