/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.axis;

import de.seetec.v5.re.cm.device.shared.motiondetection.HardwareMotionDetection;
import de.seetec.v5.re.cm.device.shared.motiondetection.MotionDetectionHandler;
import de.seetec.v5.re.cm.device.shared.net.httpserverpush.HttpServerPushContent;
import de.seetec.v5.re.cm.device.shared.net.httpserverpush.HttpServerPushHandler;
import de.seetec.v5.re.cm.device.shared.net.httpserverpush.HttpServerPushListenerIntf;
import de.seetec.v5.re.cm.device.video.axis.AxisDevice;
import de.seetec.v5.re.cm.device.video.axis.utils.AxisAPIVersion;
import de.seetec.v5.re.shared.LteHostResolver;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.net.NetworkParameterFactory;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;

public class AxisMotionDetectionHandler
extends MotionDetectionHandler
implements HttpServerPushListenerIntf {
    protected NetworkParameter networkParameter = null;
    private List<Integer> groups = new ArrayList<Integer>();
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.axis.AxisMotionDetectionHandler";
    private HttpServerPushHandler httpServerPushHandler;

    public AxisMotionDetectionHandler() {
        this.logger = LogManager.getLogger((String)CLASS_NAME);
    }

    @Override
    public int init(HardwareMotionDetection<? extends MotionDetectionHandler> hardwareMotionDetection) {
        this.listener = hardwareMotionDetection;
        if (this.listener == null) {
            return -20003;
        }
        int errorCode = this.initialMDCheckAndGroupInitialization();
        if (errorCode != 0) {
            return errorCode;
        }
        String url = "/axis-cgi/motion/motiondata.cgi";
        try {
            this.networkParameter.setSoTimeout(10000);
            this.httpServerPushHandler = new HttpServerPushHandler();
            errorCode = this.httpServerPushHandler.init(this, this.networkParameter, url);
            if (errorCode != 0) {
                this.logger.error("Error [" + errorCode + "] with " + this.httpServerPushHandler);
            } else {
                errorCode = this.httpServerPushHandler.startServerPush(true);
            }
        }
        catch (Exception e) {
            this.logger.error("Error reading configuration from " + this.listener.getVideoSrv().getDevice(), (Throwable)e);
            errorCode = -21601;
        }
        return errorCode;
    }

    protected int initialMDCheckAndGroupInitialization() {
        int errorCode = 0;
        try {
            String resolvedHost = new LteHostResolver(this.listener.getVideoSrv().getDevice().getCore().getLTESupportConfiguration()).resolve(((AxisDevice)this.listener.getVideoSrv().getDevice()).getAxisNetworkParameter().getHost());
            ((AxisDevice)this.listener.getVideoSrv().getDevice()).getAxisNetworkParameter().setHost(resolvedHost);
            this.networkParameter = NetworkParameterFactory.createNetworkParameter((NetworkParameter)((AxisDevice)this.listener.getVideoSrv().getDevice()).getAxisNetworkParameter());
            String request = ((AxisDevice)this.listener.getVideoSrv().getDevice()).getAxisAPIVersion() == AxisAPIVersion.VERSION_2 ? "/axis-cgi/operator/param.cgi?action=list&group=Motion" : "/axis-cgi/param.cgi?action=list&group=Motion";
            String responseAsString = ((AxisDevice)this.listener.getVideoSrv().getDevice()).getHttpHandler().readGetRequest(request);
            if (!responseAsString.contains("root")) {
                this.logger.warn("Motion Detection on camera DISABLED for " + this.listener.getVideoSrv());
                this.logger.warn("Enable it on the camera or disable motion detection windows in the Cayuga system.");
                errorCode = -21664;
            } else {
                String[] lines;
                for (String line : lines = responseAsString.split("\n")) {
                    String[] lineParts;
                    if (line == null || !line.contains("ImageSource=" + (this.listener.getVideoSrv().getVideoSourceCnf().getServerEntryNo() - 1)) || (lineParts = line.split("root.Motion.M")).length < 2) continue;
                    this.groups.add(Integer.parseInt(lineParts[1].substring(0, lineParts[1].indexOf("."))));
                }
            }
        }
        catch (Exception e) {
            this.logger.error("Error while tesing motion detection for " + this.listener.getVideoSrv(), (Throwable)e);
            errorCode = -20053;
        }
        return errorCode;
    }

    @Override
    public int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        if (this.httpServerPushHandler != null) {
            this.httpServerPushHandler.shutdown();
            this.httpServerPushHandler = null;
        }
        if (this.groups != null) {
            this.groups.clear();
            this.groups = null;
        }
        super.shutdown();
        return 0;
    }

    @Override
    public final boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    @Override
    public void sendStatusService(int nStatusCode) {
        if (this.isShutdown(CLASS_NAME)) {
            return;
        }
        if (nStatusCode != 0) {
            this.listener.notifyForNetworkProblems();
        }
    }

    @Override
    public void notifyForNetworkProblems() {
        this.sendStatusService(-21650);
    }

    @Override
    public void deliverContent(HttpServerPushContent httpServerPushContent) {
        boolean hasDetected = false;
        byte[] content = httpServerPushContent.getContentBody();
        if (content != null) {
            String[] windows = new String(content).split("\r\n");
            for (int i = 0; i < windows.length; ++i) {
                block5: {
                    windows[i] = windows[i].substring(windows[i].indexOf("=") + 1);
                    String[] partsOfDetection = windows[i].split(";");
                    if (partsOfDetection.length != 3) {
                        if (partsOfDetection.length <= 0 || partsOfDetection[0].startsWith("--")) continue;
                        this.logger.error("Wrong content line format. Discarding for " + this.listener.getVideoSrv());
                        continue;
                    }
                    try {
                        int group = Integer.parseInt(partsOfDetection[0].substring(partsOfDetection[0].indexOf("=") + 1));
                        int level = Integer.parseInt(partsOfDetection[1].substring(partsOfDetection[1].indexOf("=") + 1));
                        int threshold = Integer.parseInt(partsOfDetection[2].substring(partsOfDetection[2].indexOf("=") + 1));
                        if (this.groups == null || !this.groups.contains(group) || level < threshold) break block5;
                        this.logger.debug("We have motion for group " + group + " for " + this.listener.getVideoSrv());
                        hasDetected = true;
                    }
                    catch (NumberFormatException nfe) {
                        this.logger.error("Error while converting number for " + this.listener.getVideoSrv());
                        continue;
                    }
                }
                if (!hasDetected) continue;
                hasDetected = false;
                if (this.listener == null) continue;
                this.listener.evaluateWindow(i);
            }
        }
    }
}

