/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.axis;

import de.seetec.v5.re.cm.QognifyMetadataManagerRepository;
import de.seetec.v5.re.cm.device.shared.Device;
import de.seetec.v5.re.cm.device.shared.LiveCameraSrv;
import de.seetec.v5.re.cm.device.shared.Resolution;
import de.seetec.v5.re.cm.device.shared.metadata.Metadata;
import de.seetec.v5.re.cm.device.shared.metadata.MetadataReader;
import de.seetec.v5.re.cm.device.shared.metadata.QmmData;
import de.seetec.v5.re.cm.device.shared.metadata.capabilities.ClassCapabilities;
import de.seetec.v5.re.cm.device.shared.metadata.capabilities.ColorDescriptorType;
import de.seetec.v5.re.cm.device.shared.metadata.capabilities.DataType;
import de.seetec.v5.re.cm.device.shared.metadata.capabilities.MetadataCapabilities;
import de.seetec.v5.re.cm.device.shared.metadata.capabilities.Parameter;
import de.seetec.v5.re.cm.device.shared.metadata.capabilities.ShapeCapabilities;
import de.seetec.v5.re.cm.device.shared.metadata.capabilities.VehicleInfoCapabilities;
import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPHandlerIntf;
import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPHandlerSuper;
import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPResponse;
import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPStreamSettings;
import de.seetec.v5.re.cm.device.shared.net.rtsp.mikey.Mikey;
import de.seetec.v5.re.cm.device.shared.onvif.metadata.Frame;
import de.seetec.v5.re.cm.device.shared.onvif.metadata.MetadataObject;
import de.seetec.v5.re.cm.device.shared.onvif.metadata.MetadataStream;
import de.seetec.v5.re.cm.device.shared.onvif.metadata.VideoAnalytics;
import de.seetec.v5.re.cm.device.shared.videosource.PacketType;
import de.seetec.v5.re.cm.device.shared.videosource.PacketTypeParser;
import de.seetec.v5.re.cm.device.shared.videosource.RtpPacket;
import de.seetec.v5.re.cm.device.video.axis.AxisDevice;
import de.seetec.v5.re.cm.device.video.axis.utils.AxisDeviceParameters;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.re.shared.TransmissionType;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.ConfigurationException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.jose4j.json.JsonUtil;

public class AxisMetadataReader
extends MetadataReader
implements RTSPHandlerIntf {
    public static final String CLASSNAME = "de.seetec.v5.re.cm.device.video.axis.AxisMetadataReader";
    private AxisDevice axisDevice;
    private String rtspUrl;
    private RTSPStreamSettings rtspSettings;
    private boolean isMultiChannelDevice;
    private final ByteArrayOutputStream buffer = new ByteArrayOutputStream();
    private final int videoSource;
    private RTSPHandlerSuper rtspHandler;
    private final long videoSourceEntityId;
    private final String videoSourceName;
    private final TransmissionType transmissionType;
    private Resolution resolution;

    public AxisMetadataReader(LiveCameraSrv liveCameraSrv, QognifyMetadataManagerRepository qognifyMetadataManagerRepository) throws ConfigurationException {
        super(qognifyMetadataManagerRepository);
        this.videoSource = liveCameraSrv.getVideoSourceCnf().getServerEntryNo();
        this.videoSourceName = liveCameraSrv.getVideoSourceCnf().getEntity().getEntityName();
        this.videoSourceEntityId = liveCameraSrv.getVideoSourceCnf().getEntityID();
        this.transmissionType = liveCameraSrv.getBasicVideoProfileHandler().getVideoSourceParameter().getTransmissionID();
    }

    @Override
    public int shutdown() {
        this.getLogger().info("Shutting down " + this);
        this.startShutdown(CLASSNAME);
        if (this.rtspHandler != null) {
            this.rtspHandler.shutdown();
        }
        return super.shutdown();
    }

    @Override
    public int init(Device device) {
        int errorCode = 0;
        super.init(device);
        try {
            MetadataCapabilities metadataCapabilities = this.getCapabilities();
            this.deliverMetadata(metadataCapabilities);
            AxisDeviceParameters axisDeviceParameters = new AxisDeviceParameters(this.getAxisDevice());
            this.resolution = axisDeviceParameters.readDefaultResolution(this.videoSource);
            this.getLogger().info(metadataCapabilities.toString());
            errorCode = this.startMetadataStream();
        }
        catch (Exception ex) {
            this.getLogger().warn("Exception while starting metadata reading for " + this + " : " + ex.getMessage());
        }
        return errorCode;
    }

    private int startMetadataStream() {
        int errorCode;
        this.getLogger().info("Starting metadata stream for " + this);
        try {
            NetworkParameter networkParameter = this.getAxisDevice().getDeviceCnf().getNetworkParameter();
            String rtspPath = "/axis-media/media.amp?video=0&audio=0&event=off&analytics=polygon&camera=" + this.videoSource;
            this.rtspUrl = "rtsp://" + networkParameter.getHost() + rtspPath;
            this.rtspSettings = new RTSPStreamSettings();
            String keepAliveUrl = this.isMultiChannelDevice ? this.rtspUrl : "*";
            errorCode = this.rtspSettings.init(this, null, networkParameter, 554, this.rtspUrl, false, this.transmissionType, 5000, false, 4, keepAliveUrl);
            if (errorCode != 0) {
                this.getLogger().error("Initialization of RTSPsettings failes with errorCode: " + errorCode + " for " + this);
            }
            this.rtspSettings.setIsVideoEnabled(false);
            this.rtspSettings.enableMetadata(this);
            this.rtspSettings.setMetadataTimeout(0);
            this.rtspSettings.setUseSdpData(true);
            this.rtspSettings.setPlaybackCodec(Codec.MJPEG);
            this.rtspHandler = this.rtspSettings.getRTSPHandler();
            this.rtspHandler.start();
        }
        catch (Exception ex) {
            this.getLogger().error("Exception while starting metadata stream for " + this + " : " + ex.getMessage());
            errorCode = -20100;
        }
        return errorCode;
    }

    private AxisDevice getAxisDevice() {
        if (this.axisDevice == null) {
            this.axisDevice = (AxisDevice)this.getDevice();
        }
        return this.axisDevice;
    }

    @Override
    public void processData(byte[] data) {
        try {
            PacketType packetType = PacketTypeParser.parsePacketType(data);
            if (packetType == PacketType.RTCP_SENDER_REPORT) {
                byte[] receiverReport = this.generateRTCPReceiverReport(data);
                if (this.rtspHandler != null) {
                    this.rtspHandler.sendReceiverReportMetadata(receiverReport);
                }
            } else {
                RtpPacket rtpPacket = new RtpPacket(data);
                this.buffer.write(rtpPacket.getContent());
                if (rtpPacket.hasMarkerFlag()) {
                    ByteArrayInputStream bais = new ByteArrayInputStream(this.buffer.toByteArray());
                    this.buffer.reset();
                    Document document = new SAXBuilder().build((InputStream)bais);
                    List<QmmData> metadataList = this.createMetadata(document);
                    super.deliverMetadata(metadataList);
                }
            }
        }
        catch (Exception ex) {
            this.getLogger().warn("RTP Data not correct for " + this);
        }
    }

    protected List<QmmData> createMetadata(Document document) {
        try {
            MetadataStream metadataStream = new MetadataStream(document);
            List<VideoAnalytics> videoAnalyticsList = metadataStream.getVideoAnalytics();
            ArrayList<QmmData> metadataList = new ArrayList<QmmData>();
            for (VideoAnalytics videoAnalytics : videoAnalyticsList) {
                List<Frame> frameList = videoAnalytics.getFrames();
                for (Frame frame : frameList) {
                    String timestamp = frame.getUtcTime();
                    List<MetadataObject> objectList = frame.getObjects();
                    for (MetadataObject object : objectList) {
                        Metadata metadata = new Metadata();
                        metadata.setSource("Qognify VMS");
                        metadata.setPlace(this.videoSourceName);
                        metadata.setMessageId(UUID.randomUUID());
                        metadata.setCameraId(this.videoSourceEntityId);
                        metadata.setExternalCameraId(this.videoSourceEntityId);
                        metadata.setResolutionWidth(this.resolution.getWidth());
                        metadata.setResolutionHeight(this.resolution.getHeight());
                        try {
                            if (object.getAppearance().getClassDescriptor() != null && !object.getAppearance().getClassDescriptor().getClassTypes().isEmpty() && object.getAppearance().getClassDescriptor().getClassTypes().get(0).getLikelihood() != 0.0f) {
                                metadata.setVmsAssumedLikelihood(object.getAppearance().getClassDescriptor().getClassTypes().get(0).getLikelihood());
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        metadata.setTimestamp(timestamp);
                        metadata.setObject(object);
                        metadataList.add(metadata);
                    }
                }
            }
            return metadataList;
        }
        catch (Exception ex) {
            this.getLogger().warn("Exception while reading metadata for " + this.getAxisDevice() + (ex.getMessage() != null ? " : " + ex.getMessage() : ""));
            return null;
        }
    }

    @Override
    public void onNetworkError(int errorCode) {
        if (!this.isShutdown(CLASSNAME)) {
            this.getLogger().error("Network error while reading metadata for " + this);
            if (this.rtspHandler != null) {
                int error = errorCode;
                while (!this.isShutdown(CLASSNAME) && error != 0) {
                    this.getLogger().info("Will restart metadata stream for " + this);
                    this.rtspHandler.shutdown();
                    error = this.startMetadataStream();
                }
            }
        } else {
            this.getLogger().info(this + " is already shutting down");
        }
    }

    @Override
    public void sendStatusService(int errorCode) {
    }

    @Override
    public void sendDescribeResponse(RTSPResponse response) {
    }

    @Override
    public void setSsrcfromRtsp(String ssrc) {
    }

    private byte[] generateRTCPReceiverReport(byte[] data) {
        byte[] receiverReport = new byte[32];
        receiverReport[0] = -127;
        receiverReport[1] = -55;
        receiverReport[2] = 0;
        receiverReport[3] = 7;
        byte[] receiverSsrc = new byte[4];
        new Random().nextBytes(receiverSsrc);
        System.arraycopy(receiverSsrc, 0, receiverReport, 4, 4);
        System.arraycopy(data, 4, receiverReport, 8, 4);
        System.arraycopy(data, 10, receiverReport, 24, 4);
        return receiverReport;
    }

    @Override
    public void setMikey(Mikey mikey) throws Exception {
    }

    private MetadataCapabilities getCapabilities() throws Exception {
        MetadataCapabilities metadataCapabilities = new MetadataCapabilities(false);
        String url = "/axis-cgi/analyticsmetadataconfig.cgi?getSupportedMetadata";
        String body = "{\"apiVersion\": \"1.0\",\"context\": \"my context\",\"method\": \"getSupportedMetadata\",\"params\": {}}";
        String result = this.getAxisDevice().getHttpHandler().readPostRequest(url, body, true, "application/json");
        this.getLogger().info(result);
        Map metadataJson = JsonUtil.parseJson((String)result);
        Map data = (Map)metadataJson.get("data");
        List producers = (List)data.get("producers");
        for (Object object : producers) {
            Map m = (Map)object;
            String nameValue = (String)m.get("name");
            if (!nameValue.equalsIgnoreCase("AnalyticsSceneDescription")) continue;
            String xmlData = (String)m.get("sampleFrameXML");
            ByteArrayInputStream bais = new ByteArrayInputStream(xmlData.getBytes());
            Document sampleFrame = new SAXBuilder().build((InputStream)bais);
            Element root = sampleFrame.getRootElement();
            Namespace ns = root.getNamespace();
            List objects = root.getChildren("Object", ns);
            boolean containsType = false;
            boolean containsBoundingBox = false;
            boolean containsCenterOfGravity = false;
            boolean containsPolygon = false;
            boolean containsShape = false;
            boolean typeContainsType = false;
            boolean typeContainsLikelihood = false;
            boolean containsVehicleInfo = false;
            boolean containsVehicleInfoLikelihood = false;
            boolean containsVehicleColor = false;
            ArrayList<String> possibleCandidateTypeValues = new ArrayList<String>();
            ArrayList<String> possibleTypeValues = new ArrayList<String>();
            ArrayList<String> possibleVehicleTypes = new ArrayList<String>();
            for (Element sampleObject : objects) {
                Element color;
                Element vehicleInfo;
                Element type;
                Element sampleClass;
                Element appearance = sampleObject.getChild("Appearance", ns);
                if (appearance == null) continue;
                Element shape = appearance.getChild("Shape", ns);
                if (shape != null) {
                    containsShape = true;
                    if (shape.getChild("BoundingBox", ns) != null) {
                        containsBoundingBox = true;
                    }
                    if (shape.getChild("CenterOfGravity", ns) != null) {
                        containsCenterOfGravity = true;
                    }
                    if (shape.getChild("Polygon", ns) != null) {
                        containsPolygon = true;
                    }
                }
                if ((sampleClass = appearance.getChild("Class", ns)) != null) {
                    Element classCandidateType;
                    Element classCandidate = sampleClass.getChild("ClassCandidate", ns);
                    if (classCandidate != null && (classCandidateType = classCandidate.getChild("Type", ns)) != null) {
                        containsType = true;
                        String type2 = classCandidateType.getText();
                        if (!possibleCandidateTypeValues.contains(type2)) {
                            possibleCandidateTypeValues.add(type2);
                        }
                    }
                    if ((type = sampleClass.getChild("Type", ns)) != null) {
                        String typeValue;
                        typeContainsType = true;
                        Attribute typeLikelihood = type.getAttribute("Likelihood", ns);
                        if (typeLikelihood != null) {
                            typeContainsLikelihood = true;
                        }
                        if (!possibleTypeValues.contains(typeValue = type.getText())) {
                            possibleTypeValues.add(typeValue);
                        }
                    }
                }
                if ((vehicleInfo = appearance.getChild("VehicleInfo", ns)) == null) continue;
                containsVehicleInfo = true;
                type = vehicleInfo.getChild("Type", ns);
                if (type != null) {
                    String vehicle;
                    Attribute likelihood = type.getAttribute("Likelihood", ns);
                    if (likelihood != null) {
                        containsVehicleInfoLikelihood = true;
                    }
                    if (!possibleVehicleTypes.contains(vehicle = type.getText())) {
                        possibleVehicleTypes.add(vehicle);
                    }
                }
                if ((color = vehicleInfo.getChild("Color", ns)) == null) continue;
                containsVehicleColor = true;
            }
            metadataCapabilities.setVideoSource(this.videoSourceEntityId);
            if (typeContainsType || containsType) {
                ClassCapabilities classCapabilities = new ClassCapabilities(true);
                classCapabilities.getType().removeAvailableStringValues();
                if (!typeContainsType) {
                    classCapabilities.getType().addAvailableStringValues(possibleCandidateTypeValues);
                } else {
                    classCapabilities.getType().addAvailableStringValues(possibleTypeValues);
                    if (!typeContainsLikelihood) {
                        classCapabilities.getType().setDataType(DataType.STRING);
                    }
                }
                metadataCapabilities.setClassCapabilities(classCapabilities);
            }
            if (containsVehicleInfo) {
                VehicleInfoCapabilities vehicleInfoCapabilities = new VehicleInfoCapabilities(false);
                Parameter vehicleType = new Parameter();
                vehicleType.addAvailableStringValues(possibleVehicleTypes);
                if (containsVehicleInfoLikelihood) {
                    vehicleType.setDataType(DataType.STRING_LIKELIHOOD);
                } else {
                    vehicleType.setDataType(DataType.STRING);
                }
                vehicleType.setName("Vehicle type");
                vehicleType.setPath("Object.Appearance.VehicleInfo.Type.Value");
                vehicleInfoCapabilities.setVehicleType(vehicleType);
                if (containsVehicleColor) {
                    Parameter vehicleColor = new Parameter();
                    vehicleColor.setDataType(DataType.COLOR);
                    vehicleColor.setColorType(ColorDescriptorType.RGB);
                    vehicleColor.setName("Color");
                    vehicleColor.setPath("Object.Appearance.VehicleInfo.Color.ColorCluster");
                    vehicleInfoCapabilities.addExtension(vehicleColor);
                }
                metadataCapabilities.setVehicleInfoCapabilities(vehicleInfoCapabilities);
            }
            if (!containsShape) continue;
            ShapeCapabilities shapeCapabilities = new ShapeCapabilities(true);
            if (!containsBoundingBox) {
                shapeCapabilities.setBoundingBox(null);
            }
            if (!containsPolygon) {
                shapeCapabilities.setPolygon(null);
            }
            if (!containsCenterOfGravity) {
                shapeCapabilities.setCenterOfGravity(null);
            }
            metadataCapabilities.setShapeCapabilities(shapeCapabilities);
        }
        return metadataCapabilities;
    }
}

