/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.axis;

import de.seetec.v5.re.cm.device.shared.Device;
import de.seetec.v5.re.cm.device.shared.MotionRecording;
import de.seetec.v5.re.cm.device.shared.genericevent.GenericEventTriggerCnf;
import de.seetec.v5.re.cm.device.shared.genericevent.GenericEventTriggerHandler;
import de.seetec.v5.re.cm.device.shared.videosource.RtpPacket;
import de.seetec.v5.re.cm.device.video.axis.AxisAlarmHandlerIntf;
import de.seetec.v5.re.cm.device.video.axis.AxisDevice;
import de.seetec.v5.re.cm.device.video.axis.AxisEventReader;
import de.seetec.v5.re.cm.device.video.axis.eventDom.Message;
import de.seetec.v5.re.cm.device.video.axis.utils.AxisSEIUserDataReader;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.NamedThreadFactory;
import de.seetec.v5.shared.util.SeeTecException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class AxisEventTriggerHandler
extends GenericEventTriggerHandler
implements AxisAlarmHandlerIntf {
    private final Map<GenericEventTriggerCnf, GenericEventTriggerCnf> activeTrigger = Collections.synchronizedMap(new HashMap());
    private ScheduledExecutorService scheduler = null;

    public AxisEventTriggerHandler(MotionRecording motionRecording) {
        super(motionRecording);
    }

    @Override
    public int shutdown() {
        if (this.isShutdown()) {
            return 0;
        }
        if (this.scheduler != null) {
            this.scheduler.shutdownNow();
            this.scheduler = null;
        }
        if (((AxisDevice)this.device).getEventReader() != null) {
            ((AxisDevice)this.device).getEventReader().deregister(this);
        }
        this.activeTrigger.clear();
        super.shutdown();
        return 0;
    }

    @Override
    public int init(Device device, List<GenericEventTriggerCnf> genericEventTriggerCnfs) {
        this.device = device;
        this.core = device.getCore();
        this.genericEventTriggerCnfs = genericEventTriggerCnfs;
        this.scheduler = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new NamedThreadFactory("AxisSimulateTrigger " + device));
        this.scheduler.scheduleWithFixedDelay(this, 500L, 500L, TimeUnit.MILLISECONDS);
        AxisEventReader axisEventReader = ((AxisDevice)this.device).createEventReader(genericEventTriggerCnfs);
        if (axisEventReader != null) {
            axisEventReader.register(this);
        }
        return 0;
    }

    @Override
    public void receiveAlarm(byte[] data) {
        Message message = this.generateMessage(data);
        if (message != null) {
            this.matchEventTrigger(message);
            this.matchOtherTrigger(message);
        }
    }

    @Override
    public void onNetworkError(int errorCode) {
        this.logger.info("Stopping re-triggering of generic event triggers because of network error [" + errorCode + "] for " + this);
        this.activeTrigger.clear();
    }

    @Override
    public void run() {
        for (GenericEventTriggerCnf element : this.activeTrigger.keySet()) {
            try {
                this.forwardTrigger(element);
            }
            catch (ConfigurationException ex) {
                this.logger.error(ex.getMessage() + " for " + this);
            }
        }
    }

    protected void forwardTrigger(AxisSEIUserDataReader userData) {
        try {
            for (GenericEventTriggerCnf genericEventTriggerCnf : this.getGenericEventTriggerCnfs()) {
                if (genericEventTriggerCnf == null || !genericEventTriggerCnf.isEnabled()) continue;
                if (genericEventTriggerCnf.getGenericEventTriggerType().contains("V") && userData.eventTriggerNotSet(genericEventTriggerCnf.getGenericEventTriggerType())) {
                    this.forwardTrigger(genericEventTriggerCnf);
                    continue;
                }
                if (genericEventTriggerCnf.getGenericEventTriggerType().contains("V") || !userData.eventTriggerSet(genericEventTriggerCnf.getGenericEventTriggerType())) continue;
                this.forwardTrigger(genericEventTriggerCnf);
            }
        }
        catch (ConfigurationException e) {
            this.logger.error(e.getMessage() + " for " + this);
        }
    }

    protected boolean isTriggerContainingEnabled(String triggerName) throws ConfigurationException {
        for (GenericEventTriggerCnf genericEventTriggerCnf : this.getGenericEventTriggerCnfs()) {
            if (!genericEventTriggerCnf.getGenericEventTriggerType().toLowerCase().contains(triggerName) || !genericEventTriggerCnf.isEnabled()) continue;
            return true;
        }
        return false;
    }

    protected GenericEventTriggerCnf getOtherTrigger(GenericEventTriggerCnf genericEventTriggerCnf, String part) throws ConfigurationException {
        String otherString = genericEventTriggerCnf.getGenericEventTriggerType().contains(part + ":1") ? genericEventTriggerCnf.getGenericEventTriggerType().replace(part + ":1", part + ":0") : genericEventTriggerCnf.getGenericEventTriggerType().replace(part + ":0", part + ":1");
        for (GenericEventTriggerCnf otherGenericEventTriggerCnf : this.getGenericEventTriggerCnfs()) {
            if (!otherGenericEventTriggerCnf.getGenericEventTriggerType().contains(otherString)) continue;
            return otherGenericEventTriggerCnf;
        }
        return null;
    }

    private Message generateMessage(byte[] data) {
        try {
            RtpPacket rtpPacket = new RtpPacket(data);
            String content = new String(rtpPacket.getContent(), Charset.defaultCharset());
            if (!content.startsWith("<?xml")) {
                return null;
            }
            return Message.getMessageFromXML(content);
        }
        catch (SeeTecException ex) {
            this.logger.debug(ex.getMessage() + " for " + this);
            return null;
        }
    }

    private List<GenericEventTriggerCnf> findGenericEventTriggerCnfs(List<GenericEventTriggerCnf> inputList, Message message, boolean matchEventTrigger) throws ConfigurationException {
        for (GenericEventTriggerCnf genericEventTriggerCnf : inputList) {
            if (genericEventTriggerCnf == null || matchEventTrigger && !genericEventTriggerCnf.isEnabled() || !genericEventTriggerCnf.getGenericEventTriggerType().startsWith(message.getName())) continue;
            String[] parameters = genericEventTriggerCnf.getGenericEventTriggerType().split("\\|");
            boolean missMatch = false;
            for (int i = 1; i < parameters.length - 1; ++i) {
                String[] nameValuePair = parameters[i].split(":");
                if (message.hasNameValuePair(nameValuePair[0], nameValuePair[1])) continue;
                missMatch = true;
                break;
            }
            if (missMatch) continue;
            String part = parameters[parameters.length - 1].split(":")[1];
            ArrayList<GenericEventTriggerCnf> resultList = new ArrayList<GenericEventTriggerCnf>();
            resultList.add(genericEventTriggerCnf);
            if (!matchEventTrigger) {
                resultList.add(this.getOtherTrigger(genericEventTriggerCnf, part));
            } else if (!part.equals("false")) {
                resultList.add(this.getOtherTrigger(genericEventTriggerCnf, part));
            }
            return resultList;
        }
        return null;
    }

    private void matchEventTrigger(Message message) {
        try {
            List<GenericEventTriggerCnf> result = this.findGenericEventTriggerCnfs(this.getGenericEventTriggerCnfs(), message, true);
            if (result != null && !result.isEmpty()) {
                if (result.size() > 1) {
                    this.activeTrigger.put(result.get(0), result.get(1));
                }
                this.forwardTrigger(result.get(0));
            }
        }
        catch (ConfigurationException ex) {
            this.logger.error(ex.getMessage() + " for " + this);
        }
    }

    private void matchOtherTrigger(Message message) {
        try {
            List<GenericEventTriggerCnf> result = this.findGenericEventTriggerCnfs(this.getGenericEventTriggerCnfs(), message, false);
            if (result != null && result.size() > 1) {
                this.activeTrigger.remove(result.get(1));
            }
        }
        catch (ConfigurationException ex) {
            this.logger.error(ex.getMessage() + " for " + this);
        }
    }
}

