/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.axis;

import de.seetec.v5.re.cm.configuration.definition.camera.VideoCameraDefinition;
import de.seetec.v5.re.cm.configuration.device.shared.ArrayOfCameraPreset.ArrayOfCameraPreset;
import de.seetec.v5.re.cm.configuration.device.shared.ArrayOfCameraPreset.CameraPreset;
import de.seetec.v5.re.cm.device.shared.VideoSrv;
import de.seetec.v5.re.cm.device.shared.cameracontrol.CameraControl;
import de.seetec.v5.re.cm.device.shared.cameracontrol.PresetCnf;
import de.seetec.v5.re.cm.device.video.axis.AxisDevice;
import de.seetec.v5.re.cm.device.video.axis.AxisPresetPositionRank;
import de.seetec.v5.re.cm.device.video.axis.utils.AxisDeviceParameters;
import de.seetec.v5.re.cm.device.video.axis.utils.AxisPtzConfigQuery;
import de.seetec.v5.re.cm.device.video.axis.utils.AxisPtzControlQuery;
import de.seetec.v5.re.cm.device.video.axis.utils.AxisQuery;
import de.seetec.v5.re.cm.device.video.axis.utils.Query;
import de.seetec.v5.re.cm.shared.PtzInfo;
import de.seetec.v5.re.cm.shared.communication.VideoServiceClientRequestHandler;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.NamedThreadFactory;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class AxisCameraControl
extends CameraControl {
    private final BlockingQueue<Query> continuousPtzQueue = new ArrayBlockingQueue<Query>(1);
    private AxisDeviceParameters deviceParameters = null;
    private String deviceName = null;
    private boolean canContinuousFocus = false;
    private boolean canContinuousIris = false;
    private ExecutorService ptzQueueThread = null;

    private AxisDevice getAxisDevice() {
        return (AxisDevice)this.videoSrv.getDevice();
    }

    @Override
    public int init(VideoSrv videoSrv, String api, String host, int port, String usr, String pwd, Vector<PresetCnf> presetList) {
        int errorCode = super.init(videoSrv, api, host, port, usr, pwd, presetList);
        try {
            this.deviceParameters = ((AxisDevice)videoSrv.getDevice()).getAxisDeviceParameters();
        }
        catch (SeeTecException seeTecException) {
            // empty catch block
        }
        String threadName = this.videoSrv.getDevice().getDeviceEntity().getEntityName() + " Continuous PTZ";
        this.ptzQueueThread = Executors.newSingleThreadExecutor((ThreadFactory)new NamedThreadFactory(threadName));
        this.ptzQueueThread.execute(new Runnable(){

            @Override
            public void run() {
                block3: {
                    try {
                        while (!AxisCameraControl.this.isShutdown()) {
                            Query take = (Query)AxisCameraControl.this.continuousPtzQueue.poll(15L, TimeUnit.SECONDS);
                            if (take == null) continue;
                            AxisCameraControl.this.sendCameraCommand(take);
                            AxisCameraControl.this.getAbsolutePosition(false);
                        }
                    }
                    catch (InterruptedException ex) {
                        if (AxisCameraControl.this.ptzQueueThread.isShutdown()) break block3;
                        AxisCameraControl.this.ptzQueueThread.execute(this);
                    }
                }
            }
        });
        if (this.deviceParameters != null) {
            try {
                this.canContinuousFocus = Boolean.parseBoolean(this.deviceParameters.getDeviceParameterValue("root.PTZ.Support.S1.ContinuousFocus"));
                this.canContinuousIris = Boolean.parseBoolean(this.deviceParameters.getDeviceParameterValue("root.PTZ.Support.S1.ContinuousIris"));
            }
            catch (SeeTecException seeTecException) {
                // empty catch block
            }
            try {
                String maxZoomString = this.deviceParameters.getDeviceParameterValue("root.PTZ.Limit.L1.MaxZoom");
                int maxAbsoluteZoom = maxZoomString == null ? 0 : Integer.parseInt(maxZoomString);
                this.ptzInfo = new PtzInfo();
                this.ptzInfo.setMinZoom(0);
                this.ptzInfo.setMaxZoom(maxAbsoluteZoom);
                this.getAbsolutePosition(true);
            }
            catch (SeeTecException seeTecException) {
                // empty catch block
            }
            try {
                this.deviceName = this.deviceParameters.getDeviceParameterValue("root.Brand.ProdFullName");
            }
            catch (SeeTecException seeTecException) {
                // empty catch block
            }
        }
        return errorCode;
    }

    private int sendCameraCommand(Query query) {
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.info("Sending URL=[" + query + "] for " + this);
            }
            this.videoSrv.notifyForCameraControl();
            this.getAxisDevice().getHttpHandler().readGetRequest(query.toString());
            return 0;
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
            return -21600;
        }
    }

    private Integer getCameraID() {
        try {
            return this.videoSrv.getVideoSourceCnf().getServerEntryNo();
        }
        catch (ConfigurationException ex) {
            this.logger.warn("[" + (Object)((Object)ex) + "] for " + this);
            return null;
        }
    }

    @Override
    public int setAbsolutePTZ(VideoServiceClientRequestHandler sender, Integer pan, Integer tilt, Integer zoom) {
        int errorCode = 0;
        try {
            int cameraNumber = this.videoSrv.getVideoSourceCnf().getServerEntryNo();
            AxisPtzControlQuery query = this.getPtzControlQuery().camera(cameraNumber).pan(pan).tilt(tilt).zoom(zoom).speedMax();
            errorCode = this.sendCameraCommand(query);
            if (errorCode != 0) {
                return errorCode;
            }
            this.ptzInfo.setPan(pan == null ? 0 : pan);
            this.ptzInfo.setTilt(tilt == null ? 0 : tilt);
            this.ptzInfo.setZoom(zoom == null ? 0 : zoom);
        }
        catch (Throwable ex) {
            this.logger.error(ex + " for " + this, ex);
            errorCode = -21600;
        }
        return errorCode;
    }

    @Override
    public int setAbsolutePt(VideoServiceClientRequestHandler sender, Integer pan, Integer tilt) {
        int errorCode;
        try {
            int cameraNumber = this.videoSrv.getVideoSourceCnf().getServerEntryNo();
            AxisPtzControlQuery query = this.getPtzControlQuery().camera(cameraNumber).pan(pan).tilt(tilt).speedMax();
            errorCode = this.sendCameraCommand(query);
            if (errorCode == 0) {
                this.getAbsolutePosition(false);
                this.ptzInfo.setPan(pan == null ? 0 : pan);
                this.ptzInfo.setTilt(tilt == null ? 0 : tilt);
            }
        }
        catch (Throwable ex) {
            this.logger.error(ex + " for " + this, ex);
            errorCode = -21600;
        }
        return errorCode;
    }

    @Override
    public int setAbsoluteZ(VideoServiceClientRequestHandler sender, Integer zoom) {
        int errorCode = 0;
        try {
            int cameraNumber = this.videoSrv.getVideoSourceCnf().getServerEntryNo();
            AxisPtzControlQuery query = this.getPtzControlQuery().camera(cameraNumber).zoom(zoom).speedMax();
            errorCode = this.sendCameraCommand(query);
            if (errorCode != 0) {
                return errorCode;
            }
            this.getAbsolutePosition(false);
            this.ptzInfo.setZoom(zoom == null ? 0 : zoom);
        }
        catch (Throwable ex) {
            this.logger.error(ex + " for " + this, ex);
            errorCode = -21600;
        }
        return errorCode;
    }

    @Override
    public int setContinuousPTZ(Integer panSpeed, Integer tiltSpeed, Integer zoomSpeed) {
        if (panSpeed != null) {
            this.previousPanSpeed = panSpeed;
        }
        if (tiltSpeed != null) {
            this.previousTiltSpeed = tiltSpeed;
        }
        if (zoomSpeed != null) {
            this.previousZoomSpeed = zoomSpeed;
        }
        try {
            AxisPtzControlQuery query = this.getPtzControlQuery().camera(this.getCameraID());
            if (this.videoSrv.getEntityType() == 210600L) {
                if (panSpeed != null || tiltSpeed != null) {
                    query = query.continuousPanTilt(this.previousPanSpeed, this.previousTiltSpeed);
                }
                if (zoomSpeed != null) {
                    query = query.continuousZoom(this.previousZoomSpeed);
                }
            } else {
                query = query.continuousPanTilt(this.previousPanSpeed, this.previousTiltSpeed).continuousZoom(this.previousZoomSpeed);
            }
            this.continuousPtzQueue.poll();
            this.continuousPtzQueue.offer(query);
            return 0;
        }
        catch (Throwable ex) {
            this.logger.error(ex + " for " + this, ex);
            return -21600;
        }
    }

    @Override
    public int setCenterPT(Integer xPosition, Integer yPosition, int[] resolution) {
        try {
            if (resolution != null) {
                int absolutX = resolution[0] * xPosition / 100;
                int absolutY = resolution[1] * yPosition / 100;
                int imageRotation = this.videoSrv.getVideoSourceCnf().getImageRotation();
                AxisPtzControlQuery query = this.getPtzControlQuery().camera(this.getCameraID()).center(absolutX, absolutY).imageRotation(imageRotation).imageWidth(resolution[0]).imageHeight(resolution[1]);
                return this.sendCameraCommand(query);
            }
        }
        catch (Throwable t) {
            this.logger.error(t.getMessage() + " for " + this, t);
        }
        return 0;
    }

    @Override
    public int setZoomArea(Integer xPosition, Integer yPosition, Integer width, Integer height, int[] resolution) {
        try {
            int zoomFactor = 100;
            if (resolution != null) {
                int absolutX = resolution[0] * xPosition / 100;
                int absolutY = resolution[1] * yPosition / 100;
                int absolutWidth = resolution[0] * width / 100;
                int absolutHeigth = resolution[1] * height / 100;
                int absolutMiddleX = absolutX + absolutWidth / 2;
                int absolutMiddleY = absolutY + absolutHeigth / 2;
                float zoomFactorX = (float)resolution[0] / (float)absolutWidth;
                float zoomFactorY = (float)resolution[1] / (float)absolutHeigth;
                int n = zoomFactor = zoomFactorX <= zoomFactorY ? (int)((float)zoomFactor * zoomFactorX) : (int)((float)zoomFactor * zoomFactorY);
                if (this.logger.isDebugEnabled()) {
                    this.logger.info("Absolute X: " + absolutX + " Absolute Y: " + absolutY);
                    this.logger.info("Absolute width: " + absolutWidth + " Absolute height:" + absolutHeigth);
                    this.logger.info("Absolute middleX: " + absolutMiddleX + " Absolute middleY:" + absolutMiddleY);
                    this.logger.info("zoomFactorX: " + zoomFactorX + " zoomFactorY:" + zoomFactorY);
                    this.logger.info("zoomFactor: " + zoomFactor);
                }
                if (zoomFactor < 0) {
                    zoomFactor = 0;
                }
                int imageRotation = this.videoSrv.getVideoSourceCnf().getImageRotation();
                AxisPtzControlQuery query = this.getPtzControlQuery().camera(this.getCameraID()).areaZoom(absolutMiddleX, absolutMiddleY, zoomFactor).imageRotation(imageRotation).imageWidth(resolution[0]).imageHeight(resolution[1]);
                return this.sendCameraCommand(query);
            }
        }
        catch (Throwable t) {
            this.logger.error(t.getMessage() + " for " + this, t);
        }
        return 0;
    }

    @Override
    public int setAbsoluteIris(Integer value) {
        return this.sendCameraCommand(this.getPtzControlQuery().iris(value));
    }

    @Override
    public int setContinuousIris(Integer value) {
        Integer cameraID = this.getCameraID();
        AxisPtzControlQuery query = this.getPtzControlQuery().camera(cameraID);
        Integer val = value != null ? value / 20 : 0;
        if (this.canContinuousIris) {
            return this.sendCameraCommand(query.continuousIris(val));
        }
        return this.sendCameraCommand(query.relativeIris(val));
    }

    @Override
    public int setAutoIris(Boolean active) {
        AxisPtzControlQuery query = this.getPtzControlQuery().camera(this.getCameraID()).autoIris(active != false ? "on" : "off");
        return this.sendCameraCommand(query);
    }

    @Override
    public int setAbsoluteFocus(Integer value) {
        return this.sendCameraCommand(this.getPtzControlQuery().focus(value));
    }

    @Override
    public int setContinuousFocus(Integer value) {
        Integer val = value != null ? value / 20 : 0;
        int errorCode = val == 0 && this.isAutoFocusOn() && !this.isFocusStopSignalNeeded(this.deviceName) ? 0 : (this.canContinuousFocus ? this.sendCameraCommand(this.getPtzControlQuery().camera(this.getCameraID()).continuousFocus(val)) : this.sendCameraCommand(this.getPtzControlQuery().camera(this.getCameraID()).relativeFocus(val)));
        return errorCode;
    }

    protected boolean isFocusStopSignalNeeded(String deviceName) {
        return deviceName != null && (deviceName.contains("P7216") || deviceName.contains("P7214") || deviceName.contains("Q7401") || deviceName.contains("Q7411"));
    }

    private boolean isAutoFocusOn() {
        boolean result = false;
        try {
            String response = this.getAxisDevice().getHttpHandler().readGetRequest(AxisQuery.controlPtz().queryPosition().toString());
            result = response.toUpperCase().contains("AUTOFOCUS=ON");
        }
        catch (Exception exception) {
            this.logger.error("Autofocus check failed because " + exception.getMessage() + " for " + this);
        }
        return result;
    }

    @Override
    public int setAutoFocus(Boolean active) {
        return this.sendCameraCommand(this.getPtzControlQuery().autoFocus(active != false ? "on" : "off"));
    }

    @Override
    public int setZeroLux(Boolean active) {
        if (((AxisDevice)this.videoSrv.getDevice()).isSupportingImageSourceZeroLux(this.getCameraID())) {
            return this.setImageSourceZeroLux(active, false);
        }
        return this.sendCameraCommand(this.getPtzControlQuery().irCutFilter(active != false ? "off" : "on"));
    }

    @Override
    public int setAutoZeroLux(Boolean active) {
        int errorCode = 0;
        if (active.booleanValue()) {
            errorCode = ((AxisDevice)this.videoSrv.getDevice()).isSupportingImageSourceZeroLux(this.getCameraID()) ? this.setImageSourceZeroLux(false, true) : this.sendCameraCommand(this.getPtzControlQuery().irCutFilterAuto());
        }
        return errorCode;
    }

    @Override
    public int setHomePosition() {
        int errorCode = this.sendCameraCommand(this.getPtzControlQuery().camera(this.getCameraID()).moveHome());
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException ex) {
            this.logger.debug("Thread sleep interrupted for " + this);
        }
        this.getAbsolutePosition(true);
        return errorCode;
    }

    @Override
    public int addPresetPosition(Vector<byte[]> result, Long presetID, String presetName) {
        try {
            String encodedPresetName = this.getEncodedPresetName(presetName);
            AxisQuery query = this.getPtzControlQuery().camera(this.getCameraID()).setServerPresetName(encodedPresetName);
            if ((double)this.getAxisDevice().getAxisFirmwareVersion().getShortFirmwareVersion().floatValue() >= 4.3) {
                query = this.getPtzConfigQuery().camera(this.getCameraID()).setServerPresetName(encodedPresetName);
            }
            this.sendCameraCommand(query);
            PresetCnf presetCnf = PresetCnf.createPresetCnf((long)presetID, encodedPresetName);
            this.presetList.addElement(presetCnf);
            result.addElement(presetCnf.getPresetCnf());
            this.logger.info("Adding preset configuration: " + presetCnf);
            return 0;
        }
        catch (SeeTecException | UnsupportedEncodingException ex) {
            throw new RuntimeException(ex.getMessage());
        }
    }

    @Override
    public int setPresetPosition(String presetName) {
        int errorCode;
        try {
            String encodedPresetName = this.getEncodedPresetName(presetName);
            if (this.isPresetExisting(encodedPresetName)) {
                Integer cameraID = this.videoSrv.getVideoSourceCnf().getServerEntryNo();
                errorCode = this.sendCameraCommand(this.getPtzControlQuery().camera(cameraID).speedMax().gotoServerPresetName(encodedPresetName));
                this.getAbsolutePosition(true);
            } else {
                errorCode = -21683;
            }
        }
        catch (Exception ex) {
            this.logger.error("Setting preset [" + presetName + "] failed for " + this, (Throwable)ex);
            errorCode = -21600;
        }
        return errorCode;
    }

    @Override
    public int removePresetPosition(String presetName) {
        int errorCode;
        try {
            String encodedPresetName = this.getEncodedPresetName(presetName);
            if (this.removePresetFromListIfExistent(encodedPresetName)) {
                AxisQuery query = this.getPtzControlQuery().camera(this.getCameraID()).removeServerPresetName(encodedPresetName);
                if ((double)this.getAxisDevice().getAxisFirmwareVersion().getShortFirmwareVersion().floatValue() >= 4.3) {
                    query = this.getPtzConfigQuery().camera(this.getCameraID()).removeServerPresetName(encodedPresetName);
                }
                if ((errorCode = this.sendCameraCommand(query)) != 0) {
                    this.logger.warn("Removing preset [" + encodedPresetName + "] failed with error [" + errorCode + "] for " + this);
                    errorCode = 0;
                }
            } else {
                errorCode = -21683;
            }
        }
        catch (Exception ex) {
            this.logger.error("Removing preset [" + presetName + "] failed for " + this, (Throwable)ex);
            errorCode = -21600;
        }
        return errorCode;
    }

    @Override
    protected String getEncodedPresetName(String presetName) throws UnsupportedEncodingException {
        return super.getEncodedPresetName(this.limitPresetNameLength(presetName));
    }

    @Override
    public int addCameraPresets(ArrayOfCameraPreset presets) {
        int errorCode = 0;
        if (presets == null) {
            this.logger.warn("Received null camera presets object in addCameraPresets!");
            return -20002;
        }
        List<CameraPreset> cameraPresets = presets.getCameraPreset();
        for (CameraPreset cameraPreset : cameraPresets) {
            try {
                PresetCnf presetCnf = PresetCnf.createPresetCnf(cameraPreset.getId(), this.getEncodedPresetName(cameraPreset.getName()));
                this.presetList.addElement(presetCnf);
                this.logger.info("Adding preset configuration: " + presetCnf);
            }
            catch (UnsupportedEncodingException ex) {
                this.logger.error("Unsupported encoding used in the AxisCameraControl.addCameraPresets()!", (Throwable)ex);
                errorCode = -20000;
            }
        }
        return errorCode;
    }

    @Override
    public ArrayOfCameraPreset getPresetsFromCamera() {
        try {
            String result = new String(this.getAxisDevice().getHttpHandler().readGetRequestAsByteArray(this.getPtzControlQuery().queryGetAllPresets().toString()), StandardCharsets.ISO_8859_1);
            LinkedList<String> presetStrings = new LinkedList<String>(Arrays.asList(result.split("[\\r\\n]+")));
            ArrayOfCameraPreset cameraPresets = this.createSortedCameraPresetArray(presetStrings);
            return cameraPresets;
        }
        catch (SeeTecException ex) {
            this.logger.error((Object)((Object)ex) + " for " + this, (Throwable)ex);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage());
        }
        return new ArrayOfCameraPreset();
    }

    private ArrayOfCameraPreset createSortedCameraPresetArray(List<String> presetStrings) throws UnsupportedEncodingException {
        ArrayList<AxisPresetPositionRank> axisPresetPositions = new ArrayList<AxisPresetPositionRank>();
        for (String presetString : presetStrings) {
            String tempString;
            String[] tempStrings;
            if (!presetString.startsWith("presetposno") || (tempStrings = (tempString = presetString.replaceFirst("presetposno", "")).split("="))[1].equalsIgnoreCase("home")) continue;
            try {
                axisPresetPositions.add(new AxisPresetPositionRank(Integer.parseInt(tempStrings[0]), tempStrings[1]));
            }
            catch (SeeTecException seeTecException) {
                this.logger.warn(seeTecException.getMessage());
            }
            catch (NumberFormatException numberFormatException) {
                this.logger.error("Error parsing preset position [" + presetString + "] [" + numberFormatException.getMessage() + "]");
            }
        }
        Collections.sort(axisPresetPositions);
        ArrayOfCameraPreset cameraPresets = new ArrayOfCameraPreset();
        for (AxisPresetPositionRank axisPresetPosition : axisPresetPositions) {
            CameraPreset cameraPreset = new CameraPreset();
            cameraPreset.setName(axisPresetPosition.getPresetname());
            PresetCnf presetCnf = PresetCnf.createPresetCnf(cameraPreset.getId(), this.getEncodedPresetName(cameraPreset.getName()));
            cameraPreset.setPtzData(new String(presetCnf.getPresetCnf(), "UTF-8"));
            cameraPresets.getCameraPreset().add(cameraPreset);
        }
        return cameraPresets;
    }

    private void getAbsolutePosition(boolean sendStatus) {
        VideoCameraDefinition config = this.videoSrv.getDevice().getVideoCameraDefinitionFromConfiguration();
        if (config == null || !config.getFeatures().isCanAbsoluteZoom()) {
            return;
        }
        try {
            String[] results;
            String result = this.getAxisDevice().getHttpHandler().readGetRequest(AxisQuery.controlPtz().queryPosition().toString());
            for (String element : results = result.split("[\\r\\n]+")) {
                String key;
                String line = element.trim().toUpperCase();
                if (line.startsWith(key = "PAN=")) {
                    this.ptzInfo.setPan((int)(Float.parseFloat(line.substring(key.length())) * 1000.0f));
                }
                if (line.startsWith(key = "TILT=")) {
                    this.ptzInfo.setTilt((int)(Float.parseFloat(line.substring(key.length())) * 1000.0f));
                }
                if (!line.startsWith(key = "ZOOM=")) continue;
                this.ptzInfo.setZoom((int)Float.parseFloat(line.substring(key.length())));
            }
            if (sendStatus) {
                this.videoSrv.sendStatusAbsolutePTZ(null, this.ptzInfo.getPan(), this.ptzInfo.getTilt(), this.ptzInfo.getZoom());
            }
        }
        catch (Throwable ex) {
            this.logger.error(ex + " for " + this, ex);
        }
    }

    private AxisPtzControlQuery getPtzControlQuery() {
        return AxisQuery.controlPtz().sid();
    }

    private AxisPtzConfigQuery getPtzConfigQuery() {
        return AxisQuery.configurePtz().sid();
    }

    private String limitPresetNameLength(String presetName) {
        if (presetName == null) {
            return null;
        }
        return presetName.length() > 31 ? presetName.substring(0, 31) : presetName;
    }

    @Override
    public int shutdown() {
        try {
            this.ptzQueueThread.shutdownNow();
        }
        catch (Exception e) {
            this.logger.info("Error while shuting down the PTZQueue (" + this.ptzQueueThread + ") |" + e.getMessage() + " | " + this.videoSrv.getDevice());
        }
        return super.shutdown();
    }

    private int setImageSourceZeroLux(boolean active, boolean auto) {
        String value = auto ? "auto" : (active ? "no" : "yes");
        String url = "/axis-cgi/param.cgi?action=update&ImageSource.I" + (this.getCameraID() - 1) + ".DayNight.IrCutFilter=" + value;
        try {
            this.getAxisDevice().getHttpHandler().readGetRequest(url);
        }
        catch (SeeTecException ex) {
            return ex.getErrorCode();
        }
        catch (Exception ex) {
            return -20001;
        }
        return 0;
    }
}

