/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.axis;

import de.seetec.v5.re.cm.device.shared.AudioOutServer;
import de.seetec.v5.re.shared.MediaFrame;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.net.HTTPHeader;
import de.seetec.v5.shared.net.HTTPResponse;
import de.seetec.v5.shared.net.HTTPStatusCode;
import de.seetec.v5.shared.net.HttpHandlerImpl;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AxisAudioOutServer
extends AudioOutServer
implements Runnable {
    private final NetworkParameter networkParameter;
    private final Logger logger;
    private Socket postSocket;
    private boolean isShutdown = false;
    private Thread thread;
    private byte[] response = new byte[1024];

    public AxisAudioOutServer(NetworkParameter networkParameter) {
        if (networkParameter == null) {
            throw new IllegalArgumentException("NetworkParameter is null for AxisAudioOutServer");
        }
        this.networkParameter = networkParameter;
        this.logger = LogManager.getLogger(this.getClass());
    }

    public int init() {
        try {
            HttpHandlerImpl httpHandler = new HttpHandlerImpl(this.networkParameter);
            String url = "/axis-cgi/param.cgi?action=update&Audio.ReceiverTimeout=9999";
            httpHandler.readGetRequest(url);
        }
        catch (Exception ex) {
            this.logger.info("Could not set timeout value for " + this + ". Reason: " + ex.getMessage() + " Will continue anyway...");
        }
        this.thread = new Thread((Runnable)this, this.getClass().getName());
        this.thread.start();
        this.logger.info(this + " initialized");
        return 0;
    }

    private void sendAudio(byte[] audioData) {
        try {
            this.establishStream();
            OutputStream os = this.postSocket.getOutputStream();
            os.write(audioData);
            os.flush();
            InputStream is = this.postSocket.getInputStream();
            try {
                int bytesRead = is.read(this.response);
                if (bytesRead > 0) {
                    int statusCode;
                    byte[] r = new byte[bytesRead];
                    System.arraycopy(this.response, 0, r, 0, bytesRead);
                    HTTPResponse httpResponse = new HTTPResponse(r);
                    HTTPHeader httpHeader = httpResponse.getHttpHeader();
                    if (httpHeader != null && (statusCode = httpHeader.getStatusCode()) == HTTPStatusCode.HTTP_REQUEST_TIME_OUT.getStatusCode()) {
                        throw new IOException("Axis device sent timeout on Audio Out stream. ");
                    }
                }
            }
            catch (SocketTimeoutException socketTimeoutException) {}
        }
        catch (IOException iOException) {
            this.logger.info(iOException.getMessage() + "Will restart Audio Out stream for " + this);
            try {
                this.postSocket.close();
                this.postSocket = null;
                this.establishStream();
                OutputStream os = this.postSocket.getOutputStream();
                os.write(audioData);
                os.flush();
            }
            catch (IOException ioe) {
                this.logger.error("Sending audio data failed [" + iOException.getMessage() + "] for " + this);
            }
        }
    }

    private void establishStream() throws IOException {
        if (this.postSocket == null || this.postSocket.isClosed()) {
            this.postSocket = this.getPostSocket();
            this.establishPostStream();
        }
    }

    private Socket getPostSocket() {
        try {
            this.postSocket = this.networkParameter.useHTTPS() ? NetworkHelper.createNetworkConnection((String)this.networkParameter.getHost(), (int)this.networkParameter.getSSLport(), (boolean)true, (int)this.networkParameter.getSoTimeout()) : NetworkHelper.createNetworkConnection((String)this.networkParameter.getHost(), (int)this.networkParameter.getHTTPport(), (boolean)false, (int)this.networkParameter.getSoTimeout());
            this.postSocket.setSoTimeout(1);
            this.postSocket.setTcpNoDelay(true);
            this.logger.info(Basic.generateIndentedMultiLineLog((String[])new String[]{"Opening socket for audio post request:", "   NetworkParameter: " + this.networkParameter}));
        }
        catch (SocketException socketException) {
            this.logger.error("Error creating socket for " + this);
        }
        catch (Exception exception) {
            this.logger.error("Unexpected error while creating socket for " + this);
        }
        return this.postSocket;
    }

    private void establishPostStream() throws IOException {
        String authentication = this.createAxisAudioOutAuthentication(this.networkParameter);
        OutputStream os = this.postSocket.getOutputStream();
        String postRequest = this.buildPostRequest(this.networkParameter.getHost(), authentication);
        os.write(postRequest.getBytes());
        os.flush();
    }

    private String createAxisAudioOutAuthentication(NetworkParameter networkParameter) {
        String authentication = "";
        try {
            NetworkHelper.readGetRequest((NetworkParameter)networkParameter, (String)"/axis-cgi/view/param.cgi?action=list&group=root.Brand.Brand", (int)Integer.MIN_VALUE);
        }
        catch (SeeTecException seeTecException) {
            this.logger.error("Error creating authentication for " + this);
        }
        String realm = networkParameter.getRealm();
        String nonce = networkParameter.getNonce();
        String qop = networkParameter.getQop();
        if (realm != null && nonce != null) {
            try {
                String requestUrl = "http://" + networkParameter.getHost() + "/axis-cgi/audio/transmit.cgi";
                authentication = NetworkHelper.createDigestAuthorization((NetworkParameter)networkParameter, (String)realm, (String)nonce, (String)"POST", (String)requestUrl, (String)qop);
            }
            catch (Exception exception) {
                this.logger.error("Error creating authentication for " + this);
            }
        } else {
            authentication = NetworkHelper.createBasicAuthorization((String[])networkParameter.getUserPWD());
        }
        return authentication;
    }

    private String buildPostRequest(String host, String authentication) {
        String postRequest = "POST /axis-cgi/audio/transmit.cgi HTTP/1.0\r\nContent-Type: audio/basic\r\nContent-Length: 9999999\r\nConnection: Keep-Alive\r\nCache-Control: no-cache\r\nUser-Agent: Java/1.7.0\r\nHost: " + host + "\r\n" + authentication + "\r\n";
        return postRequest;
    }

    @Override
    public void run() {
        while (!this.isShutdown) {
            try {
                MediaFrame mediaFrameToSend = this.take();
                for (byte[] singlePayLoad : mediaFrameToSend.getPayload()) {
                    this.sendAudio(singlePayLoad);
                }
            }
            catch (InterruptedException exception) {
                this.logger.info("Sending thread interrupted for " + this);
            }
        }
        this.logger.info("Shutting down " + this);
    }

    public String toString() {
        String toString = "Axis audio out server [Host=[" + this.networkParameter.getHost() + "], " + (!this.networkParameter.useHTTPS() ? "HTTP port=[" + this.networkParameter.getHTTPport() : "HTTPS port=[" + this.networkParameter.getSSLport()) + "]]";
        return toString;
    }

    @Override
    public int shutdown() {
        this.isShutdown = true;
        this.thread.interrupt();
        try {
            if (this.postSocket != null) {
                this.postSocket.close();
            }
        }
        catch (IOException ioe) {
            this.logger.info("Error closing socket for " + this);
        }
        this.postSocket = null;
        return super.shutdown();
    }
}

