/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.avigilon;

import de.seetec.v5.re.cm.configuration.definition.camera.VideoCameraDefinition;
import de.seetec.v5.re.cm.configuration.definition.device.DeviceDefinition;
import de.seetec.v5.re.cm.device.shared.VideoServer;
import de.seetec.v5.re.cm.device.shared.io.IOHandler;
import de.seetec.v5.re.cm.device.shared.onvif.EventMessageDescription;
import de.seetec.v5.re.cm.device.shared.onvif.OnvifCore;
import de.seetec.v5.re.cm.device.shared.onvif.OnvifDevice;
import de.seetec.v5.re.cm.device.shared.onvif.OnvifException;
import de.seetec.v5.re.cm.device.video.avigilon.AvigilonEventHandler;
import de.seetec.v5.re.cm.device.video.avigilon.AvigilonIoHandler;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;
import java.util.Map;

public final class AvigilonDevice
extends VideoServer {
    private OnvifCore onvifCore = null;
    private AvigilonEventHandler avigilonEventHandler = null;
    private final Object SEMAPHORE = new Object();
    private Map<String, EventMessageDescription> eventTypesMap = null;

    @Override
    protected final IOHandler createIOHandler() {
        return new AvigilonIoHandler();
    }

    @Override
    protected final boolean isSupportingIO() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OnvifCore getOnvifCore() throws SeeTecException {
        if (this.onvifCore != null) {
            return this.onvifCore;
        }
        Object object = this.SEMAPHORE;
        synchronized (object) {
            try {
                if (this.onvifCore == null) {
                    NetworkParameter networkParameter = this.getDeviceCnf().getNetworkParameter();
                    if (networkParameter != null) {
                        this.onvifCore = new OnvifCore();
                        String user = null;
                        if (networkParameter.getUserPWD() != null && networkParameter.getUserPWD()[0] != null) {
                            user = networkParameter.getUserPWD()[0];
                        }
                        String password = null;
                        if (networkParameter.getUserPWD() != null && networkParameter.getUserPWD()[1] != null) {
                            password = networkParameter.getUserPWD()[1];
                        }
                        boolean useAuthorization = false;
                        if (user != null && password != null) {
                            useAuthorization = true;
                        }
                        String passwordType = "PasswordDigest";
                        OnvifDevice onvifDevice = new OnvifDevice(this.getDeviceEntity().getEntityName(), networkParameter, user, password, "PasswordDigest", useAuthorization);
                        try {
                            this.onvifCore.init(onvifDevice, this.logger.isDebugEnabled());
                            return this.onvifCore;
                        }
                        catch (OnvifException onvifException) {
                            this.onvifCore.shutdown();
                            throw new SeeTecException(onvifException.getErrorCode(), onvifException.getCause().getMessage());
                        }
                    }
                    return this.onvifCore;
                }
                throw new SeeTecException(-21601, "NetworkParameters are null");
            }
            catch (ConfigurationException exception) {
                this.logger.error("Problems while initializing ONVIF Core", (Throwable)exception);
                return null;
            }
        }
    }

    public AvigilonEventHandler getGenericOnvifEventHandler() {
        if (this.avigilonEventHandler == null) {
            try {
                this.avigilonEventHandler = new AvigilonEventHandler();
                this.avigilonEventHandler.init(this.getOnvifCore());
            }
            catch (SeeTecException exception) {
                this.logger.warn("GenericOnvifEventHandler could not be initialized", (Throwable)exception);
            }
        }
        return this.avigilonEventHandler;
    }

    @Override
    public int shutdown() {
        if (this.avigilonEventHandler != null) {
            this.avigilonEventHandler.shutdown();
            this.avigilonEventHandler = null;
        }
        return super.shutdown();
    }

    public Map<String, EventMessageDescription> getEventTypesMap() {
        if (this.eventTypesMap == null) {
            try {
                this.eventTypesMap = this.getOnvifCore().getEventService().getEventProperties();
            }
            catch (Throwable throwable) {
                this.logger.warn("Could not receive event list from " + this, throwable);
            }
        }
        return this.eventTypesMap;
    }

    @Override
    protected DeviceDefinition getDeviceDefinitionFromDevice(String signature, String manufacturer, String name, String comments) throws SeeTecException {
        return null;
    }

    @Override
    protected VideoCameraDefinition getVideoCameraDefinitionFromDevice() throws SeeTecException {
        return null;
    }
}

