/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.arh;

import de.seetec.v5.re.cm.device.shared.motiondetection.HardwareMotionDetection;
import de.seetec.v5.re.cm.device.shared.motiondetection.MotionDetectionHandler;
import de.seetec.v5.re.cm.device.shared.net.HttpPersistentConnectionHandler;
import de.seetec.v5.re.cm.device.shared.net.HttpPersistentConnectionListenerIntf;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.ConfigurationException;
import org.apache.logging.log4j.LogManager;

public class ARHMotionDetectionHandler
extends MotionDetectionHandler
implements Runnable,
HttpPersistentConnectionListenerIntf {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.arh.ARHMotionDetectionHandler";
    private Thread myThread = null;
    private NetworkParameter networkParameter = null;
    private HttpPersistentConnectionHandler httpPersistentConnectionHandler;
    private String motionDetectionURL;

    public ARHMotionDetectionHandler() {
        this.logger = LogManager.getLogger((String)CLASS_NAME);
    }

    @Override
    public int init(HardwareMotionDetection<? extends MotionDetectionHandler> hardwareMotionDetection) {
        this.listener = hardwareMotionDetection;
        if (this.listener == null) {
            return -20003;
        }
        this.motionDetectionURL = "/scapture?ajaxcall=1&multipart=1";
        this.myThread = new Thread((Runnable)this, this.toString());
        this.myThread.start();
        return 0;
    }

    @Override
    public int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        if (this.httpPersistentConnectionHandler != null) {
            this.httpPersistentConnectionHandler.shutdown();
            this.httpPersistentConnectionHandler = null;
        }
        super.shutdown();
        return 0;
    }

    @Override
    public void run() {
        int TIME_FOR_ITERATION = 100;
        int errorCode = 0;
        try {
            this.networkParameter = this.listener.getVideoSrv().getDevice().getDeviceCnf().getNetworkParameter();
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
        this.httpPersistentConnectionHandler = new HttpPersistentConnectionHandler();
        this.httpPersistentConnectionHandler.init(this, this.networkParameter, this.motionDetectionURL, 100);
        errorCode = this.httpPersistentConnectionHandler.startPersistentConnection(true);
        if (errorCode != 0) {
            this.logger.error("Error while reading HTTP persistent connection data for " + this + ", Errorcode: " + errorCode);
        }
    }

    public String toString() {
        String sThis = "de.seetec.v5.re.cm.device.video.arh.ARHMotionDetectionHandler@" + Integer.toHexString(this.hashCode());
        return "[ " + sThis.substring(sThis.lastIndexOf(46) + 1) + ", [ " + (this.listener == null ? "VideoSrv is null" : this.listener.getVideoSrv()) + " ] ]";
    }

    @Override
    public void deliverContent(byte[] httpPersistentConnectionContent) {
        String detectionData = new String(httpPersistentConnectionContent);
        if (detectionData.contains("imgmdresult=") && !detectionData.contains("imgmdresult=0")) {
            this.listener.evaluateWindow(0);
        }
    }

    @Override
    public void sendStatusService(int statusCode) {
        if (this.isShutdown(CLASS_NAME)) {
            return;
        }
        if (statusCode != 0) {
            this.listener.notifyForNetworkProblems();
        }
    }
}

