/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.arecont;

import de.seetec.v5.re.cm.device.shared.Device;
import de.seetec.v5.re.cm.device.shared.MotionRecording;
import de.seetec.v5.re.cm.device.shared.genericevent.GenericEventTriggerCnf;
import de.seetec.v5.re.cm.device.shared.genericevent.GenericEventTriggerHandler;
import de.seetec.v5.re.cm.device.video.arecont.ArecontCameraSrv;
import de.seetec.v5.re.cm.device.video.arecont.ArecontDevice;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;
import java.util.List;

class ArecontTriggerHandler
extends GenericEventTriggerHandler {
    private ArecontDevice arecontDevice = null;
    private ArecontCameraSrv videoSrv = null;
    private String channel = "";

    ArecontTriggerHandler(MotionRecording motionRecording, ArecontCameraSrv videoSrv) {
        super(motionRecording);
        this.videoSrv = videoSrv;
    }

    @Override
    public int init(Device device, List<GenericEventTriggerCnf> genericEventTriggerCnfs) {
        this.device = device;
        this.arecontDevice = (ArecontDevice)device;
        this.core = device.getCore();
        this.genericEventTriggerCnfs = genericEventTriggerCnfs;
        try {
            if (this.videoSrv.isPanoramicModel()) {
                this.channel = String.valueOf(this.videoSrv.getVideoSourceCnf().getPtzAddress());
            }
            this.arecontDevice.sendSetCommand(this.channel, "mdtotalzones", "1024");
            String motionDetect = this.arecontDevice.sendSetCommand(this.channel, "motiondetect", "on");
            if (!motionDetect.contains("on")) {
                this.logger.error("It was not possible to activate motion detection on the camera for " + this.device);
                return -20000;
            }
        }
        catch (ConfigurationException ex) {
            this.logger.error("Channel number could not be read from configuration for " + this);
            return -20000;
        }
        catch (SeeTecException ex) {
            this.logger.error("Generic Event motion could not be activated for " + this);
            return -20000;
        }
        Thread thread = new Thread((Runnable)this, "ArecontTriggerHandler");
        thread.start();
        return 0;
    }

    @Override
    public void run() {
        while (!this.isShutdown() && !this.device.isShutdown()) {
            try {
                String responseAsString = this.arecontDevice.sendGetCommand(this.channel, "mdresult");
                if (!responseAsString.isEmpty()) {
                    if (!responseAsString.contains("no motion")) {
                        for (GenericEventTriggerCnf genericEventTriggerCnf : this.getGenericEventTriggerCnfs()) {
                            if (genericEventTriggerCnf == null || !genericEventTriggerCnf.isEnabled() || !genericEventTriggerCnf.getGenericEventTriggerType().contains("mdresult")) continue;
                            this.forwardTrigger(genericEventTriggerCnf);
                        }
                    }
                } else {
                    this.logger.error("HTTP response doesn't seem to have body and content for " + this.videoSrv);
                    this.logger.error("Response was:" + responseAsString);
                }
                Thread.sleep(500L);
            }
            catch (Throwable t) {
                this.logger.warn("Error while requesting generic events for " + (this.videoSrv != null ? this.videoSrv : this), t);
            }
        }
    }
}

