/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.arecont;

import de.seetec.v5.re.cm.device.shared.motiondetection.HardwareMotionDetection;
import de.seetec.v5.re.cm.device.shared.motiondetection.MotionDetectionHandler;
import de.seetec.v5.re.cm.device.video.arecont.ArecontCameraSrv;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import org.apache.logging.log4j.LogManager;

public class ArecontMotionDetectionHandler
extends MotionDetectionHandler
implements Runnable {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.arecont.ArecontMotionDetectionHandler";
    private Thread myThread = null;
    private NetworkParameter networkParameter = null;
    private String url = null;
    private byte[] response = null;
    private String channel = "";

    public ArecontMotionDetectionHandler() {
        this.logger = LogManager.getLogger((String)CLASS_NAME);
    }

    @Override
    public int init(HardwareMotionDetection<? extends MotionDetectionHandler> hardwareMotionDetection) {
        throw new UnsupportedOperationException("Will not be called due to false in HardwareMotionDetection.init().");
    }

    public int init(HardwareMotionDetection<? extends MotionDetectionHandler> hardwareMotionDetection, String url) {
        block10: {
            this.listener = hardwareMotionDetection;
            if (this.listener == null) {
                return -20003;
            }
            this.url = url;
            if (this.url == null) {
                return -20003;
            }
            try {
                this.networkParameter = this.listener.getVideoSrv().getDevice().getDeviceCnf().getNetworkParameter();
                if (((ArecontCameraSrv)this.listener.getVideoSrv()).isPanoramicModel()) {
                    this.channel = String.valueOf(this.listener.getVideoSrv().getVideoSourceCnf().getPtzAddress());
                }
                NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)("/set" + this.channel + "?mdtotalzones=1024"), (int)Integer.MAX_VALUE);
                NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)("/set" + this.channel + "?motiondetect=on"), (int)Integer.MAX_VALUE);
                this.response = NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url, (int)Integer.MAX_VALUE);
                if (this.response != null) {
                    String responseAsString = new String(this.response);
                    if (responseAsString.startsWith("HTTP/1.0 200 OK")) {
                        String[] splittedResult = responseAsString.split("\r\n\r\n");
                        if (splittedResult.length >= 2) {
                            if (splittedResult[1].contains("Error")) {
                                this.logger.error("Error while processing test request for " + this.listener.getVideoSrv() + ". Response is:");
                                this.logger.error(splittedResult[1]);
                                return -20001;
                            }
                            break block10;
                        }
                        this.logger.error("HTTP response doesn't seem to have body and content for " + this.listener.getVideoSrv());
                        this.logger.error("Response was:" + responseAsString);
                        return -20001;
                    }
                    String[] tmpResult = responseAsString.split("\r\n");
                    if (tmpResult.length >= 1) {
                        this.logger.error("HTTP request seems to have a problem for " + this.listener.getVideoSrv() + ". First line of header: " + tmpResult[0]);
                    }
                    return -20001;
                }
                this.logger.error("Response to motion detection request is null for " + this.listener.getVideoSrv());
                return -20001;
            }
            catch (Exception e) {
                this.logger.error("Error while doing MD test request for " + this.listener.getVideoSrv(), (Throwable)e);
                return -20001;
            }
        }
        this.myThread = new Thread((Runnable)this, this.toString());
        this.myThread.start();
        return 0;
    }

    @Override
    public int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        this.url = null;
        this.response = null;
        super.shutdown();
        return 0;
    }

    @Override
    public void run() {
        long TIME_FOR_ITERATION = 500L;
        long time = 0L;
        long sleep = 0L;
        while (!this.isShutdown(CLASS_NAME)) {
            try {
                time = System.currentTimeMillis();
                this.response = NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)this.url, (int)Integer.MAX_VALUE);
                if (this.response != null) {
                    String responseAsString = new String(this.response);
                    if (responseAsString.startsWith("HTTP/1.0 200 OK")) {
                        String[] splittedResult = responseAsString.split("\r\n\r\n");
                        if (splittedResult.length >= 2) {
                            if (!splittedResult[1].startsWith("mdresult=no motion")) {
                                this.listener.evaluateWindow(0);
                            }
                        } else {
                            this.logger.error("HTTP response doesn't seem to have body and content for " + this.listener.getVideoSrv());
                            this.logger.error("Response was:" + responseAsString);
                        }
                    } else {
                        String[] tmpResult = responseAsString.split("\r\n");
                        if (tmpResult.length >= 1) {
                            this.logger.error("HTTP request seems to have a problem for " + this.listener.getVideoSrv() + ". First line of header: " + tmpResult[0]);
                        }
                    }
                } else {
                    this.logger.error("Response to motion detection request is null for " + this.listener.getVideoSrv());
                }
            }
            catch (Throwable ex) {
                this.logger.error("Error while requesting md for " + (this.listener != null ? this.listener.getVideoSrv() : this), ex);
            }
            sleep = 500L - (System.currentTimeMillis() - time);
            if (sleep > 0L) {
                try {
                    Thread.sleep(sleep);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            if (sleep >= -1000L) continue;
            this.logger.warn("Request took quite long: " + Math.abs(sleep) + "ms for " + this.listener.getVideoSrv());
        }
    }

    public String toString() {
        String thisDescription = "de.seetec.v5.re.cm.device.video.arecont.ArecontMotionDetectionHandler@" + Integer.toHexString(this.hashCode());
        String videoSrvToString = "Unknown";
        if (this.listener != null && this.listener.getVideoSrv() != null) {
            videoSrvToString = this.listener.getVideoSrv().toString();
        }
        return "[" + thisDescription.substring(thisDescription.lastIndexOf(46) + 1) + ", [" + videoSrvToString + "]]";
    }
}

