/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.archive;

import de.seetec.v5.re.cm.Core;
import de.seetec.v5.re.cm.configuration.definition.camera.VideoCameraDefinition;
import de.seetec.v5.re.cm.configuration.definition.device.DeviceDefinition;
import de.seetec.v5.re.cm.device.shared.Service;
import de.seetec.v5.re.cm.device.shared.VideoServer;
import de.seetec.v5.re.cm.device.shared.io.IOHandler;
import de.seetec.v5.re.cm.device.video.archive.ArchiveCameraSrv;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.proxy.ent.Entity;
import de.seetec.v5.shared.util.SeeTecException;

public class ArchiveDevice
extends VideoServer {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.archive.ArchiveDevice";

    @Override
    public int init(Core core, long entityID) {
        int errorCode = super.init(core, entityID);
        if (errorCode != 0) {
            this.logger.error("Initializing " + this + " failed with error [" + errorCode + "]");
            return errorCode;
        }
        Entity[] srvEnities = super.getSrvEntities();
        this.services = new Service[srvEnities.length];
        for (int i = 0; i < srvEnities.length; ++i) {
            Service lastService = null;
            try {
                long srvID = srvEnities[i].getEntityID();
                long srvType = srvEnities[i].getEntityType();
                String srvName = srvEnities[i].getEntityName();
                boolean enabled = srvEnities[i].isEnabled();
                if (!enabled) continue;
                this.logger.info("Service [" + srvID + "]/[" + srvName + "] with type [" + srvType + "] will be activated ...");
                if (srvType == 219800L) {
                    ArchiveCameraSrv cameraSrv = new ArchiveCameraSrv();
                    lastService = cameraSrv;
                    errorCode = cameraSrv.init(core, this, srvEnities[i]);
                    if (errorCode != 0) {
                        cameraSrv.shutdown();
                        this.logger.error("Creating " + (Object)((Object)lastService) + " failed with error [" + errorCode + "]");
                        return errorCode;
                    }
                    this.services[i] = cameraSrv;
                } else {
                    this.logger.warn("Service [" + Basic.longToFormattedString((long)srvType) + "] not supported for " + this);
                }
                if (!this.isShutdown(CLASS_NAME)) continue;
                this.logger.warn(this + " is already shutting down!");
                if (lastService == null) break;
                lastService.shutdown();
                break;
            }
            catch (Exception ex) {
                if (lastService != null) {
                    lastService.shutdown();
                }
                this.logger.error("Creating " + this + " failed", (Throwable)ex);
                return -1;
            }
        }
        return 0;
    }

    @Override
    protected IOHandler createIOHandler() {
        throw new RuntimeException("No i/o supported for " + this);
    }

    @Override
    protected boolean isSupportingIO() {
        return false;
    }

    @Override
    protected DeviceDefinition getDeviceDefinitionFromDevice(String signature, String manufacturer, String name, String comments) throws SeeTecException {
        return null;
    }

    @Override
    protected VideoCameraDefinition getVideoCameraDefinitionFromDevice() throws SeeTecException {
        return null;
    }
}

