/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.aper;

import de.seetec.v5.re.cm.Core;
import de.seetec.v5.re.cm.device.shared.Device;
import de.seetec.v5.re.cm.device.shared.LiveCameraSrv;
import de.seetec.v5.re.cm.device.shared.cameracontrol.CameraControl;
import de.seetec.v5.re.cm.device.shared.cameracontrol.DoNothingCameraControl;
import de.seetec.v5.re.cm.device.shared.videoprofile.AdditionalVideoProfileHandler;
import de.seetec.v5.re.cm.device.shared.videoprofile.BasicVideoProfileHandler;
import de.seetec.v5.re.cm.device.shared.videoprofile.VideoProfileHandler;
import de.seetec.v5.re.cm.device.shared.videosource.VideoSourceClient;
import de.seetec.v5.re.cm.device.video.aper.AperDevice;
import de.seetec.v5.re.cm.device.video.aper.AperOnvifVideoSourceClient;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.re.shared.ContentFrame;
import de.seetec.v5.shared.proxy.ent.Entity;
import de.seetec.v5.shared.util.SeeTecException;

public final class AperCameraSrv
extends LiveCameraSrv {
    public static final String PROFILE_1 = "MAIN_PROFILE";
    public static final String PROFILE_2 = "SECOND_PROFILE";
    public static final String VIDEO_SOURCE_1 = "general_vsource";
    public static final String VIDEO_ENCODER_1 = "main_vencoder";
    public static final String VIDEO_ENCODER_2 = "second_vencoder";
    public static final String AUDIO_SOURCE_1 = "general_asource";
    public static final String AUDIO_ENCODER_1 = "main_aencoder";
    public static final String AUDIO_ENCODER_2 = "second_aencoder";
    private int preparationError = 0;
    private boolean basicConfigurationIsSet = false;
    private boolean invertStreams = false;

    public int init(Core core, Device device, Entity entity, int preparationError) {
        this.preparationError = preparationError;
        return this.init(core, device, entity);
    }

    @Override
    public CameraControl createCameraControl(Long entityType) {
        return new DoNothingCameraControl();
    }

    @Override
    public VideoSourceClient createVideoSourceClient(Core core, VideoProfileHandler listener) throws SeeTecException {
        int errorCode = 0;
        AperOnvifVideoSourceClient videoSourceClient = null;
        this.logger.info("Creating new [ VideoSourceClient ] with VideoProfileHandler=" + listener + " ...");
        try {
            if (this.preparationError != 0) {
                errorCode = this.preparationError;
            } else {
                AperDevice aperDevice = (AperDevice)this.getDevice();
                if (aperDevice.isOnvifDevice()) {
                    AperOnvifVideoSourceClient aperOnvifVideoSourceClient = videoSourceClient = new AperOnvifVideoSourceClient();
                    String profileToken = "";
                    Codec streamingMode = listener.getVideoSourceParameter().getMediaCodec();
                    if (listener instanceof BasicVideoProfileHandler) {
                        if (streamingMode == Codec.MJPEG) {
                            this.invertStreams = true;
                            profileToken = PROFILE_2;
                            if (this.getAdditionalVideoProfileHandler().length == 0) {
                                aperOnvifVideoSourceClient.setStream(PROFILE_1);
                            }
                        } else if (streamingMode == Codec.H264) {
                            profileToken = PROFILE_1;
                            this.invertStreams = false;
                        }
                        this.basicConfigurationIsSet = true;
                    } else if (listener instanceof AdditionalVideoProfileHandler) {
                        if (streamingMode == Codec.MJPEG) {
                            if (this.basicConfigurationIsSet) {
                                profileToken = PROFILE_2;
                                this.invertStreams = false;
                            }
                        } else if (streamingMode == Codec.H264) {
                            profileToken = this.invertStreams ? PROFILE_1 : PROFILE_2;
                        }
                    }
                    aperOnvifVideoSourceClient.setProfile(profileToken);
                    errorCode = videoSourceClient.init(core, this, listener);
                }
            }
            if (errorCode != 0) {
                if (videoSourceClient != null) {
                    videoSourceClient.shutdown();
                    videoSourceClient = null;
                }
                this.logger.error("Initializing [ VideoSourceClient ] for " + this + " failed with error [ " + errorCode + " ]");
                throw new SeeTecException(errorCode, "Initializing [VideoSourceClient] for " + this + " failed with error [" + errorCode + "]");
            }
        }
        catch (SeeTecException seetecEx) {
            throw seetecEx;
        }
        catch (Throwable throwable) {
            if (videoSourceClient != null) {
                videoSourceClient.shutdown();
                videoSourceClient = null;
            }
            this.logger.error((Object)throwable, throwable);
            this.logger.error("Creating [ VideoSourceClient ] for " + this + " failed");
            throw new SeeTecException(-20001, "Creating [VideoSourceClient] for " + this + " failed");
        }
        return videoSourceClient;
    }

    @Override
    public ContentFrame getJpegSnapshot(Integer[] nResolution) throws SeeTecException {
        throw new UnsupportedOperationException();
    }
}

