/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.americandynamics;

import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPStreamSettings;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingVideoSourceClientRTSP;
import de.seetec.v5.re.cm.device.video.americandynamics.AmericanDynamicsCameraSrv;
import de.seetec.v5.re.cm.shared.Tools;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.net.RTSPStatusCode;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.ByteArrayOutputStream;

public final class AmericanDynamicsVideoSourceClient400
extends StreamingVideoSourceClientRTSP {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.americandynamics.AmericanDynamicsVideoSourceClient400";
    private int profileId = 1;

    @Override
    public int init() {
        this.errorCode = 0;
        super.setRunFinished(CLASS_NAME, false);
        this.completeFrame = new ByteArrayOutputStream();
        this.networkParameter.setSoTimeout(5000);
        try {
            byte[] r;
            this.errorCode = super.init();
            if (this.errorCode != 0) {
                this.logger.error("Error while initializing. Code: " + this.errorCode + " for " + this);
                return this.errorCode;
            }
            AmericanDynamicsCameraSrv americanDynamicsCameraSrv = (AmericanDynamicsCameraSrv)this.getVideoSrv();
            this.profileId = 1;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("/vb.htm?");
            stringBuilder.append("profile").append(this.profileId).append("format=");
            stringBuilder.append(this.videoCodec == Codec.H264 ? "H.264" : "JPEG");
            stringBuilder.append("&profile").append(this.profileId).append("resolution=");
            stringBuilder.append(this.width).append("x").append(this.height);
            int[] availableFps = new int[this.videoCodec == Codec.H264 ? 7 : 25];
            if (this.videoCodec == Codec.H264) {
                availableFps[0] = 3;
                availableFps[1] = 5;
                availableFps[2] = 7;
                availableFps[3] = 10;
                availableFps[4] = 12;
                availableFps[5] = 15;
                availableFps[6] = 25;
            } else {
                for (int i = 0; i < 25; ++i) {
                    availableFps[i] = i + 1;
                }
            }
            this.fps /= 1000L;
            this.fps = this.fps < 1L ? 1L : this.fps;
            this.fps = this.fps > 25L ? 25L : this.fps;
            this.fps = Tools.convertToCameraValues(availableFps, (int)this.fps);
            stringBuilder.append("&profile").append(this.profileId).append("rate=");
            stringBuilder.append(this.fps);
            if (this.videoCodec == Codec.H264) {
                stringBuilder.append("&profile").append(this.profileId).append("keyframeinterval=");
                this.iFrameDist = Tools.convertIFrameDistMStoFrameCount(this.fps * 1000L, this.iFrameDistMS, 1, 30);
                stringBuilder.append(this.iFrameDist);
                stringBuilder.append("&profile").append(this.profileId).append("qmode=");
                stringBuilder.append(this.isConstantBitrateUsed ? "0" : "1");
                if (this.isConstantBitrateUsed) {
                    this.bandwidth /= 1024;
                    int[] availableBitrates = new int[]{64, 128, 200, 256, 512, 1024, 2048, 4096};
                    stringBuilder.append("&profile").append(this.profileId).append("bps=");
                    this.bandwidth = Tools.convertToCameraValues(availableBitrates, this.bandwidth);
                    String bandwidthAsString = "4M";
                    if (this.bandwidth == 64) {
                        bandwidthAsString = "64K";
                    } else if (this.bandwidth == 128) {
                        bandwidthAsString = "128K";
                    } else if (this.bandwidth == 200) {
                        bandwidthAsString = "200K";
                    } else if (this.bandwidth == 256) {
                        bandwidthAsString = "256K";
                    } else if (this.bandwidth == 512) {
                        bandwidthAsString = "512K";
                    } else if (this.bandwidth == 1024) {
                        bandwidthAsString = "1M";
                    } else if (this.bandwidth == 2048) {
                        bandwidthAsString = "2M";
                    } else if (this.bandwidth == 4096) {
                        bandwidthAsString = "4M";
                    }
                    stringBuilder.append(bandwidthAsString);
                }
            }
            if (this.videoCodec == Codec.MJPEG || this.videoCodec == Codec.H264 && !this.isConstantBitrateUsed) {
                this.quality /= 1000;
                int qualityValue = 0;
                if (this.quality < 20) {
                    qualityValue = 4;
                } else if (this.quality < 40) {
                    qualityValue = 3;
                } else if (this.quality < 60) {
                    qualityValue = 2;
                } else if (this.quality < 80) {
                    qualityValue = 1;
                }
                stringBuilder.append("&profile").append(this.profileId).append("quality=");
                stringBuilder.append(qualityValue);
            }
            if (new String(r = NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)stringBuilder.toString(), (int)Integer.MAX_VALUE)).contains("UA ")) {
                return -21657;
            }
            try {
                americanDynamicsCameraSrv.setImageParameter400(this, this.useDateTime, this.useTitle, this.title);
            }
            catch (Exception exception) {
                this.logger.warn("Could not set image parameter for " + this);
                this.logger.warn((Object)exception);
            }
            if (this.isAudioEnabled) {
                NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)"/vb.htm?audioinenable=1", (int)Integer.MAX_VALUE);
                if (this.audioCodec == Codec.G711U) {
                    NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)"/vb.htm?audiotype=G.711", (int)Integer.MAX_VALUE);
                } else if (this.audioCodec == Codec.G726) {
                    NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)"/vb.htm?audiotype=G.726", (int)Integer.MAX_VALUE);
                }
            } else {
                NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)"/vb.htm?audioinenable=0", (int)Integer.MAX_VALUE);
            }
            NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)("/vb.htm?rtspport=" + this.listener.getVideoSourceParameter().getRtspPort()), (int)Integer.MAX_VALUE);
            NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)"/vb.htm?videocodec", (int)Integer.MAX_VALUE);
            this.rtspUrl = "rtsp://" + this.getHost() + ":" + this.listener.getVideoSourceParameter().getRtspPort() + "/live" + this.profileId + ".sdp";
            this.rtspSettings = new RTSPStreamSettings();
            if (this.rtspSettings.init(this, this.audioSourceClient, this.networkParameter, this.listener.getVideoSourceParameter().getRtspPort(), this.rtspUrl, this.printDebug, this.transmissionID, this.networkParameter.getSoTimeout(), this.isAudioEnabled, 4, this.rtspUrl) != 0) {
                this.logger.error("Error while initializing RTSP Settings for " + this);
                this.errorCode = -20001;
                return this.errorCode;
            }
            this.rtspSettings.setCodec(this.videoCodec);
            this.rtspHandler = this.rtspSettings.getRTSPHandler();
            this.errorCode = this.rtspHandler.start();
            if (this.errorCode != 0) {
                this.logger.error("Error while starting RTSP Handler for " + this);
                return this.errorCode;
            }
            this.logger.info("init done for" + this.getVideoSrv());
            return this.errorCode == RTSPStatusCode.RTSP_OK.getStatusCode() ? 0 : this.errorCode;
        }
        catch (SeeTecException seeTecException) {
            this.logger.error("Setting/adjusting parameters from " + this.getVideoSrv().getDevice() + " failed :-(", (Throwable)seeTecException);
            if (seeTecException.getErrorCode() == -21657) {
                return -21657;
            }
            return seeTecException.getErrorCode();
        }
        catch (Throwable throwable) {
            this.logger.error((Object)throwable, throwable);
            return this.errorCode;
        }
    }

    @Override
    public void sendStatusService(int nStatusCode) {
        this.listener.sendStatusService(nStatusCode);
    }

    public void notifyForNetworkProblems() {
        this.sendStatusService(-21603);
        this.listener.notifyForNetworkProblems();
        this.shutdown();
    }

    @Override
    public boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    @Override
    public void onNetworkError(int error) {
        this.listener.sendStatusService(error);
        this.shutdown();
    }

    @Override
    public void processData(byte[] data) {
        this.processRtpData(data);
    }

    @Override
    public synchronized int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        return super.shutdown();
    }

    public int changeFramerate(long framerate) {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("/vb.htm?");
            int[] availableFps = new int[this.videoCodec == Codec.H264 ? 7 : 25];
            if (this.videoCodec == Codec.H264) {
                availableFps[0] = 3;
                availableFps[1] = 5;
                availableFps[2] = 7;
                availableFps[3] = 10;
                availableFps[4] = 12;
                availableFps[5] = 15;
                availableFps[6] = 25;
            } else {
                for (int i = 0; i < 25; ++i) {
                    availableFps[i] = i + 1;
                }
            }
            framerate = (framerate /= 1000L) < 1L ? 1L : framerate;
            framerate = framerate > 25L ? 25L : framerate;
            framerate = Tools.convertToCameraValues(availableFps, (int)framerate);
            stringBuilder.append("&profile").append(this.profileId).append("rate=");
            stringBuilder.append(framerate);
            if (this.videoCodec == Codec.H264) {
                stringBuilder.append("&profile").append(this.profileId).append("keyframeinterval=");
                this.iFrameDist = Tools.convertIFrameDistMStoFrameCount(framerate * 1000L, this.iFrameDistMS, 1, 30);
                stringBuilder.append(this.iFrameDist);
            }
            byte[] result = NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)stringBuilder.toString(), (int)Integer.MAX_VALUE);
            this.logger.info(new String(result));
        }
        catch (SeeTecException exception) {
            this.logger.warn("Framerate could not be changed for " + this);
            this.logger.warn((Object)exception);
        }
        return 0;
    }
}

