/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.americandynamics;

import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPStreamSettings;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingVideoSourceClientRTSP;
import de.seetec.v5.re.cm.device.video.americandynamics.AmericanDynamicsCameraSrv;
import de.seetec.v5.re.cm.device.video.americandynamics.AmericanDynamicsDevice;
import de.seetec.v5.re.cm.shared.Tools;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.net.RTSPStatusCode;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.ByteArrayOutputStream;

public final class AmericanDynamicsVideoSourceClient
extends StreamingVideoSourceClientRTSP {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.americandynamics.AmericanDynamicsVideoSourceClient";

    @Override
    public int init() {
        this.errorCode = 0;
        super.setRunFinished(CLASS_NAME, false);
        this.completeFrame = new ByteArrayOutputStream();
        this.networkParameter.setSoTimeout(5000);
        try {
            this.errorCode = super.init();
            if (this.errorCode != 0) {
                this.logger.error("Error while initializing. Code: " + this.errorCode + " for " + this);
                return this.errorCode;
            }
            AmericanDynamicsCameraSrv americanDynamicsCameraSrv = (AmericanDynamicsCameraSrv)this.getVideoSrv();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("/cgi-bin/admin/param.cgi?action=update");
            String colorSystemCheckUrl = "/cgi-bin/admin/param.cgi?action=list&group=ImageSource.Sensor.ColorSystem";
            int maxFps = 25;
            byte[] colorSystemCheckResponse = NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)"/cgi-bin/admin/param.cgi?action=list&group=ImageSource.Sensor.ColorSystem", (int)Integer.MAX_VALUE);
            if (new String(colorSystemCheckResponse).split("ImageSource.Sensor.ColorSystem=")[1].substring(0, 1).equals("0")) {
                maxFps = 30;
            }
            String adCodec = americanDynamicsCameraSrv.transformCodec(this.videoCodec);
            String adResolution = americanDynamicsCameraSrv.transformResolution(this.width, this.height);
            stringBuilder.append("&Image.Appearance.PrimaryStream=").append(adCodec).append("(").append(adResolution).append(")");
            if (this.videoCodec == Codec.MJPEG) {
                this.quality /= 1000;
                this.quality = this.quality < 1 ? 1 : this.quality;
                stringBuilder.append("&Image.Appearance.Jpeg1Quality=").append(this.quality);
                this.fps /= 1000L;
                this.fps = this.fps < 1L ? 1L : this.fps;
                this.fps = this.fps > (long)maxFps ? (long)maxFps : this.fps;
                stringBuilder.append("&Image.Appearance.Jpeg1FrameRate=").append(this.fps);
            }
            if (this.videoCodec == Codec.H264) {
                this.fps /= 1000L;
                this.fps = this.fps < 1L ? 1L : this.fps;
                this.fps = this.fps > (long)maxFps ? (long)maxFps : this.fps;
                stringBuilder.append("&Image.Appearance.H2641FrameRate=").append(this.fps);
                int gop = Tools.convertIFrameDistMStoFrameCount(this.fps * 1000L, this.iFrameDistMS, 1, 50);
                stringBuilder.append("&Image.Appearance.H2641GOP=").append(gop);
                String rateControl = this.isConstantBitrateUsed ? "0" : "1";
                stringBuilder.append("&Image.Appearance.H2641RateControl=").append(rateControl);
                if (this.isConstantBitrateUsed) {
                    this.bandwidth /= 1024;
                    this.bandwidth = this.bandwidth < 500 ? 500 : this.bandwidth;
                    this.bandwidth = this.bandwidth > 8000 ? 8000 : this.bandwidth;
                    stringBuilder.append("&Image.Appearance.H2641BitRate=").append(this.bandwidth);
                } else {
                    this.quality /= 1000;
                    this.quality = this.quality * 51 / 100;
                    int qpMin = this.quality - 5;
                    qpMin = qpMin < 0 ? 0 : qpMin;
                    qpMin = qpMin > 51 ? 51 : qpMin;
                    int qpMax = this.quality + 5;
                    qpMax = qpMax < 30 ? 30 : qpMax;
                    qpMax = qpMax > 51 ? 51 : qpMax;
                    stringBuilder.append("&Image.Appearance.H2641RCMinQP=").append(qpMin);
                    stringBuilder.append("&Image.Appearance.H2641RCMaxQP=").append(qpMax);
                }
            }
            NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)stringBuilder.toString(), (int)Integer.MAX_VALUE);
            try {
                americanDynamicsCameraSrv.setImageParameter(this);
            }
            catch (Exception exception) {
                this.logger.warn("Could not set image parameter for " + this);
                this.logger.warn((Object)exception);
            }
            this.rtspUrl = "rtsp://" + this.getHost() + ":" + ((AmericanDynamicsDevice)this.getVideoSrv().getDevice()).getRtspPort() + "/primarystream";
            this.rtspSettings = new RTSPStreamSettings();
            if (this.rtspSettings.init(this, this.audioSourceClient, this.networkParameter, ((AmericanDynamicsDevice)this.getVideoSrv().getDevice()).getRtspPort(), this.rtspUrl, this.printDebug, this.transmissionID, this.networkParameter.getSoTimeout(), this.isAudioEnabled, 4, this.rtspUrl) != 0) {
                this.logger.error("Error while initializing RTSP Settings for " + this);
                this.errorCode = -20001;
                return this.errorCode;
            }
            this.rtspSettings.setCodec(this.videoCodec);
            this.rtspHandler = this.rtspSettings.getRTSPHandler();
            this.errorCode = this.rtspHandler.start();
            if (this.errorCode != 0) {
                this.logger.error("Error while starting RTSP Handler for " + this);
                return this.errorCode;
            }
            this.logger.info("init done for" + this.getVideoSrv());
            return this.errorCode == RTSPStatusCode.RTSP_OK.getStatusCode() ? 0 : this.errorCode;
        }
        catch (SeeTecException seeTecException) {
            this.logger.error("Setting/adjusting parameters from " + this.getVideoSrv().getDevice() + " failed", (Throwable)seeTecException);
            if (seeTecException.getErrorCode() == -21657) {
                return -21657;
            }
            return seeTecException.getErrorCode();
        }
        catch (Throwable throwable) {
            this.logger.error((Object)throwable, throwable);
            return this.errorCode;
        }
    }

    @Override
    public void sendStatusService(int nStatusCode) {
        this.listener.sendStatusService(nStatusCode);
    }

    public void notifyForNetworkProblems() {
        this.sendStatusService(-21603);
        this.listener.notifyForNetworkProblems();
        this.shutdown();
    }

    @Override
    public boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    @Override
    public void onNetworkError(int error) {
        this.listener.sendStatusService(error);
        this.shutdown();
    }

    @Override
    public void processData(byte[] data) {
        this.processRtpData(data);
    }

    @Override
    public synchronized int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        return super.shutdown();
    }

    public int changeFramerate(long framerate) {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("/cgi-bin/admin/param.cgi?action=update");
            framerate = (framerate /= 1000L) < 1L ? 1L : framerate;
            long l = framerate = framerate > 30L ? 30L : framerate;
            if (this.videoCodec == Codec.MJPEG) {
                stringBuilder.append("&Image.Appearance.Jpeg1FrameRate=").append(framerate);
            } else if (this.videoCodec == Codec.H264) {
                stringBuilder.append("&Image.Appearance.H2641FrameRate=").append(framerate);
                int gop = Tools.convertIFrameDistMStoFrameCount(framerate * 1000L, this.iFrameDistMS, 1, 50);
                stringBuilder.append("&Image.Appearance.H2641GOP=").append(gop);
            }
            byte[] result = NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)stringBuilder.toString(), (int)Integer.MAX_VALUE);
            this.logger.info(new String(result));
        }
        catch (SeeTecException exception) {
            this.logger.warn("Framerate could not be changed for " + this);
            this.logger.warn((Object)exception);
        }
        return 0;
    }
}

