/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.americandynamics;

import de.seetec.v5.re.cm.device.shared.motiondetection.HardwareMotionDetection;
import de.seetec.v5.re.cm.device.shared.motiondetection.MotionDetectionHandler;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.SeeTecException;
import org.apache.logging.log4j.LogManager;

public final class AmericanDynamicsMotionDetectionHandler400
extends MotionDetectionHandler
implements Runnable {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.americandynamics.AmericanDynamicsMotionDetectionHandler400";
    private Thread myThread = null;
    private NetworkParameter networkParameter = null;

    public AmericanDynamicsMotionDetectionHandler400() {
        this.logger = LogManager.getLogger((String)CLASS_NAME);
    }

    @Override
    public int init(HardwareMotionDetection<? extends MotionDetectionHandler> hardwareMotionDetection) {
        this.listener = hardwareMotionDetection;
        if (this.listener == null) {
            return -20003;
        }
        try {
            this.networkParameter = this.listener.getVideoSrv().getDevice().getDeviceCnf().getNetworkParameter();
            this.networkParameter.setSoTimeout(5000);
            String enableRequest = "/vb.htm?motionenable=1";
            byte[] enableResponse = NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)enableRequest, (int)Integer.MAX_VALUE);
            this.logger.info(new String(enableResponse));
        }
        catch (SeeTecException e) {
            this.logger.error("Error while doing MD test request for " + this.listener.getVideoSrv());
            return e.getErrorCode();
        }
        catch (Exception e) {
            this.logger.error("Error while doing MD test request for " + this.listener.getVideoSrv());
            this.logger.warn((Object)e, (Throwable)e);
            return -20001;
        }
        this.myThread = new Thread((Runnable)this, this.toString());
        this.myThread.start();
        return 0;
    }

    @Override
    public int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        super.shutdown();
        return 0;
    }

    @Override
    public void run() {
        int TIME_FOR_ITERATION = 500;
        super.setRunFinished(CLASS_NAME, false);
        long time = System.currentTimeMillis();
        try {
            String motionDetectionUrl = "/vb.htm?getalarmstatus";
            while (!this.isShutdown(CLASS_NAME)) {
                if (System.currentTimeMillis() - time < 500L) {
                    Thread.sleep(500L + time - System.currentTimeMillis());
                }
                if (this.isShutdown(CLASS_NAME)) continue;
                time = System.currentTimeMillis();
                byte[] result = NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)"/vb.htm?getalarmstatus", (int)Integer.MAX_VALUE);
                String[] alarmStatus = new String(result).split("getalarmstatus=");
                if ((Byte.valueOf(alarmStatus[1].substring(0, 4)) & 4) != 4) continue;
                this.listener.evaluateWindow(0);
            }
        }
        catch (Throwable ex) {
            this.logger.warn("Exception for " + this.listener.getVideoSrv());
            this.logger.fatal((Object)ex, ex);
            this.shutdown();
        }
    }
}

