/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.americandynamics;

import de.seetec.v5.re.cm.device.shared.io.DigitalInputSrv;
import de.seetec.v5.re.cm.device.shared.io.IOHandler;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.IOException;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.UnknownHostException;

public final class AmericanDynamicsIoHandler400
extends IOHandler {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.americandynamics.AmericanDynamicsIoHandler400";

    @Override
    public void run() {
        super.setRunFinished(CLASS_NAME, false);
        try {
            boolean previousLoopWithError = false;
            DigitalInputSrv[] iServices = super.getDigitalInputSrv();
            while (!(this.isShutdown(CLASS_NAME) || super.isShutdown() || this.device.isShutdown())) {
                try {
                    long duration;
                    long ts = System.currentTimeMillis();
                    this.readDigitalInputs();
                    if (previousLoopWithError) {
                        previousLoopWithError = false;
                        this.logger.info("Publishing input stati after error for " + this + " ...");
                        DigitalInputSrv[] digitalInputSrvArray = iServices;
                        int n = digitalInputSrvArray.length;
                        for (int i = 0; i < n; ++i) {
                            DigitalInputSrv iService = digitalInputSrvArray[i];
                            if (!iService.getEntity().isEnabled().booleanValue()) continue;
                            iService.publishServiceStatus(iService.getInputStatus());
                        }
                    }
                    if ((duration = System.currentTimeMillis() - ts) < 0L || duration >= 190L) continue;
                    try {
                        Thread.sleep(200L - duration);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                catch (Throwable ex) {
                    previousLoopWithError = true;
                    if (ex instanceof IOException || ex instanceof UnknownHostException || ex instanceof NoRouteToHostException || ex instanceof ConnectException) {
                        this.logger.warn("Network trouble for " + this);
                    } else {
                        this.logger.warn((Object)ex, ex);
                        if (ex.getMessage().contains("Address already in use")) {
                            this.logger.warn("TCP stack seems to be overloaded, so there are problems for " + this);
                        } else {
                            this.logger.warn("Unknown trouble for " + this);
                        }
                    }
                    try {
                        for (DigitalInputSrv iService : iServices) {
                            if (!iService.getEntity().isEnabled().booleanValue()) continue;
                            iService.publishServiceStatus(-21603);
                        }
                    }
                    catch (Throwable t) {
                        this.logger.warn((Object)t, t);
                    }
                    long tsTimeout = System.currentTimeMillis() + 10000L;
                    while (tsTimeout > System.currentTimeMillis() && !this.isShutdown(CLASS_NAME) && !this.device.isShutdown()) {
                        try {
                            Thread.sleep(250L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
        }
        this.logger.info("Thread of this " + this + " finished");
        super.setRunFinished(CLASS_NAME, true);
        this.shutdown();
    }

    private int readDigitalInputs() throws Exception {
        DigitalInputSrv[] iServices = super.getDigitalInputSrv();
        String url = "/vb.htm?getalarmstatus";
        byte[] result = NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)"/vb.htm?getalarmstatus", (int)Integer.MAX_VALUE);
        String[] alarmStatus = new String(result).split("getalarmstatus=");
        this.logger.info(alarmStatus[1]);
        byte value = Byte.valueOf(alarmStatus[1].substring(0, 4));
        if ((value & 1) == 1) {
            this.readInputs(iServices, 0, true);
        } else {
            this.readInputs(iServices, 0, false);
        }
        return 0;
    }

    private void readInputs(DigitalInputSrv[] iServices, int inputNumber, boolean active) {
        if (active) {
            iServices[2 * inputNumber].checkInput(1);
            iServices[2 * inputNumber + 1].checkInput(1);
        } else {
            iServices[2 * inputNumber].checkInput(0);
            iServices[2 * inputNumber + 1].checkInput(0);
        }
    }

    @Override
    public int writeDigitalOutput(int number, int value, long holdTime) {
        try {
            IOHandler.HoldTimer holdTimer;
            int errorCode;
            if (this.logger.isDebugEnabled()) {
                this.logger.info("Writing value [" + value + "] to output [" + number + "] with HoldTime [" + holdTime + "] for " + this + " ...");
            }
            NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)("/vb.htm?giooutalwayson=" + (value == 1 ? 1 : 0)), (int)Integer.MAX_VALUE);
            if (holdTime > 0L && (errorCode = (holdTimer = new IOHandler.HoldTimer()).init(number - 1, value > 0 ? 0 : 1, holdTime)) != 0) {
                holdTimer.shutdown();
                this.logger.warn("Creating " + holdTimer + " failed with error [" + errorCode + "]");
            }
            return 0;
        }
        catch (SeeTecException seeTecException) {
            this.logger.error((Object)seeTecException, (Throwable)seeTecException);
            return seeTecException.getErrorCode();
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
            return -21600;
        }
    }

    @Override
    protected final int discard() {
        return 0;
    }
}

