/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.americandynamics;

import de.seetec.v5.re.cm.Core;
import de.seetec.v5.re.cm.device.shared.LiveCameraSrv;
import de.seetec.v5.re.cm.device.shared.cameracontrol.CameraControl;
import de.seetec.v5.re.cm.device.shared.cameracontrol.DoNothingCameraControl;
import de.seetec.v5.re.cm.device.shared.videoprofile.VideoProfileHandler;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingVideoSourceClientRTSP;
import de.seetec.v5.re.cm.device.shared.videosource.VideoSourceClient;
import de.seetec.v5.re.cm.device.video.americandynamics.AmericanDynamicsVideoSourceClient;
import de.seetec.v5.re.cm.device.video.americandynamics.AmericanDynamicsVideoSourceClient400;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.re.shared.ContentFrame;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.proxy.ent.Entity;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;

public final class AmericanDynamicsCameraSrv
extends LiveCameraSrv {
    @Override
    public CameraControl createCameraControl(Long nEntityType) {
        return new DoNothingCameraControl();
    }

    @Override
    public VideoSourceClient createVideoSourceClient(Core core, VideoProfileHandler listener) throws SeeTecException {
        StreamingVideoSourceClientRTSP videoSourceClient;
        block15: {
            videoSourceClient = null;
            long entityType = super.getEntityType();
            try {
                this.logger.info("StreamingMode for " + this + " is [" + this.getVideoSourceCnf().getMediaCodec() + "]");
                if (entityType == 214500L || entityType == 214502L || entityType == 214503L || entityType == 214504L) {
                    videoSourceClient = new AmericanDynamicsVideoSourceClient();
                } else if (entityType == 214501L) {
                    videoSourceClient = new AmericanDynamicsVideoSourceClient400();
                }
                if (videoSourceClient == null) {
                    throw new SeeTecException(-20001, "Creating [VideoSourceClient] for " + this + " failed");
                }
                int errorCode = videoSourceClient.init(core, this, listener);
                if (errorCode != 0) {
                    videoSourceClient.shutdown();
                    videoSourceClient = null;
                    this.logger.error("Initializing [VideoSourceClient] for " + this + " failed with error [" + errorCode + "]");
                    throw new SeeTecException(errorCode, "Initializing [VideoSourceClient] for " + this + " failed with error [" + errorCode + "]");
                }
                long[] typeList = new long[]{9808L};
                Entity[] entities = this.device.getEnabledEntities(new long[]{this.getEntityID()}, typeList);
                if (entities.length != 0) break block15;
                try {
                    if (entityType == 214500L || entityType == 214502L || entityType == 214503L || entityType == 214504L) {
                        String enableRequest = "/cgi-bin/admin/param.cgi?action=update&Motion.Enable=0";
                        byte[] enableResponse = NetworkHelper.readGetRequest((NetworkParameter)this.getDevice().getDeviceCnf().getNetworkParameter(), (String)enableRequest, (int)Integer.MAX_VALUE);
                        this.logger.info(new String(enableResponse));
                    } else if (entityType == 214501L) {
                        String enableRequest = "/vb.htm?motionenable=0";
                        byte[] enableResponse = NetworkHelper.readGetRequest((NetworkParameter)this.getDevice().getDeviceCnf().getNetworkParameter(), (String)enableRequest, (int)Integer.MAX_VALUE);
                        this.logger.info(new String(enableResponse));
                    }
                }
                catch (SeeTecException e) {
                    this.logger.warn("Error while disable MD for " + this);
                }
                catch (Exception e) {
                    this.logger.warn("Error while disable MD for " + this);
                    this.logger.warn((Object)e, (Throwable)e);
                }
            }
            catch (SeeTecException seeTecException) {
                throw seeTecException;
            }
            catch (Throwable throwable) {
                if (videoSourceClient != null) {
                    videoSourceClient.shutdown();
                    videoSourceClient = null;
                }
                this.logger.error((Object)throwable, throwable);
                this.logger.error("Creating [VideoSourceClient] for " + this + " failed");
                throw new SeeTecException(-20001, "Creating [VideoSourceClient] for " + this + " failed");
            }
        }
        return videoSourceClient;
    }

    @Override
    public ContentFrame getJpegSnapshot(Integer[] nResolution) throws SeeTecException {
        throw new SeeTecException(-20009, "NOT YET IMPLEMENTED");
    }

    public void setImageParameter(VideoSourceClient videoSourceClient) throws SeeTecException, ConfigurationException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("/cgi-bin/admin/param.cgi?action=update&ImageSource.Sensor.Mirror=").append(videoSourceClient.getRotationAngle() == 180 ? "3" : "0");
        NetworkHelper.readGetRequest((NetworkParameter)this.getDevice().getDeviceCnf().getNetworkParameter(), (String)stringBuilder.toString(), (int)Integer.MAX_VALUE);
    }

    public void setImageParameter400(VideoSourceClient videoSourceClient, boolean useDateTime, boolean useTitle, String title) throws SeeTecException, ConfigurationException {
        NetworkHelper.readGetRequest((NetworkParameter)this.getDevice().getDeviceCnf().getNetworkParameter(), (String)("/vb.htm?tstampenable=" + (useDateTime ? "1" : "0")), (int)Integer.MAX_VALUE);
        NetworkHelper.readGetRequest((NetworkParameter)this.getDevice().getDeviceCnf().getNetworkParameter(), (String)("/vb.htm?tstamplabel=" + (useTitle ? title : "")), (int)Integer.MAX_VALUE);
        NetworkHelper.readGetRequest((NetworkParameter)this.getDevice().getDeviceCnf().getNetworkParameter(), (String)("/vb.htm?flip=" + (videoSourceClient.getRotationAngle() == 180 ? "1" : "0")), (int)Integer.MAX_VALUE);
        NetworkHelper.readGetRequest((NetworkParameter)this.getDevice().getDeviceCnf().getNetworkParameter(), (String)("/vb.htm?mirror=" + (videoSourceClient.getRotationAngle() == 180 ? "1" : "0")), (int)Integer.MAX_VALUE);
    }

    public String transformCodec(Codec givenCodec) {
        if (givenCodec == Codec.H264) {
            return "H264";
        }
        if (givenCodec == Codec.MJPEG) {
            return "MJPEG";
        }
        return "OFF";
    }

    public String transformResolution(int width, int height) {
        if (width == 1920 && height == 1080) {
            return "1080P";
        }
        if (width == 1280 && height == 960) {
            return "SXVGA";
        }
        if (width == 1280 && height == 720) {
            return "720P";
        }
        if (width == 1024 && height == 768) {
            return "XVGA";
        }
        if (width == 800 && height == 600) {
            return "SVGA";
        }
        if (width == 720 && (height == 480 || height == 576)) {
            return "D1";
        }
        if (width == 640 && height == 480) {
            return "VGA";
        }
        if (width == 704 && (height == 480 || height == 576)) {
            return "4CIF";
        }
        if (width == 704 && (height == 240 || height == 288)) {
            return "2CIF";
        }
        if (width == 352 && (height == 240 || height == 288)) {
            return "CIF";
        }
        return "...";
    }
}

