/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.acutvista.mpeg;

import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPStreamSettings;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingVideoSourceClientRTSP;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;

public class AcutvistaMPEGVideoSourceClient
extends StreamingVideoSourceClientRTSP {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.acutvista.mpeg.AcutvistaMPEGVideoSourceClient";
    private boolean isPal = true;
    private int compression;
    private int profile;
    private long framerate;
    private int bitrate;
    private Codec streamingMode;
    private byte[] result = null;
    private String[] cameraParameters = null;
    private String[] nameValuePair;
    private boolean fpsChanged = false;
    private boolean rtspPortChanged = false;
    private boolean iFrameDistChanged = false;
    private boolean bitrateChanged = false;
    private boolean compressionChanged = false;
    private boolean audioCodecChanged = false;
    private boolean clockEnabledChanged = false;
    private boolean dateEnabledChanged = false;
    private boolean useTitleChanged = false;
    private boolean titleChanged = false;
    private boolean audioBitrateChanged = false;
    private boolean audioUseChanged = false;
    private boolean rateControlChanged = false;

    private String readCameraValue(String[] cameraParameters, String parameterName) {
        if (cameraParameters != null && parameterName != null && !parameterName.isEmpty()) {
            for (String cameraParameter : cameraParameters) {
                if (!cameraParameter.contains(parameterName)) continue;
                this.nameValuePair = cameraParameter.split("=");
                if (this.nameValuePair.length < 2) continue;
                String result = this.nameValuePair[1];
                if (result.indexOf("\n") == 0) {
                    return null;
                }
                if (result.indexOf("\n") > 0) {
                    result = result.substring(0, result.indexOf("\n"));
                }
                return result;
            }
        }
        return null;
    }

    private int getAllowedValue(int value, int[] allowedValues) {
        if (value <= allowedValues[0]) {
            return allowedValues[0];
        }
        if (value >= allowedValues[allowedValues.length - 1]) {
            return allowedValues[allowedValues.length - 1];
        }
        for (int i = 0; i < allowedValues.length - 1; ++i) {
            if (value == allowedValues[i]) {
                return value;
            }
            if (value <= allowedValues[i] || value >= allowedValues[i + 1]) continue;
            if (value < (allowedValues[i] + allowedValues[i + 1]) / 2) {
                return allowedValues[i];
            }
            return allowedValues[i + 1];
        }
        return -1;
    }

    @Override
    public final int init() {
        try {
            this.errorCode = super.init();
            if (this.errorCode != 0) {
                this.logger.error("Error while initializing. Code: " + this.errorCode + " for " + this);
                return this.errorCode;
            }
            try {
                this.streamingMode = this.getVideoSrv().getVideoSourceCnf().getMediaCodec();
            }
            catch (ConfigurationException ex) {
                this.logger.error("Configuration exception while reading streaming mode for " + this + ": " + ex.getMessage());
            }
            try {
                this.result = NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)"/param.cgi?action=list", (int)Integer.MAX_VALUE);
                String resultString = new String(this.result);
                this.cameraParameters = resultString.split("\n");
            }
            catch (SeeTecException ex) {
                this.logger.error("Error reading camera configuration for " + this + ": " + ex.getMessage());
                return ex.getErrorCode();
            }
            this.isPal = this.readCameraValue(this.cameraParameters, "ImageSource.I0.Video.DetectedType").equals("pal");
            this.profile = this.streamingMode == Codec.MPEG4 ? (this.width == 704 ? 4 : (this.width == 352 ? 5 : 6)) : (this.width == 704 ? 1 : (this.width == 352 ? 2 : 3));
            this.framerate = (this.fps + 999L) / 1000L;
            long l = this.framerate = this.framerate < 1L ? 1L : this.framerate;
            this.framerate = this.isPal ? (this.framerate > 25L ? 25L : this.framerate) : (this.framerate > 30L ? 30L : this.framerate);
            this.iFrameDist = this.framerate * (long)this.iFrameDistMS / 1000L;
            int[] allowedIFrameDist = new int[]{1, 3, 5, 10, 30, 60, 90, 120};
            this.iFrameDist = this.getAllowedValue((int)this.iFrameDist, allowedIFrameDist);
            if (this.isConstantBitrateUsed) {
                this.bitrate = this.bandwidth / 1024;
                if (this.profile == 1 || this.profile == 4) {
                    this.bitrate = this.bitrate < 384 ? 384 : this.bitrate;
                    this.bitrate = this.bitrate > 4096 ? 4096 : this.bitrate;
                } else if (this.profile == 2 || this.profile == 5) {
                    this.bitrate = this.bitrate < 128 ? 128 : this.bitrate;
                    this.bitrate = this.bitrate > 2048 ? 2048 : this.bitrate;
                } else if (this.profile == 3 || this.profile == 6) {
                    this.bitrate = this.bitrate < 24 ? 24 : this.bitrate;
                    this.bitrate = this.bitrate > 512 ? 512 : this.bitrate;
                }
            } else {
                this.compression = (this.compression + 999) / 1000;
            }
            String parameter = this.readCameraValue(this.cameraParameters, "Image.I0.Stream" + this.profile + ".FPS");
            if (parameter == null || (long)Integer.parseInt(parameter) != this.framerate) {
                this.fpsChanged = true;
            }
            if ((parameter = this.readCameraValue(this.cameraParameters, "Image.I0.MPEG" + this.profile + ".PCount")) == null || (long)Integer.parseInt(parameter) != this.iFrameDist) {
                this.iFrameDistChanged = true;
            }
            if ((parameter = this.readCameraValue(this.cameraParameters, "Image.I0.Text.DateEnabled")) == null || parameter.equals("no") && this.useDateTime || parameter.equals("yes") && !this.useDateTime) {
                this.dateEnabledChanged = true;
            }
            if ((parameter = this.readCameraValue(this.cameraParameters, "Image.I0.Text.ClockEnabled")) == null || parameter.equals("no") && this.useDateTime || parameter.equals("yes") && !this.useDateTime) {
                this.clockEnabledChanged = true;
            }
            if ((parameter = this.readCameraValue(this.cameraParameters, "Image.I0.Text.TextEnabled")) == null || parameter.equals("no") && this.useTitle || parameter.equals("yes") && !this.useTitle) {
                this.useTitleChanged = true;
            }
            if ((parameter = this.readCameraValue(this.cameraParameters, "Image.I0.RateControl" + this.profile + ".TargetBitrate")) == null || Integer.parseInt(parameter) != this.bitrate) {
                this.bitrateChanged = true;
            }
            if ((parameter = this.readCameraValue(this.cameraParameters, "Image.I0.Appearance" + this.profile + ".Compression")) == null || Integer.parseInt(parameter) != this.compression) {
                this.compressionChanged = true;
            }
            if ((parameter = this.readCameraValue(this.cameraParameters, "Image.I0.RateControl" + this.profile + ".Mode")) == null || this.isConstantBitrateUsed && parameter.equals("vbr") || !this.isConstantBitrateUsed && parameter.equals("cbr")) {
                this.rateControlChanged = true;
            }
            if (this.isAudioEnabled) {
                parameter = this.readCameraValue(this.cameraParameters, "AudioSource.A0.AudioEncoding");
                if (parameter == null || !parameter.equals(this.audioCodec)) {
                    this.audioCodecChanged = true;
                }
                if ((parameter = this.readCameraValue(this.cameraParameters, "AudioSource.A0.BitRate")) == null || Integer.parseInt(parameter) != this.audioBitrate) {
                    this.audioBitrateChanged = true;
                }
                if ((parameter = this.readCameraValue(this.cameraParameters, "Audio.A0.Enabled")) == null || parameter.equals("no")) {
                    this.audioUseChanged = true;
                }
            }
            if ((parameter = this.readCameraValue(this.cameraParameters, "Network.RTSP.Port")) == null || Integer.parseInt(parameter) != this.listener.getVideoSourceParameter().getRtspPort()) {
                this.rtspPortChanged = true;
            }
            if (!(this.title == null || this.title.length() <= 0 || (parameter = this.readCameraValue(this.cameraParameters, "Image.I0.Text.String")) != null && parameter.equals(this.title))) {
                this.titleChanged = true;
            }
            StringBuilder sb = new StringBuilder(256);
            sb.append("/cgi-bin/param.cgi?action=update");
            if (this.fpsChanged) {
                sb.append("&Image.I0.Stream").append(this.profile).append(".FPS=").append(this.framerate);
            }
            if (this.iFrameDistChanged) {
                sb.append("&Image.I0.MPEG").append(this.profile).append(".PCount=").append(this.iFrameDist);
            }
            if (this.dateEnabledChanged) {
                sb.append("&Image.I0.Text.DateEnabled=").append(this.useDateTime ? "yes" : "no");
            }
            if (this.clockEnabledChanged) {
                sb.append("&Image.I0.Text.ClockEnabled=").append(this.useDateTime ? "yes" : "no");
            }
            if (this.useTitleChanged) {
                sb.append("&Image.I0.Text.TextEnabled=").append(this.useTitle ? "yes" : "no");
            }
            if (this.titleChanged && this.title != null && this.title.length() > 0) {
                String title = this.title.replace(" ", "+");
                if (title.length() > 20) {
                    title = title.substring(0, 19);
                }
                sb.append("&Image.I0.Text.String=").append(title);
            }
            if (this.rateControlChanged) {
                sb.append("&Image.I0.RateControl").append(this.profile).append(".Mode=").append(this.isConstantBitrateUsed ? "cbr" : "vbr");
            }
            if (this.isConstantBitrateUsed) {
                if (this.bitrateChanged) {
                    sb.append("&Image.I0.RateControl").append(this.profile).append(".TargetBitrate=").append(this.bitrate);
                }
            } else if (this.compressionChanged) {
                sb.append("&Image.I0.Appearance").append(this.profile).append(".Compression=").append(this.compression);
            }
            if (this.isAudioEnabled) {
                if (this.audioCodecChanged) {
                    sb.append("&AudioSource.A0.AudioEncoding=");
                    sb.append(this.audioCodec);
                }
                if (this.audioBitrateChanged) {
                    sb.append("&AudioSource.A0.BitRate=");
                    sb.append(this.audioBitrate);
                }
                if (this.audioUseChanged) {
                    sb.append("&Audio.A0.Enabled=yes");
                }
            }
            if (this.rtspPortChanged) {
                sb.append("&Network.RTSP.Port=").append(this.listener.getVideoSourceParameter().getRtspPort());
            }
            if (this.audioBitrateChanged || this.audioCodecChanged || this.audioUseChanged || this.bitrateChanged || this.clockEnabledChanged || this.compressionChanged || this.dateEnabledChanged || this.fpsChanged || this.iFrameDistChanged || this.rtspPortChanged || this.useTitleChanged || this.rateControlChanged) {
                try {
                    this.result = NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)sb.toString(), (int)Integer.MAX_VALUE);
                }
                catch (SeeTecException e) {
                    this.logger.error("Exception while setting parameters for " + this.getVideoSrv(), (Throwable)e);
                    return e.getErrorCode();
                }
            }
            sb = this.streamingMode == Codec.MPEG4 ? new StringBuilder("rtsp://" + this.getHost() + "/mpeg4/media.amp?resolution=") : new StringBuilder("rtsp://" + this.getHost() + "/h264/media.amp?resolution=");
            this.resolutionTag = "";
            if (this.profile == 1 || this.profile == 4) {
                this.resolutionTag = "4cif";
            } else if (this.profile == 2 || this.profile == 5) {
                this.resolutionTag = "cif";
            } else if (this.profile == 3 || this.profile == 6) {
                this.resolutionTag = "qcif";
            } else {
                this.logger.error("Resolution not supported for " + this);
            }
            sb.append(this.resolutionTag);
            this.rtspUrl = sb.toString();
            this.rtspSettings = new RTSPStreamSettings();
            this.errorCode = this.rtspSettings.init(this, this.audioSourceClient, this.networkParameter, this.listener.getVideoSourceParameter().getRtspPort(), this.rtspUrl, this.printDebug, this.transmissionID, this.networkParameter.getSoTimeout(), this.isAudioEnabled, 4, this.rtspUrl);
            if (this.errorCode != 0) {
                this.logger.error("Initialization of RTSPSettings failed with errorCode: " + this.errorCode + " for " + this.getVideoSrv());
                return this.errorCode;
            }
            this.rtspHandler = this.rtspSettings.getRTSPHandler();
            this.errorCode = this.rtspHandler.start();
            if (this.errorCode != 0) {
                this.logger.error(" Start of RTSPHandler failed with errorCode: " + this.errorCode + " for " + this.getVideoSrv());
                return this.errorCode;
            }
            return 0;
        }
        catch (Throwable t) {
            this.logger.error("Unexpected exception while initialization for " + this, t);
            return -20000;
        }
    }

    @Override
    public final void onNetworkError(int error) {
        if (this.isShutdown()) {
            return;
        }
        this.logger.warn("Shutting down : " + error);
        this.listener.sendStatusService(error);
        this.shutdown();
    }

    @Override
    public final boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    @Override
    public final void processData(byte[] data) {
        this.processRtpData(data);
    }

    @Override
    public final void sendStatusService(int errorCode) {
        this.listener.sendStatusService(errorCode);
    }

    @Override
    public final int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        return super.shutdown();
    }
}

