/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.acutvista.jpeg;

import de.seetec.v5.re.cm.device.shared.net.httpserverpush.HttpServerPushHandler;
import de.seetec.v5.re.cm.device.shared.net.httpserverpush.HttpServerPushListenerIntf;
import de.seetec.v5.re.cm.device.shared.videosource.JPEGVideoSourceClient;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;

public class AcutvistaJPEGVideoSourceClient
extends JPEGVideoSourceClient
implements HttpServerPushListenerIntf {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.acutvista.jpeg.AcutvistaJPEGVideoSourceClient";
    private long fps;
    private int compression;
    private int profile;
    private String[] nameValuePair;
    private String[] cameraParameters;
    private boolean fpsChanged = false;
    private boolean rtspPortChanged = false;
    private boolean compressionChanged = false;
    private boolean clockEnabledChanged = false;
    private boolean dateEnabledChanged = false;
    private boolean useTitleChanged = false;
    private boolean titleChanged = false;

    public long getMilliCompression() {
        return this.quality;
    }

    @Override
    protected boolean isRunFinished() {
        return super.isRunFinished(CLASS_NAME);
    }

    @Override
    public int init() {
        int errorCode = super.init(false);
        if (errorCode != 0) {
            this.logger.error("Error while initializing. Code: " + errorCode + " for " + this);
            return errorCode;
        }
        try {
            this.compression = (this.compression + 999) / 1000;
            this.profile = this.width == 704 ? 7 : (this.width == 352 ? 8 : 9);
            this.cameraParameters = this.readCameraParameters();
            String parameter = this.readCameraValue(this.cameraParameters, "Image.I0.Text.DateEnabled");
            if (parameter == null || parameter.equals("no") && this.useDateTime || parameter.equals("yes") && !this.useDateTime) {
                this.dateEnabledChanged = true;
            }
            if ((parameter = this.readCameraValue(this.cameraParameters, "Image.I0.Text.ClockEnabled")) == null || parameter.equals("no") && this.useDateTime || parameter.equals("yes") && !this.useDateTime) {
                this.clockEnabledChanged = true;
            }
            if ((parameter = this.readCameraValue(this.cameraParameters, "Image.I0.Text.TextEnabled")) == null || parameter.equals("no") && this.useTitle || parameter.equals("yes") && !this.useTitle) {
                this.useTitleChanged = true;
            }
            if ((parameter = this.readCameraValue(this.cameraParameters, "Image.I0.Appearance" + this.profile + ".Compression")) == null || Integer.parseInt(parameter) != this.compression) {
                this.compressionChanged = true;
            }
            if ((parameter = this.readCameraValue(this.cameraParameters, "Network.RTSP.Port")) == null || Integer.parseInt(parameter) != this.listener.getVideoSourceParameter().getRtspPort()) {
                this.rtspPortChanged = true;
            }
            if (!(this.title == null || this.title.trim().length() <= 0 || (parameter = this.readCameraValue(this.cameraParameters, "Image.I0.Text.String")) != null && parameter.equals(this.title.trim()))) {
                this.titleChanged = true;
            }
            StringBuffer sb = new StringBuffer(256);
            sb.append("/cgi-bin/param.cgi?action=update");
            if (this.compressionChanged) {
                sb.append("&Image.I0.Appearance").append(this.profile).append(".Compression=").append(this.compression);
            }
            if (this.rtspPortChanged) {
                sb.append("&Network.RTSP.Port=").append(this.listener.getVideoSourceParameter().getRtspPort());
            }
            if (this.dateEnabledChanged) {
                sb.append("&Image.I0.Text.DateEnabled=").append(this.useTitle ? "yes" : "no");
            }
            if (this.clockEnabledChanged) {
                sb.append("&Image.I0.Text.ClockEnabled=").append(this.useDateTime ? "yes" : "no");
            }
            if (this.useTitleChanged) {
                sb.append("&Image.I0.Text.TextEnabled=").append(this.useTitle ? "yes" : "no");
            }
            if (this.titleChanged && this.title != null && this.title.trim().length() > 0) {
                String title = this.title.trim().replace(" ", "+");
                if (title.length() > 20) {
                    title = title.substring(0, 19);
                }
                sb.append("&Image.I0.Text.String=").append(title);
            }
            if (this.fpsChanged || this.rtspPortChanged || this.compressionChanged || this.clockEnabledChanged || this.dateEnabledChanged || this.useTitleChanged || this.titleChanged) {
                NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)sb.toString(), (int)Integer.MAX_VALUE);
            }
            this.cameraParameters = this.readCameraParameters();
            this.fps = (this.highestFramerate + 999L) / 1000L;
            this.fps = this.fps < 1L ? 1L : this.fps;
            int highestFramerateOnCamera = Integer.parseInt(this.readCameraValue(this.cameraParameters, "Image.I0.RateControl" + this.profile + ".MaxFPS"));
            this.fps = this.fps > (long)highestFramerateOnCamera ? (long)highestFramerateOnCamera : this.fps;
            parameter = this.readCameraValue(this.cameraParameters, "Image.I0.Stream" + this.profile + ".FPS");
            if (parameter == null || (long)Integer.parseInt(parameter) != this.fps) {
                this.fpsChanged = true;
            }
            sb = new StringBuffer(256);
            sb.append("/cgi-bin/param.cgi?action=update");
            if (this.fpsChanged) {
                sb.append("&Image.I0.Stream").append(this.profile).append(".FPS=").append(this.fps);
            }
            if (this.fpsChanged) {
                NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)sb.toString(), (int)Integer.MAX_VALUE);
            }
        }
        catch (SeeTecException ex) {
            this.logger.error("Exception while setting camera parameters for " + this + ": " + ex.getMessage() + ", Errorcode: " + ex.getErrorCode());
            return ex.getErrorCode();
        }
        catch (Throwable ex) {
            this.logger.error("Trouble with JPEGServerPushStream of " + super.getVideoSrv());
            this.logger.error((Object)ex, ex);
            errorCode = -21651;
        }
        this.myThread = new Thread((Runnable)this, this.toString());
        this.myThread.start();
        return errorCode;
    }

    @Override
    public void run() {
        super.setRunFinished(CLASS_NAME, false);
        try {
            this.networkParameter = super.getVideoSrv().getDevice().getDeviceCnf().getNetworkParameter();
        }
        catch (ConfigurationException ex) {
            this.logger.error("Exception while retrieveing network parameters for " + this + ": " + ex.getMessage());
        }
        this.networkParameter.setSoTimeout(5000);
        boolean asynchronous = false;
        HttpServerPushHandler httpServerPushHandler = new HttpServerPushHandler();
        StringBuilder serverPushUrl = new StringBuilder("/mjpg/video.cgi?resolution=");
        if (this.profile == 7) {
            serverPushUrl.append("4cif");
        } else if (this.profile == 8) {
            serverPushUrl.append("cif");
        } else if (this.profile == 9) {
            serverPushUrl.append("qcif");
        } else {
            this.logger.error("Resolution not supported for " + this);
        }
        int errorCode = httpServerPushHandler.init(this, this.networkParameter, serverPushUrl.toString());
        if (errorCode != 0) {
            this.logger.error("Error [" + errorCode + "]with " + httpServerPushHandler);
        } else {
            errorCode = httpServerPushHandler.startServerPush(asynchronous);
            if (errorCode != 0) {
                this.logger.warn("ServerPush of " + httpServerPushHandler + " terminated with error [" + errorCode + "]");
            }
        }
        httpServerPushHandler.shutdown();
        this.logger.info("End grabbing images for " + this);
        super.setRunFinished(CLASS_NAME, true);
        this.shutdown();
    }

    public int changeFramerate(int framerate) {
        int fps = (int)(((long)framerate + 999L) / 1000L);
        fps = fps < 1 ? 1 : fps;
        try {
            this.cameraParameters = this.readCameraParameters();
        }
        catch (SeeTecException ex) {
            this.logger.error("Exception while reading camera parameters for " + this + ": " + ex.getMessage());
            return ex.getErrorCode();
        }
        int highestFramerate = Integer.parseInt(this.readCameraValue(this.cameraParameters, "Image.I0.RateControl" + this.profile + ".MaxFPS"));
        fps = fps > highestFramerate ? highestFramerate : fps;
        try {
            NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)("/cgi-bin/param.cgi?action=update&Image.I0.Stream" + this.profile + ".FPS=" + fps), (int)Integer.MAX_VALUE);
        }
        catch (SeeTecException ex) {
            this.logger.error("Exception while changing framerate for " + this + ex.getMessage());
            return -21654;
        }
        return 0;
    }

    private String[] readCameraParameters() throws SeeTecException {
        try {
            byte[] result = NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)"/param.cgi?action=list", (int)Integer.MAX_VALUE);
            String resultString = new String(result);
            return resultString.split("\n");
        }
        catch (SeeTecException ex) {
            this.logger.error("Error reading camera configuration for " + this + ": " + ex.getMessage());
            throw ex;
        }
    }

    @Override
    public void sendStatusService(int statusCode) {
        this.listener.sendStatusService(statusCode);
    }

    @Override
    public void notifyForNetworkProblems() {
        this.sendStatusService(-21603);
        this.shutdown();
    }

    private String readCameraValue(String[] cameraParameters, String parameterName) {
        if (cameraParameters != null && parameterName != null && !parameterName.isEmpty()) {
            for (String cameraParameter : cameraParameters) {
                if (!cameraParameter.contains(parameterName)) continue;
                this.nameValuePair = cameraParameter.split("=");
                if (this.nameValuePair.length < 2) continue;
                String result = this.nameValuePair[1];
                if (result.indexOf("\n") == 0) {
                    return null;
                }
                if (result.indexOf("\n") > 0) {
                    result = result.substring(0, result.indexOf("\n"));
                }
                return result;
            }
        }
        return null;
    }
}

