/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.acutvista;

import de.seetec.v5.re.cm.device.shared.motiondetection.HardwareMotionDetection;
import de.seetec.v5.re.cm.device.shared.motiondetection.MotionDetectionHandler;
import de.seetec.v5.re.cm.device.shared.net.httpserverpush.HttpServerPushContent;
import de.seetec.v5.re.cm.device.shared.net.httpserverpush.HttpServerPushHandler;
import de.seetec.v5.re.cm.device.shared.net.httpserverpush.HttpServerPushListenerIntf;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import org.apache.logging.log4j.LogManager;

public class AcutvistaMotionDetectionHandler
extends MotionDetectionHandler
implements HttpServerPushListenerIntf {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.acutvista.AcutvistaMotionDetectionHandler";
    private HttpServerPushHandler httpServerPushHandler = null;
    private NetworkParameter networkParameter = null;

    public AcutvistaMotionDetectionHandler() {
        this.logger = LogManager.getLogger((String)CLASS_NAME);
    }

    @Override
    public int init(HardwareMotionDetection<? extends MotionDetectionHandler> hardwareMotionDetection) {
        int errorCode;
        block10: {
            this.listener = hardwareMotionDetection;
            if (this.listener == null) {
                return -20003;
            }
            try {
                this.networkParameter = this.listener.getVideoSrv().getDevice().getDeviceCnf().getNetworkParameter();
                String sRequest = "/cgi-bin/operator/param.cgi?action=list&group=Motion";
                byte[] response = NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)sRequest, (int)Integer.MAX_VALUE);
                if (!new String(response).contains("WindowType")) {
                    this.logger.warn("Motion Detection on camera DISABLED for " + this.listener.getVideoSrv() + "\n\tTrying to enable ONE motion detection window. For other setups, please configure motion detection on camera");
                    String enableMotionDetection = "/param.cgi?action=update&Motion.M0.Left=1&Motion.M0.Top=1&Motion.M0.Right=9999&Motion.M0.Bottom=9999&Motion.M0.Name=DefaultWindow&Motion.M0.Sensitivity=90&Motion.M0.ObjectSize=15&Motion.M0.WindowType=include";
                    if (NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)enableMotionDetection, (int)Integer.MAX_VALUE) == null) {
                        this.logger.warn("Could not enable motion detection on camera for " + this.listener.getVideoSrv());
                        return -21664;
                    }
                }
            }
            catch (Exception e) {
                this.logger.error("Error while testing connectivity to motion detection for " + this.listener.getVideoSrv(), (Throwable)e);
                return -20053;
            }
            String url = "/motion/motiondata.cgi";
            try {
                try {
                    this.networkParameter.setSoTimeout(10000);
                    this.httpServerPushHandler = new HttpServerPushHandler();
                    errorCode = this.httpServerPushHandler.init(this, this.networkParameter, url);
                    if (errorCode != 0) {
                        this.logger.error("Error [" + errorCode + "] with " + this.httpServerPushHandler);
                        break block10;
                    }
                    errorCode = this.httpServerPushHandler.startServerPush(true);
                }
                catch (Exception e) {
                    this.logger.error("Reading configuration from " + this.listener.getVideoSrv().getDevice() + " failed");
                    errorCode = -21601;
                }
            }
            catch (Throwable ex) {
                this.logger.error((Object)ex, ex);
                errorCode = -21651;
            }
        }
        return errorCode;
    }

    @Override
    public int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        if (this.httpServerPushHandler != null) {
            this.httpServerPushHandler.shutdown();
            this.httpServerPushHandler = null;
        }
        super.shutdown();
        return 0;
    }

    @Override
    public final boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    @Override
    public void sendStatusService(int nStatusCode) {
        if (this.isShutdown(CLASS_NAME)) {
            return;
        }
        if (nStatusCode != 0) {
            this.listener.notifyForNetworkProblems();
        }
    }

    @Override
    public void notifyForNetworkProblems() {
        this.sendStatusService(-21650);
    }

    @Override
    public void deliverContent(HttpServerPushContent httpServerPushContent) {
        boolean hasDetected = false;
        byte[] content = httpServerPushContent.getContentBody();
        if (content != null) {
            String[] windows = new String(content).split("\r\n");
            for (int i = 0; i < windows.length; ++i) {
                block5: {
                    windows[i] = windows[i].substring(windows[i].indexOf("=") + 1);
                    String[] partsOfDetection = windows[i].split(";");
                    if (partsOfDetection.length != 3) {
                        this.logger.error("Wrong content line format. Discarding for " + this.listener.getVideoSrv());
                        continue;
                    }
                    try {
                        int level = Integer.parseInt(partsOfDetection[1].substring(partsOfDetection[1].indexOf("=") + 1));
                        int threshold = Integer.parseInt(partsOfDetection[2].substring(partsOfDetection[2].indexOf("=") + 1));
                        if (level < threshold) break block5;
                        hasDetected = true;
                    }
                    catch (NumberFormatException nfe) {
                        this.logger.error("Error while converting number for " + this.listener.getVideoSrv());
                        continue;
                    }
                }
                if (!hasDetected) continue;
                hasDetected = false;
                if (this.listener == null) continue;
                this.listener.evaluateWindow(i);
            }
        }
    }
}

