/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.acutvista;

import de.seetec.v5.re.cm.Core;
import de.seetec.v5.re.cm.device.shared.LiveCameraSrv;
import de.seetec.v5.re.cm.device.shared.cameracontrol.CameraControl;
import de.seetec.v5.re.cm.device.shared.videoprofile.VideoProfileHandler;
import de.seetec.v5.re.cm.device.shared.videosource.VideoSourceClient;
import de.seetec.v5.re.cm.device.video.acutvista.AcutvistaCameraControl;
import de.seetec.v5.re.cm.device.video.acutvista.jpeg.AcutvistaJPEGVideoSourceClient;
import de.seetec.v5.re.cm.device.video.acutvista.mpeg.AcutvistaMPEGVideoSourceClient;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.re.shared.ContentFrame;
import de.seetec.v5.shared.util.SeeTecException;

public class AcutvistaCameraSrv
extends LiveCameraSrv {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.acutvista.AcutvistaCameraSrv";

    @Override
    public CameraControl createCameraControl(Long nEntityType) {
        return new AcutvistaCameraControl();
    }

    @Override
    public VideoSourceClient createVideoSourceClient(Core core, VideoProfileHandler listener) throws SeeTecException {
        VideoSourceClient videoSourceClient = null;
        try {
            Codec streamingMode = listener.getVideoSourceParameter().getMediaCodec();
            videoSourceClient = streamingMode == Codec.MJPEG ? new AcutvistaJPEGVideoSourceClient() : new AcutvistaMPEGVideoSourceClient();
            int errorCode = videoSourceClient.init(core, this, listener);
            if (errorCode != 0) {
                videoSourceClient.shutdown();
                videoSourceClient = null;
                this.logger.error("Initializing [VideoSourceClient] for " + this + " failed with error [" + errorCode + "]");
                throw new SeeTecException(errorCode, "Initializing [VideoSourceClient] for " + this + " failed with error [" + errorCode + "]");
            }
        }
        catch (SeeTecException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            if (videoSourceClient != null) {
                videoSourceClient.shutdown();
                videoSourceClient = null;
            }
            this.logger.error((Object)ex, ex);
            this.logger.error("Creating [VideoSourceClient] for " + this + " failed");
            throw new SeeTecException(-20001, "Creating [VideoSourceClient] for " + this + " failed");
        }
        return videoSourceClient;
    }

    @Override
    public ContentFrame getJpegSnapshot(Integer[] nResolution) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

