/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.acti.mpeg;

import de.seetec.v5.re.cm.device.shared.net.TCPNetworkCallback;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingHelper;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingHelperH264;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingHelperMpeg4;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingVideoSourceClient;
import de.seetec.v5.re.cm.device.video.acti.ActiCameraSrv;
import de.seetec.v5.re.cm.device.video.acti.ActiDevice;
import de.seetec.v5.re.cm.device.video.acti.ActiHardwareMotionDetection;
import de.seetec.v5.re.cm.device.video.acti.ActiMotionDetectionHandler;
import de.seetec.v5.re.cm.device.video.acti.mpeg.ActiTCPReader;
import de.seetec.v5.re.cm.shared.Tools;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.re.shared.MediaFrame;
import de.seetec.v5.shared.net.HTTPStatusCode;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.SeeTecException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class ActiMPEGVideoSourceClient
extends StreamingVideoSourceClient
implements TCPNetworkCallback {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.acti.mpeg.ActiMPEGVideoSourceClient";
    private static final String FIRMWARE_EXTRACTION_ERROR = "Firmware version can't be extracted.";
    private static final String FIRMWARE_SUFFICIENT = "Firmware sufficient.";
    private static final String FIRMWARE_ERROR_1 = "Used firmware doesn't create valid JPEGs. Firmware has to be > 3.08.08";
    private static final String FIRMWARE_ERROR_2 = "Please update Firmware and try again!";
    private static final String FIRMWARE_VERSION_IDENTIFIER = "Firmware Version = ";
    private static final String ENCODER_CGI = "/cgi-bin/encoder?";
    private static final String SYSTEM_CGI = "/cgi-bin/system?";
    private static final String MPEG_CGI = "/cgi-bin/mpeg4?";
    private int controlPortBase = 6001;
    private int videoPortBase = 6002;
    private ActiTCPReader acti = null;
    private String bandwithAsString = null;
    private String resolutionString = null;
    private String modeIdentifier = null;
    private String modeIdentifierAsString = null;
    private String encoderType = null;
    private boolean isVideoLoss = false;
    private long streamID = 0L;
    private long[] allowedValues = null;
    private String user = "";
    private String pass = "";
    private StringBuilder passwordString;
    private String parameterString;

    @Override
    public int init() {
        StringBuffer url;
        ArrayList<Integer> ignoreHttpStatusCode = new ArrayList<Integer>();
        ignoreHttpStatusCode.add(404);
        this.errorCode = super.init();
        if (this.errorCode != 0) {
            this.logger.error("Error while initializing. Code: " + this.errorCode + " for " + this);
            return this.errorCode;
        }
        if (this.networkParameter.getUserPWD() != null) {
            this.user = this.networkParameter.getUserPWD()[0];
            this.pass = this.networkParameter.getUserPWD()[1];
        }
        this.passwordString = new StringBuilder();
        this.passwordString.append("USER=");
        this.passwordString.append(this.user);
        this.passwordString.append("&PWD=");
        this.passwordString.append(this.pass);
        ActiDevice actiDevice = (ActiDevice)this.getVideoSrv().getDevice();
        if (actiDevice.isEorDSeries()) {
            HashMap<String, String> parameters = new HashMap<String, String>();
            try {
                String tvMode = new String(NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)(SYSTEM_CGI + this.passwordString.toString() + "&VIDEO_TV"), (int)Integer.MAX_VALUE, (boolean)true));
                this.modeIdentifier = "P";
                if (tvMode.contains("NTSC")) {
                    this.modeIdentifier = "N";
                }
            }
            catch (SeeTecException ex) {
                this.logger.error("Exception while reading TV System for " + this);
                return ex.getErrorCode();
            }
            this.resolutionString = this.modeIdentifier + this.width + "x" + this.height;
            this.quality /= 1000;
            this.quality = this.quality == 0 ? 1 : this.quality;
            String h264Quality = ActiMPEGVideoSourceClient.getQualityAsString(this.quality);
            this.encoderType = this.videoCodec == Codec.H264 ? "H264" : "MJPEG";
            this.fps /= 1000L;
            if ("N".equalsIgnoreCase(this.modeIdentifier)) {
                this.modeIdentifierAsString = "NTSC";
                this.allowedValues = new long[]{1L, 3L, 5L, 10L, 15L, 30L};
                this.fps = Tools.convertToCameraValues(this.allowedValues, this.fps);
            } else {
                this.modeIdentifierAsString = "PAL";
                this.allowedValues = new long[]{1L, 3L, 5L, 8L, 12L, 25L};
                this.fps = Tools.convertToCameraValues(this.allowedValues, this.fps);
            }
            this.iFrameDist = (long)(this.iFrameDistMS / 1000) * this.fps;
            this.iFrameDist = this.iFrameDist < 1L ? 1L : this.iFrameDist;
            this.iFrameDist = this.iFrameDist > 150L ? 150L : this.iFrameDist;
            this.bandwidth /= 1024;
            this.bandwithAsString = ActiMPEGVideoSourceClient.getBandwidthAsString(this.bandwidth);
            if (((ActiCameraSrv)this.getVideoSrv()).isMultiStreamingUsed()) {
                this.logger.info("Multi-Streaming is used. StreamID: " + this.streamID + " for " + this);
            }
            parameters.put("VIDEO_ENCODER", this.encoderType);
            parameters.put("VIDEO_RESOLUTION", this.resolutionString);
            if (this.videoCodec == Codec.MJPEG) {
                parameters.put("VIDEO_MJPEG_QUALITY", "" + this.quality);
            } else if (this.isConstantBitrateUsed) {
                parameters.put("VIDEO_H264_QUALITY", "NONE");
                parameters.put("VIDEO_MAX_BITRATE", this.bandwithAsString);
            } else {
                parameters.put("VIDEO_H264_QUALITY", "" + h264Quality);
                parameters.put("VIDEO_GOP", "" + this.iFrameDist);
            }
            parameters.put("VIDEO_FPS_NUM", "" + this.fps);
            String rotateValue = this.rotationAngle == 180 ? "1" : "0";
            parameters.put("VIDEO_FLIP_MODE", rotateValue);
            parameters.put("VIDEO_MIRROR_MODE", rotateValue);
            ArrayList<String> parametersToRemove = new ArrayList<String>();
            boolean readConfig = true;
            for (Map.Entry entry : parameters.entrySet()) {
                String string = (String)entry.getKey();
                try {
                    if (this.readConfiguration(string, readConfig, parameters, this.streamID).equals(entry.getValue())) {
                        parametersToRemove.add(string);
                    }
                }
                catch (SeeTecException ex) {
                    this.logger.error("Exception while reading camera configuration for " + this + " : " + ex.getMessage());
                    return ex.getErrorCode();
                }
                readConfig = false;
            }
            for (String string : parametersToRemove) {
                parameters.remove(string);
            }
            if (!parameters.isEmpty()) {
                StringBuilder commandUrl = new StringBuilder(ENCODER_CGI + this.passwordString.toString());
                if (((ActiCameraSrv)this.getVideoSrv()).isMultiStreamingUsed()) {
                    commandUrl.append("&VIDEO_STREAM=DUAL");
                } else {
                    commandUrl.append("&VIDEO_STREAM=SINGLE");
                }
                commandUrl.append("&MEDIA=").append(this.streamID);
                for (Map.Entry<String, String> entry : parameters.entrySet()) {
                    commandUrl.append("&").append(entry.getKey()).append("=").append(entry.getValue());
                }
                try {
                    String string = commandUrl.toString().replace("?&", "?");
                    NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)string, (int)Integer.MAX_VALUE, (boolean)true);
                }
                catch (SeeTecException seeTecException) {
                    this.logger.error("Exception while setting image parameters for " + this + ": " + seeTecException.getMessage());
                    return seeTecException.getErrorCode();
                }
            }
        } else {
            byte[] result;
            block100: {
                this.passwordString.append("&CHANNEL=");
                this.passwordString.append(this.videoSourceNr);
                this.modeIdentifier = this.resolutionTag == null ? "P" : this.resolutionTag;
                this.resolutionString = this.modeIdentifier + this.width + "x" + this.height;
                this.quality /= 1000;
                int n = this.quality = this.quality == 0 ? 1 : this.quality;
                if (null != this.videoCodec) {
                    switch (this.videoCodec) {
                        case MPEG4: {
                            this.encoderType = "MPEG4";
                            break;
                        }
                        case H264: {
                            this.encoderType = "H264";
                            break;
                        }
                        default: {
                            this.encoderType = "MJPEG";
                        }
                    }
                }
                this.fps /= 1000L;
                if (this.allowedValues == null) {
                    if ("N".equalsIgnoreCase(this.modeIdentifier)) {
                        this.modeIdentifierAsString = "NTSC";
                        this.allowedValues = new long[]{1L, 2L, 3L, 4L, 5L, 6L, 7L, 10L, 15L, 30L};
                        this.fps = Tools.convertToCameraValues(this.allowedValues, this.fps);
                    } else {
                        this.modeIdentifierAsString = "PAL";
                        this.allowedValues = new long[]{1L, 2L, 3L, 4L, 5L, 6L, 8L, 12L, 25L};
                        this.fps = Tools.convertToCameraValues(this.allowedValues, this.fps);
                    }
                    if (this.fps > 2L) {
                        if (this.width == 1280 && this.height == 1024) {
                            this.fps = this.fps < 6L ? 4L : 8L;
                        } else if (this.width == 1280 && this.height == 720) {
                            this.fps = this.fps < 7L ? 5L : 10L;
                        }
                    }
                } else {
                    long old = this.fps;
                    this.fps = Tools.convertToCameraValues(this.allowedValues, this.fps);
                }
                this.iFrameDistMS = this.iFrameDistMS > 5000 ? 5000 : this.iFrameDistMS;
                this.iFrameDist = (long)(this.iFrameDistMS / 1000) * this.fps;
                this.iFrameDist = this.iFrameDist < 1L ? 1L : this.iFrameDist;
                this.iFrameDist = this.iFrameDist > 60L ? 60L : this.iFrameDist;
                this.bandwidth /= 1024;
                this.bandwithAsString = ActiMPEGVideoSourceClient.getBandwidthAsString(this.bandwidth);
                if (this.encoderType.equalsIgnoreCase("MJPEG")) {
                    url = new StringBuffer(SYSTEM_CGI);
                    url.append((CharSequence)this.passwordString);
                    url.append("&SYSTEM_INFO");
                    try {
                        result = NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url.toString(), (int)Integer.MAX_VALUE);
                        String versionInfo = new String(result);
                        if (versionInfo.contains("ERROR: bad account/password") || versionInfo.toLowerCase().contains("unauthorized")) {
                            this.logger.error("Wrong authorization data for " + this);
                            return -21657;
                        }
                        if (!versionInfo.contains(FIRMWARE_VERSION_IDENTIFIER)) {
                            this.logger.error(FIRMWARE_EXTRACTION_ERROR);
                            return -21600;
                        }
                        if (!(versionInfo = versionInfo.substring(versionInfo.indexOf(FIRMWARE_VERSION_IDENTIFIER) + FIRMWARE_VERSION_IDENTIFIER.length())).contains("\n")) {
                            this.logger.error(FIRMWARE_EXTRACTION_ERROR);
                            return -21600;
                        }
                        versionInfo = versionInfo.substring(0, versionInfo.indexOf("\n"));
                        String[] parts = versionInfo.split("-");
                        for (int i = 0; i < parts.length; ++i) {
                            if (parts[i].startsWith("v") || parts[i].startsWith("V")) {
                                String version = parts[i].substring(1, parts[i].length());
                                String[] versionParts = version.split("\\.");
                                try {
                                    if (Integer.parseInt(versionParts[0]) > 3) {
                                        this.logger.info(FIRMWARE_SUFFICIENT);
                                        break;
                                    }
                                    if (Integer.parseInt(versionParts[0]) < 3) {
                                        this.logger.error(FIRMWARE_ERROR_1);
                                        this.logger.error(FIRMWARE_ERROR_2);
                                        return -21668;
                                    }
                                    if (Integer.parseInt(versionParts[1]) > 8) {
                                        this.logger.info(FIRMWARE_SUFFICIENT);
                                        break;
                                    }
                                    if (Integer.parseInt(versionParts[1]) < 8) {
                                        this.logger.error(FIRMWARE_ERROR_1);
                                        this.logger.error(FIRMWARE_ERROR_2);
                                        return -21668;
                                    }
                                    if (Integer.parseInt(versionParts[2]) >= 8) {
                                        this.logger.info(FIRMWARE_SUFFICIENT);
                                        break;
                                    }
                                    this.logger.error(FIRMWARE_ERROR_1);
                                    this.logger.error(FIRMWARE_ERROR_2);
                                    return -21668;
                                }
                                catch (NumberFormatException nfe) {
                                    this.logger.fatal("Error when converting version to number. Error:" + nfe.getMessage());
                                    return -21600;
                                }
                            }
                            if (i != parts.length - 1) continue;
                            this.logger.error(FIRMWARE_EXTRACTION_ERROR);
                            return -21600;
                        }
                    }
                    catch (SeeTecException e) {
                        this.logger.error("Exception while requesting system info on " + this.getVideoSrv());
                        return e.getErrorCode();
                    }
                }
                if (((ActiCameraSrv)this.getVideoSrv()).isMultiStreamingUsed()) {
                    this.logger.info("Multi-Streaming is used. StreamID: " + this.streamID + " for " + this);
                }
                url = new StringBuffer(ENCODER_CGI);
                url.append((CharSequence)this.passwordString);
                if (((ActiCameraSrv)this.getVideoSrv()).isMultiStreamingUsed()) {
                    url.append("&VIDEO_STREAM=DUAL&MEDIA=");
                    url.append(this.streamID);
                } else {
                    url.append("&VIDEO_STREAM=SINGLE");
                }
                url.append("&VIDEO_ENCODER=");
                url.append(this.encoderType);
                url.append("&VIDEO_MJPEG_QUALITY=");
                url.append(this.quality);
                if (this.isConstantBitrateUsed) {
                    if (this.encoderType.equalsIgnoreCase("H264")) {
                        url.append("&VIDEO_H264_QUALITY=NONE");
                    } else {
                        url.append("&VIDEO_MPEG4_QUALITY=NONE");
                    }
                } else {
                    if (this.encoderType.equalsIgnoreCase("H264")) {
                        url.append("&VIDEO_H264_QUALITY=");
                    } else {
                        url.append("&VIDEO_MPEG4_QUALITY=");
                    }
                    url.append(ActiMPEGVideoSourceClient.getQualityAsString(this.quality));
                    if (this.quality < 33) {
                        url.append("LOW");
                    } else if (this.quality < 66) {
                        url.append("MIDDLE");
                    } else {
                        url.append("HIGH");
                    }
                }
                int rotateValue = this.rotationAngle == 180 ? 1 : 0;
                url.append("&VIDEO_FLIP_MODE=");
                url.append(rotateValue);
                url.append("&VIDEO_MIRROR_MODE=");
                url.append(rotateValue);
                if (!this.encoderType.equalsIgnoreCase("MJPEG")) {
                    url.append("&VIDEO_GOP=");
                    url.append(this.iFrameDist);
                }
                try {
                    NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url.toString(), (int)Integer.MAX_VALUE, ignoreHttpStatusCode);
                }
                catch (SeeTecException e) {
                    this.logger.error("Exception while setting ENCODER type to " + this.encoderType + " on " + this.getVideoSrv());
                    return e.getErrorCode();
                }
                if (this.modeIdentifierAsString != null) {
                    url = new StringBuffer("/cgi-bin/url.cgi?");
                    url.append((CharSequence)this.passwordString);
                    url.append("&VIDEO_TV=");
                    url.append(this.modeIdentifierAsString);
                    try {
                        NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url.toString(), (int)Integer.MAX_VALUE);
                    }
                    catch (SeeTecException e) {
                        if (e.getNetworkStatus() == HTTPStatusCode.HTTP_NOT_FOUND) break block100;
                        this.logger.error("Exception while setting VIDEO_TV mode " + this.getVideoSrv() + ". Errorcode: " + e.getErrorCode());
                        return e.getErrorCode();
                    }
                }
            }
            String alreadySetResolution = null;
            String alreadySetFPS = null;
            url = new StringBuffer(ENCODER_CGI);
            url.append((CharSequence)this.passwordString);
            if (((ActiCameraSrv)this.getVideoSrv()).isMultiStreamingUsed()) {
                url.append("&MEDIA=");
                url.append(this.streamID);
            }
            url.append("&VIDEO_RESOLUTION&VIDEO_FPS_NUM");
            try {
                result = NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url.toString(), (int)Integer.MAX_VALUE, ignoreHttpStatusCode);
                String resultString = new String(result);
                int position = resultString.indexOf("VIDEO_RESOLUTION='");
                if (position != -1) {
                    alreadySetResolution = resultString.substring(position + "VIDEO_RESOLUTION='".length());
                    alreadySetResolution = alreadySetResolution.substring(0, alreadySetResolution.indexOf("'"));
                }
                if ((position = resultString.indexOf("VIDEO_FPS_NUM='")) != -1) {
                    alreadySetFPS = resultString.substring(position + "VIDEO_FPS_NUM='".length());
                    alreadySetFPS = alreadySetFPS.substring(0, alreadySetFPS.indexOf("'"));
                }
            }
            catch (SeeTecException e) {
                this.logger.error("Exception while reading fps/resolution for " + this.getVideoSrv() + ". Errorcode: " + e.getErrorCode());
                return e.getErrorCode();
            }
            if (((ActiCameraSrv)this.getVideoSrv()).useEncoderPrefix()) {
                url = new StringBuffer(ENCODER_CGI);
                url.append((CharSequence)this.passwordString);
            } else {
                url = new StringBuffer(MPEG_CGI);
                url.append((CharSequence)this.passwordString);
            }
            if (((ActiCameraSrv)this.getVideoSrv()).isMultiStreamingUsed()) {
                url.append("&VIDEO_STREAM=DUAL&MEDIA=");
                url.append(this.streamID);
            }
            boolean atLeastOneParameterChanged = false;
            if (alreadySetResolution != null && !alreadySetResolution.equalsIgnoreCase(this.resolutionString)) {
                url.append("&VIDEO_RESOLUTION=");
                url.append(this.resolutionString);
                atLeastOneParameterChanged = true;
            }
            if (alreadySetFPS != null && !alreadySetFPS.equalsIgnoreCase("" + this.fps)) {
                url.append("&VIDEO_FPS_NUM=");
                url.append(this.fps);
                atLeastOneParameterChanged = true;
            }
            if (atLeastOneParameterChanged) {
                try {
                    NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url.toString(), (int)Integer.MAX_VALUE);
                }
                catch (SeeTecException e) {
                    this.logger.error("Exception while setting initial parameters for " + this.getVideoSrv() + "With following command sent " + url.toString() + ". Errorcode: " + e.getErrorCode());
                    return e.getErrorCode();
                }
            }
            if (!this.encoderType.equalsIgnoreCase("MJPEG")) {
                for (int i = 0; i < 2; ++i) {
                    if (((ActiCameraSrv)this.getVideoSrv()).useEncoderPrefix()) {
                        url = new StringBuffer(ENCODER_CGI);
                        url.append((CharSequence)this.passwordString);
                    } else {
                        url = new StringBuffer(MPEG_CGI);
                        url.append((CharSequence)this.passwordString);
                    }
                    if (((ActiCameraSrv)this.getVideoSrv()).isMultiStreamingUsed()) {
                        url.append("&VIDEO_STREAM=DUAL&MEDIA=");
                        url.append(this.streamID);
                    }
                    url.append("&VIDEO_BITRATE=");
                    url.append(this.bandwithAsString);
                    url.append("&VIDEO_MAX_BITRATE=");
                    url.append(this.bandwithAsString);
                    try {
                        result = NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url.toString(), (int)Integer.MAX_VALUE, (boolean)true);
                        if (!new String(result).contains("ERROR")) break;
                        this.logger.info("Can't set specified bitrate '" + this.bandwithAsString + "'. Set old max of 3M for " + this.getVideoSrv());
                        this.bandwithAsString = "3M";
                        continue;
                    }
                    catch (SeeTecException e) {
                        this.logger.error("Exception while setting initial bitrate parameters for " + this.getVideoSrv() + ". Errorcode: " + e.getErrorCode());
                        return e.getErrorCode();
                    }
                }
            }
        }
        url = new StringBuffer(SYSTEM_CGI);
        url.append((CharSequence)this.passwordString);
        if (this.isAudioEnabled) {
            url.append("&V2_AUDIO_ENABLED=1");
        } else {
            url.append("&V2_AUDIO_ENABLED=0");
        }
        try {
            NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url.toString(), (int)Integer.MAX_VALUE);
        }
        catch (SeeTecException e) {
            this.logger.error("Exception while setting audio parameters for " + this.getVideoSrv() + ". Errorcode: " + e.getErrorCode());
            return e.getErrorCode();
        }
        if (this.getVideoSrv().getDevice().getNumberOfVideoSources() <= 1) {
            this.controlPortBase = 6001;
            this.videoPortBase = 6002;
        } else {
            this.controlPortBase = 6010;
            this.videoPortBase = 6050;
        }
        this.logger.info("Control port for source '" + this.videoSourceNr + "' is: " + (this.controlPortBase + this.videoSourceNr - 1) + " for " + this.getVideoSrv());
        this.logger.info("Video port for source '" + this.videoSourceNr + "' is: " + (this.videoPortBase + this.videoSourceNr - 1) + " for " + this.getVideoSrv());
        this.acti = new ActiTCPReader();
        this.errorCode = this.acti.init(this.getHost(), this.controlPortBase + this.videoSourceNr - 1, this.videoPortBase + this.videoSourceNr - 1, this.user, this.pass, this, this.streamID);
        if (this.errorCode != 0) {
            this.logger.error("Error while initializing ACTiTCPReader. errorCode: " + this.errorCode);
            return this.errorCode;
        }
        this.logger.info("Init done for " + this.getVideoSrv());
        return 0;
    }

    public static String getQualityAsString(int quality) {
        String h264Quality = quality < 33 ? "LOW" : (quality < 66 ? "MIDDLE" : "HIGH");
        return h264Quality;
    }

    public static String getBandwidthAsString(int bandwidth) {
        String bandwithString = bandwidth <= 42 ? "28K" : (bandwidth <= 92 ? "56K" : (bandwidth <= 192 ? "128K" : (bandwidth <= 320 ? "256K" : (bandwidth <= 442 ? "384K" : (bandwidth <= 625 ? "500K" : (bandwidth <= 887 ? "750K" : (bandwidth <= 1126 ? "1M" : (bandwidth <= 1382 ? "1.2M" : (bandwidth <= 1792 ? "1.5M" : (bandwidth <= 2304 ? "2M" : (bandwidth <= 2816 ? "2.5M" : (bandwidth <= 3200 ? "3M" : (bandwidth <= 3700 ? "3.5M" : (bandwidth <= 4200 ? "4M" : (bandwidth <= 4700 ? "4.5M" : (bandwidth <= 5200 ? "5M" : (bandwidth <= 5700 ? "5.5M" : "6M")))))))))))))))));
        return bandwithString;
    }

    @Override
    public synchronized int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        if (this.acti != null) {
            this.acti.shutdown();
            this.acti = null;
        }
        this.bandwithAsString = null;
        this.resolutionString = null;
        this.modeIdentifier = null;
        this.modeIdentifierAsString = null;
        return 0;
    }

    @Override
    public void onNetworkError(int error) {
        if (this.isShutdown()) {
            return;
        }
        this.logger.warn("Shutting down : " + error + " on " + this.getVideoSrv());
        this.listener.sendStatusService(error);
        this.shutdown();
    }

    @Override
    public final boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    private int checkForVideoLoss(byte[] data) {
        switch (data[17]) {
            case 1: {
                if (this.isVideoLoss) {
                    this.isVideoLoss = false;
                    this.listener.sendStatusService(0);
                }
                return 0;
            }
            case 0: {
                if (!this.isVideoLoss) {
                    this.isVideoLoss = true;
                    this.logger.error("Video loss detected! Check connection to video source " + this.getVideoSrv());
                    this.listener.sendStatusService(-21663);
                }
                return -20000;
            }
        }
        this.logger.warn("Unknown video loss information: " + data[17] + " on " + this.getVideoSrv());
        return Integer.MIN_VALUE;
    }

    private int checkForDataClassification(byte[] data) {
        switch (data[4]) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 5;
            }
        }
        this.logger.warn("Unknown data classification: " + data[4] + " for " + this.getVideoSrv());
        return Integer.MIN_VALUE;
    }

    @Override
    public void onTcpData(byte[] data) {
        try {
            if (this.isShutdown()) {
                return;
            }
            if (data == null) {
                this.logger.error("Incoming data is null");
                return;
            }
            int type = this.checkForDataClassification(data);
            if (type == 1 || (type = this.checkForDataClassification(data)) == 5) {
                int mediaType;
                if (this.getVideoSrv().getHardwareMotionDetection() != null && this.listener.hasHardwareMotionDetection()) {
                    byte[] motionDetection = new byte[]{data[18]};
                    ((ActiMotionDetectionHandler)((Object)((ActiHardwareMotionDetection)this.getVideoSrv().getHardwareMotionDetection()).getMotionDetectionHandler())).processContent(motionDetection);
                }
                if (this.checkForVideoLoss(data) != 0) {
                    return;
                }
                if (type == 1) {
                    mediaType = StreamingHelperMpeg4.checkForMPEG4Part2MediaType(data, 44);
                } else {
                    mediaType = StreamingHelperH264.checkForH264MediaType(this.getVideoSrv().getDevice(), data, 44);
                    if (mediaType == 7) {
                        mediaType = 33;
                    }
                }
                if (mediaType >= 0) {
                    byte resolutionFromFrame = data[24];
                    if (resolutionFromFrame == 75) {
                        this.width = 2592;
                        this.height = 1944;
                    } else if (resolutionFromFrame == 76) {
                        this.width = 2048;
                        this.height = 1536;
                    } else if (resolutionFromFrame == 72) {
                        this.width = 2032;
                        this.height = 1920;
                    } else if (resolutionFromFrame == 69 || resolutionFromFrame == 74) {
                        this.width = 1920;
                        this.height = 1080;
                    } else if (resolutionFromFrame == 68) {
                        this.width = 1600;
                        this.height = 1200;
                    } else if (resolutionFromFrame == 67) {
                        this.width = 1280;
                        this.height = 1024;
                    } else if (resolutionFromFrame == 66) {
                        this.width = 1280;
                        this.height = 960;
                    } else if (resolutionFromFrame == 65) {
                        this.width = 1280;
                        this.height = 720;
                    } else if (resolutionFromFrame == 0) {
                        this.width = 720;
                        this.height = 480;
                    } else if (resolutionFromFrame == 64) {
                        this.width = 640;
                        this.height = 480;
                    } else if (resolutionFromFrame == 1) {
                        this.width = 352;
                        this.height = 240;
                    } else if (resolutionFromFrame == 2) {
                        this.width = 160;
                        this.height = 112;
                    } else if (resolutionFromFrame == 6) {
                        this.width = 176;
                        this.height = 120;
                    } else if (resolutionFromFrame == 3) {
                        this.width = 720;
                        this.height = 576;
                    } else if (resolutionFromFrame == -64) {
                        this.width = 640;
                        this.height = 480;
                    } else if (resolutionFromFrame == 4) {
                        this.width = 352;
                        this.height = 288;
                    } else if (resolutionFromFrame == 5) {
                        this.width = 176;
                        this.height = 144;
                    } else {
                        this.logger.fatal("Unknown resolution. Using the one from Configuration! But this may be the wrong one!");
                        this.logger.fatal("Used values: " + this.width + "x" + this.height + " on " + this.getVideoSrv());
                    }
                    byte[] seetecFrameByteArray = Arrays.copyOfRange(data, 44, data.length);
                    Codec codec = Codec.H264;
                    if (type == 1) {
                        codec = Codec.MPEG4;
                    }
                    MediaFrame mediaFrame = StreamingHelper.createSeeTecVideoFrameHeader(codec, this.width, this.height, seetecFrameByteArray);
                    this.deliverFrameCreateServerTimestamp(mediaType, mediaFrame);
                }
            } else if (this.checkForDataClassification(data) == 2 || this.checkForDataClassification(data) == 3) {
                if (this.isAudioEnabled) {
                    MediaFrame mediaFrame = StreamingHelper.createSeeTecAudioFrameHeader(Codec.PCM, 16, Arrays.copyOfRange(data, 28, data.length));
                    this.deliverFrameCreateServerTimestamp(16, mediaFrame);
                }
            } else if (this.checkForDataClassification(data) == 4) {
                if (this.getVideoSrv().getHardwareMotionDetection() != null && this.listener.hasHardwareMotionDetection()) {
                    byte[] motionDetection = new byte[]{data[18]};
                    ((ActiMotionDetectionHandler)((Object)((ActiHardwareMotionDetection)this.getVideoSrv().getHardwareMotionDetection()).getMotionDetectionHandler())).processContent(motionDetection);
                }
                if (this.checkForVideoLoss(data) != 0) {
                    return;
                }
                MediaFrame mediaFrame = StreamingHelper.createSeeTecVideoFrameHeader(Codec.MJPEG, Arrays.copyOfRange(data, 44, data.length), false);
                this.deliverFrameCreateServerTimestamp(0, mediaFrame);
            }
        }
        catch (Throwable t) {
            this.logger.error("Error while processing data received via onTCPData.", t);
        }
    }

    public void setStreamID(long streamID) {
        this.streamID = streamID;
    }

    public void setAllowedValues(long[] allowedValues) {
        this.allowedValues = allowedValues;
    }

    private String readConfiguration(String key, boolean readConfig, HashMap<String, String> map, long streamID) throws SeeTecException {
        if (readConfig || this.parameterString == null) {
            StringBuilder url = new StringBuilder(ENCODER_CGI + this.passwordString.toString() + "&MEDIA=" + streamID);
            for (Map.Entry entry : map.entrySet()) {
                url.append("&").append((String)entry.getKey());
            }
            this.parameterString = new String(NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url.toString(), (int)Integer.MAX_VALUE, (boolean)true));
        }
        String[] nameValuePairs = this.parameterString.split("\n");
        for (String parameter : nameValuePairs) {
            String[] nameValue;
            if (!parameter.contains(key) || (nameValue = parameter.split("=")).length != 2) continue;
            return nameValue[1].replace("'", "");
        }
        return "";
    }
}

